﻿//
//	Sil_CPreProC
//
using System;
using System.Reflection;
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using CAjrCustCtrl;

namespace Sil_CPreProC
{
	class Program
	{
		const string InpFile  = @".\bin\SampleInp.c";
		const string OutFile  = @".\bin\SampleOut.txt";
		static CAjrCPrePro		ppc 		 = new CAjrCPrePro();
		static CAjrStatic		sta 		 = new CAjrStatic();
		static ConsoleKeyInfo	c			 = new ConsoleKeyInfo();
		static string			m_svFileName = "";
		static	ETextEncode		m_SrcTec	 = ETextEncode.TEC_AUTO;
		static	EBomMode		m_SrcBom	 = EBomMode.NOT_WRITE_BOM;
		static	ArrayList		m_OptSym	 = new ArrayList();
		static	ArrayList		m_MacDef	 = new ArrayList();
		static	ArrayList		m_MacRef	 = new ArrayList();


		//	インクルード・パス群
		static	string[]	IncPath = {
				@"C:\Program Files (x86)\Microsoft Visual Studio*.*",
				@"C:\Program Files (x86)\Microsoft SDKs*.*" 	    ,
		};
		//	オプション・シンボル群
		static	string[] 	OptSym = {
				"_MSC_VER=1400"				,
				"_MSC_FULL_VER=140050727"	,
				"_INTEGRAL_MAX_BITS=64"		,
				"_WIN32"					,
				"_MBCS"						,
				"_CRTBLD"					,
				"_M_IX86"					,
				"__STDC__=0"				,
				"__STDC_WANT_SECURE_LIB__=0",
		};

		static void Main(string[] args)
		{
			//	コンソールアプリ終了ハンドラ登録
			m_CbkConApExit = new CbkConApExit(SsvConApExit);
			SetConsoleCtrlHandler(m_CbkConApExit, true);

			//	コンソールサイズ設定
			SAjrCon.SetBufSize(160, 1000);
			SAjrCon.SetWndRect(0, 0, 100, 50);

			//	プリコンパイル用コールバック設定
			ppc.SetCbNtcAnyEvt (new PpcCbkNtcAnyEvt (cbNtcAnyEvt ));	//	いずれかのイベント発生通知
			ppc.SetCbNtcSrcTec (new PpcCbkNtcSrcTec (cbNtcSrcTec ));	//	ソースファイルエンコード通知
			ppc.SetCbNtcError  (new PpcCbkNtcError	(cbNtcError  ));	//	エラー通知
			ppc.SetCbNtcMacDef (new PpcCbkNtcMacDef (cbNtcMacDef ));	//	マクロ定義通知
			ppc.SetCbNtcMacRef (new PpcCbkNtcMacRef (cbNtcMacRef ));	//	マクロ参照通知
			ppc.SetCbNtcOptSym (new PpcCbkNtcOptSym (cbNtcOptSym ));	//	オプションシンボル参照通知
			ppc.SetCbNtcFileLno(new PpcCbkNtcFileLno(cbNtcFileLno));	//	処理中のファイル行番号通知
			ppc.SetCbNtcSrcTec (new PpcCbkNtcSrcTec (cbNtcSrcTec ));	//	ソースファイルエンコード通知

			//	ベースパス設定（自プログラムフォルダの２つ上）
			Assembly myAssembly = Assembly.GetEntryAssembly();
			string BasePath =  System.IO.Path.GetDirectoryName(myAssembly.Location) + @"\..\..";
			ppc.SetBasePath(BasePath);
			
			//	インクルードパス設定
			ppc.SetIncPath(IncPath);

			//	オプションシンボル設定
			ppc.SetOptSym(OptSym);

			//	プリコンパイル実行
			Console.WriteLine(" Nest   File");
			ppc.PreCompile(InpFile, OutFile);

			//	プリコンパイルインスタンス消去
			ppc.Delete();

			//	マクロ定義情報表示
			Console.WriteLine("\n----- マクロ定義情報 -------------------");
			for (int i = 0; i < m_MacDef.Count; i++) {
				Console.WriteLine((string)m_MacDef[i]);
			}

			//	マクロ参照情報表示
			Console.WriteLine("\n----- マクロ参照情報 -------------------");
			for (int i = 0; i < m_MacRef.Count; i++) {
				Console.WriteLine((string)m_MacRef[i]);
			}

			//	オプションシンボル参照情報表示
			Console.WriteLine("\n----- オプションシンボル参照情報 -------");
			for (int i = 0; i < m_OptSym.Count; i++) {
				Console.WriteLine((string)m_OptSym[i]);
			}

			//	出力ファイルを開く
			Process.Start(BasePath + @"\" + OutFile);

			Console.Write("\n\n Hit Enter key -");
			Console.ReadLine();
		}
		//	何らかのイベント発生通知
		static void cbNtcAnyEvt(EPpcNtc ntc)
		{
			//	いずれかのキー押下でプリコンパイル中止
			if (Console.KeyAvailable) {
				c = Console.ReadKey(true);
				ppc.Stop();
			}
		}
		//	ソースファイルエンコード通知
		static void cbNtcSrcTec(string FilePath, ETextEncode tec, EBomMode bom)
		{
			m_SrcTec = tec;
			m_SrcBom = bom;
		}
		//	エラー通知
		static void cbNtcError(EPpcErr err, string FilePath, int lno, string param)
		{
			Console.WriteLine(ppc.ErrorMessaageText);
		}
		//	マクロ定義通知
		static void cbNtcMacDef(string FilePath, int lno, string MacName)
		{
			if (!MacName.StartsWith("_")) {
				m_MacDef.Add(" Def : " + MacName.PadRight(20) + " " + FilePath + " <" + lno.ToString() + ">");
			}
		}
		//	マクロ参照通知
		static void cbNtcMacRef(string FilePath, int lno, string MacName)
		{
			if (!MacName.StartsWith("_")) {
				m_MacRef.Add(" Ref : " + MacName.PadRight(20) + " " + FilePath + " <" + lno.ToString() + ">");
			}
		}
		//	オプションシンボル参照通知
		static void cbNtcOptSym(string FilePath, int lno, string OptSym)
		{
			if (!OptSym.StartsWith("_")) {
				m_OptSym.Add(" Opt : " + OptSym.PadRight(20) + " " + FilePath + " <" + lno.ToString() + ">");
			}
		}
		//	処理中のファイル行番号通知
		static void cbNtcFileLno(string FileName, int lno, int nest)
		{
			//	ファイル名表示
			if (m_svFileName != FileName) {
				Console.WriteLine(nest.ToString().PadLeft(5) + " : " + FileName);
				m_svFileName = FileName;
			}
		}
		//	コンソールアプリ終了ハンドラ用デリゲート
		[DllImport("Kernel32")]
		static extern bool SetConsoleCtrlHandler(CbkConApExit Handler, bool Add);
		delegate bool	CbkConApExit(EAJCEXITTYPE ExitType);
		static CbkConApExit  m_CbkConApExit;
		//	コンソールアプリ終了ハンドラ
		static bool SsvConApExit(EAJCEXITTYPE ExitType)
		{
			//	インスタンス消去
			ppc.Delete();
			//	false : 次のイベントハンドラへリンクする
			return false;
		}
	}
}
