﻿//
//	Sil_SerialComPort1
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using CAjrCustCtrl;

namespace Sil_SerialComPort1
{
	public partial class Form1 : Form
	{
		bool m_FirstText = true;

		public Form1()
		{
			InitializeComponent();
		}
		//----- 起動時初期設定 ------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			//	サイズ変更禁止
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			//	ツールチップ設定
			SAjrTip.Add(txtSndBin  , "バイナリデータ（２桁の１６進数を空白で区切って）設定してください");
			SAjrTip.Add(txtSndPkt  , "パケットデータ（２桁の１６進数を空白で区切って）設定してください");
			SAjrTip.Add(vthTxtChunk, "リアルタイムに受信したデータをテキストデータとして表示します。\n" +
									 "複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。");
			SAjrTip.Add(vthBinChunk, "リアルタイムに受信したデータをバイナリデータとして表示します。");
			SAjrTip.Add(vthInv	   , "リアルタイムに受信したテキストデータに不正な制御コードが含まれる場合は、\n" +
									 "テキストチャンクではなく、不正チャンクテキストとしてバイナリ表示します。\n" +
									 "不正な制御コードとは、TAB(0x09)～CR(0x0D)以外の制御コードを意味します。");
			SAjrTip.Add(vthPkt	   , "受信したパケットデータ（DLE・STX～DLE・ETX でサンドイッチされたデータ）をバイナリ表示します。");
			SAjrTip.Add(vthNoPkt   , "リアルタイムに受信したデータ内のパケットデータ（DLE・STX～DLE・ETX）以外の部分をテキストとして表示します。\n" +
									 "複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。");
			SAjrTip.Add(vthTxt	   , "受信ストリームから制御コード（TAB以外）で区切られたテキストデータを抜き出して表示します。\n" +
									 "ここにファイルをドロップすると、ファイルの内容をバイナリ送信します。");
			SAjrTip.Add(vthCtrl    , "受信ストリームから制御コード（TAB以外）を抜き出して表示します。");
			SAjrTip.Add(vthEsc	   , "受信したストリームから、ＥＳＣシーケンス（0x1B～英字）を抜きだして表示します。");
			//	ウインド位置ロード
			SAjrReg.LoadWndPos(this);
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//	ＳＣＰ初期化
			scp.Init();
			//	ポート名表示
			ShowPortName(scp.GetPortName());
			//	信号出力
			scp.SetRTS(chkRTS.Checked);
			scp.SetDTR(chkDTR.Checked);
			//	テキストエンコード設定
			 SetTextEncode();
		}
		//----- フォーム終了 --------------------------------------------------//
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	ウインド位置セーブ
			SAjrReg.SaveWndPos(this);
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//----- パラメタ設定ボタン --------------------------------------------//
		private void btnSetParam_Click_1(object sender, EventArgs e)
		{
			scp.SetParamByDialog(this.Handle);
		}
		//----- ポート オープン／クローズ　ボタン -----------------------------//
		private void btnOpenClose_Click(object sender, EventArgs e)
		{
			if (scp.IsOpened) {
				scp.Close();
			}
			else {
				scp.Open();
			}
		}
		//----- テキスト送信ボタン --------------------------------------------//
		private void btnSndTxt_Click_1(object sender, EventArgs e)
		{
			scp.SendText(txtSndTxt.Text + "\n");
		}
		//----- ＥＳＣ送信ボタン ----------------------------------------------//
		private void btnSndEsc_Click(object sender, EventArgs e)
		{
			scp.SendText("\x1B" + txtSndEsc.Text);
		}
		//----- バイナリ送信ボタン --------------------------------------------//
		private void btnSndBin_Click(object sender, EventArgs e)
		{
			string[] arr = txtSndBin.Text.Split(' ');
			int 	n = 0;
			//	有効な数算出
			for  (int i = 0; i < arr.Length; i++) {
				if (IsByteHexa(arr[i])) n++;
			}
			if (n != 0) {
				//		送信バイナリ作成
				Byte[] BArr = new Byte[n];

				int 	ix = 0;
				for  (int i = 0; i < arr.Length; i++) {
					if (IsByteHexa(arr[i])) {BArr[ix++] = Convert.ToByte(arr[i], 16);}
				}
				if (ix != 0) {
					scp.SendBinary(BArr);
				}
			}
		}
		//----- パケット送信ボタン ---------------------------------------------//
		private void btnSndPkt_Click(object sender, EventArgs e)
		{
			string[] arr = txtSndPkt.Text.Split(' ');
			int 	n = 0;
			//	有効な数算出
			for  (int i = 0; i < arr.Length; i++) {
				if (IsByteHexa(arr[i])) n++;
			}
			if (n != 0) {
				//		送信バイナリ作成
				Byte[] BArr = new Byte[n];

				int 	ix = 0;
				for  (int i = 0; i < arr.Length; i++) {
					if (IsByteHexa(arr[i])) {BArr[ix++] = Convert.ToByte(arr[i], 16);}
				}
				if (ix != 0) {
					scp.SendPacket(BArr);
				}
			}
		}
		//	１４ビット値送信ボタン
		private void btnSnd14_Click(object sender, EventArgs e)
		{
			scp.SendWord14LF(inp14Bit.IntValue);
		}
		//	全てクリアーボタン
		private void btnClearAll_Click(object sender, EventArgs e)
		{
			vthTxtChunk.Purge();
			vthBinChunk.Purge();
			vthTxt	   .Purge();
			vthCtrl    .Purge();
			vthEsc	   .Purge();
			vthInv	   .Purge();
			vthPkt	   .Purge();
			vthNoPkt   .Purge();
		}
		//----- ＲＴＳ信号出力 -------------------------------------------------//
		private void chkRTS_CheckedChanged(object sender, EventArgs e)
		{
			scp.SetRTS(chkRTS.Checked);
		}
		//----- ＤＴＲ信号出力 -------------------------------------------------//
		private void chkDTR_CheckedChanged(object sender, EventArgs e)
		{
			scp.SetDTR(chkDTR.Checked);
		}
		//----------------------------------------------------------------------//
		//	ＳＣＰイベント通知													//
		//----------------------------------------------------------------------//
		//----- ポート状態通知 -------------------------------------------------//
		private void scp_OnPortState(object sender, ScpArgPortState e)
		{
			ShowPortName(e.name);
			if (e.state == EScpPortState.Opened) {
				lblPortState.Text = "Opened";
				btnOpenClose.Text = "Close";
				scp.SetRTS(chkRTS.Checked);
				scp.SetDTR(chkDTR.Checked);
				chkCTS.Checked	= scp.GetCTS();
				chkDSR.Checked	= scp.GetDSR();
				chkRLSD.Checked = scp.GetRLSD();
				chkRING.Checked = scp.GetRING();
				ShowPortName(e.name);
			}
			else if (e.state == EScpPortState.Closed) {
				lblPortState.Text = "Closed";
				btnOpenClose.Text = "Open";
			}
			else if (e.state == EScpPortState.OpenFailure) {
				SAjrTip.ShowCenter(this, "\x1B[31m" + "Port(" + e.name + ") Open failure");
			}
			else if (e.state == EScpPortState.MySlotFail) {
				SAjrTip.ShowCenter(this, "\x1B[31m" + "MySlot(" + e.name + ") Creation failure");
			}
		}
		//----- バイナリチャンクデータ受信通知 ---------------------------------//
		unsafe private void scp_OnRxChunkBin(object sender, ScpArgRxChunkBin e)
		{
			vthBinChunk.PrintHexDump(e.bin);
			vthBinChunk.PutText("\n");
		}
		//----- 不正チャンクテキスト受信通知 -----------------------------------//
		private void scp_OnRxInvChunk(object sender, ScpArgRxInvChunk e)
		{
			vthInv.PrintHexDump(e.bin);
			vthInv.PutText("\n");
		}
		//----- テキストチャンク受信通知 ---------------------------------------//
		private void scp_OnRxChunkTxt(object sender, ScpArgRxChunkTxt e)
		{
			vthTxtChunk.PutText(e.text);
		}
		//----- テキスト受信通知 -----------------------------------------------//
		private void scp_OnRxText(object sender, ScpArgRxText e)
		{
			if (m_FirstText) {
				vthTxt.Purge();
				m_FirstText = false;
			}
			vthTxt.PutText(e.text + "\n");
		}
		//----- ＥＳＣデータ受信通知 -------------------------------------------//
		private void scp_OnRxEsc(object sender, ScpArgRxEsc e)
		{
			vthEsc.PutText("\\x1B" + e.esc.Substring(1));
			vthEsc.PutText("\n");
		}
		//----- 制御コード受信通知 ---------------------------------------------//
		private void scp_OnRxCtrl(object sender, ScpArgRxCtrl e)
		{
			int c = (int)e.ctrl;
			vthCtrl.PutFormat("0x{0:X2}\n", c);
		}
		//----- パケットデータ受信通知 -----------------------------------------//
		private void scp_OnRxPacket(object sender, ScpArgRxPacket e)
		{
			if (e.bin != null) {
				vthPkt.PrintHexDump(e.bin);
				vthPkt.PutText("\n");
			}
		}
		//----- パケット外テキスト受信通知 -------------------------------------//
		private void scp_OnRxNoPkt(object sender, ScpArgRxNoPkt e)
		{
			vthNoPkt.PutText(e.text);
		}
		//----- １４ビット値受信通知 -------------------------------------------//
		private void scp_OnRxWord14(object sender, ScpArgRxWord14 e)
		{
			if (chkView14.Checked) {
				Point pt = chkView14.ClientRectangle.Location;
				pt =  chkView14.PointToScreen(pt);
				SAjrTip.Show(pt.X +  chkView14.Size.Width + 5, pt.Y - 4, "14Bit value is received : " + e.data.ToString() +
																		" (0x" + e.data.ToString("X4") + ")");
			}
		}
		//----- ＣＴＳ信号変化通知 ---------------------------------------------//
		private void scp_OnNtcCTS(object sender, ScpArgNtcCTS e)
		{
			chkCTS.Checked	= e.cts;
			chkDSR.Checked	= e.dsr;
			chkRLSD.Checked = e.rlsd;
			chkRING.Checked = e.ring;
		}
		//----- ＤＳＲ信号変化通知 ---------------------------------------------//
		private void scp_OnNtcDSR(object sender, ScpArgNtcDSR e)
		{
			chkCTS.Checked = e.cts;
			chkDSR.Checked = e.dsr;
			chkRLSD.Checked = e.rlsd;
			chkRING.Checked = e.ring;
		}
		//----- ＲＬＳＤ信号変化通知 -------------------------------------------//
		private void scp_OnNtcRLSD(object sender, ScpArgNtcRLSD e)
		{
			chkCTS.Checked = e.cts;
			chkDSR.Checked = e.dsr;
			chkRLSD.Checked = e.rlsd;
			chkRING.Checked = e.ring;
		}
		//----- ＲＩＮＧ信号変化通知 -------------------------------------------//
		private void scp_OnNtcRING(object sender, ScpArgNtcRING e)
		{
			chkCTS.Checked = e.cts;
			chkDSR.Checked = e.dsr;
			chkRLSD.Checked = e.rlsd;
			chkRING.Checked = e.ring;
		}
		//----- テキスト表示ウインドにファイルドロップ -------------------------//
		private void vthTxt_OnFileDrop(object sender, VthArgFileDrop e)
		{
			for (int i = 0; i < e.n; i++) {
				string path = vthTxt.GetDroppedFile();
				byte[] buf = new byte[1024];
				long   FileSize;
				int    ReadSize;
				FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read);
				FileSize = fs.Length;
				while (FileSize >= 1024) {
					ReadSize = fs.Read(buf, 0, 1024);
					FileSize -= ReadSize;
					scp.SendBinary(buf);
				}
				if (FileSize > 0) {
					buf = new byte[FileSize];
					fs.Read(buf, 0, (int)FileSize);
					scp.SendBinary(buf);
				}
				fs.Dispose();
			}
		}
		//----- ポート名表示 ---------------------------------------------------//
		private bool ShowPortName(string name)
		{
			bool	rc = false;
			lblPortName.Text = name;
			string pn = scp.GetPortDevName(name);
			if (pn != "") {
				lblDevName.Text  = "(" + pn + ")";
			}
			else {
				lblDevName.Text  = "";
			}
			return rc;
		}
		//----- １６進文字列チェック -------------------------------------------//
		private bool IsByteHexa(string s)
		{
			bool	rc = false;
			do {
				 if (string.IsNullOrEmpty(s)) break;
				 if (s.Length != 2) break;
				 if (!Uri.IsHexDigit(s[0])) break;
				 if (!Uri.IsHexDigit(s[1])) break;
				 rc = true;
			 } while (false);
			return rc;
		}
		//----- 受信テキストエンコード設定ラジオボタン -------------------------//
		private void rbtRxSJis_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxUTF8_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxEuc_CheckedChanged (object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxAuto_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		//----- 送信テキストエンコード設定ラジオボタン -------------------------//
		private void rbtTxSJis_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxUTF8_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxEuc_CheckedChanged (object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxAuto_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		//	テキストエンコード設定
		private void SetTextEncode()
		{
			if		(rbtRxSJis.Checked) scp.RxTextCode = EScpRxTextCode.SJIS;
			else if (rbtRxUTF8.Checked) scp.RxTextCode = EScpRxTextCode.UTF8;
			else if (rbtRxEuc .Checked) scp.RxTextCode = EScpRxTextCode.EUC;
			else if (rbtRxAuto.Checked) scp.RxTextCode = EScpRxTextCode.AUTO;

			if		(rbtTxSJis.Checked) scp.TxTextCode = EScpTxTextCode.SJIS;
			else if (rbtTxUTF8.Checked) scp.TxTextCode = EScpTxTextCode.UTF8;
			else if (rbtTxEuc .Checked) scp.TxTextCode = EScpTxTextCode.EUC;
			else if (rbtTxAuto.Checked) scp.TxTextCode = EScpTxTextCode.SJIS;

		}
	}
}
