﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Runtime.InteropServices;
using CAjrCustCtrl;

namespace Sil_SerialComPort2C
{
	//	通信デバイス
	enum CommDev : int	{COMPORT, MAILSLOT, TCPIP};

	class Program
	{
		//	ヘルプテキスト
		static string HelpText = "起動パラメタの形式\n\n" 					+
								 "  ●ＣＯＭポート指定\n"					+
								 "      /COMnnn   - COMポート番号\n" 		+
								 "      /Rnnn     - 通信スピード[bps]\n\n"	+
								 "  ●メールスロット指定\n"					+
								 "      /T<Name>  - 自スロット名\n"			+
								 "      /H<Name>  - 相手ホスト名\n"			+
								 "      /E<Name>  - 相手スロット名\n\n"		+
								 "  ●ＴＣＰ／ＩＰ指定\n"					+
								 "      /S<Name>  - TCP/IPサーバ名\n"		+
								 "      /Pnnn     - TCP/IPポート番号\n"		+
								 "\n"										+
								 "↑：以前に入力したパラメタ\n"				+
								 "↓：次のパラメタ";
		//	通信パラメタ
		static CommDev		dev 	= CommDev.COMPORT;	//	通信デバイス
		static int			ComPort = 4;				//	ＣＯＭポート番号
		static int			Speed	= 115200;			//	ＣＯＭポート速度
		static string		MySlot	= "NoName";			//	自スロット名
		static string		RmtSlot	= "SlotB";			//	相手スロット名
		static string		RmtHost = "";				//	相手ホスト名
		static string		TcpServ = "";				//	TCP/IPサーバ名
		static uint			TcpPort = 14238;			//	TCP/IPポート番号
		//	バイトカウントタ
		static	int			ByteCount = 0;
		//	シリアル通信インスタンス
		static CAjrSerialComPort scp = new CAjrSerialComPort();
		//	コンソール入力のコールバック
		static ConCbkNtcArgs CbkNtcArgs = new ConCbkNtcArgs(cbAnalArgs);

		static void Main(string[] args)
		{
			EScpEvt evt;
			object obj;
			ConsoleKeyInfo c = new ConsoleKeyInfo();

			//	コンソールアプリ強制終了ハンドラ登録
			m_CbkConApExit = new CbkConApExit(SsvConApExit);
			SetConsoleCtrlHandler(m_CbkConApExit, true);

			Console.WriteLine(" Platform = " + (IntPtr.Size == 4 ? "WIN32" : "WIN64") + "\n");

			Console.WriteLine(" このプログラムは、受信したデータをそのまま返信します。\n");
			Console.WriteLine(" ＥＳＣキーを押すと、プログラムを終了します。");
			Console.Write("    ");

			do {
				//	起動パラメタ解析
				if (args.Length >= 1) {
					cbAnalArgs(args.Length, args);
				}
				else {
					Console.WriteLine("\n 起動パラメタを入力してください。(F1, F2 : ヘルプ)\n");
					Console.Write("    ");
					if (SAjrCon.GetLine("",						//	初期テキスト
										100, 					//	入力フィールド長
										100, 					//	入力テキスト長
										ECInGetLineOpt.ALL, 	//	オプション
										Color.Empty, 			//	文字色
										Color.Empty, 			//	入力域背景色
										HelpText, 				//	ユーザヘルプ
										cbAnalArgs) == null) {	//	コールバック
						break;	//	ESC入力で終了
					}
				}
				Console.WriteLine("");

				//----- ＳＣＰ初期化 -------------------------------------------------//
				scp.Init();
				//----- イベント待ち受けモードに設定 ---------------------------------//
				scp._ScpMode = EScpMode.WaitingForEvent;
				//----- 対象とするイベントを設定 -------------------------------------//
				scp.SetEvtMask(EScpEvt.EV_PORTSTATE | EScpEvt.EV_RXCHUNK);
				//----- ポート オープン ----------------------------------------------//
				bool rsu = false;
				switch (dev) {
					case CommDev.COMPORT:	rsu = scp.Open(ComPort, Speed, EScpDataBits.DataBit_8, EScpParity.NoParity,
															EScpStopBit.StopBit_1); break;
					case CommDev.MAILSLOT:	scp.MySlotName = MySlot; scp.CreateMySlot();
											rsu = scp.Open(RmtHost, RmtSlot);		break;
					case CommDev.TCPIP:		rsu = scp.Open(TcpServ, TcpPort);		break;
				}
				//----- ＥＳＣキー入力／ポートクローズまでループ ---------------------//
				while (c.Key != ConsoleKey.Escape) {
					obj = null;
					//----- シリアル通信イベント待ち ---------------------------------//
					evt = scp.WaitEvent(out obj, 1000);
					//----- ポート状態通知 -------------------------------------------//
					if ((evt & EScpEvt.EV_PORTSTATE) != 0) {
						if		((int)obj == 0) {	//	ポートクローズ
						}
						else if ((int)obj == 1) {	//	ポートオープン
							Console.WriteLine("ポート " + scp.GetPortPathName() + " をオープンしました\n");
							Console.WriteLine("\n Received byte count -");
							Console.Write("    0\r");
						}
						else if ((int)obj == 2) {	//	ポートオープン失敗
							Console.WriteLine("ポート " + scp.GetPortPathName() + " のオープンを失敗しました。\n");
							break;
						}
					}
					//----- バイナリチャンク受信 -------------------------------------//
					else if ((evt & EScpEvt.EV_RXCHUNK) != 0) {
						Type t = obj.GetType();
						if (t == typeof(byte[])) {
							scp.SendBinary((byte[])obj);
							ByteCount += ((byte[])obj).Length;
							Console.Write("    " + ByteCount.ToString() + "\r");
						}
					}
					//--- キー入力 ---------------------------------------------------//
					if (Console.KeyAvailable) c = Console.ReadKey(true);
				}
				//----- ポートクローズ -----------------------------------------------//
				if (scp.IsOpened) scp.Close();
			} while(false);
			//----- シリアル通信オブジェクト削除 -------------------------------------//
			scp.Delete();
		}

		//	起動パラメタ解析
		static void cbAnalArgs(int argc, string[] arg)
		{
			foreach (string s in arg) {
				int    n;
				string r;
				if		((r = SAjrGsr.AfterPrefix(s, "/COM", out n)) != null) {dev = CommDev.COMPORT;  ComPort = n;}
				else if ((r = SAjrGsr.AfterPrefix(s, "/R"  , out n)) != null) {dev = CommDev.COMPORT;  Speed   = n;}
				else if ((r = SAjrGsr.AfterPrefix(s, "/T"  , out n)) != null) {dev = CommDev.MAILSLOT; MySlot  = r;}
				else if ((r = SAjrGsr.AfterPrefix(s, "/H"  , out n)) != null) {dev = CommDev.MAILSLOT; RmtHost = r;}
				else if ((r = SAjrGsr.AfterPrefix(s, "/E"  , out n)) != null) {dev = CommDev.MAILSLOT; RmtSlot = r;}
				else if ((r = SAjrGsr.AfterPrefix(s, "/S"  , out n)) != null) {dev = CommDev.TCPIP;    TcpServ = r;}
				else if ((r = SAjrGsr.AfterPrefix(s, "/P"  , out n)) != null) {dev = CommDev.TCPIP;    TcpPort = (uint)n;}
				else {
					Console.WriteLine("*** Invalid parameter '" + s + "' ***");
				}
			}
		}

		//	コンソールアプリ終了ハンドラ用デリゲート
		[DllImport("Kernel32")]
		static extern bool SetConsoleCtrlHandler(CbkConApExit Handler, bool Add);
		delegate bool	CbkConApExit(EAJCEXITTYPE ExitType);
		static CbkConApExit  m_CbkConApExit;
		//	コンソールアプリ終了ハンドラ
		static bool SsvConApExit(EAJCEXITTYPE ExitType)
		{
			//	シリアル通信オブジェクト消去
			scp.Delete();
			//	false : 次のイベントハンドラへリンクする
			return false;
		}
	}
}


