﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_SerialComPort4
{
	public partial class Form1 : Form
	{
		System.Threading.Mutex m_Mutex = new System.Threading.Mutex(false, "Sil_SerialComPort4");

		public Form1()
		{
			InitializeComponent();
		}
		//----- 起動時初期設定 ------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			this.Disposed += OnUnloadMyControl;
			//	サイズ変更禁止
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			//	ＳＣＰ初期化
			scp.Init();
			//	メールスロットのみ設定可とする
			scp.EnablePortSelectionInDialog(false, true, false);
			//	メールスロット名設定
			if (m_Mutex.WaitOne(0, false)) {
				scp.SetMailSlotNames("SlotA", null, "SlotB");
				scp.CreateMySlot();
				//	ウインド位置設定
				this.Left = 100;
				this.Top  = 100;
				//	相手局プログラム起動
				System.Diagnostics.Process.Start("Sil_SerialComPort4.exe");
			}
			else {
				scp.SetMailSlotNames("SlotB", null, "SlotA");
				scp.CreateMySlot();
				//	ウインド位置設定
				this.Left = 100 + this.Width + 10;
				this.Top  = 100;
			}
		}
		//----- オープン／クローズ ボタン -------------------------------------//
		private void btnOpenClose_Click(object sender, EventArgs e)
		{
			if (scp.IsOpened) scp.Close();
			else              scp.Open();
		}
		//----- パラメタ設定ボタン --------------------------------------------//
		private void btnSetParam_Click(object sender, EventArgs e)
		{
			scp.SetParamByDialog(this.Handle);
		}
		//----- テキスト送信ボタン --------------------------------------------//
		private void btnSndTxt_Click(object sender, EventArgs e)
		{
			DateTime dtNow = DateTime.Now;
			string str = dtNow.ToString("yyyy/MM/dd (ddd) hh:mm:ss");

			scp.SendText(str + "\n");
		}
		//----- シリアルポート状態通知 ----------------------------------------//
		private void cAjrSerialComPort1_OnPortState(object sender, CAjrCustCtrl.ScpArgPortState e)
		{
			if		(e.state == EScpPortState.Opened	 ) btnOpenClose.Text = "Close";
			else if (e.state == EScpPortState.Closed	 ) btnOpenClose.Text = "Open";
			else if (e.state == EScpPortState.OpenFailure) {
				SAjrTip.ShowCenter(this, "\x1B[31m'" + scp.GetPortPathName() + "' Open failure.");
			}
			else if (e.state == EScpPortState.MySlotFail) {
				SAjrTip.ShowCenter(this, "\x1B[31m'" + scp.GetMySlotPathName() + "' Creation failure.");
			}
		}
		//----- テキスト受信通知 ----------------------------------------------//
		private void cAjrSerialComPort1_OnRxText(object sender, CAjrCustCtrl.ScpArgRxText e)
		{
			vthRxTxt.PutText(e.text);
		}
		//----- 制御文字受信通知 ----------------------------------------------//
		private void cAjrSerialComPort1_OnRxCtrl(object sender, CAjrCustCtrl.ScpArgRxCtrl e)
		{
			vthRxTxt.PutChar(e.ctrl);
		}
		//----- 終了処理 ------------------------------------------------------//
		void OnUnloadMyControl(object sender, EventArgs e)
		{
			//	ミューテックス解放
			m_Mutex.ReleaseMutex();
		}
	}
}
