﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Security.Permissions;
using System.Windows.Forms;

namespace Sil_SerialComPort5A
{
	public partial class FormCmd : Form
	{
        bool m_fFirst = true;

		public FormCmd()
		{
			InitializeComponent();
		}
		//	起動時初期設定
        private void FormCmd_Load(object sender, EventArgs e)
        {
            //  初期メッセージ
            vth.PutText("相手(Sil_SerialComPort5B)と通信を行います。\n" +
                        "グラフ表示開始ボタンを押すと相手から適当なデータが送られチャートグラフを表示します。\n\n" +
                        "このウインドから以下のコマンドを入力しENTERキーを押してください。\n" +
                        "  ・DATE  -- 今日の日付表示\n" + 
                        "  ・TIME  -- 現在時刻表示\n");
        }
		private void FormCmd_Activated(object sender, EventArgs e)
		{
			//	コマンドコンソールをフォーカス
			vth.Focus();
		}
		//----- VTH : キー入力通知 -----------------------------------------------------------------------------//
		private void vth_OnNtcKeyIn(object sender, CAjrCustCtrl.VthArgNtcKeyIn e)
		{
            if (m_fFirst) {
                vth.Purge();
                m_fFirst = false;
            }
			((Form1)Application.OpenForms["Form1"]).SendChar((char)e.key);
		}
		//----- 受信テキスト表示 -------------------------------------------------------------------------------//
		public void ShowText(string text)
		{
			vth.PutText(text);
		}
		//----- フォーカス -------------------------------------------------------------------------------------//
		public new void Focus()
		{
			vth.Focus();
		}
		//----- フォームの終了を禁止 ---------------------------------------------------------------------------//
		protected override CreateParams CreateParams
		{
			[SecurityPermission(SecurityAction.Demand, Flags = SecurityPermissionFlag.UnmanagedCode)]
			get {
				const int CS_NOCLOSE = 0x200;
				CreateParams cp = base.CreateParams;
				cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;
				return cp;
			}
		}

	}
}
