﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using CAjrCustCtrl;

namespace Sil_SockClient1
{
	public partial class Form1 : Form
	{
		bool m_fConnect = false;

		public Form1()
		{
			InitializeComponent();
		}
		//----- 起動時初期設定 ------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			//	サイズ変更禁止
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			//	ツールチップ設定
			SAjrTip.Add(txtSndBin  , "バイナリデータ（２桁の１６進数を空白で区切って）設定してください");
			SAjrTip.Add(txtSndPkt  , "パケットデータ（２桁の１６進数を空白で区切って）設定してください");
			SAjrTip.Add(vthTxtChunk, "リアルタイムに受信したデータをテキストデータとして表示します。\n" +
									 "複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。");
			SAjrTip.Add(vthBinChunk, "リアルタイムに受信したデータをバイナリデータとして表示します。");
			SAjrTip.Add(vthInv	   , "リアルタイムに受信したテキストデータに不正な制御コードが含まれる場合は、\n" +
									 "テキストチャンクではなく、不正チャンクテキストとしてバイナリ表示します。\n" +
									 "不正な制御コードとは、TAB(0x09)～CR(0x0D)以外の制御コードを意味します。");
			SAjrTip.Add(vthPkt	   , "受信したパケットデータ（DLE・STX～DLE・ETX でサンドイッチされたデータ）をバイナリ表示します。");
			SAjrTip.Add(vthNoPkt   , "リアルタイムに受信したデータ内のパケットデータ（DLE・STX～DLE・ETX）以外の部分をテキストとして表示します。\n" +
									 "複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。");
			SAjrTip.Add(vthTxt	   , "受信ストリームから制御コード（TAB以外）で区切られたテキストデータを抜き出して表示します。\n" +
									 "ここにファイルをドロップすると、ファイルの内容をバイナリ送信します。");
			SAjrTip.Add(vthCtrl    , "受信ストリームから制御コード（TAB以外）を抜き出して表示します。");
			SAjrTip.Add(vthEsc	   , "受信したストリームから、ＥＳＣシーケンス（0x1B～英字）を抜きだして表示します。");
			//  ウインド位置ロード
			SAjrReg.LoadWndPos(this);
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//	ＳＣＰ初期化
			sct.Init();
			//	テキストエンコード設定
			 SetTextEncode();
		}
		//----- フォーム終了 --------------------------------------------------//
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//  ウインド位置セーブ
			SAjrReg.SaveWndPos(this);
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//----- 接続／切断 ボタン ---------------------------------------------//
		private void btnConnect_Click(object sender, EventArgs e)
		{
			if (m_fConnect) {
				sct.Disconnect();
			}
			else {
				sct.Connect(txtServ.Text, uint.Parse(txtPort.Text));
			}
		}
		//----- テキスト送信ボタン --------------------------------------------//
		private void btnSndTxt_Click(object sender, EventArgs e)
		{
			sct.SendText(txtSndTxt.Text + "\n");
		}
		//----- ＥＳＣ送信ボタン ----------------------------------------------//
		private void btnSndEsc_Click(object sender, EventArgs e)
		{
			sct.SendText("\x1B" + txtSndEsc.Text);
		}
		//----- バイナリ送信ボタン --------------------------------------------//
		private void btnSndBin_Click(object sender, EventArgs e)
		{
			string[] arr = txtSndBin.Text.Split(' ');
			int 	n = 0;
			//	有効な数算出
			for  (int i = 0; i < arr.Length; i++) {
				if (IsByteHexa(arr[i])) n++;
			}
			if (n != 0) {
				//		送信バイナリ作成
				Byte[] BArr = new Byte[n];

				int 	ix = 0;
				for  (int i = 0; i < arr.Length; i++) {
					if (IsByteHexa(arr[i])) {BArr[ix++] = Convert.ToByte(arr[i], 16);}
				}
				if (ix != 0) {
					sct.SendBinary(BArr);
				}
			}
		}
		//----- パケット送信ボタン ---------------------------------------------//
		private void btnSndPkt_Click(object sender, EventArgs e)
		{
			string[] arr = txtSndPkt.Text.Split(' ');
			int 	n = 0;
			//	有効な数算出
			for  (int i = 0; i < arr.Length; i++) {
				if (IsByteHexa(arr[i])) n++;
			}
			if (n != 0) {
				//		送信バイナリ作成
				Byte[] BArr = new Byte[n];

				int 	ix = 0;
				for  (int i = 0; i < arr.Length; i++) {
					if (IsByteHexa(arr[i])) {BArr[ix++] = Convert.ToByte(arr[i], 16);}
				}
				if (ix != 0) {
					sct.SendPacket(BArr);
				}
			}
		}
		//----- 全てクリアー ボタン --------------------------------------------//
		private void btnClearAll_Click(object sender, EventArgs e)
		{
			vthTxtChunk.Purge();
			vthBinChunk.Purge();
			vthTxt	   .Purge();
			vthCtrl    .Purge();
			vthEsc	   .Purge();
			vthInv	   .Purge();
			vthPkt	   .Purge();
			vthNoPkt   .Purge();
		}
		//----------------------------------------------------------------------//
		//	ＳＣＴイベント通知													//
		//----------------------------------------------------------------------//
		//----- 接続通知 -------------------------------------------------------//
		private void sct_OnConnect(object sender, EventArgs e)
		{
			m_fConnect = true;
			btnConnect.Text = "切 断";
			ShowMsgTip("サーバと接続しました。");
		}
		//----- 切断通知 -------------------------------------------------------//
		private void sct_OnDisconnect(object sender, EventArgs e)
		{
			m_fConnect = false;
			btnConnect.Text = "接 続";
			ShowMsgTip("サーバとの回線を切断しました。");
		}
		//----- 接続失敗通知 ---------------------------------------------------//
		private void sct_OnCnFail(object sender, SctArgCnFail e)
		{
			ShowMsgTip("\x1B[31mサーバとの接続を失敗しました。");
		}
		//----- バイナリチャンクデータ受信通知 ---------------------------------//
		private void sct_OnRxChunkBin(object sender, SctArgRxChunkBin e)
		{
            vthBinChunk.PutText("----- Binary Chunk " + e.bin.Length.ToString() + " Bytes -----\n");
			vthBinChunk.PrintHexDump(e.bin);
			vthBinChunk.PutText("\n");
		}
		//----- 不正チャンクテキスト受信通知 -----------------------------------//
		private void sct_OnRxInvChunk(object sender, SctArgRxInvChunk e)
		{
			vthInv.PrintHexDump(e.bin);
			vthInv.PutText("\n");
		}
		//----- テキストチャンク受信通知 ---------------------------------------//
		private void sct_OnRxChunkTxt(object sender, SctArgRxChunkTxt e)
		{
			vthTxtChunk.PutText(e.text);
		}
		//----- テキスト受信通知 -----------------------------------------------//
		private void sct_OnRxText(object sender, SctArgRxText e)
		{
			vthTxt.PutText(e.text + "\n");
		}
		//----- ＥＳＣデータ受信通知 -------------------------------------------//
		private void sct_OnRxEsc(object sender, SctArgRxEsc e)
		{
			vthEsc.PutText("\\x1B" + e.esc.Substring(1));
			vthEsc.PutText("\n");
		}
		//----- 制御コード受信通知 ---------------------------------------------//
		private void sct_OnRxCtrl(object sender, SctArgRxCtrl e)
		{
			int c = (int)e.ctrl;
			vthCtrl.PutFormat("0x{0:X2}\n", c);
		}
		//----- パケットデータ受信通知 -----------------------------------------//
		private void sct_OnRxPacket(object sender, SctArgRxPacket e)
		{
			if (e.bin != null) {
				vthPkt.PrintHexDump(e.bin);
				vthPkt.PutText("\n");
			}
		}
		//----- パケット外テキスト受信通知 -------------------------------------//
		private void sct_OnRxNoPkt(object sender, SctArgRxNoPkt e)
		{
			vthNoPkt.PutText(e.text);
		}
		//----- 受信エラー通知 -------------------------------------------------//
		private void sct_OnRecvError(object sender, SctArgRecvError e)
		{
			if (e.overlapped) SAjrTip.ShowCenter(this, "\x1B[31m" + "受信エラー(GetOverlappedResult)");
			else			  SAjrTip.ShowCenter(this, "\x1B[31m" + "受信エラー(WSARecv)" 			);
		}
		//----- 送信エラー通知 -------------------------------------------------//
		private void sct_OnSendError(object sender, SctArgSendError e)
		{
			if (e.overlapped) SAjrTip.ShowCenter(this, "\x1B[31m" + "送信エラー(GetOverlappedResult)");
			else			  SAjrTip.ShowCenter(this, "\x1B[31m" + "送信エラー(WSASend)" 			  );
		}
		//----- その他のエラー通知 ---------------------------------------------//
		private void sct_OnGeneralError(object sender, SctArgGeneralError e)
		{
			switch (e.ErrorCode) {
				case ESctErrorCode.ERR_CREEVT:		 SAjrTip.ShowCenter(this, "\x1B[31m" + "CreateEvent() 失敗"				 	); break;
				case ESctErrorCode.ERR_SOCKET:		 SAjrTip.ShowCenter(this, "\x1B[31m" + "ソケット生成失敗" 				 	); break;
				case ESctErrorCode.ERR_ADDRINFO:	 SAjrTip.ShowCenter(this, "\x1B[31m" + "getaddrinfo 失敗" 				 	); break;
				case ESctErrorCode.ERR_SOCKOPT:		 SAjrTip.ShowCenter(this, "\x1B[31m" + "setsockopt() 失敗"				 	); break;
				case ESctErrorCode.ERR_SUBTHREAD:	 SAjrTip.ShowCenter(this, "\x1B[31m" + "サブスレッド開始失敗" 			 	); break;
				case ESctErrorCode.ERR_CRESSEP:		 SAjrTip.ShowCenter(this, "\x1B[31m" + "ストリーム分離生成失敗"			 	); break;
				case ESctErrorCode.ERR_CREMBXTXD:	 SAjrTip.ShowCenter(this, "\x1B[31m" + "送信データ用メールボックス生成失敗"	); break;
				case ESctErrorCode.ERR_TIMEOUT:		 SAjrTip.ShowCenter(this, "\x1B[31m" + "サブスレッド終了タイムアウト" 	 	); break;
			}
		}
		//----- テキスト表示ウインドにファイルドロップ -------------------------//
		private void vthTxt_OnFileDrop(object sender, VthArgFileDrop e)
		{
			for (int i = 0; i < e.n; i++) {
				string path = vthTxt.GetDroppedFile();
				byte[] buf = new byte[1024];
				long   FileSize;
				int    ReadSize;
				FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read);
				FileSize = fs.Length;
				while (FileSize >= 1024) {
					ReadSize = fs.Read(buf, 0, 1024);
					FileSize -= ReadSize;
					sct.SendBinary(buf);
				}
				if (FileSize > 0) {
					buf = new byte[FileSize];
					fs.Read(buf, 0, (int)FileSize);
					sct.SendBinary(buf);
				}
				fs.Dispose();
			}
		}
		//----- １６進文字列チェック -------------------------------------------//
		private bool IsByteHexa(string s)
		{
			bool	rc = false;
			do {
				 if (string.IsNullOrEmpty(s)) break;
				 if (s.Length != 2) break;
				 if (!Uri.IsHexDigit(s[0])) break;
				 if (!Uri.IsHexDigit(s[1])) break;
				 rc = true;
			 } while (false);
			return rc;
		}
		//----- 受信テキストエンコード設定ラジオボタン -------------------------//
		private void rbtRxSJis_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxUTF8_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxEuc_CheckedChanged (object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxAuto_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		//----- 送信テキストエンコード設定ラジオボタン -------------------------//
		private void rbtTxSJis_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxUTF8_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxEuc_CheckedChanged (object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxAuto_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		//	テキストエンコード設定
		private void SetTextEncode()
		{
			if		(rbtRxSJis.Checked) sct.RxTextCode = ESctRxTextCode.SJIS;
			else if (rbtRxUTF8.Checked) sct.RxTextCode = ESctRxTextCode.UTF8;
			else if (rbtRxEuc .Checked) sct.RxTextCode = ESctRxTextCode.EUC;
			else if (rbtRxAuto.Checked) sct.RxTextCode = ESctRxTextCode.AUTO;

			if		(rbtTxSJis.Checked) sct.TxTextCode = ESctTxTextCode.SJIS;
			else if (rbtTxUTF8.Checked) sct.TxTextCode = ESctTxTextCode.UTF8;
			else if (rbtTxEuc .Checked) sct.TxTextCode = ESctTxTextCode.EUC;
			else if (rbtTxAuto.Checked) sct.TxTextCode = ESctTxTextCode.SJIS;

		}
		//----- メッセージチップ表示 -------------------------------------------//
		private void ShowMsgTip(string txt)
		{
			Size  sz = SAjrTip.GetSize(txt, null, true);
			Point pt = grpRecv.ClientRectangle.Location;
			pt		 = grpRecv.PointToScreen(pt);
			int  x = pt.X + grpRecv.ClientRectangle.Width - sz.Width;
			int  y = pt.Y - sz.Height - 5;
			SAjrTip.Show(x, y, txt);
		}
	}
}
