﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections;
using CAjrCustCtrl;

namespace Sil_SockClient3
{
	public partial class Form1 : Form
	{
		bool		m_fConnect = false;			//	接続状態
		string		m_InpDir;					//	入力フォルダパス
		string		m_OutDir;					//	出力フォルダパス
		string		m_InpPath;					//	入力ファイルパス
		string		m_OutPath;					//	出力ファイルパス
		FileStream	m_InpFs;					//	入力ファイルストリーム
		FileStream	m_OutFs;					//	出力ファイルストリーム
		long		m_FileSize;					//	入力ファイルサイズ
		int			m_Unmatch;					//	比較不一致ファイル数
		int			m_ListCount;				//	全ファイル数
		int			m_ListIx;					//	ファイルインデクス
		ArrayList 	m_list = new ArrayList();	//	全入出力ファイル リスト
		int			m_BufSize = 1024;			//	送信データバッファサイズ
		int 		m_Bytes   = 0;				//	送信バイトカウント
		bool		m_fSendBusy = false;		//	送信中フラグ

		public Form1()
		{
			InitializeComponent();
		}
		//	フォーム開始
		private void Form1_Load(object sender, EventArgs e)
		{
			//	ビットマップ表示
			System.Reflection.Assembly myAssembly = System.Reflection.Assembly.GetExecutingAssembly();
			Bitmap bmp = new Bitmap(myAssembly.GetManifestResourceStream("Sil_SockClient3.ProgImage.bmp"));
			bmp.MakeTransparent();
			pic.Image = bmp;
			//	ウインド位置ロード
			SAjrReg.LoadWndPos(this);
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//	ＳＣＰ初期化
			sct.Init();
		}
		//	フォーム終了
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	ウインド位置セーブ
			SAjrReg.SaveWndPos(this);
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//	入力パス設定ボタン
		private void btnInpPath_Click(object sender, EventArgs e)
		{
			string path;
			if ((path = SAjrGsr.GetFolder("入力フォルダ", "")) != "") {
				txtInpPath.Text = path;
			}
		}
		//	出力パス設定ボタン
		private void btnOutPath_Click(object sender, EventArgs e)
		{
			string path;
			if ((path = SAjrGsr.GetFolder("出力フォルダ", "")) != "") {
				txtOutPath.Text = path;
			}
		}
		//	接続／切断ボタン
		private void btnConnect_Click(object sender, EventArgs e)
		{
			//	接続ボタン禁止
			btnConnect.Enabled = false;
			//	接続／切断
			if (m_fConnect) {
				sct.Disconnect();
			}
			else {
				m_Bytes = 0;
				sct.Connect(txtServ.Text, uint.Parse(txtPort.Text));
			}
		}
		//	開始ボタン
		private void btnStart_Click(object sender, EventArgs e)
		{
			//	入出力パス設定
			m_InpDir = txtInpPath.Text;
			m_OutDir = txtOutPath.Text;
			if (m_InpDir != "" && m_OutDir != "") {
				if (m_InpDir != m_OutDir) {
					//	入出力パスリストクリアー
					m_list.Clear();
					//	ファイル検索（入出力パスリスト作成）
					m_ListCount = 0;
					m_ListIx	= 0;
					m_Unmatch	= 0;
					fsr.SearchFiles(m_InpDir, "*.*", true);
					//	フォルダ構造コピー
					if (m_ListCount != 0) {
						//	出力フォルダ下の全ファイル削除
						if (MessageBox.Show(m_OutDir + "下の全ファイルを削除します。よろしいですか？", "S_SerialComPort4",
								MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation) == DialogResult.Yes) {
							//	バイトカウンタクリアー
							m_Bytes = 0;
							lblBytes.Text = "0";
							//	ログクリアー
							vthLog.Purge();
							//	ボタングレー化
							EnableButtons(false, false, true);
							//	フォルダ下クリアー
							SAjrFop.CleanFolder(m_OutDir);
							//	フォルダ構造コピー
							SAjrFop.CopyFolderStruct(m_InpDir, m_OutDir);
							//	ファイルをオープンし送信開始
							SendNextFile();
						}
					} else SAjrTip.ShowCenter(this, "\x1B[31m" + "入力フォルダ下にファイルがありません。");

				} else SAjrTip.ShowCenter(this, "\x1B[31m" + "入出力フォルダが同じです。");

			} else SAjrTip.ShowCenter(this, "\x1B[31m" + "入出力フォルダが設定されていません。");
		}
		//	中止ボタン
		private void btnStop_Click(object sender, EventArgs e)
		{
			//	送信中フラグクリアー
			m_fSendBusy = false;
			//	回線切断
			sct.Disconnect();
			//	ファイルストリーム解放
			if (m_InpFs != null) {m_InpFs.Dispose(); m_InpFs = null;}
			if (m_OutFs != null) {m_OutFs.Dispose(); m_OutFs = null;}
			vthLog.PutText("\n\n--- ループバックテストをキャンセルしました ---\n");
			//	全ボタン禁止
			EnableButtons(false, false, false);
		}
		//	ファイル検索通知
		private bool fsr_OnFindFile_1(object sender, FsrArgFindFile e)
		{
			if (e.FileAtt != EFileAtt._A_SUBDIR) {
				//	入出力ファイルパス設定（セミコロン(;)で区切る）
				string dtail, outpath;
				dtail	= Path.GetDirectoryName(e.PathName);
				dtail	= SAjrGsr.PathCat(dtail, "");
				dtail	= dtail.Substring(m_InpDir.Length);
				outpath = SAjrGsr.PathCat(m_OutDir + dtail, e.FileName);
				m_list.Add(e.PathName + ";" + outpath);
				m_ListCount++;
			}
			return true;
		}
		//------------------------------------------------------------------------------------------------------//
		//	ＳＣＴイベント																						//
		//------------------------------------------------------------------------------------------------------//
		//	接続通知
		private void sct_OnConnect(object sender, EventArgs e)
		{
			//	接続状態の旨、フラグ設定
			m_fConnect = true;
			//	ボタンフェース変更
			btnConnect.Text = "切 断";
			vthLog.PutText("サーバと接続しました\n");
			//	接続ボタン禁止，開始／中止ボタン許可
			EnableButtons(false, true, true);
		}
		//	切断通知
		private void sct_OnDisconnect(object sender, EventArgs e)
		{
			//	動作中の切断ならば、中止ボタン押下
			if (m_fSendBusy) {
				btnStop.PerformClick();
			}
			//	切断状態の旨、フラグ設定
			m_fConnect = false;
			//	ボタンフェース変更
			btnConnect.Text = "接 続";
			vthLog.PutText("回線を切断しました。\n");
			//	接続ボタン許可，開始／中止ボタン禁止
			EnableButtons(true, false, false);
		}
		//	接続失敗通知
		private void sct_OnCnFail(object sender, SctArgCnFail e)
		{
			vthLog.PutText("接続を失敗しました。\n");
			//	接続ボタン許可，開始／中止ボタン禁止
			EnableButtons(true, false, false);
		}
		//	パケット受信通知
		private void sct_OnRxPacket(object sender, SctArgRxPacket e)
		{
			//	空パケット（ファイル終端）以外ならば、受信データをファイルへ出力
			if (e.bin != null) {
				if (m_OutFs != null) {
					m_OutFs.Write(e.bin, 0, e.bin.Length);
				}
			}
			//	空パケット（ファイル終端）ならば、次のファイル送信へ・・
			else {
				//	出力ファイルクローズ
				if (m_OutFs != null) {m_OutFs.Dispose(); m_OutFs = null;}
				//	ファイルコンペア
				if (SAjrFop.FileCompare(m_InpPath, m_OutPath)) {
					vthLog.PutText("OK (Match)\n");
				}
				else {
					m_Unmatch++;
					vthLog.PutText("\x1B[31mNG (Unmatch)\x1B[0m\n");
				}
				//	次のファイル送信開始
				SendNextFile();
			}
		}
		//	送信完了通知
		private void sct_OnTxEmpty(object sender, EventArgs e)
		{
			//	次のファイルデータ送信
			if (m_InpFs != null) {
				FileSend();
			}
		}
		//------------------------------------------------------------------------------------------------------//
		//	サブファンクション																					//
		//------------------------------------------------------------------------------------------------------//
		//	次のファイル送信開始
		private bool SendNextFile()
		{
			bool rc = false;
			if (FileOpen()) {
				m_fSendBusy = true;
				FileSend();
				rc = true;
			}
			else {
				m_fSendBusy = false;
				sct.Disconnect();
				vthLog.PutText("\n--- ループバックテストを終了しました ---\n");
				vthLog.PutText("    ループバック不一致数 : " + m_Unmatch.ToString() + " / " +
															   m_ListCount.ToString() + " [files]\n");
				//	接続ボタン許可，開始／中止ボタン禁止
				EnableButtons(false, false, false);
			}
			return rc;
		}
		//	ファイルオープン（true:ゼロサイズ以外のファイルオープン，false:ゼロサイズファイル）
		private bool FileOpen()
		{
			bool	rc = false;
			while (m_ListIx < m_ListCount) {
				//	入出力パス名設定
				Object obj = m_list[m_ListIx++];
				string pathes = (string)obj;
				string[] s = pathes.Split(';');
				m_InpPath  = s[0];
				m_OutPath  = s[1];
				vthLog.PutText("\n" + m_ListIx.ToString("D3") + " : " + m_InpPath + "\n");
				vthLog.PutText("   -> " + m_OutPath + " - ");
				//	入出力ファイルオープン
				m_InpFs    = new FileStream(m_InpPath, FileMode.Open);
				m_OutFs    = new FileStream(m_OutPath, FileMode.Create);
				//	ファイルサイズ設定
				m_FileSize = m_InpFs.Length;
				//	ゼロサイズならば、ファイルクローズ
				if (m_FileSize == 0) {
					vthLog.PutText("OK (Zero size)\n");
					if (m_InpFs != null) {m_InpFs.Dispose(); m_InpFs = null;}
					if (m_OutFs != null) {m_OutFs.Dispose(); m_OutFs = null;}
				}
				//	ゼロサイズ以外ならば、ファールオープンした旨を返す
				else {
					rc = true;
					break;
				}
			}
			return rc;
		}
		//	ファイル送信
		private void FileSend()
		{
			//	バッファサイズを超える残データ有りならば、データ送信し、バイト数減算
			if (m_FileSize > m_BufSize) {
				byte[] buf = new byte[m_BufSize];
				m_InpFs.Read(buf, 0, m_BufSize);
				m_Bytes += sct.SendPacket(buf);
				m_FileSize -= m_BufSize;
			}
			//	バッファサイズ以下の残データ有りならば、ファイル末尾データ送信
			else if (m_FileSize != 0) {
				byte[] buf = new byte[m_FileSize];
				m_InpFs.Read(buf, 0, (int)m_FileSize);
				m_Bytes += sct.SendPacket(buf);
				m_FileSize = 0;
			}
			//	残データ無しならば、ファイル終端を示す空パケットを送信
			else {
				//	空パケット送信
				m_Bytes += sct.SendPacket(null);
				//	入力ファイルクローズ
				if (m_InpFs != null) {m_InpFs.Dispose(); m_InpFs = null;}
			}
            //  送信バイトカウント表示
			lblBytes.Text = SAjrGsr.SepDecimal(m_Bytes.ToString());
		}
		//	ボタン群許可／禁止
		private void EnableButtons(bool fConnect, bool fStart, bool fStop)
		{
			btnConnect.Enabled = fConnect;	//	接続ボタン
			btnStart.Enabled   = fStart;	//	開始ボタン
			btnStop.Enabled    = fStop;		//	中止ボタン
		}
	}
}
