﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using CAjrCustCtrl;

namespace Sil_SockServer1
{
	public partial class ClientForm : Form
	{
		IntPtr			m_hClient;
		CAjrSockServer	m_Ssv;

		public ClientForm()
		{
			InitializeComponent();
		}
		//	フォーム開始
		private void ClientForm_Load(object sender, EventArgs e)
		{
			//	サイズ変更禁止
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			//	ツールチップ設定
			SAjrTip.Add(txtSndBin  , "バイナリデータ（２桁の１６進数を空白で区切って）設定してください");
			SAjrTip.Add(txtSndPkt  , "パケットデータ（２桁の１６進数を空白で区切って）設定してください");
			SAjrTip.Add(vthTxtChunk, "リアルタイムに受信したデータをテキストデータとして表示します。\n" +
									 "複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。");
			SAjrTip.Add(vthBinChunk, "リアルタイムに受信したデータをバイナリデータとして表示します。");
			SAjrTip.Add(vthInv	   , "リアルタイムに受信したテキストデータに不正な制御コードが含まれる場合は、\n" +
									 "テキストチャンクではなく、不正チャンクテキストとしてバイナリ表示します。\n" +
									 "不正な制御コードとは、TAB(0x09)～CR(0x0D)以外の制御コードを意味します。");
			SAjrTip.Add(vthPkt	   , "受信したパケットデータ（DLE・STX～DLE・ETX でサンドイッチされたデータ）をバイナリ表示します。");
			SAjrTip.Add(vthNoPkt   , "リアルタイムに受信したデータ内のパケットデータ（DLE・STX～DLE・ETX）以外の部分をテキストとして表示します。\n" +
									 "複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。");
			SAjrTip.Add(vthTxt	   , "受信ストリームから制御コード（TAB以外）で区切られたテキストデータを抜き出して表示します。\n" +
									 "ここにファイルをドロップすると、ファイルの内容をバイナリ送信します。");
			SAjrTip.Add(vthCtrl    , "受信ストリームから制御コード（TAB以外）を抜き出して表示します。");
			SAjrTip.Add(vthEsc	   , "受信したストリームから、ＥＳＣシーケンス（0x1B～英字）を抜きだして表示します。");
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
		}
		//	フォーム終了
		private void ClientForm_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	ウインド位置セーブ
			SAjrReg.SaveWndPos(this, m_Ssv.GetIpAddrStr(m_hClient) + "_");
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
			//	クライアント切断
			m_Ssv.Disconnect(m_hClient);
		}
		//	クライアントハンドル退避
		public void SaveHClient(CAjrSockServer ssv, IntPtr hClient)
		{
			m_Ssv	  = ssv;
			m_hClient = hClient;
			this.Text = "Sil_SockServer1 (" + m_Ssv.GetIpAddrStr(m_hClient) + ")";
			//	ウインド位置ロード
			SAjrReg.LoadWndPos(this, m_Ssv.GetIpAddrStr(m_hClient) + "_");
		}
		//	受信バイナリチャンク表示
		public void ShowBinaryChunk(Byte[] bin)
		{
			vthBinChunk.PutText("----- Binary Chunk " + bin.Length.ToString() + " Bytes -----\n");
			vthBinChunk.PrintHexDump(bin);
			vthBinChunk.PutText("\n");
		}
		//	受信テキストチャンク表示
		public void ShowTextChunk(string text)
		{
			vthTxtChunk.PutText(text);
		}
		//	受信不正チャンクテキスト表示
		public void ShowInvChunk(byte[] bin)
		{
			vthInv.PrintHexDump(bin);
			vthInv.PutText("\n");
		}
		//	受信テキスト表示
		public void ShowText(string text)
		{
			vthTxt.PutText(text + "\n");
		}
		//	受信ＥＳＣ表示
		public void ShowEsc(string esc)
		{
			vthEsc.PutText("\\x1B" + esc.Substring(1));
			vthEsc.PutText("\n");
		}
		//	受信制御コード表示
		public void ShowCtrl(char ctrl)
		{
			int c = (int)ctrl;
			vthCtrl.PutFormat("0x{0:X2}\n", c);
		}
		//	受信パケットデータ表示
		public void ShowPacket(byte[] bin)
		{
			if (bin != null) {
				vthPkt.PrintHexDump(bin);
				vthPkt.PutText("\n");
			}
		}
		//	受信パケット外テキスト表示
		public void ShowNoPkt(string text)
		{
			vthNoPkt.PutText(text);
		}
		//	テキスト表示ウインドにファイルドロップ（ファイル送信）
		private void vthTxt_OnFileDrop(object sender, VthArgFileDrop e)
		{
			for (int i = 0; i < e.n; i++) {
				string path = vthTxt.GetDroppedFile();
				SubReadAndSend(path);
			}
		}
		//	Disconnectボタン
		private void btnDisconnect_Click(object sender, EventArgs e)
		{
			m_Ssv.Disconnect(m_hClient);
		}
		//	テキスト送信ボタン
		private void btnSndTxt_Click(object sender, EventArgs e)
		{
			m_Ssv.SendText(m_hClient, txtSndTxt.Text + "\n");
		}
		//	ＥＳＣ送信ボタン
		private void btnSndEsc_Click(object sender, EventArgs e)
		{
			m_Ssv.SendText(m_hClient, "\x1B" + txtSndEsc.Text);
		}
		//	バイナリ送信ボタン
		private void btnSndBin_Click(object sender, EventArgs e)
		{
			string[] arr = txtSndBin.Text.Split(' ');
			int 	n = 0;
			//	有効な数算出
			for  (int i = 0; i < arr.Length; i++) {
				if (IsByteHexa(arr[i])) n++;
			}
			if (n != 0) {
				//		送信バイナリ作成
				Byte[] BArr = new Byte[n];
				int 	ix = 0;
				for  (int i = 0; i < arr.Length; i++) {
					if (IsByteHexa(arr[i])) {BArr[ix++] = Convert.ToByte(arr[i], 16);}
				}
				if (ix != 0) {
					m_Ssv.SendBinary(m_hClient, BArr);
				}
			}
		}
		//	パケット送信ボタン
		private void btnSndPkt_Click(object sender, EventArgs e)
		{
			string[] arr = txtSndPkt.Text.Split(' ');
			int 	n = 0;
			//	有効な数算出
			for  (int i = 0; i < arr.Length; i++) {
				if (IsByteHexa(arr[i])) n++;
			}
			if (n != 0) {
				//		送信バイナリ作成
				Byte[] BArr = new Byte[n];
				int 	ix = 0;
				for  (int i = 0; i < arr.Length; i++) {
					if (IsByteHexa(arr[i])) {BArr[ix++] = Convert.ToByte(arr[i], 16);}
				}
				if (ix != 0) {
					m_Ssv.SendPacket(m_hClient, BArr);
				}
			}
		}
		//	全てクリアーボタン
		private void btnClearAll_Click(object sender, EventArgs e)
		{
			vthTxtChunk.Purge();
			vthBinChunk.Purge();
			vthTxt	   .Purge();
			vthCtrl    .Purge();
			vthEsc	   .Purge();
			vthInv	   .Purge();
			vthPkt	   .Purge();
			vthNoPkt   .Purge();
		}
		//	バイナリファイルの読み出しと送信
		private void SubReadAndSend(string FilePath)
		{
			FileStream fs = new FileStream(FilePath, FileMode.Open, FileAccess.Read);
			int FileSize  = (int)fs.Length; 		//	ファイルのサイズ
			byte[] buf	  = new byte[FileSize]; 	//	データ格納用配列
			fs.Read(buf, 0, FileSize);				//	ファイル読み出し
			m_Ssv.SendBinary(m_hClient, buf);		//	バイナリデータ送信
			fs.Dispose();
		}
		//	１６進文字列チェック
		private bool IsByteHexa(string s)
		{
			bool	rc = false;
			do {
				 if (string.IsNullOrEmpty(s)) break;
				 if (s.Length != 2) break;
				 if (!Uri.IsHexDigit(s[0])) break;
				 if (!Uri.IsHexDigit(s[1])) break;
				 rc = true;
			} while (false);
			return rc;
		}
	}
}
