﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_SockServer1
{
	public partial class Form1 : Form
	{
		public Form1()
		{
			InitializeComponent();
		}
		//	起動時初期設定
		private void Form1_Load(object sender, EventArgs e)
		{
			//	サイズ変更禁止
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			//	ホスト名表示
			lblMyName.Text = Environment.MachineName;
            //  ウインド位置ロード
            SAjrReg.LoadWndPos(this);
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//	テキストエンコード設定
			 SetTextEncode();
		}
		//	終了処理
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
            //  ウインド位置セーブ
            SAjrReg.SaveWndPos(this);
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//	サーバ開始ボタン
		private void btnStart_Click(object sender, EventArgs e)
		{

			uint pno;
			uint.TryParse(txtPortNo.Text, out pno);
			int  mxc;
			int.TryParse(txtMaxClients.Text, out mxc);
			ssv.Start(pno, mxc);
		}
		//	サーバ停止ボタン
		private void btnStop_Click(object sender, EventArgs e)
		{
			ssv.Stop();
		}
		//	サーバ開始通知
		private void ssv_OnStart(object sender, CAjrCustCtrl.SsvArgStart e)
		{
			btnStart.Enabled = false;
			btnStop.Enabled  = true;
		}
		//	サーバ停止通知
		private void ssv_OnStop(object sender, CAjrCustCtrl.SsvArgStop e)
		{
			btnStart.Enabled = true;
			btnStop.Enabled  = false;
		}
		//	接続通知
		private void ssv_OnConnect(object sender, CAjrCustCtrl.SsvArgConnect e)
		{
			//	クライアントフォーム表示
			ClientForm cf = new ClientForm();
			cf.Text = ssv.GetIpAddrStr(e.hClient);
			cf.Show();
			//	クライアントにフォームを関連付ける
			ssv.SetClientData(e.hClient, (object)cf);
			//	リストボックスにクライアントのＩＰアドレス追加
			lbxClient.Items.Add(ssv.GetIpAddrStr(e.hClient));
			//	フォームにクライアントハンドル退避
			cf.SaveHClient(ssv, e.hClient);
		}
		//	切断通知
		private void ssv_OnDisconnect(object sender, CAjrCustCtrl.SsvArgDisconnect e)
		{
			//	クライアントに関連付けたフォームを取得
			ClientForm cf = GetClientForm(e.hClient);
			//	フォームを閉じる
			cf.Close();
			//	リストボックスのクライアントのＩＰアドレス削除
			lbxClient.Items.Remove(ssv.GetIpAddrStr(e.hClient));
		}
		//	バイナリチャンク受信通知
		private void ssv_OnRxChunkBin(object sender, CAjrCustCtrl.SsvArgRxChunkBin e)
		{
			//	クライアントに関連付けたフォームを取得
			ClientForm cf = GetClientForm(e.hClient);
			//	バイナリチャンクデータ表示
			cf.ShowBinaryChunk(e.bin);
		}
		//	テキストチャンク受信通知
		private void ssv_OnRxChunkTxt(object sender, CAjrCustCtrl.SsvArgRxChunkTxt e)
		{
			//	クライアントに関連付けたフォームを取得
			ClientForm cf = GetClientForm(e.hClient);
			//	テキストチャンクデータ表示
			cf.ShowTextChunk(e.text);
		}
		//	不正テキストチャンク受信通知
		private void ssv_OnRxInvChunk(object sender, CAjrCustCtrl.SsvArgRxInvChunk e)
		{
			//	クライアントに関連付けたフォームを取得
			ClientForm cf = GetClientForm(e.hClient);
			//	不正テキストチャンク表示
			cf.ShowInvChunk(e.bin);
		}
		//	テキスト受信通知
		private void ssv_OnRxText(object sender, CAjrCustCtrl.SsvArgRxText e)
		{
			//	クライアントに関連付けたフォームを取得
			ClientForm cf = GetClientForm(e.hClient);
			//	テキスト表示
			cf.ShowText(e.text);
		}
		//	制御コード受信通知
		private void ssv_OnRxCtrl(object sender, CAjrCustCtrl.SsvArgRxCtrl e)
		{
			//	クライアントに関連付けたフォームを取得
			ClientForm cf = GetClientForm(e.hClient);
			//	制御コード表示
			cf.ShowCtrl(e.ctrl);
		}
		//	エスケープシーケンス受信通知
		private void ssv_OnRxEsc(object sender, CAjrCustCtrl.SsvArgRxEsc e)
		{
			//	クライアントに関連付けたフォームを取得
			ClientForm cf = GetClientForm(e.hClient);
			//	エスケープシーケンス表示
			cf.ShowEsc(e.esc);
		}
		//	パケット受信通知
		private void ssv_OnRxPacket(object sender, CAjrCustCtrl.SsvArgRxPacket e)
		{
			if (e.bin != null) {
				//	クライアントに関連付けたフォームを取得
				ClientForm cf = GetClientForm(e.hClient);
   				//	パケットデータ表示
				cf.ShowPacket(e.bin);
			}
		}
		//	パケット外テキスト受信通知
		private void ssv_OnRxNoPkt(object sender, CAjrCustCtrl.SsvArgRxNoPkt e)
		{
			//	クライアントに関連付けたフォームを取得
			ClientForm cf = GetClientForm(e.hClient);
			//	パケット外テキスト表示
			cf.ShowNoPkt(e.text);
		}
		//	受信エラー通知
		private void ssv_OnRecvError(object sender, CAjrCustCtrl.SsvArgRecvError e)
		{
			vthError.PutText(ssv.GetIpAddrStr(e.hClient) + " : ");;
			if (e.overlapped) vthError.PutText("受信エラー(GetOverlappedResult)\n");
			else			  vthError.PutText("受信エラー(WSARecv)\n");
		}
		//	送信エラー通知
		private void ssv_OnSendError(object sender, CAjrCustCtrl.SsvArgSendError e)
		{
			vthError.PutText(ssv.GetIpAddrStr(e.hClient) + " : ");;
			if (e.overlapped) vthError.PutText("送信エラー(GetOverlappedResult)\n");
			else			  vthError.PutText("送信エラー(WSASend)\n");
		}
		//	その他のエラー通知
		private void ssv_OnGeneralError(object sender, CAjrCustCtrl.SsvArgGeneralError e)
		{
			switch (e.ErrorCode) {
				case ESsvErrorCode.ERR_CREEVT:		 vthError.PutText("CreateEvent() 失敗\n"				  ); break;
				case ESsvErrorCode.ERR_SOCKET:		 vthError.PutText("ソケット生成失敗\n"					  ); break;
				case ESsvErrorCode.ERR_BIND:		 vthError.PutText("bind 失敗\n"							  ); break;
				case ESsvErrorCode.ERR_LISTEN:		 vthError.PutText("listen 失敗\n"						  ); break;
				case ESsvErrorCode.ERR_ACCEPT:		 vthError.PutText("accept 失敗\n"						  ); break;
				case ESsvErrorCode.ERR_ADDRINFO:	 vthError.PutText("getaddrinfo 失敗\n"					  ); break;
				case ESsvErrorCode.ERR_SOCKOPT:		 vthError.PutText("setsockopt() 失敗\n"					  ); break;
				case ESsvErrorCode.ERR_THREADLISTEN: vthError.PutText("接続待機スレッド開始失敗\n"			  ); break;
				case ESsvErrorCode.ERR_THREADCLIENT: vthError.PutText("クライアント通信スレッド開始失敗\n"	  ); break;
				case ESsvErrorCode.ERR_CRESSEP:		 vthError.PutText("ストリーム分離生成失敗\n"			  ); break;
				case ESsvErrorCode.ERR_CREMBXTXD:	 vthError.PutText("送信データ用メールボックス生成失敗\n"  ); break;
				case ESsvErrorCode.ERR_TIMEOUT:		 vthError.PutText("サーバ終了タイムアウト\n"			  ); break;
			}
		}
		//	クライアントに関連付けたフォームを取得
		private ClientForm GetClientForm(IntPtr hClient)
		{
			object obj;
			ssv.GetClientData(hClient, out obj);
			return (ClientForm)obj;
		}
		//----- 受信テキストエンコード設定ラジオボタン -------------------------//
		private void rbtRxSJis_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxUTF8_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxEuc_CheckedChanged (object sender, EventArgs e) {SetTextEncode();}
		private void rbtRxAuto_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		//----- 送信テキストエンコード設定ラジオボタン -------------------------//
		private void rbtTxSJis_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxUTF8_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxEuc_CheckedChanged (object sender, EventArgs e) {SetTextEncode();}
		private void rbtTxAuto_CheckedChanged(object sender, EventArgs e) {SetTextEncode();}
		//	テキストエンコード設定
		private void SetTextEncode()
		{
			if		(rbtRxSJis.Checked) ssv.RxTextCode = ESsvRxTextCode.SJIS;
			else if (rbtRxUTF8.Checked) ssv.RxTextCode = ESsvRxTextCode.UTF8;
			else if (rbtRxEuc .Checked) ssv.RxTextCode = ESsvRxTextCode.EUC;
			else if (rbtRxAuto.Checked) ssv.RxTextCode = ESsvRxTextCode.AUTO;

			if		(rbtTxSJis.Checked) ssv.TxTextCode = ESsvTxTextCode.SJIS;
			else if (rbtTxUTF8.Checked) ssv.TxTextCode = ESsvTxTextCode.UTF8;
			else if (rbtTxEuc .Checked) ssv.TxTextCode = ESsvTxTextCode.EUC;
			else if (rbtTxAuto.Checked) ssv.TxTextCode = ESsvTxTextCode.SJIS;
		}
	}
}
