﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_StrPool
{
	public partial class Form1 : Form
	{
		public Form1()
		{
			InitializeComponent();
		}
		//	フォーム開始
		private void Form1_Load(object sender, EventArgs e)
		{
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//	初期文字列登録
			SetInitialValue();
		}
		//	フォーム終了
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//	RECOGNIZE_WIDTH （英大小区別あり）
		private void rbtRECOGNIZEWIDTH_CheckedChanged(object sender, EventArgs e)
		{
			spl.CompMode = ESplComp.RECOGNIZE_WIDTH;
			ShowAll();
		}
		//	IGNORE_WIDTH （英大小区別なし）
		private void rbtIGNOREWIDTH_CheckedChanged(object sender, EventArgs e)
		{
			spl.CompMode = ESplComp.IGNORE_WIDTH;
			ShowAll();
		}
		//	ALPHABETIC （英大小区別あり，英字順）
		private void rbtMIXTURE_CheckedChanged(object sender, EventArgs e)
		{
			spl.CompMode = ESplComp.ALPHABETIC;
			ShowAll();
		}
		//	Ascending（昇順）
		private void rbtAscending_CheckedChanged(object sender, EventArgs e)
		{
			ShowAll();
		}
		//	Descending（降順）
		private void rbtDescending_CheckedChanged(object sender, EventArgs e)
		{
			ShowAll();
		}

		//	文字列登録
		private void cmdRegist_Click(object sender, EventArgs e)
		{
			IntPtr ptr = spl.RegistPtr(txtRegist.Text);
			lblRegist.Text = spl.PtrToString(ptr);
			ShowAll();
		}
		//	文字列検索
		private void cmdFind_Click(object sender, EventArgs e)
		{
			IntPtr ptr = spl.FindPtr(txtFind.Text);
			if (ptr != (IntPtr)0) lblFind.Text = spl.PtrToString(ptr);
			else				  lblFind.Text = "Not found";
		}
		//	文字列プール中の部分文字列検索
		private void cmdInPool_Click(object sender, EventArgs e)
		{
			IntPtr ptr; 
			if (rbtInPoolMATCHFIRST.Checked) ptr = spl.PartStrInPoolPtr(txtInPool.Text, ESplInStr.MATCHFIRST);
			else							 ptr = spl.PartStrInPoolPtr(txtInPool.Text, ESplInStr.INCLUDING );
			if (ptr != (IntPtr)0) lblInPool.Text = spl.PtrToString(ptr);
			else				  lblInPool.Text = "Not found";
		}
		//	文字列プールの各文字列を部分文字列として検索
		private void cmdInStr_Click(object sender, EventArgs e)
		{
			IntPtr ptr;
			if (rbtInStrMATCHFIRST.Checked) ptr = spl.PoolStrInStrPtr(txtInStr.Text, ESplInStr.MATCHFIRST);
			else							ptr = spl.PoolStrInStrPtr(txtInStr.Text, ESplInStr.INCLUDING );
			if (ptr != (IntPtr)0) lblInStr.Text = spl.PtrToString(ptr);
			else				  lblInStr.Text = "Not found";
		}
		//	文字列削除
		private void cmdRemove_Click(object sender, EventArgs e)
		{
			if (spl.Remove(txtRemove.Text)) lblRemove.Text = "Success";
			else							lblRemove.Text = "Failure";
			ShowAll();
		}
		//	文字列プールリセット
		private void cmdReset_Click(object sender, EventArgs e)
		{
			spl.Reset();
			ShowAll();
		}
		//	文字列プールの内容表示
		private void ShowAll()
		{
			vth.Purge();
			if (rbtAscending.Checked) spl.EnumStr(ESplSeq.Ascending);
			else					  spl.EnumStr(ESplSeq.Descending);
		}
		//	文字列通知イベント
		private bool spl_OnNtcStr(object sender, CAjrCustCtrl.SplArgNtcStr e)
		{
			vth.PutText(e.str + "\n");
			return true;
		}
		//	初期値登録
		private void cmdInit_Click(object sender, EventArgs e)
		{
			 SetInitialValue();
		}
		private void SetInitialValue()
		{
			vth.Purge();
			spl.Regist("Sapporo" );
			spl.Regist("Sendai"  );
			spl.Regist("Niigata" );
			spl.Regist("Yokohama");
			spl.Regist("Nagoya"  );
			spl.Regist("Hirosima");
			spl.Regist("Fukuoka" );
			ShowAll();
		}
	}
}
