﻿//
//	Sil_TextFile
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_TextFile
{
	public partial class Form1 : Form
	{
		public Form1()
		{
			InitializeComponent();
		}

		//	フォーム開始
		private void Form1_Load(object sender, EventArgs e)
		{
            //  サイズ変更不可
            this.FormBorderStyle = FormBorderStyle.FixedSingle;
            //	設定値ロード
			SAjrReg.LoadAllCtrls(this);
            //  テキストボックスにファイルドロップ許可
            SAjrGsr.EnableDropToTextBox (this);
		}

		//	フォーム終了
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}

		//	ファイル読み出しボタン
		private void cmdRead_Click(object sender, EventArgs e)
		{
			//	テキストエンコード設定
			ETextEncode		tec = ETextEncode.TEC_MBC;
			if		(rbtMBC_I.Checked	 ) tec = ETextEncode.TEC_MBC;
			else if (rbtUTF8_I.Checked	 ) tec = ETextEncode.TEC_UTF_8;
			else if (rbtEUCJ_I.Checked	 ) tec = ETextEncode.TEC_EUC_J;
			else if (rbtUTF16LE_I.Checked) tec = ETextEncode.TEC_UTF_16LE;
			else if (rbtUTF16BE_I.Checked) tec = ETextEncode.TEC_UTF_16BE;
			else if (rbtAUTO_I.Checked	 ) tec = ETextEncode.TEC_AUTO;
			//	ファイルを読み出して表示
			vth.Purge();
            try {
    			txf.Open(txtPath_I.Text, tec);
            }
            catch (Exception exc) {
                vth.PutText("\x1B[31m" + exc.ToString() + "\x1B[0m\n");
                return;
            }
			switch (txf.TextEncodeAtRead) {
				case ETextEncode.TEC_MBC:		txtRxTec.Text = "MBC(S-JIS)"; break;
				case ETextEncode.TEC_UTF_8:		txtRxTec.Text = "UTF-8";	  break;
				case ETextEncode.TEC_EUC_J:		txtRxTec.Text = "EUC-J";	  break;
				case ETextEncode.TEC_UTF_16LE:	txtRxTec.Text = "UTF-16LE";   break;
				case ETextEncode.TEC_UTF_16BE:	txtRxTec.Text = "UTF-16BE";   break;
			}
			for (string s = txf.GetS(); s != null; s = txf.GetS()) {
				vth.PutText(s);
			}
			txf.Close();
		}

		//	ファイル書き込みボタン
		private void cmdWrite_Click(object sender, EventArgs e)
		{
			//	テキストエンコード設定
			ETextEncode		tec = ETextEncode.TEC_MBC;
			if		(rbtMBC_O.Checked	 ) tec = ETextEncode.TEC_MBC;
			else if (rbtUTF8_O.Checked	 ) tec = ETextEncode.TEC_UTF_8;
			else if (rbtEUCJ_O.Checked	 ) tec = ETextEncode.TEC_EUC_J;
			else if (rbtUTF16LE_O.Checked) tec = ETextEncode.TEC_UTF_16LE;
			else if (rbtUTF16BE_O.Checked) tec = ETextEncode.TEC_UTF_16BE;
			//	表示テキストをファイルへ出力
            try {
                if (chkAppend.Checked) txf.Append(txtPath_O.Text, tec, chkWriteBOM.Checked ? EBomMode.WRITE_BOM : EBomMode.NOT_WRITE_BOM);
                else                   txf.Create(txtPath_O.Text, tec, chkWriteBOM.Checked ? EBomMode.WRITE_BOM : EBomMode.NOT_WRITE_BOM);
            }
            catch (Exception exc) {
                vth.PutText("\x1B[31m" + exc.ToString() + "\x1B[0m\n");
                return;
            }
			for (int i = 0; i < vth.LineCount; i++) {
				string s = vth.GetLineText(i);
				txf.PutS(s + "\n");
			}
			txf.Close();
		}
	}
}
