﻿//
//	Sil_TimeChart1
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_TimeChart1
{
	public partial class Form1 : Form
	{
		double	m_Theta = 0.0;
		bool	m_fStop = true;

		public Form1()
		{
			InitializeComponent();
		}
		//----- 起動時初期設定 ---------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			//----- フォームの縦サイズ変更禁止 -----------------------//
			int width  = this.Width;
			int height = this.Height;
			this.MinimumSize = new Size(width, height);
			this.MaximumSize = new Size(1900 , height);
			//----- タイトルテキスト設定 -----------------------------//
            tch1.SetTitleText(" 三角関数 ", Color.Blue, Color.Aqua, 
												new Font("MS UI Gothic", 9, FontStyle.Bold | FontStyle.Italic));
			tch2.SetTitleText(" 球面座標 ", Color.Blue, Color.Aqua,
                                                new Font("MS UI Gothic", 9, FontStyle.Bold | FontStyle.Italic));
            //----- 注釈テキスト描画 ---------------------------------//
            tch1.TextOut(Txo.Center, 3, "\x1B[30mSin \x1B[31mCos \x1B[32mTan");
            tch2.TextOut(Txo.Center, 3, "\x1B[30mＸ \x1B[31mＹ \x1B[32mＺ");
            //----- 設定値ロード -------------------------------------//
			SAjrReg.LoadAllCtrls(this);
		}
		//----- 終了時後処理 -----------------------------------------//
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//----- タイマイベント ---------------------------------------//
		private void tim_Tick(object sender, EventArgs e)
		{
			if (!m_fStop) {
				//	データ投与（タイムチャート１）
				double s = SAjrMath.Sin(m_Theta);
				double c = SAjrMath.Cos(m_Theta);
				double t = SAjrMath.Tan(m_Theta);
				t = Math.Min(t,  2.0);
				t = Math.Max(t, -2.0);
				tch1.PutData(s, c, t);
				m_Theta += 1.0;
                //  ログ表示
                vth1.PutText(string.Format("x={0,5:f2}, y={1,5:f2} z={2,5:f2}\n", s, c, t));
				//	データ投与（タイムチャート２）
				AJC3DVEC	v = spd.Calc();
				tch2.PutData(v.x, v.y, v.z);
                //  ログ表示
                vth2.PutText(string.Format("x={0,5:f2}, y={1,5:f2} z={2,5:f2}\n", v.x, v.y, v.z));
			}
		}
		//----- タイムチャート1・スクロール通知 ----------------------//
		private void tch1_OnNtcScrollPos(object sender, TchArgNtcScrollPos e)
		{
			if (m_fStop) {
				tch2.SetScrollPos(e.pos);
			}
		}
		//----- タイムチャート1・レンジ変化通知 ----------------------//
		private void tch1_OnRangeChanged(object sender, TchArgRangeChanged e)
		{
			SAjrTip.ShowCenter(tch1, "レンジが設定されました。");
		}
		//----- タイムチャート1・右クリック通知 ----------------------//
		private void tch1_OnRClick(object sender, TchArgRClick e)
		{
			SAjrTip.ShowCenter(tch1, (e.ctrl ? "CTRL + " : "") + (e.shift ? "SHIFT + " : "") +
									 "右クリック発生 (x = " + e.x.ToString() + ", y = " + e.y.ToString() + ")");
		}
		//----- タイムチャート1・ディレクトリドロップ通知 ------------//
		private void tch1_OnDirDrop(object sender, TchArgDirDrop e)
		{
			string text = "ディレクトリがドロップされました。";
			for (int i = 0; i < e.n; i++) {
				text = text + "\n  " + tch1.GetDroppedDir();
			}
			SAjrTip.ShowCenter(tch1, text);
		}
		//----- タイムチャート1・ファイルドロップ通知 ----------------//
		private void tch1_OnFileDrop(object sender, TchArgFileDrop e)
		{
			string text = "ファイルがドロップされました。";
			for (int i = 0; i < e.n; i++) {
				text = text + "\n  " + tch1.GetDroppedFile();
			}
			SAjrTip.ShowCenter(tch1, text);
		}
		//----- タイムチャート２・スクロール通知 ---------------------//
		private void tch2_OnNtcScrollPos(object sender, TchArgNtcScrollPos e)
		{
			if (m_fStop) {
				tch1.SetScrollPos(e.pos);
			}
		}
		//----- タイムチャート２・レンジ変化通知 ---------------------//
		private void tch2_OnRangeChanged(object sender, TchArgRangeChanged e)
		{
			SAjrTip.ShowCenter(tch2, "レンジが設定されました。");
		}
		//----- タイムチャート２・右クリック通知 ---------------------//
		private void tch2_OnRClick(object sender, TchArgRClick e)
		{
			SAjrTip.ShowCenter(tch2, "右クリック発生 (x = " + e.x.ToString() + ", y = " + e.y.ToString() + ")");
		}
		//----- タイムチャート２・ディレクトリドロップ通知 -----------//
		private void tch2_OnDirDrop(object sender, TchArgDirDrop e)
		{
			string text = "ディレクトリがドロップされました。";
			for (int i = 0; i < e.n; i++) {
				text = text + "\n  " + tch2.GetDroppedDir();
			}
			SAjrTip.ShowCenter(tch2, text);
		}
		//----- タイムチャート２・ファイルドロップ通知 ---------------//
		private void tch2_OnFileDrop(object sender, TchArgFileDrop e)
		{
			string text = "ファイルがドロップされました。";
			for (int i = 0; i < e.n; i++) {
				text = text + "\n  " + tch2.GetDroppedFile();
			}
			SAjrTip.ShowCenter(tch2, text);
		}
		//----- プロット開始／停止ボタン -----------------------------//
		private void btnStart_Click(object sender, EventArgs e)
		{
			if (m_fStop) {
				tch1.Start();
				tch2.Start();
				tim.Enabled = true;
				m_fStop 	= false;
				btnStart.Text = "プロット停止";
			}
			else {
				tch1.Stop();
				tch2.Stop();
				tim.Enabled = false;
				m_fStop 	= true;
				btnStart.Text = "プロット開始";
			}
		}
		//----- プロット周期変更通知 ---------------------------------//
		private void cAjrInpValue1_OnNtcIntValue(object sender, IvArgNtcIntValue e)
		{
			tim.Interval = e.value;
		}
		//----- Enable ボタン ----------------------------------------//
		private void btnEnable_Click(object sender, EventArgs e)
		{
			tch1.Enabled = true;
			tch2.Enabled = true;
		}
		//----- Disable ボタン ---------------------------------------//
		private void btnDisable_Click(object sender, EventArgs e)
		{
			tch1.Enabled = false;
			tch2.Enabled = false;
		}
		//----- スタイル設定チェックボックス群 -----------------------//
		private void chkShowBorder_CheckedChanged	 (object sender, EventArgs e) {tch1.ShowBorder	   = chkShowBorder	  .Checked;}
		private void chkShowFilter_CheckedChanged	 (object sender, EventArgs e) {tch1.ShowFilter	   = chkShowFilter	  .Checked;}
		private void chkShowScaleLine_CheckedChanged (object sender, EventArgs e) {tch1.ShowScaleLine  = chkShowScaleLine .Checked;}
		private void chkShowScaleValue_CheckedChanged(object sender, EventArgs e) {tch1.ShowScaleValue = chkShowScaleValue.Checked;}
		//----- データ項目の表示色設定ボタン群 -----------------------//
		private void btnColor0_Click(object sender, EventArgs e) {SetItemColor(0);}
		private void btnColor1_Click(object sender, EventArgs e) {SetItemColor(1);}
		private void btnColor2_Click(object sender, EventArgs e) {SetItemColor(2);}
		//----- データ項目の表示色設定 -------------------------------//
		private void SetItemColor(int id)
		{
			ColorDialog cd = new ColorDialog();
			cd.Color = tch1.GetItemColor(id);
			if (cd.ShowDialog() == DialogResult.OK)
			{
				tch1.SetItemColor(id, cd.Color);
			}
		}
	}
}
