﻿'
' Sil_TimeChart1
'
Imports CAjrCustCtrl

Public Class Form1
    Dim m_Theta As Double = 0.0
    Dim m_fStop As Boolean = True
    '//----- 起動時初期設定 ---------------------------------------//
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        If (IntPtr.Size = 4) Then : Me.Text = Me.Text + " (WIN32)" : Else : Me.Text = Me.Text + " (WIN64)" : End If
        '//----- フォームの縦サイズ変更禁止 -----------------------//
        Dim width As Integer = Me.Width
        Dim height As Integer = Me.Height
        Me.MinimumSize = New Size(width, height)
        Me.MaximumSize = New Size(1900, height)
        '//----- タイトルテキスト設定 -----------------------------//
        tch1.SetTitleText(" Sin, Cos Tan", Color.Blue, Color.Aqua, New Font("Terminal", 9, FontStyle.Bold Or FontStyle.Italic))
        tch2.SetTitleText(" Sample data ", Color.Blue, Color.Aqua, New Font("Terminal", 9, FontStyle.Bold Or FontStyle.Italic))
        '//----- 設定値ロード -------------------------------------//
        SAjrReg.LoadAllCtrls(Me)
    End Sub
    '//----- 終了時後処理 -----------------------------------------//
    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        '//	設定値セーブ
        SAjrReg.SaveAllCtrls(Me)
    End Sub
    '//----- タイマイベント ---------------------------------------//
    Private Sub tim_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tim.Tick
        If (Not m_fStop) Then
            '//	データ投与（タイムチャート１）
            Dim s As Double = SAjrMath.Sin(m_Theta)
            Dim c As Double = SAjrMath.Cos(m_Theta)
            Dim t As Double = SAjrMath.Tan(m_Theta)
            t = Math.Min(t, 2.0)
            t = Math.Max(t, -2.0)
            tch1.PutData(s, c, t)
            m_Theta += 1.0
            '// ログ表示
            vth1.PutText(String.Format("x={0,5:f2}, y={1,5:f2} z={2,5:f2}" + vbLf, s, c, t))
            '//	データ投与（タイムチャート２）
            Dim v As AJC3DVEC = spd.Calc()
            tch2.PutData(v.x, v.y, v.z)
            '//  ログ表示
            vth2.PutText(String.Format("x={0,5:f2}, y={1,5:f2} z={2,5:f2}" + vbLf, v.x, v.y, v.z))
        End If
    End Sub
    '//----- タイムチャート1・スクロール通知 ----------------------//
    Private Sub tch1_OnNtcScrollPos(ByVal sender As System.Object, ByVal e As CAjrCustCtrl.TchArgNtcScrollPos) Handles tch1.OnNtcScrollPos
        If (m_fStop) Then
            tch2.SetScrollPos(e.pos)
        End If
    End Sub
    '//----- タイムチャート1・レンジ変化通知 ----------------------//
    Private Sub tch1_OnRangeChanged(sender As System.Object, e As CAjrCustCtrl.TchArgRangeChanged) Handles tch1.OnRangeChanged
        SAjrTip.ShowCenter(tch1, "レンジが設定されました。")
    End Sub
    '//----- タイムチャート1・右クリック通知 ----------------------//
    Private Sub tch1_OnRClick(sender As System.Object, e As CAjrCustCtrl.TchArgRClick) Handles tch1.OnRClick
        SAjrTip.ShowCenter(tch1, IIf(e.ctrl, "CTRL + ", "") + IIf(e.shift, "SHIFT + ", "") +
                                 "右クリック発生 (x = " + e.x.ToString() + ", y = " + e.y.ToString() + ")")
    End Sub
    '//----- タイムチャート1・ディレクトリドロップ通知 ------------//
    Private Sub tch1_OnDirDrop(sender As System.Object, e As CAjrCustCtrl.TchArgDirDrop) Handles tch1.OnDirDrop
        Dim text As String = "ディレクトリがドロップされました。"
        Dim i As Integer
        For i = 0 To e.n - 1
            text = text + "\n  " + tch1.GetDroppedDir()
        Next
        SAjrTip.ShowCenter(tch1, text)
    End Sub
    '//----- タイムチャート1・ファイルドロップ通知 ----------------//
    Private Sub tch1_OnFileDrop(sender As System.Object, e As CAjrCustCtrl.TchArgFileDrop) Handles tch1.OnFileDrop
        Dim text As String = "ファイルがドロップされました。"
        Dim i As Integer
        For i = 0 To e.n - 1
            text = text + "\n  " + tch1.GetDroppedFile()
        Next
        SAjrTip.ShowCenter(tch1, text)
    End Sub
    '//----- タイムチャート２・スクロール位置変化通知 -------------//
    Private Sub tch2_OnNtcScrollPos(ByVal sender As System.Object, ByVal e As CAjrCustCtrl.TchArgNtcScrollPos) Handles tch2.OnNtcScrollPos
        If (m_fStop) Then
            tch1.SetScrollPos(e.pos)
        End If
    End Sub
    '//----- タイムチャート２・レンジ変化通知 ---------------------//
    Private Sub tch2_OnRangeChanged(sender As System.Object, e As CAjrCustCtrl.TchArgRangeChanged) Handles tch2.OnRangeChanged
        SAjrTip.ShowCenter(tch2, "レンジが設定されました。")
    End Sub
    '//----- タイムチャート２・右クリック通知 ---------------------//
    Private Sub tch2_OnRClick(sender As System.Object, e As CAjrCustCtrl.TchArgRClick) Handles tch2.OnRClick
        SAjrTip.ShowCenter(tch2, IIf(e.ctrl, "CTRL + ", "") + IIf(e.shift, "SHIFT + ", "") +
                                 "右クリック発生 (x = " + e.x.ToString() + ", y = " + e.y.ToString() + ")")
    End Sub
    '//----- タイムチャート２・ディレクトリドロップ通知 -----------//
    Private Sub tch2_OnDirDrop(sender As System.Object, e As CAjrCustCtrl.TchArgDirDrop) Handles tch2.OnDirDrop
        Dim text As String = "ディレクトリがドロップされました。"
        Dim i As Integer
        For i = 0 To e.n - 1
            text = text + "\n  " + tch2.GetDroppedDir()
        Next
        SAjrTip.ShowCenter(tch2, text)
    End Sub
    '//----- タイムチャート２・ファイルドロップ通知 ---------------//
    Private Sub tch2_OnFileDrop(sender As System.Object, e As CAjrCustCtrl.TchArgFileDrop) Handles tch2.OnFileDrop
        Dim text As String = "ファイルがドロップされました。"
        Dim i As Integer
        For i = 0 To e.n - 1
            text = text + "\n  " + tch2.GetDroppedFile()
        Next
        SAjrTip.ShowCenter(tch2, text)
    End Sub
    '//----- プロット開始／停止ボタン -----------------------------//
    Private Sub btnStart_Click(sender As System.Object, e As System.EventArgs) Handles btnStart.Click
        If m_fStop Then
            tch1.Start()
            tch2.Start()
            tim.Enabled = True
            m_fStop = False
            btnStart.Text = "プロット停止"
        Else
            tch1.Stop()
            tch2.Stop()
            tim.Enabled = False
            m_fStop = True
            btnStart.Text = "プロット開始"
        End If
    End Sub
    '//----- プロット周期変更通知 ---------------------------------//
    Private Sub cAjrInpValue1_OnNtcIntValue(sender As System.Object, e As CAjrCustCtrl.IvArgNtcIntValue) Handles cAjrInpValue1.OnNtcIntValue
        tim.Interval = e.value
    End Sub
    '//----- Enable ボタン ----------------------------------------//
    Private Sub btnEnable_Click(sender As System.Object, e As System.EventArgs) Handles btnEnable.Click
        tch1.Enabled = True
        tch2.Enabled = True
    End Sub
    '//----- Disable ボタン ---------------------------------------//
    Private Sub btnDisable_Click(sender As System.Object, e As System.EventArgs) Handles btnDisable.Click
        tch1.Enabled = False
        tch2.Enabled = False
    End Sub
    '//----- スタイル設定チェックボックス群 -----------------------//
    Private Sub chkShowBorder_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkShowBorder.CheckedChanged
        tch1.ShowBorder = chkShowBorder.Checked
    End Sub

    Private Sub chkShowFilter_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkShowFilter.CheckedChanged
        tch1.ShowFilter = chkShowFilter.Checked
    End Sub

    Private Sub chkShowScaleLine_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkShowScaleLine.CheckedChanged
        tch1.ShowScaleLine = chkShowScaleLine.Checked
    End Sub

    Private Sub chkShowScaleValue_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkShowScaleValue.CheckedChanged
        tch1.ShowScaleValue = chkShowScaleValue.Checked
    End Sub
    '//----- データ項目の表示色設定ボタン群 -----------------------//
    Private Sub btnColor0_Click(sender As System.Object, e As System.EventArgs) Handles btnColor0.Click
        SetItemColor(0)
    End Sub

    Private Sub btnColor1_Click(sender As System.Object, e As System.EventArgs) Handles btnColor1.Click
        SetItemColor(1)
    End Sub

    Private Sub btnColor2_Click(sender As System.Object, e As System.EventArgs) Handles btnColor2.Click
        SetItemColor(2)
    End Sub

    Private Sub SetItemColor(id As Integer)
        Dim cd As New ColorDialog()
        cd.Color = tch1.GetItemColor(id)
        If cd.ShowDialog() = DialogResult.OK Then
            tch1.SetItemColor(id, cd.Color)
        End If
    End Sub
End Class
