﻿//
//	SP_AVL.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

//	ノードデータ形式
typedef struct {
	UTP 	pTimStr;			//	ヒープ上の時刻文字列へのポインタ
} NODEDATA, *PNODEDATA;

//----- CAjxAvs, CAjxCon の派生クラス --------------------------------------------------------------------------//
class CAjxAvsEx : public CAjxAvs, public CAjxCon
{
private:
	NODEDATA	m_Node;
public:
	//	コンストラクタ（初期ノード登録）
	CAjxAvsEx()
	{
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited AAA")); InsNode(TEXT("AAA"), &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited BBB")); InsNode(TEXT("BBB"), &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited CCC")); InsNode(TEXT("CCC"), &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited DDD")); InsNode(TEXT("DDD"), &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited EEE")); InsNode(TEXT("EEE"), &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited FFF")); InsNode(TEXT("FFF"), &m_Node, sizeof m_Node);
	}
	//	デストラクタ
	~CAjxAvsEx()
	{
		//	デストラクト中に OnNtcRemove() を発生させるには DelAllNodes() メソッドを実行します
		DelAllNodes();
	}
	//	ノード削除通知
	VO OnNtcRemove (C_UTP pKey, VOP pNodeData, UI len, UI nest) override
	{
		SAjxCon::PrintF(TEXT("ノードが削除されました - key=%s, len=%d, nest=%d, data='%s'\n"), pKey, len, nest, ((PNODEDATA)pNodeData)->pTimStr);
		AjcTFree(((PNODEDATA)pNodeData)->pTimStr);
	}

	//	ノード列挙通知
	BOOL OnNtcNode	(C_UTP pKey, VOP pNodeData, UI len, UI nest) override
	{
		PAJCAVLNODE pNode = ((PAJCAVLNODE)pNodeData) - 1;
		SAjxCon::PrintF(TEXT("%-26s:%*s, %d\n"), ((PNODEDATA)pNodeData)->pTimStr, nest * 6, pKey, pNode->bal);
		return TRUE;
	}
	//	入力テキスト通知(ASCII)
	VO		OnNtcStr(int argc, UT *argv[], C_UTP pTxt) override
	{
		//	入力テキスト表示
		SAjxCon::PrintF(TEXT("%s\n"), pTxt);
		//	コマンド実行
		if (argc >= 1) {
			//	ノード挿入
			if		(_tcsicmp(argv[0], TEXT("I")) == 0) {
				if (argc == 2) {
					if (!InsNode(argv[1], &(m_Node.pTimStr = GetTimeStr()), sizeof m_Node)) {
						if (m_Node.pTimStr != NULL) AjcTFree(m_Node.pTimStr); m_Node.pTimStr = NULL;
						SAjxCon::PrintF(TEXT("ノードの挿入を失敗しました。\n"));
					}
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	ノード置換
			else if (_tcsicmp(argv[0], TEXT("R")) == 0) {
				if (argc == 2) {
					if (!RepNode(argv[1], &(m_Node.pTimStr = GetTimeStr()), sizeof m_Node)) {
						if (m_Node.pTimStr != NULL) AjcTFree(m_Node.pTimStr); m_Node.pTimStr = NULL;
						SAjxCon::PrintF(TEXT("ノードの置換を失敗しました。\n"));
					}
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	ノードの挿入／置換
			else if (_tcsicmp(argv[0], TEXT("X")) == 0) {
				if (argc == 2) {
					if (!InsOrRepNode(argv[1], &(m_Node.pTimStr = GetTimeStr()), sizeof m_Node)) {
						if (m_Node.pTimStr != NULL) AjcTFree(m_Node.pTimStr); m_Node.pTimStr = NULL;
						SAjxCon::PrintF(TEXT("ノードの挿入／置換を失敗しました。\n"));
					}
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	ノード削除
			else if (_tcsicmp(argv[0], TEXT("D"))  == 0) {
				if (argc == 2) {
					if (!DelNode(argv[1])) {
						SAjxCon::PrintF(TEXT("ノードの削除を失敗しました。\n"));
					}
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	全ノード破棄
			else if (_tcsicmp(argv[0], TEXT("A"))  == 0) {
				if (!DelAllNodes()) {
					SAjxCon::PrintF(TEXT("全ノードの削除を失敗しました。\n"));
				}
			}
			//	全ノード表示
			else if (_tcsicmp(argv[0], TEXT("P"))  == 0) {
				EnumNodes(TRUE);
			}
			//	その他
			else {
				SAjxCon::PrintF(TEXT("*** Invalid command.\n"));
			}
		}
	}

private:
	//	現在時刻文字列生成（現在時刻文字列を格納した、動的メモリへのポインタを返す）
	UTP		GetTimeStr()
	{
		UTP			rc;
		SYSTEMTIME	st;
		UI			len;
		UT			szTim[64];

		GetLocalTime(&st);
		AjcSnPrintF(szTim, AJCTSIZE(szTim), TEXT("%02d:%02d:%02d.%03d"), st.wHour, st.wMinute, st.wSecond, st.wMilliseconds);
		len = (UI)_tcslen(szTim) + 1;
		MAjcStrCpy(rc = AjcTAlloc(len), len, szTim);
		return rc;
	}
};

//----- m a i n ------------------------------------------------------------------------------------------------//
int AjcMain()
{
	CAjxAvsEx avs;

	SAjxCon::SetStdMode();

	//	コマンドメニュー
	SAjxCon::PrintF(TEXT("  I   SSSSS  : ノード挿入, key=\"SSSSS\"\n"));
	SAjxCon::PrintF(TEXT("  R   SSSSS  : ノード置換, key=\"SSSSS\"\n"));
	SAjxCon::PrintF(TEXT("  X   SSSSS  : ノードの挿入／置換, key=\"SSSSS\"\n"));
	SAjxCon::PrintF(TEXT("  D   SSSSS  : ノード削除, key=\"SSSSS\"\n"));
	SAjxCon::PrintF(TEXT("  A          : 全ノードを破棄\n"));
	SAjxCon::PrintF(TEXT("  P          : 全ノード表示\n"));
	SAjxCon::PrintF(TEXT("  <ESC>キー  : 終了\n"));
	SAjxCon::PrintF(TEXT("\n"));

	//	初期ノード表示
	avs.EnumNodes(TRUE);
	//	コマンドを入力しメニュー処理実行
	SAjxCon::PrintF(TEXT("Input(%3u) - "), avs.GetCount());
	while (avs.Input(TEXT(""))) {
		SAjxCon::PrintF(TEXT("Input(%3u) - "), avs.GetCount());
	}
	return 0;
}
