﻿//
//	SP_PPC.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
#include	<conio.h>
using namespace AjxControl;

static	AJCLBXITEM	OptSym[] = {{"_MSC_VER=1400"			 }, {"_MSC_FULL_VER=140050727"},
								{"_INTEGRAL_MAX_BITS=64"	 }, {"_WIN32"				  },
								{"_MBCS"					 }, {"_CRTBLD" 				  },
								{"_M_IX86"					 }, {"__STDC__=0"			  },
								{"__STDC_WANT_SECURE_LIB__=0"}, {NULL					  },
};

static	AJCLBXITEM	IncPath[] = {{"C:\\Program Files (x86)\\Microsoft Visual Studio*.*"},
								 {"C:\\Program Files (x86)\\Microsoft SDKs\\*.*"	   },
								 {"C:\\Program Files (x86)\\Windows Kits\\*.*"		   },
								 {NULL}
};

class CAjxPpcEx : public CAjxPpc
{
	//	いずれかのイベント発生
	VO		OnNtcAnyEvt		(AJCPPCNOTIFY evt)										override {
		if (_kbhit()) Stop();
	}
	//	ファイル名，行番号通知
	VO		OnNtcFileLno	(C_BCP pFile, UI lno, UI nest)							override {
	}
	//	インクルードファイル検索開始通知
	VO		OnNtcSrhStart	(C_BCP pIncFile, C_BCP pDirPath)						override {
		SAjxCon::PrintF("- Search include file %s\n", pIncFile);
	}
	//	インクルードファイル検索中のフォルダ通知
	VO		OnNtcSrhDir		(				 C_BCP pDirPath)						override {
	}
	//	インクルードファイル検索終了通知
	VO		OnNtcSrhEnd		(C_BCP pIncFile, BOOL fFind)							override {
	}
	//	プリプロセス用オプションシンボル通知
	VO		OnNtcOptSym		(PCAJCPPCTKNNODE pTkn)									override {
	}
	//	マクロ定義通知
	VO		OnNtcMacDef		(PCAJCPPCTKNNODE pTkn, PCAJCPPCMACINFO pMac)			override {
	}
	//	マクロ参照通知
	VO		OnNtcMacRef		(PCAJCPPCTKNNODE pTkn, PCAJCPPCMACINFO pMac)			override {
	}
	//	トークンストリームをファイルへ出力ループ中
	VO		OnNtcOutLoop	(VO)													override {
	}
	//	ソースファイルのエンコード通知
	VO		OnNtcSrcTec		(C_BCP pFilePath, EAJCTEC tec, BOOL fBom)				override {
	}
	//	トークン通知
	VO		OnNtcToken		(EAJCTKCODE tkn, C_BCP pTkn)							override {
	}
	//	エラー通知
	VO		OnNtcError		(AJCPPCERROR err, C_BCP pFile, UI lno, C_BCP pErrTxt)	override {
		SAjxCon::PrintF("%s\n", pErrTxt);
	}
	//	マクロ列挙通知
	BOOL	OnNtcMacInfo	(PCAJCPPCMACINFO pMacInfo)								override {
		return TRUE;
	}
};

int AjcMain()
{
	CAjxPpcEx ppc;

	BC		src[MAX_PATH];
	BC		out[MAX_PATH];

	SAjxCon::SetStdMode();
	SAjxCon::SetBufSize(160, 256);
	SAjxCon::SetWndRect(0, 0, 159, 30);

	AjcGetAppPath(src, sizeof src);
	strcat_s(src, sizeof src, "SW_CPreProSample.c");
	SAjxCon::PrintF("\n プリコンパイルを行います。 (%s)\n いずれかのキーを押すと中止します。\n\n", src);
	//	プリコンパイル実行
	if (ppc.PreCompile(src,									//	ソースファイル
					   AJCTEC_AUTO,							//	ソースファイルのテキストコード
					   NULL,								//	ベースパス
					   IncPath,								//	インクルードパス
					   OptSym) == AJCPPCR_OK) {				//	オプションシンボル
		//	ファイル出力
		AjcGetAppPath(out, sizeof out);
		strcat_s(out, sizeof out, "Temp.txt");
		SAjxCon::PrintF("\n プリコンパイル結果を出力します、(%s)\n\n", out);
		ppc.TokenStreamToFile(out,							//	出力ファイル
							  AJCTEC_AUTO,					//	出力ファイルのテキストコード
							  FALSE,						//	出力ファイルのＢＯＭなし
							  TRUE,							//	インクルードの展開内容を含める
							  AJCPPC_PPK_ALL);				//	全プリプロセス文出力
	}

	SAjxCon::PrintF("\nHit Enter Key!!");
	getchar();
	return 0;
}
