﻿//
//	SP_QUE.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>

using namespace AjxControl;

static const UTP IniTxt[] = {TEXT("200"), TEXT("300"), TEXT("400")};

//	ノードデータ
typedef struct {
	UTP		pStr;
} NODE, *PNODE;

class CAjxQueEx : public CAjxQue, public CAjxCon
{
public:
	//	コンストラクタ（ノードのデフォルトサイズ設定）
	CAjxQueEx() {
		SetDefSize(sizeof(NODE));
	}
	//	デストラクタ
	~CAjxQueEx()
	{
		//	デストラクト中に OnNtcRemove() を発生させるには Purge() メソッドを実行します
		Purge();
	}
	//	ノード消去通知
	VO OnNtcRemove	(VOP pNodeData, UI len) override
	{
		PNODE	pNode = (PNODE)pNodeData;
		SAjxCon::PrintF(TEXT(" ノード削除 %p -> %p : %s, len = %d\n"), pNode, pNode->pStr, pNode->pStr, len);
		AjcTFree(pNode->pStr);
	}
	//	入力テキスト通知(ASCII)
	VO		OnNtcStr(int argc, UT *argv[], C_UTP pTxt)
	{
		UI		bytes, len, seq;
		NODE	node;
		PNODE	pNode;

		//	入力テキスト表示
		SAjxCon::PrintF(TEXT("%s\n"), pTxt);
		//	コマンド実行
		if (argc >= 1) {
			//	文字列へのポインタを持つノードを末尾に挿入
			if		(_tcsicmp(argv[0], TEXT("Q")) == 0) {
				if (argc == 2) {
					node.pStr = AjcTAlloc(len = (UI)_tcslen(argv[1]) + 1);
					_tcscpy_s(node.pStr, len, argv[1]); 
					Enque(&node);
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	文字列へのポインタを持つノードを先頭に挿入
			else if (_tcsicmp(argv[0], TEXT("QT")) == 0) {
				if (argc == 2) {
					node.pStr = AjcTAlloc(len = (UI)_tcslen(argv[1]) + 1);
					_tcscpy_s(node.pStr, len, argv[1]); 
					EnqTop(&node);
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	ノードデータ一覧を表示
			else if (_tcsicmp(argv[0], TEXT("L")) == 0) {
				seq = 0;
				if (pNode = (PNODE)TopNode(&bytes)) {
					do {
						SAjxCon::PrintF(TEXT("%2d - %p -> %p : %s\n"), seq++, pNode, pNode->pStr, pNode->pStr);
					} while(pNode = (PNODE)NextNode(pNode, &bytes));
				}
			}
			//	全ノードを取り出して表示
			else if (_tcsicmp(argv[0], TEXT("G"))  == 0) {
				seq = 0;
				while ((Deque(&node, sizeof node)) != -1) {
					SAjxCon::PrintF(TEXT("%2d - %p : %s\n"), seq++, node.pStr, node.pStr);
				}
			}
			//	全ノードを破棄
			else if (_tcsicmp(argv[0], TEXT("A"))  == 0) {
				Purge();
			}
			//	ノードヘッダのダンプ表示
			else if (_tcsicmp(argv[0], TEXT("DMP"))  == 0) {
				seq = 0;
				if (pNode = (PNODE)TopNode(&bytes)) {
					do {
						PAJCVQNODE pH = ((PAJCVQNODE)pNode) - 1;
						SAjxCon::PrintF(TEXT("%2d - %p : next = %p, len = %d, dat = %p -> %p : %s\n"),
															seq++, pH, pH->pNxt, pH->len, pNode, pNode->pStr, pNode->pStr);
					} while(pNode = (PNODE)NextNode(pNode, &bytes));
				}
			}
			//	その他
			else {
				SAjxCon::PrintF(TEXT("*** Invalid command.\n"));
			}
		}
	}
};

int AjcMain()
{
	CAjxQueEx	que;

	SAjxCon::SetStdMode();
	SAjxCon::SetBufSize(128, 64);
	SAjxCon::SetWndRect(0, 0, 127, 30);

	//	コマンドメニュー
	SAjxCon::PrintF(TEXT("\n 以下のコマンドを入力してください。\n\n"));
	SAjxCon::PrintF(TEXT("  Q   <文字列>     : 文字列データを持つノードを末尾に挿入\n"));
	SAjxCon::PrintF(TEXT("  QT  <文字列>     : 文字列データを持つノードを先頭に挿入\n"));
	SAjxCon::PrintF(TEXT("  L                : ノードデータ一覧を表示（昇順）\n"));
	SAjxCon::PrintF(TEXT("  G                : 全ノードを取り出して表示\n"));
	SAjxCon::PrintF(TEXT("  A                : 全ノードを破棄\n"));
	SAjxCon::PrintF(TEXT("  DMP              : ノードヘッダのダンプ表示\n"));
	SAjxCon::PrintF(TEXT("  <ESC>キー        : 終了\n"));
	SAjxCon::PrintF(TEXT("\n"));

	//	コマンドを入力しメニュー処理実行
	SAjxCon::PrintF(TEXT("Input(%3u) - "), que.GetCount());
	while (que.Input(TEXT(""))) {
		SAjxCon::PrintF(TEXT("Input(%3u) - "), que.GetCount());
	}

	return 0;
}
