﻿//
//	SP_SCP1.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define	IDC_VTH		5001
#define	WM_MYPOPUP	(WM_APP + 10)
#define	MID_SETPORT	1
#define	MID_OPEN	2
#define	RB_DOWN		999

static	HINSTANCE	hInst	 = NULL;
static	HWND		hWndMain = NULL;
static	HWND		hWndVth  = NULL;
static	BOOL		fTimer	 = FALSE;
static const UT	TipMsg[] =	TEXT("右クリック(ポップアップメニュー)でポートの設定や、オープン／クローズを行います。\n")
							TEXT("このウインドにテキストファイルをドロップすると、その内容を送信します。\n")
							TEXT("受信したテキストは、そのままウインドに表示します。");
AJC_WNDPROC_DEF(Main);
//----- CAjxScp + CAjxVthの派生クラス --------------------------------------------------------------------------//
class CAjxVthEx :
	public CAjxScp,
	public CAjxVth
{
public:
	VO	OnNtcPortState(C_UTP pPortName, UI Param) override {	//	ポート状態通知
		switch (Param) {
			case AJCSCP_CLOSED:		SetTitleText(TEXT(" Closed "));				break;
			case AJCSCP_OPENED:		SetTitleText(TEXT(" Opened "));				break;
			case AJCSCP_OPENFAIL:	SetTitleText(TEXT(" Closed "));
			  PrintF(TEXT("\x1b[31mポートのオープンを失敗しました\x1b[0m\n"));	break;
		}
	}
	VO	OnNtcRxTextChunk(C_UTP pText) override {				//	テキストチャンク受信通知
		PutText(pText);
	}
	VO	OnNtcDropFile (UI nFiles) override	{					//	ファイルドロップ通知
		CAjxFile f;
		UT	path[MAX_PATH];
		UT	buf[1024];
		while (GetDroppedFile(path)) {
			PrintF(TEXT("- Send File : %s\n\n"), path);
			SendTextF(TEXT("\n【【【【【【 %s 】】】】】】\n"), path);
			if (f.FOpen(path)) {
				while (f.FGetS(buf, AJCTSIZE(buf))) {
					SendText(buf);
				}
				f.FClose();
			}
		}
	}
};
static	CAjxVthEx	scp_vth;
//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;

	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_SCP");
	atm = RegisterClass(&wc);
	hWndMain = CreateWindowEx(0,
				TEXT("SP_SCP"),	TEXT("SP_SCP"),				// window class name, caption
				WS_OVERLAPPEDWINDOW,						// window style
				CW_USEDEFAULT, CW_USEDEFAULT, 800, 400,		// position, size
				NULL, NULL, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	//	ＳＣＰ初期化
	scp_vth.Init	(TEXT("MyScpSect"), AJCSCP_CM_TEXT);
	scp_vth.SetEvtMask(AJCSCP_EV_PORTSTATE | AJCSCP_EV_RXCHUNK);
	//	ＶＴ１００ウインド生成
	RECT	r;
	GetClientRect(hwnd, &r);
	GetClientRect(hwnd, &r);
	hWndVth = CreateWindowEx(WS_EX_ACCEPTFILES,
							 TEXT("AjcCtrlVT100"), 					// window class
							 TEXT("P: VW=512, VH=128, ML=10000, TS=4, LS=3, FN=ＭＳ ゴシック, LF=12"),	// window caption
							 WS_CHILD,								// window style
							 0, 0, r.right, r.bottom, 				// position, size
							 hwnd, (HMENU)IDC_VTH, hInst, NULL);	// parent, menu, instance, param

	SAjxTip::Add	   (hWndVth, TipMsg);	//	ツールチップ設定
	scp_vth.Attach(hWndVth);				//	VT100ウインドハンドル割り当て
	scp_vth.PutText(TipMsg); scp_vth.PutText(TEXT("\n\n"));
	scp_vth.SetTitleText(TEXT(" Closed "));
	scp_vth.EnablePopupMenu(FALSE);			//	VT100のポップアップメニュー禁止(親へWM_RBUTOONDOWN/UPを送る)
	ShowWindow(hWndVth, SW_SHOW);			//	VT100ウインド表示
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	DestroyWindow(hWndVth);
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	MoveWindow(hWndVth, 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
	return 0;
}
//----- WM_RBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_RBUTTONDOWN)
{
	AJCPPMTBL	tbl[] = {{0, MID_SETPORT, 0, TEXT("ポート設定")},
						 {0, MID_OPEN	, 0, TEXT("オープン／クローズ")},
						 {AJCPPMF_EOT}};
	POINT		pt;
	GetCursorPos(&pt);
	AjcPopupMenu(hwnd, WM_MYPOPUP, pt.x, pt.y, tbl, 0);
	return 0;
}
//----- WM_MYPOPUP ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_MYPOPUP	)
{
	if (wParam == MID_SETPORT) scp_vth.DlgParamEasy(hWndMain);
	else {
		if (scp_vth.IsOpened()) scp_vth.Close();
		else					scp_vth.Open();
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE		)
	AJC_WNDMAP_MSG(Main, WM_DESTROY		)
	AJC_WNDMAP_MSG(Main, WM_SIZE		)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONDOWN	)
	AJC_WNDMAP_MSG(Main, WM_MYPOPUP		)
AJC_WNDMAP_END
