﻿//
//	SP_SCT1.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define	IDC_VTH		5001
#define	WM_MYPOPUP	(WM_APP + 10)

static	HINSTANCE	hInst	 = NULL;
static	HWND		hWndMain = NULL;
static	HWND		hWndVth  = NULL;
static	HWND		hTxtServ = NULL;
static	BOOL		fConnect = FALSE;

static const UT	TipMsg[] =	TEXT("テキストボックスにサーバー名／ＩＰアドレスを入力してください。\n")
							TEXT("ダブルクリックで回線を接続／切断します。(Port = 14238))\n")
							TEXT("このウインドにテキストファイルをドロップすると、その内容を送信します。\n")
							TEXT("受信したテキストは、そのままウインドに表示します。");
AJC_WNDPROC_DEF(Main);
//----- CAjxSct + CAjxVthの派生クラス --------------------------------------------------------------------------//
class CAjxSctEx :
	public CAjxSct,
	public CAjxVth
{
public:
	VO	OnNtcConnect()		override {							//	接続通知
		PrintF(TEXT("- 回線を接続しました。\n"));
		fConnect = TRUE;
	}
	VO	OnNtcDisconnect()	override {							//	切断通知
		PrintF(TEXT("- 回線を切断しました。\n"));
		fConnect = FALSE;
	}
	VO	OnNtcCnErr(UI param) override {							//	接続失敗通知
		PrintF(TEXT("- 回線の接続を失敗しました。(%d)\n"), param);
	}
	VO	OnNtcRxTextChunk(C_UTP pText) override {				//	テキストチャンク受信通知
		PutText(pText);
	}
	VO	OnNtcDblClk		(UI flag)	override	{				//	ダブルクリック通知
		if (fConnect) {
			Disconnect();
		}
		else {
			UT	szServ[256];
			AjcGetCtrlStr(hTxtServ, szServ, 256);
			Connect	(szServ, TEXT("14238"));
		}
	}
	VO	OnNtcDropFile (UI nFiles) override	{					//	ファイルドロップ通知
		CAjxFile f;
		UT	path[MAX_PATH];
		UT	buf[1024];
		while (GetDroppedFile(path)) {
			PrintF(TEXT("- Send File : %s\n\n"), path);
			SendTextF(TEXT("\n【【【【【【 %s 】】】】】】\n"), path);
			if (f.FOpen(path)) {
				while (f.FGetS(buf, AJCTSIZE(buf))) {
					SendText(buf);
				}
				f.FClose();
			}
		}
	}
	VO	OnNtcTxEmpty() 		override {							//	送信完了通知
		PrintF(TEXT("- 送信を完了しました。\n"));
	}
};
static	CAjxSctEx	sct_vth;
//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;

	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_SCT");
	atm = RegisterClass(&wc);
	hWndMain = CreateWindowEx(0,
				TEXT("SP_SCT"),	TEXT("SP_SCT"),				// window class name, caption
				WS_OVERLAPPEDWINDOW,						// window style
				CW_USEDEFAULT, CW_USEDEFAULT, 800, 400,		// position, size
				NULL, NULL, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	SetFocus(hTxtServ);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	//	ＶＴ１００ウインド生成
	RECT	r;
	GetClientRect(hwnd, &r);
	GetClientRect(hwnd, &r);
	hWndVth = CreateWindowEx(WS_EX_ACCEPTFILES,
							 TEXT("AjcCtrlVT100"), 					// window class
							 TEXT("P: VW=512, VH=128, ML=10000, TS=4, LS=3, FN=ＭＳ ゴシック, LF=12"),	// window caption
							 WS_CHILD,								// window style
							 0, 20, r.right, r.bottom - 20, 		// position, size
							 hwnd, (HMENU)IDC_VTH, hInst, NULL);	// parent, menu, instance, param
	ShowWindow(hWndVth, SW_SHOW);			//	VT100表示
	SAjxTip::Add	   (hWndVth, TipMsg);	//	ツールチップ設定
	sct_vth.Attach(hWndVth);				//	VT100ウインドハンドル割り当て
	sct_vth.PutText(TipMsg); sct_vth.PutText(TEXT("\n\n"));
	sct_vth.SetTitleText(TEXT(" Closed "));
	//	テキストボックス生成
	hTxtServ = CreateWindow( TEXT("Edit"), 							// window class
							 TEXT("127.0.0.1"),						// window caption
							 WS_CHILD | ES_NOHIDESEL,				// window style
							 1, 1, r.right - 2, 18, 				// position, size
							 hwnd, (HMENU)IDC_VTH, hInst, NULL);	// parent, menu, instance, param
	SAjxCtrl::CtrlLoadTextBox(hTxtServ, TEXT("MySect"));
	SendMessage(hTxtServ, EM_SETSEL, 0, -1);
	ShowWindow (hTxtServ, SW_SHOW);			//	テキストボックス表示
	//	イベントマスク設定
	sct_vth.SetEvtMask	(AJCSCT_EV_GENERAL | AJCSCT_EV_RXCHUNK | AJCSCT_EV_TXEMPTY);
	sct_vth.SetChunkMode(AJCSCT_CM_TEXT);
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	SAjxCtrl::CtrlSaveTextBox(hTxtServ, TEXT("MySect"));
	DestroyWindow(hWndVth );
	DestroyWindow(hTxtServ);
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	MoveWindow(hTxtServ, 1,  1, LOWORD(lParam) - 2, 18				   , FALSE);
	MoveWindow(hWndVth , 0, 20, LOWORD(lParam)	  , HIWORD(lParam) - 20, FALSE);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE		)
	AJC_WNDMAP_MSG(Main, WM_DESTROY		)
	AJC_WNDMAP_MSG(Main, WM_SIZE		)
AJC_WNDMAP_END
