﻿//
//	SP_SCT2.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

//	ガイドテキスト
static const UT Help[] = TEXT("コマンド形式：\n")
						 TEXT("  C  <サーバ名> ----- 回線接続\n")
						 TEXT("  D ----------------- 回線切断\n")
						 TEXT("  T <ファイルパス> -- ファイル送信\n")
						 TEXT("ESCキー押下でプログラムを終了します。");

//	コンソールウインドハンドル
HWND	hWndCon = NULL;

//----- CAjxSct + CAjxConの派生クラス --------------------------------------------------------------------------//
class CAjxSctEx : public CAjxSct, public CAjxCon
{
public:
	//	接続通知
	VO	OnNtcConnect()		override {
		SAjxCon::PrintF(TEXT("- 回線を接続しました。\n"));
	}
	//	切断通知
	VO	OnNtcDisconnect()	override {
		SAjxCon::PrintF(TEXT("- 回線を切断しました。\n"));
	}
	//	接続失敗通知
	VO	OnNtcCnErr(UI param) override {							
		SAjxCon::PrintF(TEXT("- 回線の接続を失敗しました。(%d)\n"), param);
	}
	//	テキストチャンク受信通知
	VO	OnNtcRxTextChunk(C_UTP pText) override {
		SAjxCon::PutS(pText);
	}
	//	入力文字列と引数リスト通知
	VO	OnNtcStr(int argc, UT *argv[], C_UTP pTxt) override {
		//	入力文字列表示
		SAjxCon::PrintF(TEXT("%s\n"), pTxt);
		//	コマンド実行
		if (argc != 0) {
			AJCSCT_STATE state = GetState();
			if		(argc == 2 && _tcsicmp(argv[0], TEXT("C")) == 0) {	//	C  <サーバ名>
				if (state == AJCSCT_DISCONNECT) Connect(argv[1], TEXT("14238"));
				else							SAjxCon::PrintF(TEXT("*** 回線は接続済です。\n"));
			}
			else if (argc == 1 && _tcsicmp(argv[0], TEXT("D")) == 0) {	//	D
				if (state == AJCSCT_CONNECT   ) Disconnect();
				else							SAjxCon::PrintF(TEXT("*** 回線は接続されていません。\n"));
			}
			else if (argc == 2 && _tcsicmp(argv[0], TEXT("T")) == 0) {	//	T  <ファイルパス>
				if (state == AJCSCT_CONNECT) {
					CAjxFile f;
					UT	buf[1024];
					if (f.FOpen(argv[1])) {
						while (f.FGetS(buf, AJCTSIZE(buf))) {
							SendText(buf);
						}
						f.FClose();
					}
				}
				else {SAjxCon::PrintF(TEXT("*** 回線は接続されていないか、データ送信中です。\n"));	}
			}
			else SAjxCon::PrintF(TEXT("- 不正なコマンドです。\n"));
		}
	}
};
static CAjxSctEx	sct_con;


int  AjcMain(int argc, UTP argv[])
{
	SAjxCon::SetStdMode();

	//	コンソールのウインドハンドル取得
	UT WndTxt[256];
	GetConsoleTitle(WndTxt, 256);
	hWndCon = FindWindow(NULL, WndTxt);
	//	ＳＣＴ初期化
	sct_con.SetEvtMask	(AJCSCT_EV_GENERAL | AJCSCT_EV_RXCHUNK);
	sct_con.SetChunkMode(AJCSCT_CM_TEXT);
	SAjxCon::PrintF(TEXT("\n%s\n\n"), Help);
	//	コンソール入力ループ
	while (sct_con.Input(Help)) {
		//	最初のイベント待ち（5秒）
		if (sct_con.WaitEvent(5000)) {
			//	２つ目以降のイベント待ち（100ms）
			while (sct_con.WaitEvent(100));
		}
		AjcSetFocusWindow(hWndCon);
	}

	return 0;
}

