﻿//
//	SP_VTH.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define	IDC_VTH	5001

static	HINSTANCE	hInst	 = NULL;
static	HWND		hWndMain = NULL;
static	HWND		hWndVth  = NULL;
static	BOOL		fTimer	 = FALSE;

AJC_WNDPROC_DEF(Main);
static const UT	TipMsg[] =	TEXT("このウインドにドロップしたテキストファイルの内容を表示します。\n")
							TEXT("このツールチップ上にカーソルを置くと表示を継続します。\n")
							TEXT("このツールチップ上をクリックするとツールチップは消えます。");

//----- CAjxVthの派生クラス ------------------------------------------------------------------------------------//
class CAjxVthEx :
	public CAjxVth
{
public:
	VO	OnNtcDropFile (UI nFiles) override	{		//	ファイルドロップ通知
		CAjxFile f;
		UT	path[MAX_PATH];
		UT	buf[1024];
		while (GetDroppedFile(path)) {
			PrintF(TEXT("\x1B[34m【 %s 】\x1B[0m\n"), path);
			if (f.FOpen(path)) {
				while (f.FGetS(buf, AJCTSIZE(buf))) {
					PutText(buf);
				}
				f.FClose();
			}
		}
	}
};
static	CAjxVthEx	vth;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;

	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_VTH");
	atm = RegisterClass(&wc);
	hWndMain = CreateWindowEx(0,
				TEXT("SP_VTH"),	TEXT("SP_VTH"),				// window class name, caption
				WS_OVERLAPPEDWINDOW,						// window style
				CW_USEDEFAULT, CW_USEDEFAULT, 800, 400,		// position, size
				NULL, NULL, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	//	ＶＴ１００ウインド生成
	RECT	r;
	GetClientRect(hwnd, &r);
	GetClientRect(hwnd, &r);
	hWndVth = CreateWindowEx(WS_EX_ACCEPTFILES,
							 TEXT("AjcCtrlVT100"), 					// window class
							 TEXT("P: VW=512, VH=128, ML=10000, TS=4, FN=ＭＳ ゴシック, LF=12"),	// window caption
							 WS_CHILD,								// window style
							 0, 0, r.right, r.bottom, 				// position, size
							 hwnd, (HMENU)IDC_VTH, hInst, NULL);		// parent, menu, instance, param

	SAjxTip::Add	   (hWndVth, TipMsg);	//	ツールチップ設定
	SAjxTip::ShowCenter(hWndVth, TipMsg);	//	ツールチップ初期表示
	vth.Attach(hWndVth);					//	VT100ウインドハンドル割り当て
	vth.PutText(TEXT("\n このウインドにドロップしたテキストファイルの内容を表示します。\n\n"));
	ShowWindow(hWndVth, SW_SHOW);			//	VT100ウインド表示
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	DestroyWindow(hWndVth);
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	MoveWindow(hWndVth, 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
	return 0;
}
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE	)
	AJC_WNDMAP_MSG(Main, WM_DESTROY )
	AJC_WNDMAP_MSG(Main, WM_SIZE	)
AJC_WNDMAP_END
