﻿#ifndef	AJCCTOKEN_H_
#define	AJCCTOKEN_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	機能フラグ																									//
//--------------------------------------------------------------------------------------------------------------//
//	Bit 7 - 0
#define	AJCTKFLG_CPLUSPLUS			0x00000001		//	Ｃ＋＋のトークンを含める
#define	AJCTKFLG_INCSPACE			0x00000002		//	空白／改行／コメントもトークンに含める
#define	AJCTKFLG_INCSYM_DOLLAR		0x00000004		//	シンボルの英字としてドルマーク($)を含める
#define	AJCTKFLG_INCSYM_ATMARK		0x00000008		//	シンボルの英字としてアットマーク(@)を含める	
#define	AJCTKFLG_INCSYM_MBSTR		0x00000010		//	シンボルの英字としてマルチバイト文字を含める
#define	AJCTKFLG_APOST_NOESC		0x00000020		//	アポストロフィ(')で囲まれた文字列は、エスケース文字(\)を認識しない
#define	AJCTKFLG_DOTSYMBOL			0x00000040		//	シンボル＋Dot(.)＋数字列を１つのシンボルとみなす(Ex. P3.12)
#define	AJCTKFLG_ASMHEX				0x00000080		//	アセンブラ記法の16進数（末尾がH, ex 0FFH)を許可する

//	Bit 31-24
#define	AJCTKFLG_LBF_1K				0x01000000		//	テキストファイル行の読み出しバッファサイズ＝ ２KB
#define	AJCTKFLG_LBF_2K				0x02000000		//			〃								  ＝ ４KB
#define	AJCTKFLG_LBF_4K				0x04000000		//			〃								  ＝ ８KB
#define	AJCTKFLG_LBF_8K				0x08000000		//			〃								  ＝ 16KB
#define	AJCTKFLG_LBF_16K			0x10000000		//			〃								  ＝ 32KB
#define	AJCTKFLG_LBF_32K			0x20000000		//			〃								  ＝ 64KB
#define	AJCTKFLG_LBF_64K			0x40000000		//			〃								  ＝128KB
#define	AJCTKFLG_LBF_128K			0x80000000		//			〃								  ＝256KB
#define	AJCTKFLG_LBF_MASK			0xFF000000

//--------------------------------------------------------------------------------------------------------------//
//	エラーコード																								//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTKERR_OK				 		0			//	ＯＫ
#define	AJCTKERR_NULLPTR				0x8000		//	ＮＵＬＬポインタが指定された
#define	AJCTKERR_ZEROSIZE				0x4000		//	バッファサイズがゼロ
#define	AJCTKERR_MEMALLOC				0x2000		//	メモリ割り当て失敗
#define	AJCTKERR_INVALID_OCTALNUMBER	0x1000		//	不正な８進数
#define	AJCTKERR_INVALID_HEXADECIMAL	0x0800		//	不正な１６進数
#define	AJCTKERR_INVALID_REALNUMBER		0x0400		//	不正な実数表現
#define	AJCTKERR_INVALID_SUFFIX			0x0200		//	不正なサフィックス
#define	AJCTKERR_INVALID_DELIMITER		0x0100		//	不正なデリミタ
#define	AJCTKERR_LFINSTR				0x0080		//	文字列中に改行が含まれている
#define	AJCTKERR_BUFOVER				0x0040		//	トークンバッファオーバー
#define	AJCTKERR_EOFINCOMMENT			0x0020		//	コメント中にＥＯＦ検出（ファイル内でコメントが閉じていない）

//--------------------------------------------------------------------------------------------------------------//
//	トークン識別コード																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTKKND_USRSYM		0x0100					//	ユーザシンボル
#define	AJCTKKND_RSVSYM		0x0200					//	予約語
#define	AJCTKKND_VALUE		0x0400					//	数値定数
#define	AJCTKKND_STRING		0x0800					//	文字列
#define	AJCTKKND_PATHNAME	0x1000					//	ファイルパス名（#includeのみ)
#define	AJCTKKND_DELIMIT	0x2000					//	デリミタ
#define	AJCTKKND_SPACE		0x4000					//	空白／改行／コメント／行継続記号（￥）
#define	AJCTKKND_NEXT		0x8000					//	ユーザ定義用
//--------------------------------------------------------------------------------------------------------------//
//	トークン識別マクロ																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTKIS_USRSYM(TKN)		(((TKN) & AJCTKKND_USRSYM)	!= 0)	//	ユーザシンボル
#define	AJCTKIS_RSVSYM(TKN)		(((TKN) & AJCTKKND_RSVSYM)	!= 0)	//	予約語
#define	AJCTKIS_VALUE(TKN)		(((TKN) & AJCTKKND_VALUE)	!= 0)	//	数値定数
#define	AJCTKIS_STRING(TKN)		(((TKN) & AJCTKKND_STRING)	!= 0)	//	文字列
#define	AJCTKIS_PATHNAME(TKN)	(((TKN) & AJCTKKND_PATHNAME)!= 0)	//	ファイルパス名（#includeのみ)
#define	AJCTKIS_DELIMIT(TKN)	(((TKN) & AJCTKKND_DELIMIT)	!= 0)	//	デリミタ

#define	AJCTKIS_SYMBOL(TKN)	(((TKN) & (AJCTKKND_RSVSYM | AJCTKKND_USRSYM)) != 0)
#define	AJCTKIS_VALSYM(TKN)	(((TKN) & (AJCTKKND_RSVSYM | AJCTKKND_USRSYM | AJCTKKND_VALUE)) != 0)

#define	AJCTKIS_SPACE(TKN)	(((TKN) & AJCTKKND_SPACE) != 0)		//	空白／改行／コメント／行継続記号（￥）

//--------------------------------------------------------------------------------------------------------------//
//	トークンコード																								//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	EAJCTK_EOF			= 0					,	//	End Of File
	EAJCTK_PREPRO							,	//	プリプロセス文（プリコンパイル機能用）

	EAJCTK_USR_NAME		= AJCTKKND_USRSYM	,	//	ユーザ定義名

	EAJCTK_RSV_ASM		= AJCTKKND_RSVSYM	,	//	asm
	EAJCTK_RSV_AUTO							,	//	auto
	EAJCTK_RSV_BREAK						,	//	break
	EAJCTK_RSV_CASE							,	//	case
	EAJCTK_RSV_CATCH						,	//	catch		（C++）
	EAJCTK_RSV_CHAR							,	//	char
	EAJCTK_RSV_CLASS						,	//	class		（C++）
	EAJCTK_RSV_CONST						,	//	const
	EAJCTK_RSV_CONCAST						,	//	const_cast	（C++）
	EAJCTK_RSV_CONTINUE						,	//	continue
	EAJCTK_RSV_DEFAULT						,	//	default
	EAJCTK_RSV_DEFINE						,	//	define		(プリプロセッサ）
	EAJCTK_RSV_DEFINED						,	//	defined		(プリプロセッサ）
	EAJCTK_RSV_DELETE						,	//	delete		（C++）
	EAJCTK_RSV_DO							,	//	do
	EAJCTK_RSV_DOUBLE						,	//	double
	EAJCTK_RSV_DYNCAST						,	//	dynamic_cast（C++）
	EAJCTK_RSV_ELIF							,	//	elif		(プリプロセッサ）
	EAJCTK_RSV_ELSE							,	//	else		(プリプロセッサ兼用）
	EAJCTK_RSV_ENDIF						,	//	endif		(プリプロセッサ）
	EAJCTK_RSV_ENUM							,	//	enum
	EAJCTK_RSV_EXTERN						,	//	extern
	EAJCTK_RSV_FLOAT						,	//	float
	EAJCTK_RSV_FOR							,	//	for
	EAJCTK_RSV_FRIEND						,	//	friend		（C++）
	EAJCTK_RSV_GOTO							,	//	goto
	EAJCTK_RSV_IF							,	//	if			(プリプロセッサ兼用）
	EAJCTK_RSV_IFDEF						,	//	ifdef		(プリプロセッサ）
	EAJCTK_RSV_IFNDEF						,	//	ifndef		(プリプロセッサ）
	EAJCTK_RSV_INCLUDE						,	//	include		(プリプロセッサ）
	EAJCTK_RSV_INLINE						,	//	inline
	EAJCTK_RSV_INT							,	//	int
	EAJCTK_RSV_LONG							,	//	long
	EAJCTK_RSV_NEW							,	//	new			（C++）
	EAJCTK_RSV_OPERATOR						,	//	operator	（C++）
	EAJCTK_RSV_PRAGMA						,	//	pragma		(プリプロセッサ）
	EAJCTK_RSV_PRIVATE						,	//	private		（C++）
	EAJCTK_RSV_PROTECTED					,	//	protected	（C++）
	EAJCTK_RSV_PUBLIC						,	//	public		（C++）
	EAJCTK_RSV_REGISTER						,	//	register
	EAJCTK_RSV_REICAST						,	//	reinterpret_cast（C++）
	EAJCTK_RSV_RETURN						,	//	return
	EAJCTK_RSV_SHORT						,	//	short
	EAJCTK_RSV_SIGNED						,	//	signed
	EAJCTK_RSV_SIZEOF						,	//	sizeof
	EAJCTK_RSV_STATIC						,	//	static
	EAJCTK_RSV_STACAST						,	//	static_cast	（C++）
	EAJCTK_RSV_STRUCT						,	//	struct
	EAJCTK_RSV_SWITCH						,	//	switch
	EAJCTK_RSV_TEMPLATE						,	//	template	（C++）
	EAJCTK_RSV_THIS							,	//	this		（C++）
	EAJCTK_RSV_THROW						,	//	tnrow		（C++）
	EAJCTK_RSV_TRY							,	//	try			（C++）
	EAJCTK_RSV_TYPEDEF						,	//	typedef
	EAJCTK_RSV_UNDEF						,	//	undef
	EAJCTK_RSV_UNION						,	//	union
	EAJCTK_RSV_UNSIGNED						,	//	unsigned
	EAJCTK_RSV_VIRTUAL						,	//	virtual		（C++）
	EAJCTK_RSV_VOID							,	//	void
	EAJCTK_RSV_VOLATILE						,	//	volatile
	EAJCTK_RSV_WCHAR_T						,	//	wchar_t
	EAJCTK_RSV_WHILE						,	//	while

	EAJCTK_CIP_FUNCTION						,	//	ＣＩＰ用：'function'


	EAJCTK_VAL_DECIMAL	= AJCTKKND_VALUE	,	//	nnn	
	EAJCTK_VAL_HEXA							,	//	0xhhh
	EAJCTK_VAL_OCTAL						,	//	0nnn
	EAJCTK_VAL_REAL							,	//	nn.mm / nnnE[+-]mm
	EAJCTK_VAL_INVALID						,	//	不完全な数値表現（エラー）

	EAJCTK_VAL_HEXA_H						,	//	hhhH（アセンブラ記法）

	EAJCTK_CIP_INTEGER						,	//	ＣＩＰ用：数値定数（整数）
	EAJCTK_CIP_REAL							,	//	ＣＩＰ用：数値定数（実数）


	EAJCTK_STR_QUOTE	= AJCTKKND_STRING	,	//	"..."
	EAJCTK_STR_APOST						,	//	'...'
	EAJCTK_STR_NEXT							,	//	その他の文字定数

	EAJCTK_CIP_STRING						,	//	ＣＩＰ用：文字列


	EAJCTK_PATHNAME		= AJCTKKND_PATHNAME	,	//	#includeのヘッダファイルパス名

	EAJCTK_DLM_LSPART	= AJCTKKND_DELIMIT	,	//	(
	EAJCTK_DLM_LMPART						,	//	{
	EAJCTK_DLM_LLPART						,	//	[
	EAJCTK_DLM_RSPART						,	//	)
	EAJCTK_DLM_RMPART						,	//	}
	EAJCTK_DLM_RLPART						,	//	]

	EAJCTK_DLM_SCOPE						,	//	::		(C++)
	EAJCTK_DLM_IDDOT						,	//	.*		(C++)
	EAJCTK_DLM_IDARROW						,	//	->*		(C++)

	EAJCTK_DLM_LAND							,	//	&&
	EAJCTK_DLM_LOR							,	//	||

	EAJCTK_DLM_ARROW						,	//	->
	EAJCTK_DLM_QUEST						,	//	?
	EAJCTK_DLM_COLON						,	//	:
	EAJCTK_DLM_SEMICOL						,	//	;
	EAJCTK_DLM_COMMA						,	//	,
	EAJCTK_DLM_VARG							,	//	...	
	EAJCTK_DLM_DOT							,	//	.

	EAJCTK_DLM_SHREQ						,	//	>>=	
	EAJCTK_DLM_SHLEQ						,	//	<<=	
	EAJCTK_DLM_SHR							,	//	>>
	EAJCTK_DLM_SHL							,	//	<<

	EAJCTK_DLM_EQEQ							,	//	==
	EAJCTK_DLM_NOTEQ						,	//	!=
	EAJCTK_DLM_LOEQ							,	//	<=
	EAJCTK_DLM_HIEQ							,	//	>=
	EAJCTK_DLM_LO							,	//	<
	EAJCTK_DLM_HI							,	//	>

	EAJCTK_DLM_PLUSEQ						,	//	+=
	EAJCTK_DLM_MINUSEQ						,	//	-=
	EAJCTK_DLM_MULTEQ						,	//	*=
	EAJCTK_DLM_DIVEQ						,	//	/=
	EAJCTK_DLM_MODEQ						,	//	%=
	EAJCTK_DLM_ANDEQ						,	//	&=
	EAJCTK_DLM_OREQ							,	//	|=
	EAJCTK_DLM_XOREQ						,	//	^=

	EAJCTK_DLM_SHARP2						,	//	##
	EAJCTK_DLM_PLUS2						,	//	++
	EAJCTK_DLM_MINUS2						,	//	--

	EAJCTK_DLM_SHARP						,	//	#
	EAJCTK_DLM_PLUS							,	//	+
	EAJCTK_DLM_MINUS						,	//	-
	EAJCTK_DLM_MULT							,	//	*
	EAJCTK_DLM_DIV							,	//	/
	EAJCTK_DLM_MOD							,	//	%
	EAJCTK_DLM_AND							,	//	&
	EAJCTK_DLM_OR							,	//	|
	EAJCTK_DLM_XOR							,	//	^
	EAJCTK_DLM_EQ							,	//	=
	EAJCTK_DLM_NOT							,	//	~
	EAJCTK_DLM_LNOT							,	//	!
	EAJCTK_DLM_UNKNOWN						,	//	未定義のデリミタ
	EAJCTK_DLM_NEXT							,	//	その他のデリミタ

	EAJCTK_SPACE		= AJCTKKND_SPACE	,	//	空白／タブ列
	EAJCTK_EOL								,	//	改行文字列
	EAJCTK_COMMENT							,	//	コメント（／＊・・・＊／）
	EAJCTK_LINECOMMENT						,	//	コメント（／／・・・）
	EAJCTK_LINECONT							,	//	行継続記号（￥）
	EAJCTK_NEXTSPACE						,	//	その他の空白

} EAJCTKCODE, *LPEAJCTKCODE;

#define	EAJCTK_INVALID		((EAJCTKCODE)-1)

#define	EAJCTK_RSV_MINCODE	EAJCTK_RSV_ASM
#define	EAJCTK_RSV_MAXCODE	EAJCTK_RSV_WHILE

#define	EAJCTK_DLM_MINCODE	EAJCTK_DLM_LSPART
#define	EAJCTK_DLM_MAXCODE	EAJCTK_DLM_LNOT

//--------------------------------------------------------------------------------------------------------------//
//	数値定数のサフィックス・コード																				//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	EAJCTKSUF_NONE	=	0	,		//	サフィックスなし
	EAJCTKSUF_L				,		//	L
	EAJCTKSUF_UL			,		//	UL / LU
	EAJCTKSUF_LL			,		//	LL
	EAJCTKSUF_ULL			,		//	ULL
	EAJCTKSUF_FLOAT			,		//	F
	EAJCTKSUF_DOUBLE		,		//	D
	EAJCTKSUF_LDOUBLE				//	L
} EAJCTKSUF, *LPEAJCTKSUF;

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTKMAX_PPHIST		16

typedef struct {
	UI			InstID;						//	インスタンス識別ＩＤ
	EAJCTKCODE	tkn;						//	トークンコード
	EAJCTKSUF	suffix;						//	数値定数のサフィックス・コード
	UI			ctkf;						//	フラグ
	UI			flag;						//	Ｃ＋＋予約語／空白認識フラグ
	UI			err;						//	エラーコード
	UI			lno;						//	行番号
	UI			loc;						//	トークンのバイト位置
	UI			len;						//	トークンのバイト数
	UI			lLineBuf;					//	行バッファサイズ（バイト数）
	WCP			pLineBuf;					//	行バッファ
	WCP			pLine;						//	行ポインタ
	UX			xp;							//	コールバックパラメタ
	union {
		BOOL	(CALLBACK *cbCtkA)(BCP pBuf, UI lBuf, UX xp);
		BOOL	(CALLBACK *cbCtkW)(WCP pBuf, UI lBuf, UX xp);
	} u;
	//----- プリプロセス文情報 -----//
	UI			PpHistIx;					//	プリプロセス文のトークンカウンタ
	EAJCTKCODE	PpHist[AJCTKMAX_PPHIST];	//	プリプロセス文の先頭トークン履歴（'￥'は含まない）

	BOOL		fUnicode;

} AJCTK, *HAJCTK;

//----- ctkf ---------------------------------------------------------------------------------------------------//
//----- 内部処理フラグ -------//
#define	AJCTKF_EOF				0x80000000					//	End of file
#define	AJCTKF_TOL				0x40000000					//	行頭フラグ
#define	AJCTKF_LCONT			0x20000000					//	行継続記号（￥）出現フラグ
#define	AJCTKF_INCOMMENT		0x10000000					//	コメント（／＊...＊／）中フラグ	
#define	AJCTKF_PATHNAME			0x08000000					//	#includeのファイルパス名処理中
#define	AJCTKF_ISLASTPEEK		0x04000000					//	直前が「ＰＥＥＫ」であることを示すフラグ
#define	AJCTKF_SRHMACARGTOP		0x02000000					//	マクロ引数先頭 '(' 検索状態
#define	AJCTKF_SRHMACARGEND		0x01000000					//	マクロ引数終端 ')' 検索状態
#define	AJCTKF_FINDMACARGEND	0x00800000					//	マクロ引数終端 ')' 検出状態
#define	AJCTKF_SRHMACBODY		0x00400000					//	マクロボディ検索状態
//----- ユーザ通知フラグ -----//
#define	AJCTKF_PREPRO				0x0080					//	プリプロセス文
#define	AJCTKF_PPTOP				0x0040					//	プリプロセス文の先頭トークン（＃）
#define	AJCTKF_MACNAME				0x0020					//	マクロ名
#define	AJCTKF_MACWITHARG			0x0010					//	引数付のマクロ名
#define	AJCTKF_MACARG				0x0008					//	マクロ引数' ( ・・・ ) '
#define	AJCTKF_MACBODY				0x0004					//	マクロボディ
#define	AJCTKF_NXTSPC				0x0002					//	トークンの次に空白ありを示すフラグ
#define	AJCTKF_WIDECHAR				0x0001					//	ワイド文字（L'X' / L"XXX"）フラグ

//	ユーザ通知フラグのマスク
#define	AJCTKF_USER		(AJCTKF_PREPRO | AJCTKF_PPTOP | AJCTKF_MACNAME | AJCTKF_MACWITHARG | AJCTKF_MACARG | AJCTKF_MACBODY | AJCTKF_NXTSPC | AJCTKF_WIDECHAR)

//	プリプロセス or ワイド文字
#define	AJCTKF_PPORWC	(AJCTKF_PREPRO | AJCTKF_PPTOP | AJCTKF_MACNAME | AJCTKF_MACWITHARG | AJCTKF_MACARG | AJCTKF_MACBODY |				  AJCTKF_WIDECHAR)

//----- 情報取得マクロ -----------------------------------------------------------------------------------------//
#define	AJCTK_TOKEN(H)		((H)->tkn)
#define	AJCTK_SUFFIX(H)		((H)->suffix)
#define	AJCTK_FLAG(H)		((H)->ctkf & AJCTKF_USER)
#define	AJCTK_LINE(H)		((H)->lno)
#define	AJCTK_LOC(H)		AjcCtkGetTokenLocation(H)
#define	AJCTK_POS(H, N)		AjcCtkGetTokenPosition(H, N)
#define	AJCTK_ERROR(H)		((H)->err)

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	PCBAJCTK					PCBAJCTKW
	#define	AjcCtkCreate				AjcCtkCreateW
	#define	AjcCtkSetCallBack			AjcCtkSetCallBackW
	#define	AjcCtkInit					AjcCtkInitW
	#define	AjcCtkGetToken				AjcCtkGetTokenW
	#define	AjcCtkPeekToken				AjcCtkPeekTokenW
	#define	AjcCtkGetTokenString		AjcCtkGetTokenStringW
	#define	AjcCtkGetTokenLocation		AjcCtkGetTokenLocationW
	#define	AjcCtkGetTokenPosition		AjcCtkGetTokenPositionW
#else
	#define	PCBAJCTK					PCBAJCTKA
	#define	AjcCtkCreate				AjcCtkCreateA
	#define	AjcCtkSetCallBack			AjcCtkSetCallBackA
	#define	AjcCtkInit					AjcCtkInitA
	#define	AjcCtkGetToken				AjcCtkGetTokenA
	#define	AjcCtkPeekToken				AjcCtkPeekTokenA
	#define	AjcCtkGetTokenString		AjcCtkGetTokenStringA
	#define	AjcCtkGetTokenLocation		AjcCtkGetTokenLocationA
	#define	AjcCtkGetTokenPosition		AjcCtkGetTokenPositionA
#endif

typedef	BOOL (CALLBACK *PCBAJCTKA)(BCP pBuf, UI lBuf, UX cbp);
typedef	BOOL (CALLBACK *PCBAJCTKW)(WCP pBuf, UI lBuf, UX cbp);

AJCEXPORT	HAJCTK	WINAPI	AjcCtkCreateA	(UI flag, PCBAJCTKA cbGetLine, UX cbp);
AJCEXPORT	HAJCTK	WINAPI	AjcCtkCreateW	(UI flag, PCBAJCTKW cbGetLine, UX cbp);

AJCEXPORT	BOOL	WINAPI	AjcCtkReset		(HAJCTK hCtk);

AJCEXPORT	BOOL	WINAPI	AjcCtkSetCallBackA(HAJCTK hCtk, PCBAJCTKA cbGetLine, UX cbp);
AJCEXPORT	BOOL	WINAPI	AjcCtkSetCallBackW(HAJCTK hCtk, PCBAJCTKW cbGetLine, UX cbp);

AJCEXPORT	BOOL	WINAPI	AjcCtkSetCallBackParam	 (HAJCTK pW, UX cbp);

AJCEXPORT	BOOL	WINAPI	AjcCtkDelete	(HAJCTK hCtk);

AJCEXPORT	BOOL	WINAPI	AjcCtkSetFlag	(HAJCTK hCtk, UI flag);
AJCEXPORT	UI		WINAPI	AjcCtkGetFlag	(HAJCTK hCtk);

AJCEXPORT	BOOL	WINAPI	AjcCtkGetTokenA (HAJCTK hCtk, BCP pStrBuf, UI lStrBuf);
AJCEXPORT	BOOL	WINAPI	AjcCtkGetTokenW (HAJCTK hCtk, WCP pStrBuf, UI lStrBuf);

AJCEXPORT	BOOL	WINAPI	AjcCtkPeekTokenA(HAJCTK hCtk, BCP pStrBuf, UI lStrBuf);
AJCEXPORT	BOOL	WINAPI	AjcCtkPeekTokenW(HAJCTK hCtk, WCP pStrBuf, UI lStrBuf);

AJCEXPORT	C_BCP	WINAPI	AjcCtkGetTokenStringA(EAJCTKCODE tkn);
AJCEXPORT	C_WCP	WINAPI	AjcCtkGetTokenStringW(EAJCTKCODE tkn);

AJCEXPORT	UI		WINAPI	AjcCtkGetTokenLocationA(HAJCTK hCtk);
AJCEXPORT	UI		WINAPI	AjcCtkGetTokenLocationW(HAJCTK hCtk);

AJCEXPORT	UI		WINAPI	AjcCtkGetTokenPositionA(HAJCTK hCtk, UI TabStep);
AJCEXPORT	UI		WINAPI	AjcCtkGetTokenPositionW(HAJCTK hCtk, UI TabStep);

AJCEXPORT	HAJCTK	WINAPI	AjcCtkGetReplicatedHandle(HAJCTK hCtk);


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT	EAJCTKCODE	WINAPI	AjcCtkGetCurToken		(HAJCTK pW);
AJCEXPORT	EAJCTKSUF	WINAPI	AjcCtkGetCurSuffix		(HAJCTK pW);
AJCEXPORT	UI			WINAPI	AjcCtkGetCurFlag		(HAJCTK pW);
AJCEXPORT	UI			WINAPI	AjcCtkGetCurLineNumber	(HAJCTK pW);
AJCEXPORT	UI			WINAPI	AjcCtkGetCurPosition	(HAJCTK pW, UI TabWidth);
AJCEXPORT	UI			WINAPI	AjcCtkGetCurError		(HAJCTK pW);

AJCEXPORT	BOOL		WINAPI	AjcCtkIsUsrSym			(EAJCTKCODE tkn);
AJCEXPORT	BOOL		WINAPI	AjcCtkIsRsvSym			(EAJCTKCODE tkn);
AJCEXPORT	BOOL		WINAPI	AjcCtkIsValue			(EAJCTKCODE tkn);
AJCEXPORT	BOOL		WINAPI	AjcCtkIsString			(EAJCTKCODE tkn);
AJCEXPORT	BOOL		WINAPI	AjcCtkIsPathName		(EAJCTKCODE tkn);
AJCEXPORT	BOOL		WINAPI	AjcCtkIsDelimit			(EAJCTKCODE tkn);

AJCEXPORT	BOOL		WINAPI	AjcCtkIsSymbol			(EAJCTKCODE tkn);
AJCEXPORT	BOOL		WINAPI	AjcCtkIsValSym			(EAJCTKCODE tkn);
AJCEXPORT	BOOL		WINAPI	AjcCtkIsSpace			(EAJCTKCODE tkn);

/****************************************************************************************************************/
#endif
