﻿#ifndef	AJRCHECKSUM_H_
#define	AJRCHECKSUM_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	バイトサム																									//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UB		WINAPI AjcCalcByteSum  (C_VOP sp,  UL len);		//	バイトサム算出（単純加算）
AJCEXPORT	UB		WINAPI AjcCalcByteSumN (C_VOP sp,  UL len);		//	　〃　　　　　（１の補数）
AJCEXPORT	UB		WINAPI AjcCalcByteSumS (C_VOP sp,  UL len);		//	　〃　　　　　（２の補数）
AJCEXPORT	UB		WINAPI AjcCalcByteSumX (C_VOP sp,  UL len);		//	　〃　　　　　（排他論理和）

AJCEXPORT	BOOL	WINAPI AjcSetByteSum   (VOP   rec, UL rl);		//	バイトサム設定（単純加算）
AJCEXPORT	BOOL	WINAPI AjcSetByteSumN  (VOP   rec, UL rl);		//	　〃　　　　　（１の補数）
AJCEXPORT	BOOL	WINAPI AjcSetByteSumS  (VOP   rec, UL rl);		//	　〃　　　　　（２の補数）
AJCEXPORT	BOOL	WINAPI AjcSetByteSumX  (VOP   rec, UL rl);		//	　〃　　　　　（排他論理和）

AJCEXPORT	BOOL	WINAPI AjcChkByteSum   (C_VOP rec, UL rl);		//	バイトサム検査（単純加算）
AJCEXPORT	BOOL	WINAPI AjcChkByteSumN  (C_VOP rec, UL rl);		//	　〃　　　　　（１の補数）
AJCEXPORT	BOOL	WINAPI AjcChkByteSumS  (C_VOP rec, UL rl);		//	　〃　　　　　（２の補数）
AJCEXPORT	BOOL	WINAPI AjcChkByteSumX  (C_VOP rec, UL rl);		//	　〃　　　　　（排他論理和）

//--------------------------------------------------------------------------------------------------------------//
//	ワードサム																									//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UW		WINAPI AjcCalcWordSum   (C_VOP sp,  UL len);	//	ワードサム算出（単純加算）
AJCEXPORT	UW		WINAPI AjcCalcWordSumN  (C_VOP sp,  UL len);	//	　〃　　　　　（１の補数）
AJCEXPORT	UW		WINAPI AjcCalcWordSumS  (C_VOP sp,  UL len);	//	　〃　　　　　（２の補数）
AJCEXPORT	UW		WINAPI AjcCalcWordSumX  (C_VOP sp,  UL len);	//	　〃　　　　　（排他論理和）

AJCEXPORT	BOOL	WINAPI AjcSetWordSum    (VOP   rec, UL rl);		//	ワードサム設定（単純加算）
AJCEXPORT	BOOL	WINAPI AjcSetWordSumN   (VOP   rec, UL rl);		//	　〃　　　　　（１の補数）
AJCEXPORT	BOOL	WINAPI AjcSetWordSumS   (VOP   rec, UL rl);		//	　〃　　　　　（２の補数）
AJCEXPORT	BOOL	WINAPI AjcSetWordSumX   (VOP   rec, UL rl);		//	　〃　　　　　（排他論理和）

AJCEXPORT	BOOL	WINAPI AjcChkWordSum    (C_VOP rec, UL rl);		//	ワードサム検査（単純加算）
AJCEXPORT	BOOL	WINAPI AjcChkWordSumN   (C_VOP rec, UL rl);		//	　〃　　　　　（１の補数）
AJCEXPORT	BOOL	WINAPI AjcChkWordSumS   (C_VOP rec, UL rl);		//	　〃　　　　　（２の補数）
AJCEXPORT	BOOL	WINAPI AjcChkWordSumX   (C_VOP rec, UL rl);		//	　〃　　　　　（排他論理和）

//--------------------------------------------------------------------------------------------------------------//
//	ワードサム（逆エンディアン）																				//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UW		WINAPI AjcCalcWordSumR (C_VOP sp,  UL len);	//	逆のエンディアンでワードサム算出（単純加算）
AJCEXPORT	UW		WINAPI AjcCalcWordSumNR(C_VOP sp,  UL len);	//	　〃                            （１の補数）
AJCEXPORT	UW		WINAPI AjcCalcWordSumSR(C_VOP sp,  UL len);	//	　〃                            （２の補数）
AJCEXPORT	UW		WINAPI AjcCalcWordSumXR(C_VOP sp,  UL len);	//	　〃                            （排他論理和）

AJCEXPORT	BOOL	WINAPI AjcSetWordSumR  (VOP   rec, UL rl);	//	逆のエンディアンでワードサム設定（単純加算）
AJCEXPORT	BOOL	WINAPI AjcSetWordSumNR (VOP   rec, UL rl);	//	　〃                            （１の補数）
AJCEXPORT	BOOL	WINAPI AjcSetWordSumSR (VOP   rec, UL rl);	//	　〃                            （２の補数）
AJCEXPORT	BOOL	WINAPI AjcSetWordSumXR (VOP   rec, UL rl);	//	　〃                            （排他論理和）

AJCEXPORT	BOOL	WINAPI AjcChkWordSumR  (C_VOP rec, UL rl);	//	逆のエンディアンでワードサム検査（単純加算）
AJCEXPORT	BOOL	WINAPI AjcChkWordSumNR (C_VOP rec, UL rl);	//	　〃                            （１の補数）
AJCEXPORT	BOOL	WINAPI AjcChkWordSumSR (C_VOP rec, UL rl);	//	　〃                            （２の補数）
AJCEXPORT	BOOL	WINAPI AjcChkWordSumXR (C_VOP rec, UL rl);	//	　〃                            （排他論理和）


/***************************************************************************************************************/
#endif
