﻿#ifndef	AJCCTRLLOGFILE_H_
#define	AJCCTRLLOGFILE_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcLgfSetDir				AjcLgfSetDirW
	#define	AjcLgfGetDir				AjcLgfGetDirW
	#define	AjcLgfPutText				AjcLgfPutTextW
	#define	AjcLgfPrintF				AjcLgfPrintFW
	#define	AjcLgfSetLogFileNamePrefix	AjcLgfSetLogFileNamePrefixW
	#define	AjcLgfGetLogFileNamePrefix	AjcLgfGetLogFileNamePrefixW
	#define	AjcLgfSetLogFileExtention	AjcLgfSetLogFileExtentionW
	#define	AjcLgfGetLogFileExtention	AjcLgfGetLogFileExtentionW
	#define	AjcLgfLoadProp				AjcLgfLoadPropW
	#define	AjcLgfSaveProp				AjcLgfSavePropW
	#define	AjcLgfGetFilePath			AjcLgfGetFilePathW
#else
	#define	AjcLgfSetDir				AjcLgfSetDirA
	#define	AjcLgfGetDir				AjcLgfGetDirA
	#define	AjcLgfPutText				AjcLgfPutTextA
	#define	AjcLgfPrintF				AjcLgfPrintFA
	#define	AjcLgfSetLogFileNamePrefix	AjcLgfSetLogFileNamePrefixA
	#define	AjcLgfGetLogFileNamePrefix	AjcLgfGetLogFileNamePrefixA
	#define	AjcLgfSetLogFileExtention	AjcLgfSetLogFileExtentionA
	#define	AjcLgfGetLogFileExtention	AjcLgfGetLogFileExtentionA
	#define	AjcLgfLoadProp				AjcLgfLoadPropA
	#define	AjcLgfSaveProp				AjcLgfSavePropA
	#define	AjcLgfGetFilePath			AjcLgfGetFilePathA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのスタイル																						//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCLGF_DISCLICK		0x0080			//	Bit7   : 左クリック禁止
#define	AJCLGF_NOBLINK		0x0040			//	Bit6   : ブリンクしない

//--------------------------------------------------------------------------------------------------------------//
//	タイムスタンプ形式																							//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCLGFTS_NO		= 0	,		//	タイムスタンプなし
	AJCLGFTS_HMSN		,		//	hh:mm:ss.nnn
	AJCLGFTS_HMS		,		//	hh:mm:ss
	AJCLGFTS_TICK		,		//	Windows開始時からの経過時間[ms]
	AJCLGFTS_MS			,		//	ログファイル出力コントロール開始時からの経過時間[ms]
	AJCLGFTS_US			,		//	ログファイル出力コントロール開始時からの経過時間[us]

	AJCLGFTS_NUM		,

	AJCLGFTS_ERR	= 99		//	エラー
} AJCLGFTS;

//--------------------------------------------------------------------------------------------------------------//
//	通知メッセージ																								//
//--------------------------------------------------------------------------------------------------------------//
//																				wParam					lParam
#define	AJCLGFN_START			(WM_APP + 20)	//	ログ出力開始				－						出力ファイルパス名のアドレス
#define	AJCLGFN_STOP			(WM_APP + 21)	//	ログ出力停止				－						－
#define	AJCLGFN_ENCODE			(WM_APP + 22)	//	テキストエンコード変更		－						LOWORD: 出力エンコード
//																				－						HIWORD: BOM出力フラグ

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSetDirA					(HWND hwnd, C_BCP pDirPath);
AJCEXPORT BOOL	   WINAPI AjcLgfSetDirW					(HWND hwnd, C_WCP pDirPath);

AJCEXPORT BOOL	   WINAPI AjcLgfGetDirA					(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT BOOL	   WINAPI AjcLgfGetDirW					(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT BOOL	   WINAPI AjcLgfSetTextEncode			(HWND hwnd, EAJCTEC   iTec, EAJCTEC   oTec, BOOL   fBOM);
AJCEXPORT BOOL	   WINAPI AjcLgfGetTextEncode			(HWND hwnd, PEAJCTEC piTec, PEAJCTEC poTec, BOOL *pfBOM);

AJCEXPORT BOOL	   WINAPI AjcLgfStart					(HWND hwnd);
AJCEXPORT BOOL	   WINAPI AjcLgfStop					(HWND hwnd);
AJCEXPORT BOOL	   WINAPI AjcLgfIsActive				(HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcLgfPutTextA				(HWND hwnd, C_BCP pCmd, BOOL fTimeStamp, C_BCP pTxt);
AJCEXPORT BOOL	   WINAPI AjcLgfPutTextW				(HWND hwnd, C_WCP pCmd, BOOL fTimeStamp, C_WCP pTxt);

AJCEXPORT BOOL	   WINAPI AjcLgfPrintFA					(HWND hwnd, C_BCP pCmd, BOOL fTimeStamp, C_BCP pFmt, ...);
AJCEXPORT BOOL	   WINAPI AjcLgfPrintFW					(HWND hwnd, C_WCP pCmd, BOOL fTimeStamp, C_WCP pFmt, ...);

AJCEXPORT BOOL	   WINAPI AjcLgfSetTimeStampFormat		(HWND hwnd, AJCLGFTS TimeStampFormat);
AJCEXPORT AJCLGFTS WINAPI AjcLgfGetTimeStampFormat		(HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcLgfSetLogFileNamePrefixA	(HWND hwnd, C_BCP pPrefix);
AJCEXPORT BOOL	   WINAPI AjcLgfSetLogFileNamePrefixW	(HWND hwnd, C_WCP pPrefix);

AJCEXPORT BOOL	   WINAPI AjcLgfGetLogFileNamePrefixA	(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT BOOL	   WINAPI AjcLgfGetLogFileNamePrefixW	(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT BOOL	   WINAPI AjcLgfSetLogFileExtentionA	(HWND hwnd, C_BCP pExt);
AJCEXPORT BOOL	   WINAPI AjcLgfSetLogFileExtentionW	(HWND hwnd, C_WCP pExt);

AJCEXPORT BOOL	   WINAPI AjcLgfGetLogFileExtentionA	(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT BOOL	   WINAPI AjcLgfGetLogFileExtentionW	(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT BOOL	   WINAPI AjcLgfLoadPropA				(HWND hwnd, C_BCP pSect);
AJCEXPORT BOOL	   WINAPI AjcLgfLoadPropW				(HWND hwnd, C_WCP pSect);

AJCEXPORT BOOL	   WINAPI AjcLgfSavePropA				(HWND hwnd, C_BCP pSect);
AJCEXPORT BOOL	   WINAPI AjcLgfSavePropW				(HWND hwnd, C_WCP pSect);

AJCEXPORT HWND	   WINAPI AjcLgfGetMainWindow			(HWND hwnd, COLORREF *pBkGnd);

/****************************************************************************************************************/
#endif
