﻿#ifndef	AJCDATEANDTIME_H_
#define	AJCDATEANDTIME_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcDateStr					AjcDateStrW
	#define	AjcTimeStr					AjcTimeStrW
	#define	AjcSetDateFromText			AjcSetDateFromTextW
	#define	AjcSetDateFromTextEx		AjcSetDateFromTextExW
	#define	AjcSetTimeFromText			AjcSetTimeFromTextW
	#define	AjcSetTimeFromTextEx		AjcSetTimeFromTextExW
	#define	AjcSetDateAndTimeFromText 	AjcSetDateAndTimeFromTextW
	#define	AjcSetDateAndTimeFromTextEx	AjcSetDateAndTimeFromTextExW
#else
	#define	AjcDateStr					AjcDateStrA
	#define	AjcTimeStr					AjcTimeStrA
	#define	AjcSetDateFromText			AjcSetDateFromTextA
	#define	AjcSetDateFromTextEx		AjcSetDateFromTextExA
	#define	AjcSetTimeFromText			AjcSetTimeFromTextA
	#define	AjcSetTimeFromTextEx		AjcSetTimeFromTextExA
	#define	AjcSetDateAndTimeFromText 	AjcSetDateAndTimeFromTextA
	#define	AjcSetDateAndTimeFromTextEx	AjcSetDateAndTimeFromTextExA
#endif

/*--------------------------------------------------------------------------------------------------------------*/
/*	日付時刻指定フラグ																							*/
/*--------------------------------------------------------------------------------------------------------------*/
#define	AJCDATEFLAG_YYMMDD	0x8000		/*	年月日の順で指定													*/
#define	AJCDATEFLAG_MMDDYY	0x4000		/*	月日年の順で指定													*/
#define	AJCDATEFLAG_DDMMYY	0x2000		/*	日月年の順で指定													*/
#define	AJCDATEFLAG_MMYYDD	0x1000		/*	月年日の順で指定													*/

#define	AJCDATEFLAG_FORM	0xF000

#define	AJCDATEFLAG_ADJUST	0x0080		/*	年＝1970～2105、月＝1～12、日＝1～28,29,30 or 31の範囲内に補正		*/
#define	AJCDATEFLAG_SETDEF	0x0040		/*	未指定の項目に規定値（年=2000, 月=1, 日=1）を設定する				*/
#define	AJCDATEFLAG_SETDOW	0x0020		/*	曜日(wDayOfWeek)を設定する											*/

#define	AJCTIMEFLAG_ADJUST	0x0008		/*	時＝00～23、分＝00～59、秒＝00～58，ミリ秒=000～999の範囲内に補正	*/
#define	AJCTIMEFLAG_SETDEF	0x0004		/*	未指定の時刻項目に規定値（０）を設定する							*/

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	BOOL	WINAPI	AjcTime1970ToSysTime (UI  Time1970, LPSYSTEMTIME pStime);
AJCEXPORT	BOOL	WINAPI	AjcTime1970ToSysTimeL(ULL Time1970, LPSYSTEMTIME pStime);

AJCEXPORT	UI		WINAPI	AjcSysTimeToTime1970 (const SYSTEMTIME *pStime);
AJCEXPORT	ULL		WINAPI	AjcSysTimeToTime1970L(const SYSTEMTIME *pStime);

AJCEXPORT	BOOL	WINAPI	AjcSysTimeToLocalTime(const SYSTEMTIME *pStime, LPSYSTEMTIME pLtime);

AJCEXPORT	BOOL	WINAPI	AjcTimeUpdate(const SYSTEMTIME *pStime, LPSYSTEMTIME pUpdated, int Second);

AJCEXPORT	BCP		WINAPI	AjcDateStrA(const SYSTEMTIME *pStime);
AJCEXPORT	WCP		WINAPI	AjcDateStrW(const SYSTEMTIME *pStime);

AJCEXPORT	BCP		WINAPI	AjcTimeStrA(const SYSTEMTIME *pStime, BOOL fMilliseconds);
AJCEXPORT	WCP		WINAPI	AjcTimeStrW(const SYSTEMTIME *pStime, BOOL fMilliseconds);

AJCEXPORT	BOOL	WINAPI	AjcSetDateFromTextA				(C_BCP pDateText, LPSYSTEMTIME pSt, BCP *pNext);
AJCEXPORT	BOOL	WINAPI	AjcSetDateFromTextW				(C_WCP pDateText, LPSYSTEMTIME pSt, WCP *pNext);

AJCEXPORT	BOOL	WINAPI	AjcSetDateFromTextExA			(C_BCP pDateText, LPSYSTEMTIME pSt, BCP *pNext, UI flag, BC dlm);
AJCEXPORT	BOOL	WINAPI	AjcSetDateFromTextExW			(C_WCP pDateText, LPSYSTEMTIME pSt, WCP *pNext, UI flag, WC dlm);

AJCEXPORT	BOOL	WINAPI	AjcSetTimeFromTextA				(C_BCP pTimeText, LPSYSTEMTIME pSt, BCP *pNext);
AJCEXPORT	BOOL	WINAPI	AjcSetTimeFromTextW				(C_WCP pTimeText, LPSYSTEMTIME pSt, WCP *pNext);

AJCEXPORT	BOOL	WINAPI	AjcSetTimeFromTextExA			(C_BCP pTimeText, LPSYSTEMTIME pSt, BCP *pNext, UI flag, BC dlm, BC dms);
AJCEXPORT	BOOL	WINAPI	AjcSetTimeFromTextExW			(C_WCP pTimeText, LPSYSTEMTIME pSt, WCP *pNext, UI flag, WC dlm, WC dms);

AJCEXPORT	BOOL	WINAPI	AjcSetDateAndTimeFromTextA 		(C_BCP pText	, LPSYSTEMTIME pSt, BCP *pNext);
AJCEXPORT	BOOL	WINAPI	AjcSetDateAndTimeFromTextW 		(C_WCP pText	, LPSYSTEMTIME pSt, WCP *pNext);

AJCEXPORT	BOOL	WINAPI	AjcSetDateAndTimeFromTextExA	(C_BCP pText	, LPSYSTEMTIME pSt, BCP *pNext, UI flag, BC dlm_d, BC dlm_t, BC dms);
AJCEXPORT	BOOL	WINAPI	AjcSetDateAndTimeFromTextExW	(C_WCP pText	, LPSYSTEMTIME pSt, WCP *pNext, UI flag, WC dlm_d, WC dlm_t, WC dms);

AJCEXPORT	BOOL	WINAPI	AjcGetRandomDateAndTime (LPSYSTEMTIME pSt, LPSYSTEMTIME pStSrt, LPSYSTEMTIME pStEnd);

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＭＳＩＬサポート用																							*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	BOOL	WINAPI	AjcMsilTime1970ToSysTime(UI Time1970, UIP pYear, UIP pMonth, UIP pDay, UIP pHour, UIP pMinute, UIP pSecond);
AJCEXPORT	UI		WINAPI	AjcMsilSysTimeToTime1970(UI Year, UI Month, UI Day, UI Hour, UI Minute, UI Second);
AJCEXPORT	BOOL	WINAPI	AjcMsilSysTimeToLocalTime(UIP pYear, UIP pMonth, UIP pDay, UIP pHour, UIP pMinute, UIP pSecond);


/****************************************************************************************************************/
#endif
