﻿#ifndef	AJCDEF_H_
#define	AJCDEF_H_
/****************************************************************************************************************/

//==============================================================================================================//
//																												//
//	基本タイプ定義																								//
//																												//
//==============================================================================================================//
#ifndef	AJC_DEFINED_BASICTYPE

typedef		void				VO;			/*	VOID															*/

typedef		signed	 char		SB;			/*	　８ビット整数 （符号付き）										*/
typedef		unsigned char		UB;			/*	　　〃　　　　 （符号なし）										*/
typedef		signed	 short		SW;			/*	１６ビット整数 （符号付き）										*/
typedef		unsigned short		UW;			/*	　　〃　　　　 （符号なし）										*/
typedef		signed	 long		SL;			/*	３２ビット整数 （符号付き）										*/
typedef		unsigned long		UL;			/*	　　〃　　　　 （符号なし）										*/
typedef		signed	 int		SI;			/*	１６ビット以上の整数 （符号付き）								*/
typedef		unsigned int		UI;			/*	　　〃　　　　 　　　（符号なし）								*/
typedef		char				BC;			/*	バイト文字														*/
typedef		wchar_t				WC;			/*	ワイド文字														*/

typedef signed	 __int64		SLL;
typedef	unsigned __int64		ULL;

/*----- SX / UX : ポインタ値を格納可能なビット数の整数 ---------------------------------------------------------*/
#if _MSC_VER <= 1200
		typedef signed	 int		SX;
		typedef	unsigned int		UX;
#else
	#ifdef _WIN64
		typedef signed	 __int64	SX;
		typedef	unsigned __int64	UX;
	#else
		typedef _W64 signed   int	SX;
		typedef _W64 unsigned int	UX;
	#endif
#endif

/*----- P O I N T E R ------------------------------------------------------------------------------------------*/
typedef		VO	*VOP;
typedef		SB	*SBP;
typedef		UB	*UBP;
typedef		SW	*SWP;
typedef		UW	*UWP;
typedef		SL	*SLP;
typedef		UL	*ULP;
typedef		SI	*SIP;
typedef		UI	*UIP;
typedef		SX	*SXP;
typedef		UX	*UXP;
typedef		BC	*BCP;
typedef		WC	*WCP;

typedef signed	 __int64	*	SLLP;
typedef	unsigned __int64	*	ULLP;

/*----- C O N S T	P O I N T E R ------------------------------------------------------------------------------*/
typedef		const VO	*	C_VOP;
typedef		const SB	*	C_SBP;
typedef		const UB	*	C_UBP;
typedef		const SW	*	C_SWP;
typedef		const UW	*	C_UWP;
typedef		const SL	*	C_SLP;
typedef		const UL	*	C_ULP;
typedef		const SI	*	C_SIP;
typedef		const UI	*	C_UIP;
typedef		const SX	*	C_SXP;
typedef		const UX	*	C_UXP;
typedef		const BC	*	C_BCP;
typedef		const WC	*	C_WCP;

typedef const signed   __int64	*	C_SLLP;
typedef	const unsigned __int64	*	C_ULLP;

/*----- T E X T ------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	typedef WC			  UT;
	typedef WC		  *   UTP;
	typedef const WC  * C_UTP;
#else
	typedef BC			  UT;
	typedef BC		  *   UTP;
	typedef const BC  * C_UTP;
#endif

#endif	// AJC_DEFINED_BASICTYPE

/*----- 複素数 -------------------------------------------------------------------------------------------------*/
typedef struct {
	double re;		//	実部
	double im;		//	虚部
} AJCCOMPLEX, *PAJCCOMPLEX;
typedef const AJCCOMPLEX *PCAJCCOMPLEX;

/*----- WinMain / wWinMain -------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcMain		wmain
	#define	AjcWinMain	wWinMain
#else
	#define	AjcMain		 main
	#define	AjcWinMain	 WinMain
#endif

//==============================================================================================================//
//																												//
//	ＤＬＬインタフェース定義																					//
//																												//
//==============================================================================================================//
#ifdef	AJC_DLL
	#ifdef __cplusplus
		#define AJCEXPORT extern "C" __declspec ( dllexport )
	#else
		#define AJCEXPORT			 __declspec ( dllexport )
	#endif
#else
	#ifdef __cplusplus
		#define AJCEXPORT extern "C" __declspec ( dllimport )
	#else
		#define AJCEXPORT			 __declspec ( dllimport )
	#endif
#endif
//==============================================================================================================//
//																												//
//	UNICODE と _UNICODE																							//
//																												//
//==============================================================================================================//
#ifdef UNICODE
	#ifdef _MBCS
		#undef _MBCS
	#endif
	#ifndef _UNICODE
		#define	_UNICODE
	#endif
#endif
//==============================================================================================================//
//																												//
//	文字エンコード																								//
//																												//
//==============================================================================================================//
typedef enum {
	AJCTEC_MBC			= 0	,		//	マルチバイト
	AJCTEC_UTF_8		= 1	,		//	ＵＴＦ－８
	AJCTEC_EUC_J		= 2,		//	ＥＵＣ（日本語）
	AJCTEC_UTF_16LE		= 3,		//	ＵＴＦ－１６ＬＥ
	AJCTEC_UTF_16BE		= 4,		//	ＵＴＦ－１６ＢＥ
	AJCTEC_AUTO			= 9,		//	自動設定
	AJCTEC_ERROR		= 99,		//	エラー
} EAJCTEC, *PEAJCTEC;

#define	MAJCTEC_VALID(V)	((V) == AJCTEC_MBC || (V) == AJCTEC_UTF_8 || (V) == AJCTEC_EUC_J || (V) == AJCTEC_UTF_16LE || (V) == AJCTEC_UTF_16BE || (V) == AJCTEC_AUTO)

//==============================================================================================================//
//																												//
//	文字列比較モード																							//
//																												//
//==============================================================================================================//
typedef enum {
	AJCCMP_EXACT_WIDTH		= 0,	//	英字の大小文字を区別する
	AJCCMP_IGNORE_WIDTH		= 1,	//	英字の大小文字を区別しない
	AJCCMP_MIX				= 2,	//	同一文字列の場合のみ英字の大小文字を区別する（アルファベット順に並ぶように比較）
} EAJCCMPMODE, *PEAJCCMPMODE;

//	旧バージョン互換
#define		AJCCMP_RECOGNIZE_WIDTH	AJCCMP_EXACT_WIDTH
#define		AJCCMP_ALPHABETIC		AJCCMP_MIX

//==============================================================================================================//
//																												//
//	オプションの合成マクロ																						//
//																												//
//==============================================================================================================//
#define		AJCOPT1(Z, A)												(Z##A)
#define		AJCOPT2(Z, A, B)											(Z##A | Z##B)
#define		AJCOPT3(Z, A, B, C)											(Z##A | Z##B | Z##C)
#define		AJCOPT4(Z, A, B, C, D)										(Z##A | Z##B | Z##C | Z##D)
#define		AJCOPT5(Z, A, B, C, D, E)									(Z##A | Z##B | Z##C | Z##D | Z##E)
#define		AJCOPT6(Z, A, B, C, D, E, F)								(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F)
#define		AJCOPT7(Z, A, B, C, D, E, F, G)								(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G)
#define		AJCOPT8(Z, A, B, C, D, E, F, G, H)							(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H)
#define		AJCOPT9(Z, A, B, C, D, E, F, G, H, I)						(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H | Z##I)

#define		AJCOPT10(Z, A, B, C, D, E, F, G, H, I, J)					(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H | Z##I | Z##J)
#define		AJCOPT11(Z, A, B, C, D, E, F, G, H, I, J, K)				(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H | Z##I | Z##J | Z##K)
#define		AJCOPT12(Z, A, B, C, D, E, F, G, H, I, J, K, L)				(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H | Z##I | Z##J | Z##K | Z##L)
#define		AJCOPT13(Z, A, B, C, D, E, F, G, H, I, J, K, L, M)			(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H | Z##I | Z##J | Z##K | Z##L | Z##M)
#define		AJCOPT14(Z, A, B, C, D, E, F, G, H, I, J, K, L, M, N)		(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H | Z##I | Z##J | Z##K | Z##L | Z##M | Z##N)
#define		AJCOPT15(Z, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)	(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H | Z##I | Z##J | Z##K | Z##L | Z##M | Z##N | Z##O)
#define		AJCOPT16(Z, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)	(Z##A | Z##B | Z##C | Z##D | Z##E | Z##F | Z##G | Z##H | Z##I | Z##J | Z##K | Z##L | Z##M | Z##N | Z##O | Z##P)

//==============================================================================================================//
//																												//
//	６４ビットWindows　互換マクロ																				//
//																												//
//==============================================================================================================//
#if  _MSC_VER >= 1300
//--------------------------------------------------------------------------------------------------------------//
//	For Visual Studio .NET																						//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	_WIN64
	#define	MAjcSetWindowLong(_HWND_, _IDX_, _VAL_)	((LONG_PTR)AjcSetWindowLongPtr(_HWND_, _IDX_, (LONG_PTR)(_VAL_)))
	#define	MAjcGetWindowLong(_HWND_, _IDX_)		((LONG_PTR)AjcGetWindowLongPtr(_HWND_, _IDX_))
	#define	MAjcSetClassLong(_HWND_, _IDX_, _VAL_)	((LONG_PTR)AjcSetClassLongPtr(_HWND_, _IDX_, (LONG_PTR)(_VAL_)))
	#define	MAjcGetClassLong(_HWND_, _IDX_)			((LONG_PTR)AjcGetClassLongPtr(_HWND_, _IDX_))

	#define	GCL_HBRBACKGROUND	GCLP_HBRBACKGROUND	
	#define	GCL_HCURSOR			GCLP_HCURSOR		
	#define	GCL_HICON			GCLP_HICON			
	#define	GCL_HICONSM			GCLP_HICOMSM		
	#define	GCL_HMODULE			GCLP_HMODULE		
	#define	GCL_MENUNAME		GCLP_MENUNAME		
	#define	GCL_WNDPROC			GCLP_WNDPROC		

	#define	GWL_WNDPROC			GWLP_WNDPROC	
	#define	GWL_HWNDPARENT		GWLP_HWNDPARENT	
	#define	GWL_USERDATA		GWLP_USERDATA	
	#define	GWL_HINSTANCE		GWLP_HINSTANCE	
	#define	DWL_DLGPROC			DWLP_DLGPROC	
	#define	DWL_MSGRESULT		DWLP_MSGRESULT	
	#define	DWL_USER			DWLP_USER		

#else
	#define	MAjcSetWindowLong(_HWND_, _IDX_, _VAL_)	((LONG_PTR)AjcSetWindowLongPtr(_HWND_, _IDX_, (LONG)((_W64 LONG)(_VAL_))))
	#define	MAjcGetWindowLong(_HWND_, _IDX_)		((LONG_PTR)AjcGetWindowLongPtr(_HWND_, _IDX_))
	#define	MAjcSetClassLong(_HWND_, _IDX_, _VAL_)	((LONG_PTR)AjcSetClassLongPtr(_HWND_, _IDX_, (LONG)((_W64 LONG)(_VAL_))))
	#define	MAjcGetClassLong(_HWND_, _IDX_)			((LONG_PTR)AjcGetClassLongPtr(_HWND_, _IDX_))
#endif

#else	// _MSC_VER >= 1300
//--------------------------------------------------------------------------------------------------------------//
//	For Visual Studio 6.0																						//
//--------------------------------------------------------------------------------------------------------------//
#ifndef	GCLP_HBRBACKGROUND
	#define	GCLP_HBRBACKGROUND		GCL_HBRBACKGROUND
	#define	GCLP_HCURSOR			GCL_HCURSOR
	#define	GCLP_HICON				GCL_HICON
	#define	GCLP_HICOMSM			GCL_HICONSM
	#define	GCLP_HMODULE			GCL_HMODULE
	#define	GCLP_MENUNAME			GCL_MENUNAME
	#define	GCLP_WNDPROC			GCL_WNDPROC

	#define	GWLP_WNDPROC			GWL_WNDPROC
	#define	GWLP_HWNDPARENT			GWL_HWNDPARENT
	#define	GWLP_ID					GWL_ID
	#define	GWLP_USERDATA			GWL_USERDATA
	#define	GWLP_HINSTANCE			GWL_HINSTANCE
	#define	DWLP_DLGPROC			DWL_DLGPROC
	#define	DWLP_MSGRESULT			DWL_MSGRESULT
	#define	DWLP_USER				DWL_USER

	#define	MAjcSetWindowLong(_HWND_, _IDX_, _VAL_)	SetWindowLong(_HWND_, _IDX_, (LONG)(_VAL_))
	#define	MAjcGetWindowLong(_HWND_, _IDX_)		GetWindowLong(_HWND_, _IDX_)
	#define	MAjcSetClassLong(_HWND_, _IDX_, _VAL_)	SetClassLong(_HWND_, _IDX_, (LONG)(_VAL_))
	#define	MAjcGetClassLong(_HWND_, _IDX_)			GetClassLong(_HWND_, _IDX_))
#endif
#endif	// _MSC_VER >= 1300

/****************************************************************************************************************/
#endif
