﻿#ifndef	AJCGENERAL_H_
#define	AJCGENERAL_H_
/****************************************************************************************************************/

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcGetLastErrorText				AjcGetLastErrorTextW
	#define	AjcDateStr						AjcDateStrW
	#define	AjcTimeStr						AjcTimeStrW
	#define	AjcSkipCmdArgs					AjcSkipCmdArgsW
	#define	AjcParseCmdArgs					AjcParseCmdArgsW
	#define	AjcParseCmdArgsEx				AjcParseCmdArgsExW
	#define	AjcGetCpuId						AjcGetCpuIdW
	#define	AjcCreateDllExportInfo			AjcCreateDllExportInfoW
	#define	AjcReleaseDllExportInfo			AjcReleaseDllExportInfoW
	#define	AjcCreateModImportInfo			AjcCreateModImportInfoW
	#define	AjcReleaseModImportInfo			AjcReleaseModImportInfoW
	#define	AJCDLLEXPORTINFO				AJCDLLEXPORTINFOW
	#define	PAJCDLLEXPORTINFO				PAJCDLLEXPORTINFOW
	#define	AJCMODIMPORTINFO				AJCMODIMPORTINFOW
	#define	PAJCMODIMPORTINFO				PAJCMODIMPORTINFOW
	#define	AjcGetSidStringByCurrentUser	AjcGetSidStringByCurrentUserW
	#define	AjcGetRidInSid					AjcGetRidInSidW
	#define	AjcGetParentProcess				AjcGetParentProcessW
	#define	AjcCreateFont					AjcCreateFontW

	#define	AjcGetVerInfo					AjcGetVerInfoW

	#define	AjcGetClipboardText				AjcGetClipboardTextW
	#define	AjcCreateClipboardText			AjcCreateClipboardTextW
	#define	AjcReleaseClipboardText			AjcReleaseClipboardTextW
	#define	AjcPutClipboardText				AjcPutClipboardTextW

#else
	#define	AjcGetLastErrorText				AjcGetLastErrorTextA
	#define	AjcDateStr						AjcDateStrA
	#define	AjcTimeStr						AjcTimeStrA
	#define	AjcSkipCmdArgs					AjcSkipCmdArgsA
	#define	AjcParseCmdArgs					AjcParseCmdArgsA
	#define	AjcParseCmdArgsEx				AjcParseCmdArgsExA
	#define	AjcGetCpuId						AjcGetCpuIdA
	#define	AjcCreateDllExportInfo			AjcCreateDllExportInfoA
	#define	AjcReleaseDllExportInfo			AjcReleaseDllExportInfoA
	#define	AjcCreateModImportInfo			AjcCreateModImportInfoA
	#define	AjcReleaseModImportInfo			AjcReleaseModImportInfoA
	#define	AJCDLLEXPORTINFO				AJCDLLEXPORTINFOA
	#define	PAJCDLLEXPORTINFO				PAJCDLLEXPORTINFOA
	#define	AJCMODIMPORTINFO				AJCMODIMPORTINFOA
	#define	PAJCMODIMPORTINFO				PAJCMODIMPORTINFOA
	#define	AjcGetSidStringByCurrentUser	AjcGetSidStringByCurrentUserA
	#define	AjcGetRidInSid					AjcGetRidInSidA
	#define	AjcGetParentProcess				AjcGetParentProcessA
	#define	AjcCreateFont					AjcCreateFontA

	#define	AjcGetVerInfo					AjcGetVerInfoA

	#define	AjcGetClipboardText				AjcGetClipboardTextA
	#define	AjcCreateClipboardText			AjcCreateClipboardTextA
	#define	AjcReleaseClipboardText			AjcReleaseClipboardTextA
	#define	AjcPutClipboardText				AjcPutClipboardTextA

#endif

/*--------------------------------------------------------------------------------------------------------------*/
/*	ストックフォントＩＤ																						*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef enum {
	AJCFID_FIX10  = 0	,
	AJCFID_FIX12		,
	AJCFID_FIX14		,
	AJCFID_FIX16		,
	AJCFID_FIX18		,
	AJCFID_FIX20		,
	AJCFID_FIX22		,
	AJCFID_FIX24		,

	AJCFID_VAR10		,
	AJCFID_VAR12		,
	AJCFID_VAR14		,
	AJCFID_VAR16		,
	AJCFID_VAR18		,
	AJCFID_VAR20		,
	AJCFID_VAR22		,
	AJCFID_VAR24		,
} AJCFONTID, *PAJCFONTID;

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＤＬＬエクスポート情報																						*/
/*--------------------------------------------------------------------------------------------------------------*/
//----- ＤＬＬエクスポート情報（バイト文字）--------------------------------------------------------------------//
typedef struct {
	int		Ordinal;			//	序数
	C_BCP	pFuncName;			//	エクスポート関数名へのポインタ
	VOP		pFuncAddr;			//	関数のアドレス
} AJCDLLEXPORTINFOA, *PAJCDLLEXPORTINFOA;

//----- ＤＬＬエクスポート情報（ワイド文字）--------------------------------------------------------------------//
typedef struct {
	int		Ordinal;			//	序数
	C_WCP	pFuncName;			//	エクスポート関数名へのポインタ
	VOP		pFuncAddr;			//	関数のアドレス
} AJCDLLEXPORTINFOW, *PAJCDLLEXPORTINFOW;

/*--------------------------------------------------------------------------------------------------------------*/
/*	モジュールのインポート情報																					*/
/*--------------------------------------------------------------------------------------------------------------*/
//----- モジュールのインポート情報（バイト文字）----------------------------------------------------------------//
typedef struct {
	C_BCP	pDllName;			//	ＤＬＬ名へのポインタ
	int		Ordinal;			//	序数
	C_BCP	pFuncName;			//	エクスポート関数名へのポインタ
	VOP		pFuncAddr;			//	関数のアドレス
} AJCMODIMPORTINFOA, *PAJCMODIMPORTINFOA;

//----- モジュールのインポート情報（ワイド文字）----------------------------------------------------------------//
typedef struct {
	C_WCP	pDllName;			//	ＤＬＬ名へのポインタ
	int		Ordinal;			//	序数
	C_WCP	pFuncName;			//	エクスポート関数名へのポインタ
	VOP		pFuncAddr;			//	関数のアドレス
} AJCMODIMPORTINFOW, *PAJCMODIMPORTINFOW;

//--------------------------------------------------------------------------------------------------------------//
//	バージョン情報の名称																						//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCVERINFO_COMMENTS				TEXT("Comments")
#define	AJCVERINFO_INTERNAL_NAME		TEXT("InternalName")
#define	AJCVERINFO_PRODUCT_NAME			TEXT("ProductName")
#define	AJCVERINFO_COMPANY_NAME			TEXT("CompanyName")
#define	AJCVERINFO_LEGAL_COPYLIGHT		TEXT("LegalCopyright")
#define	AJCVERINFO_PRODUCT_VERSION		TEXT("ProductVersion")
#define	AJCVERINFO_FILE_DESCRIPTION		TEXT("FileDescription")
#define	AJCVERINFO_LEGAL_TRADEMARKS		TEXT("LegalTrademarks")
#define	AJCVERINFO_PRIVATE_BUILD		TEXT("PrivateBuild")
#define	AJCVERINFO_FILE_VERSION			TEXT("FileVersion")
#define	AJCVERINFO_ORIGINAL_FILENAME	TEXT("OriginalFilename")
#define	AJCVERINFO_SPECIAL_BUILD		TEXT("SpecialBuild")

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	UI		WINAPI	AjcGetLastErrorTextA(int LastError, BCP pBuf, UI bfl);
AJCEXPORT	UI		WINAPI	AjcGetLastErrorTextW(int LastError, WCP pBuf, UI bfl);


AJCEXPORT	VOP		WINAPI	AjcGetVariantInfo(const VARIANT* pVa, ULP pLen);

AJCEXPORT	UW		WINAPI	AjcExcWord	 (UI	 x);
AJCEXPORT	UL		WINAPI	AjcExcLong	 (UL	 x);
AJCEXPORT	ULL		WINAPI	AjcExcLLong	 (ULL	 x);
AJCEXPORT	float	WINAPI	AjcExcFloat	 (float	 x);
AJCEXPORT	double	WINAPI	AjcExcDouble (double x);
AJCEXPORT	VO		WINAPI	AjcExcAny (VOP pVal, int len);
AJCEXPORT	VO		WINAPI	AjcMemSwap(VOP pMem1, VOP pMem2, UI len);

AJCEXPORT	VOP		WINAPI	AjcMemSet8 (VOP pBuf, UB dat, UI len);
AJCEXPORT	VOP		WINAPI	AjcMemSet16(VOP pBuf, UW dat, UI len);
AJCEXPORT	VOP		WINAPI	AjcMemSet32(VOP pBuf, UL dat, UI len);

AJCEXPORT	double	WINAPI	AjcAdjustMultValue(double value, double unit);
AJCEXPORT	double	WINAPI	AjcAdjustMultPow10(double n, UIP pDigit, UIP pPrec, BOOL fEven);
AJCEXPORT	double	WINAPI	AjcRoundMultPow10 (double n, UIP pDigit, UIP pPrec);
AJCEXPORT	double	WINAPI	AjcAdjustPow10(double n, UIP pDigit, UIP pPrec);


AJCEXPORT	UI		WINAPI	AjcRgbBright(COLORREF rgb);
AJCEXPORT	double	WINAPI	AjcRgbIntensity(COLORREF rgb);
AJCEXPORT	double	WINAPI	AjcRgbIntensityRatio(double L1, double L2);
AJCEXPORT	UI		WINAPI	AjcRgbDeffrence(COLORREF rgb1, COLORREF rgb2);
AJCEXPORT	COLORREF WINAPI	AjcComplementaryColor(COLORREF rgb);

AJCEXPORT	C_BCP	WINAPI	AjcSkipCmdArgsA(C_BCP pCmd, UI n);
AJCEXPORT	C_WCP	WINAPI	AjcSkipCmdArgsW(C_WCP pCmd, UI n);

AJCEXPORT	BCP	*	WINAPI	AjcParseCmdArgsA(C_BCP pCmd, UIP pArgC);
AJCEXPORT	WCP	*	WINAPI	AjcParseCmdArgsW(C_WCP pCmd, UIP pArgC);

AJCEXPORT	BCP	*	WINAPI	AjcParseCmdArgsExA(C_BCP pCmd, UIP pArgC, BOOL fRemoveQuote);
AJCEXPORT	WCP	*	WINAPI	AjcParseCmdArgsExW(C_WCP pCmd, UIP pArgC, BOOL fRemoveQuote);

AJCEXPORT	VO		WINAPI	AjcReleaseCmdArgs(VOP pArgV);

#ifndef _WIN64
AJCEXPORT	BCP		WINAPI	AjcGetCpuIdA(UIP pSignature, UIP pParam, ULLP pSerialNo);
AJCEXPORT	WCP		WINAPI	AjcGetCpuIdW(UIP pSignature, UIP pParam, ULLP pSerialNo);
#endif

AJCEXPORT	double	WINAPI	AjcDifferenceOfTheta(double t1, double t2);

AJCEXPORT	PAJCDLLEXPORTINFOA	WINAPI	AjcCreateDllExportInfoA(HMODULE hDll, UIP pNum);
AJCEXPORT	PAJCDLLEXPORTINFOW	WINAPI	AjcCreateDllExportInfoW(HMODULE hDll, UIP pNum);

AJCEXPORT	VO		WINAPI	AjcReleaseDllExportInfoA(PAJCDLLEXPORTINFOA pInfo);
AJCEXPORT	VO		WINAPI	AjcReleaseDllExportInfoW(PAJCDLLEXPORTINFOW pInfo);

AJCEXPORT	PAJCMODIMPORTINFOA	WINAPI	AjcCreateModImportInfoA(HMODULE hMod, UIP pNum);
AJCEXPORT	PAJCMODIMPORTINFOW	WINAPI	AjcCreateModImportInfoW(HMODULE hMod, UIP pNum);

AJCEXPORT	VO		WINAPI	AjcReleaseModImportInfoA(PAJCMODIMPORTINFOA pInfo);
AJCEXPORT	VO		WINAPI	AjcReleaseModImportInfoW(PAJCMODIMPORTINFOW pInfo);

AJCEXPORT	BOOL	WINAPI	AjcExitWindows	 (UI flag);
AJCEXPORT	BOOL	WINAPI	AjcExitWindowsEx (UI flag, UI reason);
AJCEXPORT	BOOL	WINAPI	AjcSetSystemPowerState (BOOL fSuspend, BOOL fForce);

AJCEXPORT	UI		WINAPI	AjcGetSidStringByCurrentUserA(BCP pSidBuf, UI lSidBuf);
AJCEXPORT	UI		WINAPI	AjcGetSidStringByCurrentUserW(WCP pSidBuf, UI lSidBuf);

AJCEXPORT	int		WINAPI	AjcGetRidInSidA(C_BCP pSid);
AJCEXPORT	int		WINAPI	AjcGetRidInSidW(C_WCP pSid);

AJCEXPORT	UI		WINAPI	AjcGetDupRect(LPCRECT pRect1, LPCRECT pRect2, LPRECT pDup);

AJCEXPORT	BOOL	WINAPI	AjcAspGetZoomedRect(LPCRECT pRectSrc, LPCRECT pRectRef, LPRECT pRectBuf);
AJCEXPORT	BOOL	WINAPI	AjcAspGetZoomedSize(const SIZE *pSizeSrc, const SIZE *pSizeRef, LPSIZE pSizeBuf);
AJCEXPORT	BOOL	WINAPI	AjcAspGetZoomedInfo(int cx, int cy, int MaxLen, LPSIZE pSizeBuf);

AJCEXPORT	VO		WINAPI	AjcBell(VO);

AJCEXPORT	BOOL	WINAPI	AjcGetParentProcessA(UL pid, ULP pParent, BCP pBuf, UI lBuf);
AJCEXPORT	BOOL	WINAPI	AjcGetParentProcessW(UL pid, ULP pParent, WCP pBuf, UI lBuf);

AJCEXPORT	HFONT	WINAPI	AjcGetStockFont(AJCFONTID fid);

AJCEXPORT	HFONT	WINAPI	AjcCreateFontA(LPLOGFONTA pLf);
AJCEXPORT	HFONT	WINAPI	AjcCreateFontW(LPLOGFONTW pLf);

AJCEXPORT	UI		WINAPI	AjcGetVerInfoA(C_BCP pPath, C_BCP pInfoName, BCP pInfoBuf, int lInfoBuf);
AJCEXPORT	UI		WINAPI	AjcGetVerInfoW(C_WCP pPath, C_WCP pInfoName, WCP pInfoBuf, int lInfoBuf);

AJCEXPORT	UI		WINAPI	AjcGetClipboardTextA(BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI	AjcGetClipboardTextW(WCP pBuf, UI lBuf);

AJCEXPORT	BCP		WINAPI	AjcCreateClipboardTextA(VO);
AJCEXPORT	WCP		WINAPI	AjcCreateClipboardTextW(VO);

AJCEXPORT	BOOL	WINAPI	AjcReleaseClipboardTextA(BCP pTxt);
AJCEXPORT	BOOL	WINAPI	AjcReleaseClipboardTextW(WCP pTxt);

AJCEXPORT	BOOL	WINAPI	AjcPutClipboardTextA(C_BCP pTxt, UI lBuf);
AJCEXPORT	BOOL	WINAPI	AjcPutClipboardTextW(C_WCP pTxt, UI lBuf);

AJCEXPORT	UI		WINAPI AjcEnumMenuItems(HMENU hMenu, BOOL fSubMenu, UX cbp, BOOL (CALLBACK *cbEnumMenu)(HMENU hMenu, UI ix, UX id, UI type, UI state, HMENU hSubMenu, UX cbp));


/****************************************************************************************************************/
#endif

