﻿#ifndef	AJCLZHDECODE_H_
#define	AJCLZHDECODE_H_
//**************************************************************************************************************//

//--------------------------------------------------------------------------------------------------------------//
//	エラーコード																								//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCLZHERR_OK					= 0			,	//	ＯＫ
	AJCLZHERR_UNARYCODE_OUTOFRANGE	= 0x7F00	,	//	単進符号が規定範囲外
	AJCLZHERR_ILLEGAL_BITLEN					,	//	不正ビット長
	AJCLZHERR_BLEN_OVER19						,	//	ビット長のビット長テーブルのエントリ数が１９ヶをオーバー
	AJCLZHERR_BLEN_OVER510						,	//	ビット長テーブルのエントリ数が５１０をオーバー
	AJCLZHERR_ILLEGAL_FORMAT					,	//	ヘッダの内容が不正（"-lh0-" , "-lh5-" , "-lhd-" 以外）
	AJCLZHERR_ILLEGAL_HDLVL						,	//	ヘッダの内容が不正（ヘッダレベルが０～２以外）
	AJCLZHERR_NOTFOUND							,	//	ファイルが見つからない
	AJCLZHERR_MEMORY							,	//	メモリ不足
	AJCLZHERR_INVALIDMODE						,	//	不正モード
	AJCLZHERR_NULLPTR							,	//	NULLポインタ

	AJCLZHERR_NUM
} AJCLZHERR, *PAJCLZHERR;
//--------------------------------------------------------------------------------------------------------------//
//	インスタンス																								//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCLZHINPBUFSIZE	128				//	入力バッファサイズ（バイト数）
#define		AJCLZHNAMEBUFSIZE	MAX_PATH		//	名称（パス名，ファイル名等）のバッファサイズ（バイト数）

//----- 処理モード(mode) ---------------------------------------------------------------------------------------//
typedef enum {
	AJCLZHMODE_SEARCH	 =	1		,			//	書庫内ファイル名検索モード
	AJCLZHMODE_READ								//	書庫内ファイル読み出しモード
} AJCLZHMODE;

//----- フラグ情報(flg) ----------------------------------------------------------------------------------------//
//	動作指定フラグ
#define	AJCLZHF_SUBDIR	 	0x01			//	サブディレクトリ検索
#define	AJCLZHF_SRH_DIR		0x02			//	ディレクトリ検索
#define	AJCLZHF_NOSRH_FILE	0x04			//	非ファイル検索

#define	AJCLZHF_DIRONLY	(AJCLZHF_SUBDIR | AJCLZHF_SRH_DIR | AJCLZHF_NOSRH_FILE)

//	ＥＯＦインジケータ
#define	AJCLZHF_EOF		 	0x80			//	書庫ファイルのＥＯＦフラグ

//	マスク値
#define	AJCLZHF_MSK_FIND	(AJCLZHF_SUBDIR | AJCLZHF_SRH_DIR | AJCLZHF_NOSRH_FILE)
#define	AJCLZHF_MSK_OPEN	(AJCLZHF_SUBDIR)


//--------------------------------------------------------------------------------------------------------------//
typedef struct {								//	コードテーブルエントリ
	UW		bl;									//		ビット長
	UW		bptn;								//		ビットパターン
	UW		code;								//		コード
} AJCLZHCTB, *PAJCLZHCTB;
//--------------------------------------------------------------------------------------------------------------//
typedef struct {								//	ビット長テーブル／コードテーブル
	UI			MaxBl;							//		最大ビット長
	UBP			pBlt; UI nBlt;					//		ビット長テーブル（アドレス，エントリ数）
	PAJCLZHCTB	pCtb; UI nCtb;					//		デコードテーブル（アドレス，エントリ数）
} AJCLZHTBL, *PAJCLZHTBL;

//----- ワードユニオン -------------------------------------------------------------------------------------//
typedef	union	{
	struct	{SB  l, h;}	sb;
	struct	{UB  l, h;}	ub;
	SW					sw;
	UW					uw;
} AJCLZHUNIWORD;

//----- ロングワードユニオン -------------------------------------------------------------------------------//
typedef	union	{
	struct	{SB  l, ml, mh, h;}	sb;
	struct	{UB  l, ml, mh, h;}	ub;
	struct	{SW  l, h;}			sw;
	struct	{UW  l, h;}			uw;
	SL							sl;
	UL							ul;
} AJCLZHUNILONG;
//--------------------------------------------------------------------------------------------------------------//
typedef	struct	{

	AJCLZHMODE		mode;						//	処理モード
	UI				flg;						//	動作指定フラグ，書庫ファイルのＥＯＦインジケータ

	//----- ストリーム入力管理情報 -----------------------------------------------------------------------------//
	UI		dl;												//	バッファ中の有効データバイト数					//
	UI		ix;												//	バッファインデクス								//
	UB		RBuf[AJCLZHINPBUFSIZE];							//	ファイル読み出しバッファ						//
	UX		xp;												//	コールバックパラメタ							//
	UI		(CALLBACK *cbRead)(UX xp, VOP pBuf, UI len);	//	入力用コールバック関数							//
	VO		(CALLBACK *cbSeek)(UX xp, UL ofs);				//	バイト位置設定用コールバック関数				//

	//----- ファイル検索用ワーク -------------------------------------------------------------------------------//
	BC		WildDir [MAX_PATH];					//	ワイルドカードのパス名部分
	BC		WildSpec[MAX_PATH];					//	ワイルドカード
	UL		ofs;								//	書庫内の現在のバイト位置
	UL		BlkSize;							//	ヘッダ＋圧縮データのサイズ
	UW 		crc;								//	ＣＲＣ
	UW		crcEx;								//	拡張ヘッダ内のＣＲＣ
	UB		Sig;								//	シグネチャ('0' / '5' / 'd')
	UB		Lvl;								//	ヘッダレベル（０/１/２）
	UB		os;									//	ＯＳ識別
	UB		CheckSum;							//	チェックサム
	UB		FileAttr;							//	ファイル属性
	UB		filler1[3];							//	－
	UI		HeadSize;							//	ヘッダサイズ

	BC		PathName[MAX_PATH];					//	パス名
	UB		fLocalTime;							//	FALSE=UTC, TRUE=Local Time
	UB		filler2[3];							//	－
	UL		HuffSize;							//	圧縮データサイズ
	UL		FileSize;							//	ファイルサイズ
	UL		FileCnt;							//	デコード済みバイト数
	UL		FileTime;							//	ファイルタイム
	BC		DirName [MAX_PATH];					//	ディレクトリ名
	BC		FileName[MAX_PATH];					//	ファイル名＋拡張子

	//----- デコード用ワーク -----------------------------------------------------------------------------------//
	UW		BlkCodes;							//	当該圧縮ｺｰﾄﾞﾌﾞﾛｯｸのコード数(デコードするコード数、
												//	但し、一致文字列長を表す一連の2～3コードは１ヶとして数える）
	AJCLZHUNILONG	u;							//	ビットストリーム３２ビットバッファ
	UI			rem;							//	残り有効ビット数
	AJCLZHTBL	BLen;							//	ビット長テーブル
	AJCLZHTBL	Deco;							//	デコードテーブル
	AJCLZHTBL	Dist;							//	ディスタンステーブル
	UBP			pDicTop;						//	スライド辞書の先頭アドレス
	UBP			pDic;							//	スライド辞書ポインタ
	UI			xDic;							//	pDicが示す位置のスライド辞書内オフセット値
	UI			MatchLen;						//	一致バイト数
	UBP			pMatch;							//	一致文字列へのポインタ
	UI			xMatch;							//	pMatchが示す位置のスライド辞書内オフセット値
} AJCLZH, *HAJCLZH;

//--------------------------------------------------------------------------------------------------------------//
//	検索結果情報																								//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	UL		HuffSize;							//	圧縮データサイズ
	UL		FileSize;							//	ファイルサイズ
	UL		FileTime;							//	ファイルタイム（1970-01-01, 00:00:00からの通算秒数）
	BOOL	fLocalTime;							//	TRUE:ローカルタイム．FALSE:ＵＴＣ
	UW		crc;								//	ＣＲＣ
	UW		dmy;								//	ダミー
	BC		szPathName[MAX_PATH];				//	ファイルパス名へのポインタ（ex. "temp\sample.txt" ）
	BC		szDirName [MAX_PATH];				//	ディレクトリ名へのポインタ（ex. "temp\"           ）
	BC		szFileName[MAX_PATH];				//	ファイル名へのポインタ	  （ex. "sample.txt"	  ）
	BOOL	fDir;								//	ディレクトリであることを示すフラグ
} AJCLZHFILEINFOA, *PAJCLZHFILEINFOA;

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	UL		HuffSize;							//	圧縮データサイズ
	UL		FileSize;							//	ファイルサイズ
	UL		FileTime;							//	ファイルタイム（1970-01-01, 00:00:00からの通算秒数）
	BOOL	fLocalTime;							//	TRUE:ローカルタイム．FALSE:ＵＴＣ
	UW		crc;								//	ＣＲＣ
	UW		dmy;								//	ダミー
	WC		szPathName[MAX_PATH];				//	ファイルパス名へのポインタ（ex. "temp\sample.txt" ）
	WC		szDirName [MAX_PATH];				//	ディレクトリ名へのポインタ（ex. "temp\"           ）
	WC		szFileName[MAX_PATH];				//	ファイル名へのポインタ	  （ex. "sample"		  ）
	WC		szExtName [MAX_PATH];				//	拡張子名へのポインタ	  （ex. "txt"			  ）
	BOOL	fDir;								//	ディレクトリであることを示すフラグ
} AJCLZHFILEINFOW, *PAJCLZHFILEINFOW;


//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	AJCLZHFILEINFO		AJCLZHFILEINFOW
	#define	PAJCLZHFILEINFO		PAJCLZHFILEINFOW
	#define	AjcLzhFindFirst		AjcLzhFindFirstW
	#define	AjcLzhOpen			AjcLzhOpenW
	#define	AjcLzhGetFileInfo	AjcLzhGetFileInfoW
#else
	#define	AJCLZHFILEINFO		AJCLZHFILEINFOA
	#define	PAJCLZHFILEINFO		PAJCLZHFILEINFOA
	#define	AjcLzhFindFirst		AjcLzhFindFirstA
	#define	AjcLzhOpen			AjcLzhOpenA
	#define	AjcLzhGetFileInfo	AjcLzhGetFileInfoA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCLZH		WINAPI	AjcLzhFindFirstA(C_BCP pWild, UI flag, UX xp,
												UI (CALLBACK *cbRead)(UX xp, VOP pBuf, UI len),
												VO (CALLBACK *cbSeek)(UX xp, UL ofs));

AJCEXPORT	HAJCLZH		WINAPI	AjcLzhFindFirstW(C_WCP pWild, UI flag, UX xp,
												UI (CALLBACK *cbRead)(UX xp, VOP pBuf, UI len),
												VO (CALLBACK *cbSeek)(UX xp, UL ofs));

AJCEXPORT	BOOL		WINAPI	AjcLzhFindNext (HAJCLZH hLzh);

AJCEXPORT	HAJCLZH		WINAPI	AjcLzhOpenA(C_BCP pFilePath, UI flag, UX xp,
											 UI (CALLBACK *cbRead)(UX xp, VOP pBuf, UI len),
											 VO (CALLBACK *cbSeek)(UX xp, UL ofs));

AJCEXPORT	HAJCLZH		WINAPI	AjcLzhOpenW(C_WCP pFilePath, UI flag, UX xp,
											 UI (CALLBACK *cbRead)(UX xp, VOP pBuf, UI len),
											 VO (CALLBACK *cbSeek)(UX xp, UL ofs));

AJCEXPORT	UI			WINAPI	AjcLzhRead		(HAJCLZH hLzh, VOP pBuf, UI len);

AJCEXPORT	VO			WINAPI	AjcLzhClose	(HAJCLZH hLzh);

AJCEXPORT	BOOL		WINAPI	AjcLzhGetFileInfoA(HAJCLZH hLzh, PAJCLZHFILEINFOA);
AJCEXPORT	BOOL		WINAPI	AjcLzhGetFileInfoW(HAJCLZH hLzh, PAJCLZHFILEINFOW);

AJCEXPORT	AJCLZHERR	WINAPI	AjcLzhGetLastError(VO);

//**************************************************************************************************************//
#endif
