﻿#ifndef	AJCMALLOC_H_
#define	AJCMALLOC_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcMAlloc		AjcMAllocW
	#define		AjcSetMemError	AjcSetMemErrorW
	#define		AJCMEM			AJCMEMW
#else
	#define		AjcMAlloc		AjcMAllocA
	#define		AjcSetMemError	AjcSetMemErrorA
	#define		AJCMEM			AJCMEMA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	マクロ																										//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCUC(S)		L##S
#define		AJCWIDE(S)		AJCUC(S)
#define		AJCMEMA(S)		AjcMAllocA(((size_t)(S)),		  __FILE__,  __LINE__)
#define		AJCMEMW(S)		AjcMAllocW(((size_t)(S)), AJCWIDE(__FILE__), __LINE__)

#define		AJCFREE(P)		AjcMFree(P)

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	VOP		WINAPI	AjcMAllocA(size_t size, C_BCP pFName, UI lno);
AJCEXPORT	VOP		WINAPI	AjcMAllocW(size_t size, C_WCP pFName, UI lno);

AJCEXPORT	VO		WINAPI	AjcMFree(VOP pMem);

AJCEXPORT	VO		WINAPI	AjcSetMemErrorA(UX cbp, VO (CALLBACK *cbNtcMemError)(C_BCP pFName, UI lno, C_BCP pVer, UX cbp));
AJCEXPORT	VO		WINAPI	AjcSetMemErrorW(UX cbp, VO (CALLBACK *cbNtcMemError)(C_WCP pFName, UI lno, C_WCP pVer, UX cbp));

/****************************************************************************************************************/
#endif
