﻿#ifndef	AJCRINGBUF_H_
#define	AJCRINGBUF_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	キューデータ形式																							//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct  _AJCRNGQUE {
	struct _AJCRNGQUE	*pNxt;			//	次のキューへのポインタ
	UI		six;						//	リングバッファ先頭インデクス
	UI		eix;						//	　〃　　　　　末尾インデクス
	UB		dat[4];						//	リングバッファデータ
} AJCRNGQUE, *PAJCRNGQUE;

#define	AJCRNGQUE_HEADER_SIZE	(sizeof(AJCRNGQUE) - 4)			//	キューのヘッダ部分のバイト数
#define	AJCRNG_STDSIZE			(4096 - AJCRNGQUE_HEADER_SIZE)	//	最適なデータサイズ

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct {
	UI					InstID;			//	インスタンス識別ＩＤ
	UL					DataSize;		//	リングバッファに格納されているデータの総バイト数
	UBP					pStaticBuf;		//	スタティックなリングバッファのアドレス（無い場合はNULL)	
	UI					lStaticBuf;		//	　〃　　　　　　　　　　　　のバイト数
	UI					stSix;			//	　〃　　　　　　　　　　　　の先頭インデクス
	UI					stEix;			//	　〃　　　　　　　　　　　　の末尾インデクス
	PAJCRNGQUE			pQTop;			//	先頭キューデータへのポインタ
	PAJCRNGQUE			pQEnd;			//	末尾キューデータへのポインタ
	PAJCRNGQUE			pQBfr;			//	末尾キューの直前のキューデータへのポインタ
	UI					siz;			//	リングバッファサイズ（拡張チャンクサイズ）

	BOOL				fMultiThread;	//	排他制御フラグ
	CRITICAL_SECTION	cs;				//	クリティカルセクション・オブジェクト

} AJCRNG, *LPAJCRNG, *HAJCRNG;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCRNG	WINAPI	AjcRngCreate     (VOP pStaticBuf, UI lStaticBuf, UI ChunkSize);
AJCEXPORT	BOOL	WINAPI	AjcRngDelete     (HAJCRNG hRng);
AJCEXPORT	BOOL	WINAPI	AjcRngEnableMultiThread(HAJCRNG pW, BOOL fEnable);

AJCEXPORT	UI		WINAPI	AjcRngPutData    (HAJCRNG hRng, C_VOP pDat, UI lDat);
AJCEXPORT	UI		WINAPI	AjcRngPutDataEx  (HAJCRNG hRng, C_VOP pDat, UI lDat);
AJCEXPORT	UI		WINAPI	AjcRngGetData    (HAJCRNG hRng,   VOP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI	AjcRngPeekData   (HAJCRNG hRng,   VOP pBuf, UI lBuf);
AJCEXPORT	UL		WINAPI	AjcRngGetDataSize(HAJCRNG hRng);
AJCEXPORT	BOOL	WINAPI	AjcRngPurge      (HAJCRNG hRng);

/****************************************************************************************************************/
#endif
