﻿#ifndef	AJCSERIALCOMPORT_H_
#define	AJCSERIALCOMPORT_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcScpCreate				AjcScpCreateW
	#define	AjcScpCreatePf				AjcScpCreatePfW
	#define	AjcScpCreateSlot			AjcScpCreateSlotW
	#define	AjcScpCreateEx				AjcScpCreateExW
	#define	AjcScpCreateSlotEx			AjcScpCreateSlotExW
	#define	AjcScpOpenSlot				AjcScpOpenSlotW
	#define	AjcScpOpenSock				AjcScpOpenSockW
	#define	AjcScpSendChar				AjcScpSendCharW
	#define	AjcScpSendText				AjcScpSendTextW
	#define	AjcScpSendTextF				AjcScpSendTextFW
	#define	AjcScpGetPortPathName		AjcScpGetPortPathNameW
	#define	AjcScpGetPortName			AjcScpGetPortNameW
	#define	AjcScpGetPortDevName		AjcScpGetPortDevNameW
	#define	AjcScpGetMySlotPathName		AjcScpGetMySlotPathNameW
	#define	AjcScpGetMyComputerName		AjcScpGetMyComputerNameW
	#define	AjcScpSetMailSlotNames		AjcScpSetMailSlotNamesW
	#define	AjcScpGetMailSlotNames		AjcScpGetMailSlotNamesW
	#define	AjcScpLoadParamFromProfile	AjcScpLoadParamFromProfileW
	#define	AjcScpSaveParamToProfile	AjcScpSaveParamToProfileW
#else
	#define	AjcScpCreate				AjcScpCreateA
	#define	AjcScpCreatePf				AjcScpCreatePfA
	#define	AjcScpCreateSlot			AjcScpCreateSlotA
	#define	AjcScpCreateEx				AjcScpCreateExA
	#define	AjcScpCreateSlotEx			AjcScpCreateSlotExA
	#define	AjcScpOpenSlot				AjcScpOpenSlotA
	#define	AjcScpOpenSock				AjcScpOpenSockA
	#define	AjcScpSendChar				AjcScpSendCharA
	#define	AjcScpSendText				AjcScpSendTextA
	#define	AjcScpSendTextF				AjcScpSendTextFA
	#define	AjcScpGetPortPathName		AjcScpGetPortPathNameA
	#define	AjcScpGetPortName			AjcScpGetPortNameA
	#define	AjcScpGetPortDevName		AjcScpGetPortDevNameA
	#define	AjcScpGetMySlotPathName		AjcScpGetMySlotPathNameA
	#define	AjcScpGetMyComputerName		AjcScpGetMyComputerNameA
	#define	AjcScpSetMailSlotNames		AjcScpSetMailSlotNamesA
	#define	AjcScpGetMailSlotNames		AjcScpGetMailSlotNamesA
	#define	AjcScpLoadParamFromProfile	AjcScpLoadParamFromProfileA
	#define	AjcScpSaveParamToProfile	AjcScpSaveParamToProfileA
#endif


//--------------------------------------------------------------------------------------------------------------//
//	送受信データサイズ																							//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCSCPMAX_TXSIZE_COMPORT	2048
#define		AJCSCPMAX_RXSIZE			2048

#define		AJCSCPMAX_TXSIZE_MAILSLOT	420
#define		AJCSCPMAX_TXSIZE_SOCKET		1024

//--------------------------------------------------------------------------------------------------------------//
//	ポート選択情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCSCP_SEL_COMPORT	= 0,
	AJCSCP_SEL_MAILSLOT	= 1,
	AJCSCP_SEL_SOCKET	= 2,
} AJCSCP_PORTSEL, *PAJCSCP_PORTSEL;

//--------------------------------------------------------------------------------------------------------------//
//	イベントコード																								//
//--------------------------------------------------------------------------------------------------------------//
						//	HIWORD(wParam)		内容
#define	AJCSCP_EV_PORTSTATE	0x8000			//	ポート状態通知
#define	AJCSCP_EV_RXCHUNK	0x4000			//	チャンクデータ受信通知
#define	AJCSCP_EV_RXTEXT	0x2000			//	テキスト受信通知
#define	AJCSCP_EV_RXESC		0x1000			//	ＥＳＣコード受信通知
#define	AJCSCP_EV_RXCTRL	0x0800			//	制御コード受信通知
#define	AJCSCP_EV_RXPKT		0x0400			//	パケットデータ受信通知
#define	AJCSCP_EV_TXEMPTY	0x0200			//	送信完了
#define	AJCSCP_EV_RXNOPKT	0x0100			//	パケット外データ

#define	AJCSCP_EV_ERR		0x0080			//	エラー通知
#define	AJCSCP_EV_RING		0x0020			//	RING変化通知
#define	AJCSCP_EV_RLSD		0x0010			//	RLSD変化通知
#define	AJCSCP_EV_DSR		0x0008			//	DSR変化通知
#define	AJCSCP_EV_CTS		0x0004			//	CTS変化通知

#define	AJCSCP_EV_RXWORD14	0x0002			//	バイトペアによるワード（14Bit）データ受信

#define	AJCSCP_EV_INVCHUNK	0x0001			//	不正チャンクテキスト受信通知


//#define	AJCSCP_EV_RXFLAG	0x0002			//	フラグバイト受信通知
//#define	AJCSCP_EV_RXCHAR	0x0001			//	１バイト受信通知

#define	AJCSCP_EV_SSEP				(AJCSCP_EV_RXTEXT | AJCSCP_EV_RXESC | AJCSCP_EV_RXCTRL | AJCSCP_EV_RXPKT)
#define	AJCSCP_EV_DEFAULT_EVT		(AJCSCP_EV_SSEP | AJCSCP_EV_DSR | AJCSCP_EV_CTS)
#define	AJCSCP_EV_DEFAULT_POST		(AJCSCP_EV_PORTSTATE | AJCSCP_EV_DEFAULT_EVT)


//--------------------------------------------------------------------------------------------------------------//
//	ポート状態(AJCSCP_EV_PORTSTATEのパラメタ)																	//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCSCP_CLOSED		0				//	クローズ状態
#define		AJCSCP_OPENED		1				//	オープン状態
#define		AJCSCP_OPENFAIL		2				//	オープン失敗
#define		AJCSCP_PORTCHG		3				//	通信リソース変化
#define		AJCSCP_MYSLOTFAIL	4				//	自メールスロット生成失敗
#define		AJCSCP_TXFAILURE	5				//	送信失敗

#define		AJCSCP_PORTNO		AJCSCP_PORTCHG	//	ポート番号変化

//--------------------------------------------------------------------------------------------------------------//
//	信号状態																									//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCSCP_FIRST	0x8000			//	初回フラグ
#define		AJCSCP_CTS		MS_CTS_ON		//	ＣＴＳ信号状態
#define		AJCSCP_DSR		MS_DSR_ON		//	ＤＳＲ信号状態
#define		AJCSCP_RING		MS_RING_ON		//	ＲＩＮＧ信号状態
#define		AJCSCP_RLSD		MS_RLSD_ON		//	ＲＬＳＤ信号状態

//--------------------------------------------------------------------------------------------------------------//
//	通信エラーコード																							//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCSCP_CE_RXOVER	CE_RXOVER	//	0x0001
#define		AJCSCP_CE_OVERRUN	CE_OVERRUN	//	0x0002
#define		AJCSCP_CE_RXPARITY	CE_RXPARITY	//	0x0004
#define		AJCSCP_CE_FRAME		CE_FRAME	//	0x0008
#define		AJCSCP_CE_BREAK		CE_BREAK	//	0x0010
#define		AJCSCP_CE_TXFULL	CE_TXFULL	//	0x0100
#define		AJCSCP_CE_PTO		CE_PTO		//	0x0200
#define		AJCSCP_CE_IOE		CE_IOE		//	0x0400
#define		AJCSCP_CE_DNS		CE_DNS		//	0x0800
#define		AJCSCP_CE_OOP		CE_OOP		//	0x1000
#define		AJCSCP_CE_MODE		CE_MODE		//	0x8000

#define		AJCSCP_CE_RXERR		0x10000		//	受信エラー（メールスロット／ソケット）
#define		AJCSCP_CE_TXERR		0x20000		//	送信エラー（メールスロット／ソケット）

//--------------------------------------------------------------------------------------------------------------//
//	TCP/IP アドレス情報ストレージ																				//
//--------------------------------------------------------------------------------------------------------------//
typedef union {
	struct sockaddr_in		sain;
	struct sockaddr_in6		sain6;
	struct sockaddr_storage storage;
} AJCSCPSAIN, *PAJCSCPSAIN;
typedef const AJCSCPSAIN *PCAJCSCPSAIN;

//--------------------------------------------------------------------------------------------------------------//
//	イベントハンドル																							//
//--------------------------------------------------------------------------------------------------------------//
typedef union {
	struct {HANDLE Comm, Recv, TxEnd, Cmd, Exit, TmSlt;} s;
	HANDLE	arr[5];
} AJCSCP_HEVENT;

//--------------------------------------------------------------------------------------------------------------//
//	チャンク・データ・通知モード																				//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCSCP_CM_BIN	=	0x01	,			//	Bit0 : バイナリチャンク
	AJCSCP_CM_TEXT	=	0x02	,			//	Bit1 : テキストチャンク
	AJCSCP_CM_BOTH	=	0x03	,			//	両方
} AJCSCP_CHUNKMODE;

//--------------------------------------------------------------------------------------------------------------//
//	テキスト・コード																							//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCSCP_TXT_SJIS	=	AJCMBC_SJIS	,		//	シフトＪＩＳ(=1)
	AJCSCP_TXT_EUC	=	AJCMBC_EUC	,		//	ＥＵＣ　　　(=2)
	AJCSCP_TXT_UTF8	=	AJCMBC_UTF8	,		//	ＵＴＦ－８　)=3)
	AJCSCP_TXT_AUTO	=	9	,				//	自動判別　　
} AJCSCP_TEXTCODE;

//--------------------------------------------------------------------------------------------------------------//
//	ホスト名，スロット名，ポート名の最大長																		//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCMAX_HOSTNAME_LENGTH		64
#define	AJCMAX_SLOTNAME_LENGTH		64
#define	AJCMAX_PORTNAME_LENGTH		64


//--------------------------------------------------------------------------------------------------------------//
//	スロット名情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	WC		MyHostName [AJCMAX_HOSTNAME_LENGTH];		//	自コンピュータ名
	WC		MySlotName [AJCMAX_SLOTNAME_LENGTH];		//	自メールスロット名
	WC		RmtHostName[AJCMAX_HOSTNAME_LENGTH];		//	相手コンピュータ名
	WC		RmtSlotName[AJCMAX_SLOTNAME_LENGTH];		//	相手メールスロット名
	BOOL	fTxDelay;									//	送信速度制限フラグ
	UI		TxDelayBPS;									//	送信制限速度[Bytes / sec]
} AJCSCP_SLOTINFO, *PAJCSCP_SLOTINFO;

//--------------------------------------------------------------------------------------------------------------//
//	ソケット情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	WC		ServName[AJCMAX_HOSTNAME_LENGTH];			//	サーバ名（相手コンピュータ名）／IPアドレス
	UW		PortNo;										//	ポート番号
	UW		Filler;
} AJCSCP_SOCKINFO, *PAJCSCP_SOCKINFO;

//----- ワードユニオン -------------------------------------------------------------------------------------//
typedef	union	{
	struct	{UB  l, h;}	s;
	UW					w;
} AJCSCPUNIWORD, *PAJCSCPUNIWORD;

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct {
	//----- インスタンスＩＤ ---------------------------------------------------//
	UI					InstID;
	//----- プロファイルセクション ---------------------------------------------//
	WC					ProfileSect[64];
	//----- ＣＯＭ／スロット選択情報 -------------------------------------------//
	AJCSCP_PORTSEL		PortSel;
	//----- ＣＯＭポート情報 ---------------------------------------------------//
	UI					PortNo;				//	ＣＯＭポート番号（１～２５５）
	DCB					CommDcb;			//	ＤＣＢ
	COMMTIMEOUTS		CommTmo;			//	タイムアウト情報

	HANDLE				hPort;				//	ＣＯＭポート／メールスロットハンドル／ソケットハンドル
	BOOL				fTxBusy;			//	送信中フラグ
	UI					GpiState;			//	入力信号(CTS, DSR, RING, RLSD)状態

	//----- メールスロット情報 -------------------------------------------------//
	HANDLE				hSlot;				//	自スロットハンドル
	AJCSCP_SLOTINFO		SlotInfo;			//	メールスロット名称
	WC					MySlotPath[MAX_PATH];

	UI						MaxMsgSize;		//	１つのメッセージの最大サイズ（０：任意）
	UI						ReadTimeout;	//	読み取りタイムアウト時間[ms]
	SECURITY_DESCRIPTOR		secDesc;		//	セキュリティ記述子
	LPSECURITY_ATTRIBUTES	pSecAttr;		//	セキュリテイ属性(secAttr)へのポインタ(未使用時はNULL)

	BOOL				fTxSlotOpened;		//	送信スロットオープン済みフラグ
											//	メールスロットの場合、送信スロット名を未指定でオープンした場合は
											//	実際には送信ポートをオープンしない（hPort=NULLである）が、
											//	オープン操作を行った旨、このフラグをセットする。

	//----- ソケット情報 -------------------------------------------------------//
	BOOL				fConnect;			//	接続状態
	BOOL				fSockRead;			//	ソケット受信可能フラグ
	BOOL				fSockWrite;			//	ソケット送信可能フラグ
	HANDLE				hEvtSock;			//	ソケットイベント
	AJCSCP_SOCKINFO		SockInfo;			//	サーバ名，ポート番号

	//----- テキスト情報 -------------------------------------------------------//
	BOOL				fUnicode;			//	UNICODEフラグ
	AJCSCP_CHUNKMODE	ChunkMode;			//	チャンクデータ通知モード
	AJCSCP_TEXTCODE		RxTxtCode;			//	受信テキストコード
	AJCSCP_TEXTCODE		TxTxtCode;			//	送信テキストコード
	BC					SvSndA, dmy1;		//	テキスト送信時の全角１バイト目退避バッファ
	WC					SvSndW;				//	テキスト送信時のサロゲート１文字目退避バッファ

	//----- ストリーム分離インスタンスハンドル ---------------------------------//
	HAJCSSEP			hSsep;

	//----- イベントマスク -----------------------------------------------------//
	UI					EvtMask;

	//----- スレッドハンドル，スレッドＩＤ -------------------------------------//
	HANDLE				hThreadRx;
	HANDLE				hThreadTx;
	HANDLE				hThreadObs;

	UL					idThreadRx;
	UL					idThreadTx;
	UL					idThreadObs;

	//----- スレッド間通信用メールボックス -------------------------------------//
	HAJCVMBX			hVMbxTxD;			//	送信データ・メールボックスハンドル
	HAJCFMBX			hFMbxNtc;			//	ユーザＡＰへのイベント通知用メールボックスハンドル

	//----- ユーザＡＰへのイベント通知情報 -------------------------------------//
	HWND				hWndNtc;			//	ユーザＡＰへのイベント通知用ウインドハンドル
	UI					MsgNtc;				//	ユーザＡＰへのイベント通知用ウインドメッセージ

	//----- ＣＯＭポートアクセス排他制御用クリティカルセクション ---------------//
	CRITICAL_SECTION	CsCommApi;			//	システムＡＰＩ排他制御
	CRITICAL_SECTION 	CsTxDelay;			//	送信速度制限（TxDelayBytesCount，TxDelayTickCount）排他制御

	//----- スレッド制御情報 ---------------------------------------------------//
	BOOL				fThreadEnd;			//	スレッド終了指示フラグ
	BOOL				fThrSendEnd;		//	送信スレッド終了フラグ
	BOOL				fThrRecvEnd;		//	受信スレッド終了フラグ
	BOOL				fThrSObsEnd;		//	信号監視スレッド終了フラグ

	//----- ポート設定ダイアログ情報 ------------------------------------------//
	UI					mskRbt;				//	ＣＯＭポート／メールスロット選択ラジオボタンのマスク(0:許可，1:禁止）
	UI					mskGray;			//	ダイアログ項目のマスク

	//----- ポート名称作成ワーク ----------------------------------------------//
	union {
		BC		BStr[AJCMAX_HOSTNAME_LENGTH + 128];
		WC		WStr[AJCMAX_HOSTNAME_LENGTH + 128];
	} PortName;

	//----- 受信バッファ ------------------------------------------------------//
	UI				ixRxb;							//	受信バッファ空部分のインデクス（＝前部の半端マルチバイト数）
	UB				RxBuf[AJCSCPMAX_RXSIZE + 8];	//	受信テキストデータバッファ（データ＋中途マルチバイト(1～5)）＋終端(0x00)）
	UB				RxBin[AJCSCPMAX_RXSIZE];		//	受信バイナリデータバッファ

	//----- パケット外テキスト受信バッファ ------------------------------------//
	UI				ixNpk;							//	パケット外バッファ空部分のインデクス（＝前部の半端マルチバイト数）
	BC				NpBuf[AJCSCPMAX_RXSIZE + 8];	//	パケット外バッファ（データ＋中途マルチバイト(1～5)）＋終端(0x00)）

	//----- 送受信停止認識時間 ------------------------------------------------//
	ULL		MesTxTime;								//	送信停止認識時間[ms]
	ULL		MesRxTime;								//	受信停止認識時間[ms]

	//----- 送信遅延情報（メールスロット時の送信速度調整） --------------------//
	BOOL	fTxDelay;								//	送信速度制限フラグ
	UI		TxDelayBPS;								//	送信制限速度[Bytes / sec]
	ULL		TxDelayBytesCount;						//	送信遅延用バイトカウンタ
	ULL		TxDelayTickCount;						//	送信遅延用・経過時間[us]

	HAJCMESTIME	hMesTxDelay;						//	時間計測オブジェクトハンドル

	//----- バイトペア受信制御情報 --------------------------------------------//
	BOOL	fBpLBFirst;								//	0: High Byte First1 : Low Byte First
	BOOL	BpSeq;									//	受信バイトカウンタ（０～１）
	AJCSCPUNIWORD	BpDat;							//	受信データ(14Bit)バッファ

	//----- MSILサポート用 ----------------------------------------------------//
	HWND	hWndForMsil;							//	MSIL用ダミーウインドハンドル

} AJCSCP, *HAJCSCP;


//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreateA(VO);
AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreateW(VO);

AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreatePfA(C_BCP pSect);
AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreatePfW(C_WCP pSect);

AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreateSlotA(C_BCP pSect, BOOL fCreateMySlot, C_BCP pMySlot, C_BCP pRmtHost, C_BCP pRmtSlot);
AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreateSlotW(C_WCP pSect, BOOL fCreateMySlot, C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot);

AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreateExA  (C_BCP pSect, BOOL fCreateMySlot, C_BCP pMySlot, C_BCP pRmtHost, C_BCP pRmtSlot);	//	非推奨（AjcScpCreateSlotAと同じ）
AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreateExW  (C_WCP pSect, BOOL fCreateMySlot, C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot);	//	非推奨（AjcScpCreateSlotWと同じ）

AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreateSlotExA(C_BCP pSect, BOOL fCreateMySlot, C_BCP pMySlot, C_BCP pRmtHost, C_BCP pRmtSlot, UI nMaxMessageSize, UI lReadTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
AJCEXPORT	HAJCSCP			 WINAPI	AjcScpCreateSlotExW(C_WCP pSect, BOOL fCreateMySlot, C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot, UI nMaxMessageSize, UI lReadTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes);

AJCEXPORT	BOOL			 WINAPI		AjcScpDelete				(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetMode				(HAJCSCP hScp, HWND hWndNtc, UI WndMsgNtc, AJCSCP_CHUNKMODE ChunkMode);
AJCEXPORT	BOOL			 WINAPI		AjcScpOpen					(HAJCSCP hScp, UI Port, UI Rate, UI DataBits, UI Parity, UI StopBit);
AJCEXPORT	BOOL			 WINAPI		AjcScpOpenEx				(HAJCSCP hScp, UI Port, LPDCB pDcb, LPCOMMTIMEOUTS pTmo);

AJCEXPORT	BOOL			 WINAPI		AjcScpOpenSlotA				(HAJCSCP hScp, C_BCP pRmtHost, C_BCP pRmtSlot);
AJCEXPORT	BOOL			 WINAPI		AjcScpOpenSlotW				(HAJCSCP hScp, C_WCP pRmtHost, C_WCP pRmtSlot);

AJCEXPORT	BOOL			 WINAPI		AjcScpOpenSockA				(HAJCSCP hScp, C_BCP pServ, UI PortNo);
AJCEXPORT	BOOL			 WINAPI		AjcScpOpenSockW				(HAJCSCP hScp, C_WCP pServ, UI PortNo);

AJCEXPORT	BOOL			 WINAPI		AjcScpOpenDefault			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpOpenSelect			(HAJCSCP hScp, AJCSCP_PORTSEL sel);
AJCEXPORT	BOOL			 WINAPI		AjcScpClose					(HAJCSCP hScp);
AJCEXPORT	UI				 WINAPI		AjcScpGetSelectedPort		(HAJCSCP hScp);
AJCEXPORT	UI				 WINAPI		AjcScpIsOpened				(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpIsTxOpened			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpIsRxOpened			(HAJCSCP hScp);

AJCEXPORT	BOOL			 WINAPI		AjcScpSendCharA				(HAJCSCP hScp, BC code);
AJCEXPORT	BOOL			 WINAPI		AjcScpSendCharW				(HAJCSCP hScp, WC code);

AJCEXPORT	BOOL			 WINAPI		AjcScpSendWord14LF			(HAJCSCP hScp, UI data);
AJCEXPORT	BOOL			 WINAPI		AjcScpSendWord14HF			(HAJCSCP hScp, UI data);

AJCEXPORT	BOOL			 WINAPI		AjcScpSetByteSeqRxWord14	(HAJCSCP hScp, BOOL fLowByteFirst);
AJCEXPORT	BOOL			 WINAPI		AjcScpGetByteSeqRxWord14	(HAJCSCP hScp);

AJCEXPORT	BOOL			 WINAPI		AjcScpSendTextA				(HAJCSCP hScp, C_BCP pTxt, UI lTxt);
AJCEXPORT	BOOL			 WINAPI		AjcScpSendTextW				(HAJCSCP hScp, C_WCP pTxt, UI lTxt);

AJCEXPORT	BOOL			 WINAPI		AjcScpSendTextFA			(HAJCSCP hScp, C_BCP pFmt, ...);
AJCEXPORT	BOOL			 WINAPI		AjcScpSendTextFW			(HAJCSCP hScp, C_WCP pFmt, ...);

AJCEXPORT	BOOL			 WINAPI		AjcScpSendBinData			(HAJCSCP hScp, C_VOP pDat, UI lDat);
AJCEXPORT	UI				 WINAPI		AjcScpSendPacket			(HAJCSCP hScp, C_VOP pPkt, UI lPkt);
AJCEXPORT	BOOL			 WINAPI		AjcScpSendBreak				(HAJCSCP hScp, BOOL fBreak);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetEvtMask			(HAJCSCP hScp, UI Mask);
AJCEXPORT	UI				 WINAPI		AjcScpGetEvtMask			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetDTR				(HAJCSCP hScp, BOOL fActive);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetRTS				(HAJCSCP hScp, BOOL fActive);
AJCEXPORT	UI				 WINAPI		AjcScpGetSigState			(HAJCSCP hScp);
AJCEXPORT	ULL				 WINAPI		AjcScpGetTxBytes			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpPurgeRecvData			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpPurgeSendData			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpPurgeAllData			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetParam				(HAJCSCP hScp, const DCB *pDcb, const COMMTIMEOUTS *pTmo);
AJCEXPORT	UI				 WINAPI		AjcScpGetParam				(HAJCSCP hScp, LPDCB pDcb, LPCOMMTIMEOUTS pTmo);
AJCEXPORT	BOOL			 WINAPI		AjcScpWaitEvent				(HAJCSCP hScp, WPARAM *pwParam, LPARAM *plParam, UI msTime);
AJCEXPORT	BOOL			 WINAPI		AjcScpGetEventData			(HAJCSCP hScp, LPARAM lParam, VOP *ppDat, UIP plDat, UIP pParam);
AJCEXPORT	BOOL			 WINAPI		AjcScpRelEventData			(HAJCSCP hScp, LPARAM lParam);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetPktCtrlCode		(HAJCSCP hScp, UI stx, UI etx, UI dle);
AJCEXPORT	BOOL			 WINAPI		AjcScpGetPktCtrlCode		(HAJCSCP hScp, UIP pStx, UIP pEtx, UIP pDle);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetPktTimeout			(HAJCSCP hScp, UI msTime);
AJCEXPORT	BOOL			 WINAPI		AjcScpGetPktTimeout			(HAJCSCP hScp, UIP pMsTime);
AJCEXPORT	BOOL			 WINAPI		AjcScpEnableComPortSelection(HAJCSCP hScp, BOOL fEnableComPort);
AJCEXPORT	BOOL			 WINAPI		AjcScpEnableMailslotSelection(HAJCSCP hScp, BOOL fEnableMailSlot);
AJCEXPORT	BOOL			 WINAPI		AjcScpEnableSocketSelection	(HAJCSCP hScp, BOOL fEnableSocket);
AJCEXPORT	BOOL			 WINAPI		AjcScpEnablePortSelection	(HAJCSCP hScp, BOOL fEnableComPort, BOOL fEnableMailSlot);
AJCEXPORT	BOOL			 WINAPI		AjcScpEnablePortSelectionEx	(HAJCSCP hScp, BOOL fEnableComPort, BOOL fEnableMailSlot, BOOL fEnableSocket);
AJCEXPORT	UI				 WINAPI		AjcScpDlgParamEasy			(HAJCSCP hScp, HWND hWndOwner);
AJCEXPORT	UI				 WINAPI		AjcScpDlgParamEasyEx		(HAJCSCP hScp, HWND hWndOwner, int x, int y);
AJCEXPORT	UI				 WINAPI		AjcScpDlgParamDetail		(HAJCSCP hScp, HWND hWndOwner);
AJCEXPORT	UI				 WINAPI		AjcScpDlgParamDetailEx		(HAJCSCP hScp, HWND hWndOwner, int x, int y);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetDialogGrayMask		(HAJCSCP hScp, UI mskGray);
AJCEXPORT	VO				 WINAPI		AjcScpGetDefaultParam		(LPDCB pDcb, LPCOMMTIMEOUTS pTmo);
AJCEXPORT	HAJCSSEP		 WINAPI		AjcScpGetSsepHandle			(HAJCSCP hScp);
AJCEXPORT	UI				 WINAPI		AjcScpEnumSerialPorts		(UBP pMap, UI lMap, UI CurrentPort);

AJCEXPORT	BCP				 WINAPI		AjcScpGetPortPathNameA		(HAJCSCP hScp);
AJCEXPORT	WCP				 WINAPI		AjcScpGetPortPathNameW		(HAJCSCP hScp);

AJCEXPORT	BCP				 WINAPI		AjcScpGetPortNameA			(HAJCSCP hScp);
AJCEXPORT	WCP				 WINAPI		AjcScpGetPortNameW			(HAJCSCP hScp);

AJCEXPORT	int				 WINAPI		AjcScpGetPortDevNameA		(C_BCP pPortName, BCP pBuf, UI lBuf);
AJCEXPORT	int				 WINAPI		AjcScpGetPortDevNameW		(C_WCP pPortName, WCP pBuf, UI lBuf);


AJCEXPORT	BOOL			 WINAPI		AjcScpSetChunkMode			(HAJCSCP hScp, AJCSCP_CHUNKMODE ChunkMode);
AJCEXPORT	AJCSCP_CHUNKMODE WINAPI		AjcScpGetChunkMode			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetRxTextCode			(HAJCSCP hScp, AJCSCP_TEXTCODE code);
AJCEXPORT	AJCSCP_TEXTCODE	 WINAPI		AjcScpGetRxTextCode			(HAJCSCP hScp);
AJCEXPORT	AJCSCP_TEXTCODE	 WINAPI		AjcScpGetActualRxTextCode	(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetTxTextCode			(HAJCSCP hScp, AJCSCP_TEXTCODE code);
AJCEXPORT	AJCSCP_TEXTCODE	 WINAPI		AjcScpGetTxTextCode			(HAJCSCP hScp);
AJCEXPORT	AJCSCP_TEXTCODE	 WINAPI		AjcScpGetActualTxTextCode	(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpCreateMySlot			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpCreateMySlotEx		(HAJCSCP hScp, UI nMaxMessageSize, UI lReadTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
AJCEXPORT	BOOL			 WINAPI		AjcScpDeleteMySlot			(HAJCSCP hScp);
AJCEXPORT	BOOL			 WINAPI		AjcScpMySlotIsCreated		(HAJCSCP hScp);

AJCEXPORT	BCP				 WINAPI		AjcScpGetMySlotPathNameA	(HAJCSCP hScp);
AJCEXPORT	WCP				 WINAPI		AjcScpGetMySlotPathNameW	(HAJCSCP hScp);

AJCEXPORT	BOOL			 WINAPI		AjcScpGetMyComputerNameA	(HAJCSCP hScp, BC pBuf[AJCMAX_HOSTNAME_LENGTH]);
AJCEXPORT	BOOL			 WINAPI		AjcScpGetMyComputerNameW	(HAJCSCP hScp, WC pBuf[AJCMAX_HOSTNAME_LENGTH]);

AJCEXPORT	BOOL			 WINAPI		AjcScpSetMailSlotNamesA		(HAJCSCP hScp, C_BCP pMySlot, C_BCP pRmyHost, C_BCP pRmtSlot);
AJCEXPORT	BOOL			 WINAPI		AjcScpSetMailSlotNamesW		(HAJCSCP hScp, C_WCP pMySlot, C_WCP pRmyHost, C_WCP pRmtSlot);

AJCEXPORT	BOOL			 WINAPI		AjcScpGetMailSlotNamesA		(HAJCSCP hScp, BC pMySlot[64], BC pRmyHost[AJCMAX_HOSTNAME_LENGTH], BC pRmtSlot[64]);
AJCEXPORT	BOOL			 WINAPI		AjcScpGetMailSlotNamesW		(HAJCSCP hScp, WC pMySlot[64], WC pRmyHost[AJCMAX_HOSTNAME_LENGTH], WC pRmtSlot[64]);

AJCEXPORT	BOOL			 WINAPI		AjcScpSetTxSpeedLimit		(HAJCSCP hScp, BOOL flag, UI bps);
AJCEXPORT	BOOL			 WINAPI		AjcScpGetTxSpeedLimit		(HAJCSCP hScp, UIP pBps);

AJCEXPORT	ULL				 WINAPI		AjcScpSetRecognizeTxStopTime(HAJCSCP hScp, UI msTime);
AJCEXPORT	ULL				 WINAPI		AjcScpSetRecognizeRxStopTime(HAJCSCP hScp, UI msTime);


//	非公開ＡＰＩ
AJCEXPORT	BOOL			 WINAPI		AjcScpLoadParamFromProfileA	(HAJCSCP hScp, C_BCP pSect);
AJCEXPORT	BOOL			 WINAPI		AjcScpLoadParamFromProfileW	(HAJCSCP hScp, C_WCP pSect);

AJCEXPORT	BOOL			 WINAPI		AjcScpSaveParamToProfileA	(HAJCSCP hScp, C_BCP pSect);
AJCEXPORT	BOOL			 WINAPI		AjcScpSaveParamToProfileW	(HAJCSCP hScp, C_WCP pSect);

//==============================================================================================================//
//	ダイアログボックスのグレー化項目（ScpDlgSetParam...の mskGray 引数）										//
//==============================================================================================================//
//	mskRbt
#define		AJCSCPRBT_ComPort						0x00000040
#define		AJCSCPRBT_MailSlot						0x00000020
#define		AJCSCPRBT_Socket						0x00000010

//	mskGray
#define		AJCSCPGRY_Port							0x80000000
#define		AJCSCPGRY_BaudRate						0x40000000
#define		AJCSCPGRY_ByteSize						0x20000000
#define		AJCSCPGRY_StopBits						0x10000000

#define		AJCSCPGRY_fParity						0x08000000
#define		AJCSCPGRY_Parity						0x04000000
#define		AJCSCPGRY_Paritys						(AJCSCPGRY_fParity |		\
													 AJCSCPGRY_Parity)

#define		AJCSCPGRY_fOutX							0x02000000
#define		AJCSCPGRY_fOutxCtsFlow					0x01000000
#define		AJCSCPGRY_fOutxDsrFlow					0x00800000
#define		AJCSCPGRY_TxFlowControl					(AJCSCPGRY_fOutX		|	\
													 AJCSCPGRY_fOutxCtsFlow |	\
													 AJCSCPGRY_fOutxDsrFlow)

#define		AJCSCPGRY_fInX							0x00400000
#define		AJCSCPGRY_XoffLim						0x00200000
#define		AJCSCPGRY_XonLim						0x00100000
#define		AJCSCPGRY_fTXContinueOnXoff				0x00080000
#define		AJCSCPGRY_RxFlowControl					(AJCSCPGRY_fInX		|			\
													 AJCSCPGRY_XoffLim	|			\
													 AJCSCPGRY_XonLim	|			\
													 AJCSCPGRY_fTXContinueOnXoff)

#define		AJCSCPGRY_DtrControl					0x00040000
#define		AJCSCPGRY_RtsControl					0x00020000

#define		AJCSCPGRY_fBinary						0x00010000
#define		AJCSCPGRY_fDsrSensitivity				0x00008000
#define		AJCSCPGRY_fErrorChar					0x00004000
#define		AJCSCPGRY_fNull							0x00002000
#define		AJCSCPGRY_fAbortOnError					0x00001000
#define		AJCSCPGRY_Flags							(AJCSCPGRY_fBinary		   |	\
													 AJCSCPGRY_fDsrSensitivity |	\
													 AJCSCPGRY_fErrorChar	   |	\
													 AJCSCPGRY_fNull		   |	\
													 AJCSCPGRY_fAbortOnError)

#define		AJCSCPGRY_XonChar						0x00000800
#define		AJCSCPGRY_XoffChar						0x00000400
#define		AJCSCPGRY_ErrorChar						0x00000200
#define		AJCSCPGRY_EofChar						0x00000100
#define		AJCSCPGRY_EvtChar						0x00000080
#define		AJCSCPGRY_Characters					(AJCSCPGRY_XonChar	 |	\
													 AJCSCPGRY_XoffChar	 |	\
													 AJCSCPGRY_ErrorChar |	\
													 AJCSCPGRY_EofChar	 |	\
													 AJCSCPGRY_EvtChar)

#define		AJCSCPGRY_ReadIntervalTimeout			0x00000040
#define		AJCSCPGRY_ReadTotalTimeoutMultiplier	0x00000020
#define		AJCSCPGRY_ReadTotalTimeoutConstant		0x00000010
#define		AJCSCPGRY_WriteTotalTimeoutMultiplier	0x00000008
#define		AJCSCPGRY_WriteTotalTimeoutConstant		0x00000004
#define		AJCSCPGRY_Timeouts						(AJCSCPGRY_ReadIntervalTimeout		   |	\
													 AJCSCPGRY_ReadTotalTimeoutMultiplier  |	\
													 AJCSCPGRY_ReadTotalTimeoutConstant	   |	\
													 AJCSCPGRY_WriteTotalTimeoutMultiplier |	\
													 AJCSCPGRY_WriteTotalTimeoutConstant)

#define		AJCSCPGRY_SetDetail						0x00000002


//==============================================================================================================//
//	ダイアログボックスにより変更された項目(ScpDlgSetParamEasy/Detailの戻り値）									//
//==============================================================================================================//
#define	AJCSCPDGR_PORTCHANGED	0x00000040		//	ポート変更
#define	AJCSCPDGR_DCBCHANGED	0x00000020		//	ＤＣＢ変更
#define	AJCSCPDGR_TMOCHANGED	0x00000010		//	タイマ変更
#define	AJCSCPDGR_SELCHANGED	0x00000008		//	ＣＯＭポート／メールスロットの選択変更
#define	AJCSCPDGR_SLOTCHANGED	0x00000004		//	メールスロット情報変更
#define	AJCSCPDGR_SOCKCHANGED	0x00000002		//	ソケット情報変更
#define	AJCSCPDGR_OKBUTTON		0x00000001		//	ＯＫボタンによる終了
#define	AJCSCPDGR_CHANED	(AJCSCPDGR_PORTCHANGED | AJCSCPDGR_DCBCHANGED | AJCSCPDGR_TMOCHANGED | AJCSCPDGR_SELCHANGED | AJCSCPDGR_SLOTCHANGED)


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- コントロールウインド生成 -------------------------------------------------------------------------------//
AJCEXPORT HAJCSCP WINAPI AjcScpCreateForMSIL(	VO (CALLBACK *cbPortState )(int state, C_WCP pPortName),
												VO (CALLBACK *cbRxChunkTxt)(C_WCP text),
												VO (CALLBACK *cbRxChunkBin)(C_VOP pData, int lData),
												VO (CALLBACK *cbRxText	  )(C_WCP text),
												VO (CALLBACK *cbRxEsc	  )(C_WCP esc),
												VO (CALLBACK *cbRxCtrl	  )(int   ctrl),
												VO (CALLBACK *cbRxPacket  )(C_VOP pData, int lData),
												VO (CALLBACK *cbTxEmpty   )(VO),
												VO (CALLBACK *cbRxNoPkt   )(C_WCP text),
												VO (CALLBACK *cbRxWord14  )(int   data),
												VO (CALLBACK *cbRxInvChunk)(C_VOP pData, int lData),
												VO (CALLBACK *cbError	  )(int err),
												VO (CALLBACK *cbNtcRING   )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring),
												VO (CALLBACK *cbNtcRLSD   )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring),
												VO (CALLBACK *cbNtcDSR	  )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring),
												VO (CALLBACK *cbNtcCTS	  )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring));
//----- 自スロット生成（エラー未検知で暗黙的に生成）------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpCreateMySlotForMSIL(HAJCSCP hScp);
//----- モード設定 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpSetModeForMSIL(HAJCSCP hScp, BOOL fEventMode);
//----- ポート名取得 -------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpGetPortNameForMSIL(HAJCSCP hScp, WCP pBuf, int lBuf);
//----- ポートパス名取得 ---------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpGetPortPathNameForMSIL(HAJCSCP hScp, WCP pBuf, int lBuf);
//----- 自スロットパス名取得 -----------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpGetMySlotPathNameForMSIL(HAJCSCP hScp, WCP pBuf, int lBuf);
//----- 終了処理 -----------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpDeleteForMSIL(HAJCSCP hScp);
//----- プロファイルセクション名設定／取得 ---------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpSetProfileSectForMSIL(HAJCSCP hScp, C_WCP pProfileSect);
AJCEXPORT VO WINAPI AjcScpGetProfileSectForMSIL(HAJCSCP hScp,	WCP pProfileSect, int lProfileSect);
//----- 自スロット名設定／取得 ---------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpSetMySlotForMSIL(HAJCSCP hScp, C_WCP pMySlot);
AJCEXPORT VO WINAPI AjcScpGetMySlotForMSIL(HAJCSCP hScp,   WCP pMySlot, int lMySlot);
//----- リモートホスト名設定／取得 -----------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpSetRmtHostForMSIL(HAJCSCP hScp, C_WCP pRmtHost);
AJCEXPORT VO WINAPI AjcScpGetRmtHostForMSIL(HAJCSCP hScp,	WCP pRmtHost, int lRmtHost);
//----- リモートスロット名設定／取得 ---------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcScpSetRmtSlotForMSIL(HAJCSCP hScp, C_WCP pRmtSlot);
AJCEXPORT VO WINAPI AjcScpGetRmtSlotForMSIL(HAJCSCP hScp,	WCP pRmtSlot, int lRmtSlot);


/****************************************************************************************************************/
#endif
