﻿#ifndef	AJCSOCKCLIENT_H_
#define	AJCSOCKCLIENT_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcSctConnect			AjcSctConnectW
	#define	AjcSctSendChar			AjcSctSendCharW
	#define	AjcSctSendText			AjcSctSendTextW
	#define	AjcSctSendTextF			AjcSctSendTextFW
	#define	AjcSctGetIpAddrStr		AjcSctGetIpAddrStrW

	#define	AJCSCTADIF				AJCSCTADIFW
	#define	PAJCSCTADIF				PAJCSCTADIFW
	#define	PCAJCSCTADIF			PCAJCSCTADIFW
#else
	#define	AjcSctConnect			AjcSctConnectA
	#define	AjcSctSendChar			AjcSctSendCharA
	#define	AjcSctSendText			AjcSctSendTextA
	#define	AjcSctSendTextF			AjcSctSendTextFA
	#define	AjcSctGetIpAddrStr		AjcSctGetIpAddrStrA

	#define	AJCSCTADIF				AJCSCTADIFA
	#define	PAJCSCTADIF				PAJCSCTADIFA
	#define	PCAJCSCTADIF			PCAJCSCTADIFA
#endif


//	イベントコード
#define	AJCSCT_EV_RXTEXT		AJCSSEP_EV_TXT				//	テキストデータ通知		0x01
#define	AJCSCT_EV_RXESC			AJCSSEP_EV_ESC				//	ＥＳＣコードデータ通知	0x02
#define	AJCSCT_EV_RXPKT			AJCSSEP_EV_PKT				//	パケットデータ通知		0x04
#define	AJCSCT_EV_RXCTRL		AJCSSEP_EV_CTRL				//	制御コード通知			0x08
#define	AJCSCT_EV_RXNOPKT		AJCSSEP_EV_NOPKT			//	パケット外テキスト		0x10

#define	AJCSCT_EV_RXCHUNK		0x00000100					//	チャンクデータ受信通知
#define	AJCSCT_EV_INVCHUNK		0x00000200					//	不正チャンクテキスト受信通知
#define	AJCSCT_EV_TXEMPTY		0x00000400					//	送信完了通知
#define	AJCSCT_EV_CONNECT		0x00000800					//	接続通知
#define	AJCSCT_EV_DISCONNECT	0x00001000					//	切断通知
#define	AJCSCT_EV_CNFAIL		0x00002000					//	接続失敗通知

#define	AJCSCT_EV_RXERR			0x00010000					//	受信エラー通知
#define	AJCSCT_EV_TXERR			0x00020000					//	送信エラー通知
#define	AJCSCT_EV_ERR			0x08000000					//	その他のエラー通知

#define	AJCSCT_EV_SSEP			(AJCSCT_EV_RXTEXT  | AJCSCT_EV_RXESC	  | AJCSCT_EV_RXCTRL  | AJCSCT_EV_RXPKT | AJCSCT_EV_RXNOPKT)
#define	AJCSCT_EV_COMM			(AJCSCT_EV_RXCHUNK | AJCSCT_EV_INVCHUNK   | AJCSCT_EV_TXEMPTY					)
#define	AJCSCT_EV_GENERAL		(AJCSCT_EV_CONNECT | AJCSCT_EV_DISCONNECT | AJCSCT_EV_CNFAIL					)
#define	AJCSCT_EV_ERRS			(AJCSCT_EV_RXERR   | AJCSCT_EV_TXERR	  | AJCSCT_EV_ERR						)
#define	AJCSCT_EV_ALL			(AJCSCT_EV_SSEP    | AJCSCT_EV_COMM 	  | AJCSCT_EV_GENERAL | AJCSCT_EV_ERRS	)

//	エラーコード
#define	AJCSCT_ERR_CREEVT				 10			//	終了通知用イベントオブジェクト生成失敗
#define	AJCSCT_ERR_SOCKET				 20			//	接続要求待機用ソケット生成失敗(socket)
#define	AJCSCT_ERR_ADDRINFO				 30			//	アドレス情報取得失敗（getaddrinfo）
#define	AJCSCT_ERR_SOCKOPT				 40			//	ソケットオプション設定失敗(setsockopt)
#define	AJCSCT_ERR_SUBTHREAD			 50			//	クライアント通信サブスレッド開始失敗
#define	AJCSCT_ERR_CRESSEP				 60			//	ストリーム分離インスタンス生成失敗
#define	AJCSCT_ERR_CREMBXTXD			 70			//	送信データ用メールボックス生成失敗
#define	AJCSCT_ERR_TIMEOUT				 80			//	サブスレッド終了タイムアウト
#define	AJCSCT_ERR_THREADBUSY			 90			//	接続，通信スレッド実行中
#define	AJCSCT_ERR_CREATEEVENT			100			//	WSACreateEvent失敗
#define	AJCSCT_ERR_EVENTSELECT			110			//	WSAEventSelect失敗
#define	AJCSCT_ERR_ENUMNETWORKEVENTS	120			//	WSAEnumNetworkEvents失敗
#define	AJCSCT_ERR_SOCKERRORCODE		0x80000000	//	Bit31=1の場合、下位ビットがソケットエラーコード

//	回線状態
typedef enum {
	AJCSCT_DISCONNECT			= 0	,			//	切断状態
	AJCSCT_CONNECTING			= 1	,			//	接続中
	AJCSCT_CONNECT				= 2	,			//	接続状態
	AJCSCT_DISCONNECTING		= 3	,			//	切断中
} AJCSCT_STATE;

//	テキスト・コード
typedef enum {
	AJCSCT_TXT_SJIS		=	AJCMBC_SJIS	,		//	シフトＪＩＳ(=1)
	AJCSCT_TXT_EUC		=	AJCMBC_EUC	,		//	ＥＵＣ　　　(=2)
	AJCSCT_TXT_UTF8		=	AJCMBC_UTF8	,		//	ＵＴＦ－８　(=3)
	AJCSCT_TXT_AUTO		=	9			,		//	自動判別　　
} AJCSCT_TEXTCODE;

//	送受信バッファサイズ
#define	AJCSCTMAX_RXBUF	1024
#define	AJCSCTMAX_TXBUF	1024

//	チャンク・データ・モード
typedef enum {
	AJCSCT_CM_BIN	=	0x01	,				//	バイナリチャンク
	AJCSCT_CM_TEXT	=	0x02	,				//	テキストチャンク
	AJCSCT_CM_BOTH	=	0x03	,				//	両方
} AJCSCT_CHUNKMODE;

//	アドレス情報ストレージ
typedef union {
	struct sockaddr_in		sain;
	struct sockaddr_in6		sain6;
	struct sockaddr_storage storage;
} AJCSCTSAIN, *PAJCSCTSAIN;
typedef const AJCSCTSAIN *PCAJCSCTSAIN;

//	インスタンスワーク
typedef struct {
	UI					InstID;								//	インスタンス識別ＩＤ
	BOOL				fThreadBusy;						//	接続，通信スレッド実行中フラグ
	BOOL				fConnected;							//	回線接続中フラグ
	BOOL				fEnding;							//	回線切断中フラグ
	BOOL				fExit;								//	通信スレッド終了フラグ
	AJCSCT_STATE		State;								//	回線状態

	//	インスタンス生成時ワーク
	UI					EvtMask;							//	通知イベントマスク
	AJCSCT_CHUNKMODE	ChunkMode;							//	チャンクデータ通知モード
	AJCSCT_TEXTCODE		RxTxtCode;							//	受信テキストコード
	AJCSCT_TEXTCODE		TxTxtCode;							//	送信テキストコード
	UI					PktTimeout;							//	パケット受信タイムアウト[ms]
	UB					stx, etx, dle;						//	パケットを認識するための制御コード
	UB					dummy;
	HAJCSSEP			hSsep;								//	ストリーム分離インスタンス
	HAJCFMBX			hFMbxNtc;							//	ユーザＡＰへのイベント通知用メールボックスハンドル
	HAJCVMBX			hVMbxTxD;							//	送信データ・メールボックスハンドル

	//	通信開始時ワーク
	BOOL				fUnicode;							//	UNICODEフラグ
	HWND				hWndNtc;							//	イベント通知用ウインドハンドル
	UI					MsgNtc;								//	イベント通知メッセージコード
	int					AddressFamily;						//	アドレスファミリ
	WCP					pServ;								//	サーバ名
	WCP					pPort;								//	ポート／サービス名へのポインタ
	SOCKET				hSock;								//	TCP/IPストリームソケット
	HANDLE				hThread;							//	通信スレッドハンドル
	UL					idThread;							//	通信スレッドＩＤ

	BOOL				fTxBusy;							//	送信完了検出用フラグ
	BC					SvSndA, dmy1;						//	テキスト送信時の全角１バイト目退避バッファ
	WC					SvSndW;								//	テキスト送信時のサロゲート１文字目退避バッファ

	UI					ixRxb;								//	受信バッファ空部分のインデクス（＝前部の半端マルチバイト数）
	UB					RxBuf[AJCSCTMAX_RXBUF + 8];			//	受信データバッファ（データ＋中途マルチバイト(1～5)）＋終端(0x00)）
	UB					RxBin[AJCSCTMAX_RXBUF];				//	バイナリ受信バッファ

	UI					ixNpk;								//	パケット外バッファ空部分のインデクス（＝前部の半端マルチバイト数）
	BC					NpBuf[AJCSCTMAX_RXBUF + 8];			//	パケット外バッファ（データ＋中途マルチバイト(1～5)）＋終端(0x00)）

	//----- MSILサポート用 ----------------------------------------------------//
	HWND	hWndForMsil;						//	MSIL用ダミーウインドハンドル

} AJCSCT, *HAJCSCT;
typedef const AJCSCT *PCAJCSCT;


//	プロトタイプ
AJCEXPORT	HAJCSCT	 		WINAPI	AjcSctCreate				(VO);
AJCEXPORT	BOOL			WINAPI	AjcSctDelete				(HAJCSCT hSct);

AJCEXPORT	BOOL			WINAPI	AjcSctConnectA				(HAJCSCT hSct, C_BCP pServ, C_BCP pPort, int AddressFamily, HWND hWndNtc, UI WndMsgNtc);
AJCEXPORT	BOOL			WINAPI	AjcSctConnectW				(HAJCSCT hSct, C_WCP pServ, C_WCP pPort, int AddressFamily, HWND hWndNtc, UI WndMsgNtc);

AJCEXPORT	BOOL			WINAPI	AjcSctDisconnect			(HAJCSCT hSct);
AJCEXPORT	BOOL			WINAPI	AjcSctDisconnectEx			(HAJCSCT hSct, UI msTimeout);

AJCEXPORT	AJCSCT_STATE	WINAPI	AjcSctGetState				(HAJCSCT hSct);

AJCEXPORT	BOOL			WINAPI	AjcSctSetChunkMode			(HAJCSCT hSct,	AJCSCT_CHUNKMODE ChunkMode);
AJCEXPORT	AJCSCT_CHUNKMODE WINAPI	AjcSctGetChunkMode			(HAJCSCT hSct);
AJCEXPORT	BOOL			WINAPI	AjcSctSetEvtMask			(HAJCSCT hSct, UI EvtMsk);
AJCEXPORT	UI		 		WINAPI	AjcSctGetEvtMask			(HAJCSCT hSct);
AJCEXPORT	BOOL			WINAPI	AjcSctSetRxTextCode			(HAJCSCT hSct, AJCSCT_TEXTCODE code);
AJCEXPORT	AJCSCT_TEXTCODE	WINAPI	AjcSctGetRxTextCode			(HAJCSCT hSct);
AJCEXPORT	AJCSCT_TEXTCODE	WINAPI	AjcSctGetActualRxTextCode	(HAJCSCT hSct);
AJCEXPORT	BOOL			WINAPI	AjcSctSetTxTextCode			(HAJCSCT hSct, AJCSCT_TEXTCODE code);
AJCEXPORT	AJCSCT_TEXTCODE	WINAPI	AjcSctGetTxTextCode			(HAJCSCT hSct);
AJCEXPORT	AJCSCT_TEXTCODE	WINAPI	AjcSctGetActualTxTextCode	(HAJCSCT hSct);
AJCEXPORT	BOOL			WINAPI	AjcSctWaitEvent				(HAJCSCT hSct, WPARAM *pwParam, LPARAM *plParam, UI msTime);
AJCEXPORT	BOOL			WINAPI	AjcSctGetEventData			(HAJCSCT hSct, LPARAM lParam, VOP *ppDat, UIP plDat, UIP pParam);
AJCEXPORT	BOOL			WINAPI	AjcSctRelEventData			(HAJCSCT hSct, LPARAM lParam);
AJCEXPORT	BOOL			WINAPI	AjcSctSetPktCtrlCode		(HAJCSCT hSct, UI stx, UI etx, UI dle);
AJCEXPORT	BOOL			WINAPI	AjcSctGetPktCtrlCode		(HAJCSCT hSct, UIP pStx, UIP pEtx, UIP pDle);
AJCEXPORT	BOOL			WINAPI	AjcSctSetPktTimeout			(HAJCSCT hSct, UI msTime);
AJCEXPORT	BOOL			WINAPI	AjcSctGetPktTimeout			(HAJCSCT hSct, UIP pMsTime);

AJCEXPORT	BOOL			WINAPI	AjcSctSendCharA				(HAJCSCT hSct, BC code);
AJCEXPORT	BOOL			WINAPI	AjcSctSendCharW				(HAJCSCT hSct, WC code);

AJCEXPORT	BOOL			WINAPI	AjcSctSendTextA				(HAJCSCT hSct, C_BCP pTxt, UI lTxt);
AJCEXPORT	BOOL			WINAPI	AjcSctSendTextW				(HAJCSCT hSct, C_WCP pTxt, UI lTxt);

AJCEXPORT	BOOL			WINAPI	AjcSctSendTextFA			(HAJCSCT hSct, C_BCP pFmt, ...);
AJCEXPORT	BOOL			WINAPI	AjcSctSendTextFW			(HAJCSCT hSct, C_WCP pFmt, ...);

AJCEXPORT	BOOL			WINAPI	AjcSctSendBinData			(HAJCSCT hSct, C_VOP pDat, UI lDat);
AJCEXPORT	UI				WINAPI	AjcSctSendPacket			(HAJCSCT hSct, C_VOP pPkt, UI lPkt);

AJCEXPORT	BOOL			WINAPI	AjcSctPurgeRecvData			(HAJCSCT hSct);
AJCEXPORT	BOOL			WINAPI	AjcSctPurgeSendData			(HAJCSCT hSct);
AJCEXPORT	BOOL			WINAPI	AjcSctPurgeAllData			(HAJCSCT hSct);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- コントロールウインド生成 -------------------------------------------------------------------------------//
AJCEXPORT HAJCSCT WINAPI AjcSctCreateForMSIL(	VO	 (CALLBACK *cbRxText		)(C_WCP text),
												VO	 (CALLBACK *cbRxEsc			)(C_WCP text),
												VO	 (CALLBACK *cbRxCtrl		)(int	ctrl),
												VO	 (CALLBACK *cbRxPacket		)(C_VOP pData, int lData),
												VO	 (CALLBACK *cbRxNoPkt		)(C_WCP text),
												VO	 (CALLBACK *cbTxEmpty		)(VO),
												VO	 (CALLBACK *cbRxChunkTxt	)(C_WCP text),
												VO	 (CALLBACK *cbRxChunkBin	)(C_VOP pData, int lData),
												VO	 (CALLBACK *cbRxInvChunk	)(C_VOP pData, int lData),
												VO	 (CALLBACK *cbConnect		)(VO),
												VO	 (CALLBACK *cbDisconnect	)(VO),
												VO	 (CALLBACK *cbCnFail		)(int err),
												VO	 (CALLBACK *cbRecvError		)(BOOL fOverlapped),
												VO	 (CALLBACK *cbSendError		)(BOOL fOverlapped),
												VO	 (CALLBACK *cbGeneralError	)(UI ErrCode));
//----- 通信開始 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcSctConnectForMSIL(HAJCSCT hSct, C_WCP pServ, C_WCP pPort, int AddressFamily, BOOL fOnEvent);
//----- 終了処理 -----------------------------------------------------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcSctDeleteForMSIL(HAJCSCT hSct);



/****************************************************************************************************************/
#endif
