﻿#ifndef	AJCSTDIO_H_
#define	AJCSTDIO_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcPutC						AjcPutCW
	#define		AjcPutS						AjcPutSW
	#define		AjcPrintF					AjcPrintFW
	#define		AjcErrPutC					AjcErrPutCW
	#define		AjcErrPutS					AjcErrPutSW
	#define		AjcErrPrintF				AjcErrPrintFW
	#define		AjcConInputEasy				AjcConInputEasyW
	#define		AjcConInputByNtc			AjcConInputByNtcW
	#define		AjcConInput					AjcConInputW
	#define		AjcConInputEx				AjcConInputExW
	#define		MAjcAllocMainArgs(c, v)		AjcAllocMainArgsW(c, (char ***)&v)
	#define		MAjcFreeMainArgs(c, v)		AjcFreeMainArgsW (c, (char **)v)

	#define		AjcSystem					AjcSystemW

	#define		AJCCIN_SECT					AJCCIN_SECTW
#else
	#define		AjcPutC						AjcPutCA
	#define		AjcPutS						AjcPutSA
	#define		AjcPrintF					AjcPrintFA
	#define		AjcErrPutC					AjcErrPutCA
	#define		AjcErrPutS					AjcErrPutSA
	#define		AjcErrPrintF				AjcErrPrintFA
	#define		AjcConInputEasy				AjcConInputEasyA
	#define		AjcConInputByNtc			AjcConInputByNtcA
	#define		AjcConInput					AjcConInputA
	#define		AjcConInputEx				AjcConInputExA
	#define		MAjcAllocMainArgs(c, v)
	#define		MAjcFreeMainArgs(c, v)

	#define		AjcSystem					AjcSystemA

	#define		AJCCIN_SECT					AJCCIN_SECTA
#endif

//	AjcConInput()の永続記録用セクション
#define		AJCCIN_SECTA		 "AjcConInputSec"
#define		AJCCIN_SECTW		L"AjcConInputSec"

//	オプションフラグ( AjcConInput)
#define		AJCCIN_F1GUIDE		0x0001		//	初期ガイド表示
#define		AJCCIN_SHOWREDO		0x0002		//	やり直しデータ位置表示
#define		AJCCIN_SHOWPREV		0x0004		//	参照テキストデータ位置表示
#define		AJCCIN_SHOWTEXT		0x0008		//	入力したテキスト表示
#define		AJCCIN_ALL			(AJCCIN_F1GUIDE | AJCCIN_SHOWREDO | AJCCIN_SHOWPREV | AJCCIN_SHOWTEXT)

//	コンソール入力１６色指定
#define		AJCCI_16(N)			(COLORREF)(0x80000000 | N)

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	BOOL 	WINAPI AjcSetStdoutMode  (VO);
AJCEXPORT	BOOL 	WINAPI AjcSetStdoutModeEx(EAJCTEC tec, BOOL fBom);
AJCEXPORT	BOOL 	WINAPI AjcSetStdMode	 (EAJCTEC tec, BOOL fBom);

AJCEXPORT	int		WINAPI AjcPutCA(BC c);
AJCEXPORT	int		WINAPI AjcPutCW(WC c);

AJCEXPORT	int		WINAPI AjcPutSA(C_BCP pStr);
AJCEXPORT	int		WINAPI AjcPutSW(C_WCP pStr);

AJCEXPORT	int		WINAPI AjcPrintFA(C_BCP pFmt, ...);
AJCEXPORT	int		WINAPI AjcPrintFW(C_WCP pFmt, ...);

AJCEXPORT	int		WINAPI AjcErrPutCA(BC c);
AJCEXPORT	int		WINAPI AjcErrPutCW(WC c);

AJCEXPORT	int		WINAPI AjcErrPutSA(C_BCP pStr);
AJCEXPORT	int		WINAPI AjcErrPutSW(C_WCP pStr);

AJCEXPORT	int	 	WINAPI AjcErrPrintFA(C_BCP pFmt, ...);
AJCEXPORT	int	 	WINAPI AjcErrPrintFW(C_WCP pFmt, ...);

AJCEXPORT	BOOL	WINAPI AjcAllocMainArgsW(int argc, char **argv[]);
AJCEXPORT	VO		WINAPI AjcFreeMainArgsW (int argc, char *argv[]);

AJCEXPORT	BOOL	WINAPI AjcGetConsoleScreenBufferInfo(LPSIZE pBufSize, LPRECT pRcWnd, LPSIZE pMaxWndSize);
AJCEXPORT	BOOL	WINAPI AjcGetConsoleMaxWndSize		(int *pCx  , int *pCy);

AJCEXPORT	BOOL	WINAPI AjcSetConsoleBufSize			(int cx, int cy);
AJCEXPORT	BOOL	WINAPI AjcGetConsoleBufSize 		(int *pCx  , int *pCy);

AJCEXPORT	BOOL	WINAPI AjcSetConsoleWndRect			(int left  , int top  , int right  , int bottom  );
AJCEXPORT	BOOL	WINAPI AjcGetConsoleWndRect			(int *pLeft, int *pTop, int *pRight, int *pBottom);

AJCEXPORT	BOOL	WINAPI AjcSetConsoleColor(COLORREF	  ForeColor,   COLORREF  BackColor);
AJCEXPORT	BOOL	WINAPI AjcGetConsoleColor(LPCOLORREF pForeColor, LPCOLORREF pBackColor);
AJCEXPORT	COLORREF WINAPI AjcGetConsoleForeColor(VO);
AJCEXPORT	COLORREF WINAPI AjcGetConsoleBackColor(VO);

AJCEXPORT	BOOL	WINAPI AjcSetConsole16Color(UI	 ForeColor,  UI   BackColor);
AJCEXPORT	BOOL	WINAPI AjcGetConsole16Color(UIP pForeColor,  UIP pBackColor);
AJCEXPORT	UI		WINAPI AjcGetConsoleFore16Color(VO);
AJCEXPORT	UI		WINAPI AjcGetConsoleBack16Color(VO);

AJCEXPORT	BOOL	WINAPI AjcSelConsolePalette(UI ForePalette, UI BackPalette);
AJCEXPORT	UI		WINAPI AjcGetConsolePalette(COLORREF Palette[16]);
AJCEXPORT	BOOL	WINAPI AjcSetConsolePalette(const COLORREF Palette[16]);

AJCEXPORT	BOOL	 WINAPI AjcSetConsolePalByIx(UI ix, COLORREF color);
AJCEXPORT	COLORREF WINAPI AjcGetConsolePalByIx(UI ix);

AJCEXPORT	BOOL	WINAPI AjcSetConsoleCursor(int x, int y);
AJCEXPORT	BOOL	WINAPI AjcGetConsoleCursor(int *pX, int *pY);


AJCEXPORT BOOL	 WINAPI AjcConInputEasyA(BCP pBuf, UI lBuf);
AJCEXPORT BOOL	 WINAPI AjcConInputEasyW(WCP pBuf, UI lBuf);

AJCEXPORT BOOL	 WINAPI AjcConInputByNtcA(UX cbp, VO (CALLBACK *cbNtcArgs)(int argc, BC *argv[], C_BCP pTxt, UX cbp));
AJCEXPORT BOOL	 WINAPI AjcConInputByNtcW(UX cbp, VO (CALLBACK *cbNtcArgs)(int argc, WC *argv[], C_WCP pTxt, UX cbp));

AJCEXPORT BOOL	 WINAPI AjcConInputA(C_BCP pInitialText, UI lInpField, BCP pBuf, UI lBuf, UI fOpt);
AJCEXPORT BOOL	 WINAPI AjcConInputW(C_WCP pInitialText, UI lInpField, WCP pBuf, UI lBuf, UI fOpt);

AJCEXPORT BOOL	 WINAPI AjcConInputExA (C_BCP pInitialText, UI lInpField,
										BCP pBuf		  , UI lBuf,
										UI fOpt, COLORREF TextColor, COLORREF BackColor, C_BCP pHelpText,
										UX cbp, VO (CALLBACK *cbNtcArgs)(int argc, BC *argv[], C_BCP pTxt, UX cbp));

AJCEXPORT BOOL	 WINAPI AjcConInputExW (C_WCP pInitialText, UI lInpField,
										WCP pBuf		  , UI lBuf,
										UI fOpt, COLORREF TextColor, COLORREF BackColor, C_WCP pHelpText,
										UX cbp, VO (CALLBACK *cbNtcArgs)(int argc, WC *argv[], C_WCP pTxt, UX cbp));

AJCEXPORT BOOL	 WINAPI AjcConInputForMSIL(C_WCP pInitialText, UI lInpField,
										WCP pBuf, UI lBuf,
										UI fOpt, COLORREF TextColor, COLORREF BackColor, C_WCP pHelpText,
										UX cbp, VO (CALLBACK *cbNtcStr)(int argc, C_WCP pStr, UX cbp));


AJCEXPORT	BOOL	WINAPI AjcSystemA(C_BCP pCmdLine, C_BCP pOutFile, UI msTime);
AJCEXPORT	BOOL	WINAPI AjcSystemW(C_WCP pCmdLine, C_WCP pOutFile, UI msTime);

/****************************************************************************************************************/
#endif
