﻿#ifndef	AJCSTRPOOL_H_
#define	AJCSTRPOOL_H_
/****************************************************************************************************************/

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcSplCreate		AjcSplCreateW
	#define	AjcSplSetCompMode	AjcSplSetCompModeW
	#define	AjcSplRegist		AjcSplRegistW
	#define	AjcSplFind			AjcSplFindW
	#define	AjcSplRemove		AjcSplRemoveW
	#define	AjcSplEnumStr		AjcSplEnumStrW
	#define	AjcSplPartStrInPool	AjcSplPartStrInPoolW
	#define	AjcSplPoolStrInStr	AjcSplPoolStrInStrW
#else
	#define	AjcSplCreate		AjcSplCreateA
	#define	AjcSplSetCompMode	AjcSplSetCompModeA
	#define	AjcSplRegist		AjcSplRegistA
	#define	AjcSplFind			AjcSplFindA
	#define	AjcSplRemove		AjcSplRemoveA
	#define	AjcSplEnumStr		AjcSplEnumStrA
	#define	AjcSplPartStrInPool	AjcSplPartStrInPoolA
	#define	AjcSplPoolStrInStr	AjcSplPoolStrInStrA
#endif
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	文字列比較パラメタ																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCSPL_CMP_EXACT_WIDTH		AJCCMP_EXACT_WIDTH			//	英大小文字を区別する
#define	AJCSPL_CMP_IGNORE_WIDTH		AJCCMP_IGNORE_WIDTH			//	英大小文字を区別しない
#define	AJCSPL_CMP_MIX				AJCCMP_ALPHABETIC			//	同一の場合のみ英大小文字を区別する

//	旧バージョン互換
#define	AJCSPL_CMP_DISTINGUISH		AJCSPL_CMP_EXACT_WIDTH
#define	AJCSPL_CMP_NODISTINGUISH	AJCSPL_CMP_IGNORE_WIDTH

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	部分文字列検索パラメタ																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCSPL_ISP_MATCHFIRST = 1	,		//	先頭部分が文字列と一致
	AJCSPL_ISP_INCLUDING		,		//	文字列を含む
} AJCSPL_INSTROPT;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	インスタンスワーク																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI				InstID;				//	インスタンス識別ＩＤ
	EAJCCMPMODE		CmpMode;			//	文字列の比較方法
	BOOL			fDistinguish;		//	英大文字，小文字の区別（TRUE:区別する，FALSE：区別しない）
	HAJCAVL			hAvlStr;			//	文字列プール用２文木
} AJCSPL, *HAJCSPL;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSPL			WINAPI	AjcSplCreateA(EAJCCMPMODE CmpMode);
AJCEXPORT	HAJCSPL			WINAPI	AjcSplCreateW(EAJCCMPMODE CmpMode);

AJCEXPORT	BOOL			WINAPI	AjcSplDelete (HAJCSPL hSpl);

AJCEXPORT	BOOL			WINAPI	AjcSplSetCompModeA(HAJCSPL hSpl, EAJCCMPMODE CmpMode);
AJCEXPORT	BOOL			WINAPI	AjcSplSetCompModeW(HAJCSPL hSpl, EAJCCMPMODE CmpMode);

AJCEXPORT	EAJCCMPMODE		WINAPI	AjcSplGetCompMode(HAJCSPL hSpl);

AJCEXPORT	C_BCP			WINAPI	AjcSplRegistA(HAJCSPL hSpl, C_BCP pStr);
AJCEXPORT	C_WCP			WINAPI	AjcSplRegistW(HAJCSPL hSpl, C_WCP pStr);

AJCEXPORT	C_BCP			WINAPI	AjcSplFindA  (HAJCSPL hSpl, C_BCP pStr);
AJCEXPORT	C_WCP			WINAPI	AjcSplFindW  (HAJCSPL hSpl, C_WCP pStr);

AJCEXPORT	C_BCP			WINAPI	AjcSplPartStrInPoolA(HAJCSPL hSpl, C_BCP pPartStr, AJCSPL_INSTROPT opt);
AJCEXPORT	C_WCP			WINAPI	AjcSplPartStrInPoolW(HAJCSPL hSpl, C_WCP pPartStr, AJCSPL_INSTROPT opt);

AJCEXPORT	C_BCP			WINAPI	AjcSplPoolStrInStrA(HAJCSPL hSpl, C_BCP pStr, AJCSPL_INSTROPT opt);
AJCEXPORT	C_WCP			WINAPI	AjcSplPoolStrInStrW(HAJCSPL hSpl, C_WCP pStr, AJCSPL_INSTROPT opt);

AJCEXPORT	BOOL			WINAPI	AjcSplRemoveA(HAJCSPL hSpl, C_BCP pStr);
AJCEXPORT	BOOL			WINAPI	AjcSplRemoveW(HAJCSPL hSpl, C_WCP pStr);

AJCEXPORT	UI				WINAPI	AjcSplGetCount(HAJCSPL hSpl);
AJCEXPORT	UI				WINAPI	AjcSplNumber  (HAJCSPL hSpl);

AJCEXPORT	BOOL			WINAPI	AjcSplReset  (HAJCSPL hSpl);

AJCEXPORT	UI				WINAPI	AjcSplEnumStrA(HAJCSPL hSpl, UX cbp, BOOL (CALLBACK *cbNtcStr)(C_BCP pStr, UX cbp), BOOL fDownSeq);
AJCEXPORT	UI				WINAPI	AjcSplEnumStrW(HAJCSPL hSpl, UX cbp, BOOL (CALLBACK *cbNtcStr)(C_WCP pStr, UX cbp), BOOL fDownSeq);

AJCEXPORT	HAJCAVL			WINAPI	AjcSplGetAvlHandle(HAJCSPL hSpl);

/****************************************************************************************************************/
#endif
