﻿#ifndef	AJCTEXTOUT_H_
#define	AJCTEXTOUT_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcTxoPrintF			AjcTxoPrintFW
	#define	AjcTxoPrintFEx			AjcTxoPrintFExW
	#define	AjcTxoPrintFExEx		AjcTxoPrintFExExW
	#define	AjcTxoTextOut			AjcTxoTextOutW
	#define	AjcTxoTextOutEx			AjcTxoTextOutExW
	#define	AjcTxoTextOutExEx		AjcTxoTextOutExExW
	#define	AjcTxoEscOut			AjcTxoEscOutW
	#define	AjcTxoGetLineCount		AjcTxoGetLineCountW
	#define	AjcTxoGetExtent			AjcTxoGetExtentW
	#define	AjcTxoGetExtentEx		AjcTxoGetExtentExW
	#define	AjcTxoGetExtent2		AjcTxoGetExtent2W
	#define	AjcTxoGetExtent2Ex		AjcTxoGetExtent2ExW
	#define	AjcTxoGetImgSpaceSize	AjcTxoGetImgSpaceSizeW
	#define	AjcTxoEnumEsc			AjcTxoEnumEscW
	#define	AjcTxoGetRgbByText		AjcTxoGetRgbByTextW
#else
	#define	AjcTxoPrintF			AjcTxoPrintFA
	#define	AjcTxoPrintFEx			AjcTxoPrintFExA
	#define	AjcTxoPrintFExEx		AjcTxoPrintFExExA
	#define	AjcTxoTextOut			AjcTxoTextOutA
	#define	AjcTxoTextOutEx			AjcTxoTextOutExA
	#define	AjcTxoTextOutExEx		AjcTxoTextOutExExA
	#define	AjcTxoEscOut			AjcTxoEscOutA
	#define	AjcTxoGetLineCount		AjcTxoGetLineCountA
	#define	AjcTxoGetExtent			AjcTxoGetExtentA
	#define	AjcTxoGetExtentEx		AjcTxoGetExtentExA
	#define	AjcTxoGetExtent2		AjcTxoGetExtent2A
	#define	AjcTxoGetExtent2Ex		AjcTxoGetExtent2ExA
	#define	AjcTxoGetImgSpaceSize	AjcTxoGetImgSpaceSizeA
	#define	AjcTxoEnumEsc			AjcTxoEnumEscA
	#define	AjcTxoGetRgbByText		AjcTxoGetRgbByTextA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	コーナー指定値																								//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCTXO_CORNER_MIN	0x1FFF0000				//	全最小値
#define		AJCTXO_CORNER_MAX	0x1FFFFFFF				//	全最大値
//	右隅
#define		AJCTXO_RIGHT_MIN	0x1FFF0000				//	最小値
#define		AJCTXO_RIGHT_MAX	0x1FFF3FFF				//	最大値
#define		AJCTXO_RIGHT		0x1FFF2000				//	中央値
//	下隅
#define		AJCTXO_BOTTOM_MIN	0x1FFF4000				//	最小値
#define		AJCTXO_BOTTOM_MAX	0x1FFF7FFF				//	最大値
#define		AJCTXO_BOTTOM		0x1FFF6000				//	中央値
//	中央
#define		AJCTXO_CENTER_MIN	0x1FFF8000				//	最小値
#define		AJCTXO_CENTER_MAX	0x1FFFBFFF				//	最大値
#define		AJCTXO_CENTER		0x1FFFA000				//	中央値

//--------------------------------------------------------------------------------------------------------------//
//	文字詰め																									//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCTXOALIGN_LEFT		= 1, 		//	左詰め
	AJCTXOALIGN_CENTER		= 2, 		//	中央合わせ
	AJCTXOALIGN_RIGHT		= 3, 		//	右詰め
	AJCTXOALIGN_TAB_RIGHT	= 4,		//	左詰めでＴＡＢ以降を右詰め
} AJCTXOALIGN, *PAJCTXOALIGN;

//--------------------------------------------------------------------------------------------------------------//
//	文字背景モード																								//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCTXO_TRANSPARENT	=	TRANSPARENT,	//	透明
	AJCTXO_OPAQUE		=	OPAQUE,			//	不透明
} AJCTXOBKMODE, *PAJCTXOBKMODE;


//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
//----- 描画イメージ情報 ---------------------------------------------------------------------------------------//
typedef struct {
	UI		id;										//	識別ＩＤ
	BOOL	fIcon;									//	イメージ種別（FALSE : Bitmap, TRUE : Icon）
	union	{HBITMAP hBmp; HICON hIcon; UX h;} u;	//	イメージのハンドル
	int		x, y, cx, cy;							//	描画位置とサイズ
} TXOIMGINFO, *PTXOIMGINFO;
typedef const TXOIMGINFO *PCTXOIMGINFO;

//----- インスタンスワーク -------------------------------------------------------------------------------------//
typedef  struct {
	UI					InstID;				//	インスタンス識別ＩＤ
	HDC					hdc;				//	ＤＣハンドル
	SIZE				szBmp;				//	ＤＣ描画スペースのサイズ（ビットマップサイズ）
	int					xLeft;				//	Ｘ左端位置（'\r'による復帰位置）
	int					yTop;				//	Ｙ上端位置
	int					x, y;				//	描画ピクセル位置
	int					TabStep;			//	タブステップ［ピクセル数］
	int					cxChar;				//	文字の幅	［ピクセル数］
	int					cyChar;				//	文字の高さ	［ピクセル数］
	int					Lsp;				//	行間スペース［ピクセル数］
	AJCTXOALIGN			Align;				//	文字列整列（左詰め、中合わせ、右詰め，TAB以降右詰め）
	int					NestItalic;			//	斜字のネスト数
	int					NestBold;			//	太字のネスト数
	int					NestULine;			//	下線のネスト数
	COLORREF			Palette[8];			//	パレット
	//----- 起動時のＤＣ属性 -----------------------------------------------------------------------------------//
	HFONT				hFontOrg;			//	オリジナルフォント
	UI					BkModeOrg;			//	オリジナル背景モード
	COLORREF			BkColorOrg;			//	オリジナル背景色
	COLORREF			TxtColorOrg;		//	オリジナル文字色
	//----- デフォルト情報 -------------------------------------------------------------------------------------//
	UI					LspDef;				//	行間スペース
	COLORREF			TxtColorDef;		//	テキスト色
	COLORREF			BkColorDef;			//	背景色（-1：透明）
	//----- フォント変更情報 -----------------------------------------------------------------------------------//
	UI					fFont;				//	フォント変更フラグ
	HFONT				hFontN;				//	ノーマルフォント
	HFONT				hFontB;				//	ボールド
	HFONT				hFontI;				//	イタリック
	HFONT				hFontU;				//	アンダーライン
	HFONT				hFontBI;			//	ボールド   ＋ イタリック
	HFONT				hFontBU;			//	ボールド   ＋ アンダーライン
	HFONT				hFontIU;			//	イタリック ＋ アンダーライン
	HFONT				hFontBIU;			//	ボールド   ＋ イタリック ＋ アンダーライン
} AJCTXO, *HAJCTXO;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCTXO		WINAPI	AjcTxoCreate		(HDC hdc, int left, int top, int defLsp);
AJCEXPORT	BOOL		WINAPI	AjcTxoDelete		(HAJCTXO hTxo, BOOL fRestore);

AJCEXPORT	BOOL		WINAPI	AjcTxoSetDcBmpSize	(HAJCTXO hTxo, int cx, int cy);

AJCEXPORT	BOOL		WINAPI	AjcTxoSetAlign		(HAJCTXO hTxo, AJCTXOALIGN Align);
AJCEXPORT	AJCTXOALIGN	WINAPI	AjcTxoGetAlign		(HAJCTXO hTxo);

AJCEXPORT	BOOL		WINAPI	AjcTxoLocate		(HAJCTXO hTxo, int x, int y);

AJCEXPORT	BOOL		WINAPI	AjcTxoSetPos		(HAJCTXO hTxo, LPPOINT pPt);
AJCEXPORT	BOOL		WINAPI	AjcTxoGetPos		(HAJCTXO hTxo, LPPOINT pPt);

AJCEXPORT	BOOL		WINAPI	AjcTxoPrintFA		(HAJCTXO hTxo, C_BCP pFmt, ...);
AJCEXPORT	BOOL		WINAPI	AjcTxoPrintFW		(HAJCTXO hTxo, C_WCP pFmt, ...);

AJCEXPORT	BOOL		WINAPI	AjcTxoPrintFExA		(HAJCTXO hTxo, int x, int y, C_BCP pFmt, ...);
AJCEXPORT	BOOL		WINAPI	AjcTxoPrintFExW		(HAJCTXO hTxo, int x, int y, C_WCP pFmt, ...);

AJCEXPORT	BOOL		WINAPI	AjcTxoPrintFExExA	(HAJCTXO hTxo, int x, int y, int cx, C_BCP pFmt, ...);
AJCEXPORT	BOOL		WINAPI	AjcTxoPrintFExExW	(HAJCTXO hTxo, int x, int y, int cx, C_WCP pFmt, ...);

AJCEXPORT	BOOL		WINAPI	AjcTxoTextOutA		(HAJCTXO hTxo, C_BCP pText);
AJCEXPORT	BOOL		WINAPI	AjcTxoTextOutW		(HAJCTXO hTxo, C_WCP pText);

AJCEXPORT	BOOL		WINAPI	AjcTxoTextOutExA	(HAJCTXO hTxo, int x, int y, C_BCP pText);
AJCEXPORT	BOOL		WINAPI	AjcTxoTextOutExW	(HAJCTXO hTxo, int x, int y, C_WCP pText);

AJCEXPORT	BOOL		WINAPI	AjcTxoTextOutExExA	(HAJCTXO hTxo, int x, int y, int cx, C_BCP pText);
AJCEXPORT	BOOL		WINAPI	AjcTxoTextOutExExW	(HAJCTXO hTxo, int x, int y, int cx, C_WCP pText);

AJCEXPORT	BCP			WINAPI	AjcTxoEscOutA		(HAJCTXO hTxo, C_BCP pEsc, BOOL fDraw);		//	非公開
AJCEXPORT	WCP			WINAPI	AjcTxoEscOutW		(HAJCTXO hTxo, C_WCP pEsc, BOOL fDraw);		//	非公開

AJCEXPORT	UI			WINAPI	AjcTxoGetLineCountA	(HAJCTXO hTxo, C_BCP pText);
AJCEXPORT	UI			WINAPI	AjcTxoGetLineCountW	(HAJCTXO hTxo, C_WCP pText);

AJCEXPORT	UI			WINAPI	AjcTxoGetExtentA	(HAJCTXO hTxo, C_BCP pText, LPSIZE pSzTxt);
AJCEXPORT	UI			WINAPI	AjcTxoGetExtentW	(HAJCTXO hTxo, C_WCP pText, LPSIZE pSzTxt);

AJCEXPORT	UI			WINAPI	AjcTxoGetExtentExA	(HAJCTXO hTxo, int x, int y, C_BCP pText, LPSIZE pSzTxt);
AJCEXPORT	UI			WINAPI	AjcTxoGetExtentExW	(HAJCTXO hTxo, int x, int y, C_WCP pText, LPSIZE pSzTxt);

AJCEXPORT	UI			WINAPI	AjcTxoGetExtent2A	(HAJCTXO hTxo, C_BCP pText, LPSIZE pSzTxt, UI LinePixs[], UI nLine);
AJCEXPORT	UI			WINAPI	AjcTxoGetExtent2W	(HAJCTXO hTxo, C_WCP pText, LPSIZE pSzTxt, UI LinePixs[], UI nLine);

AJCEXPORT	UI			WINAPI	AjcTxoGetExtent2ExA	(HAJCTXO hTxo, int x, int y, C_BCP pText, LPSIZE pSzTxt, UI LinePixs[], UI nLine);
AJCEXPORT	UI			WINAPI	AjcTxoGetExtent2ExW	(HAJCTXO hTxo, int x, int y, C_WCP pText, LPSIZE pSzTxt, UI LinePixs[], UI nLine);

AJCEXPORT	BOOL		WINAPI	AjcTxoGetImgSpaceSizeB(C_BCP pText, LPSIZE pSzImg);
AJCEXPORT	BOOL		WINAPI	AjcTxoGetImgSpaceSizeW(C_WCP pText, LPSIZE pSzImg);

AJCEXPORT	BOOL		WINAPI	AjcTxoSetPalette	(HAJCTXO hTxo, COLORREF rgb[8]);
AJCEXPORT	COLORREF	WINAPI	AjcTxoSetPaletteItem(HAJCTXO hTxo, int ix, COLORREF rgb);

AJCEXPORT	BOOL		WINAPI	AjcTxoGetPalette	 (HAJCTXO hTxo, COLORREF rgb[8]);
AJCEXPORT	COLORREF	WINAPI	AjcTxoGetPaletteItem (HAJCTXO hTxo, int ix);

AJCEXPORT	COLORREF	WINAPI	AjcTxoSetDefTextColor(HAJCTXO hTxo, COLORREF defColor);

AJCEXPORT	COLORREF	WINAPI	AjcTxoSetDefBkColor  (HAJCTXO hTxo, COLORREF defColor);

AJCEXPORT	BOOL		WINAPI	AjcTxoGetCharSize	 (HAJCTXO hTxo, LPSIZE pSize);

AJCEXPORT	UI			WINAPI	AjcTxoGetLineSpace	 (HAJCTXO hTxo);
AJCEXPORT	UI			WINAPI	AjcTxoSetLineSpace	 (HAJCTXO hTxo, int LineSpace);

AJCEXPORT	int			WINAPI	AjcTxoGetTabStep	 (HAJCTXO hTxo);
AJCEXPORT	int			WINAPI	AjcTxoSetTabStep	 (HAJCTXO hTxo, int TabStep);

AJCEXPORT	AJCTXOBKMODE WINAPI	AjcTxoGetBkMode	 (HAJCTXO hTxo);
AJCEXPORT	AJCTXOBKMODE WINAPI	AjcTxoSetBkMode	 (HAJCTXO hTxo, AJCTXOBKMODE BkMode);

AJCEXPORT	UI			WINAPI	AjcTxoEnumEscA(C_BCP pText, UX cbp, BOOL (CALLBACK *cbNtcEsc)(C_BCP pEsc, UI lEsc, BC cLast, UX cbp));
AJCEXPORT	UI			WINAPI	AjcTxoEnumEscW(C_WCP pText, UX cbp, BOOL (CALLBACK *cbNtcEsc)(C_WCP pEsc, UI lEsc, WC cLast, UX cbp));

AJCEXPORT	BCP			WINAPI	AjcTxoGetRgbByTextA	(C_BCP pText, COLORREF *pBuf);
AJCEXPORT	WCP			WINAPI	AjcTxoGetRgbByTextW	(C_WCP pText, COLORREF *pBuf);

AJCEXPORT	BOOL		WINAPI	AjcTxoRegistBitmap	(HBITMAP hBmp , UI id, int x, int y, int cx, int cy);
AJCEXPORT	BOOL		WINAPI	AjcTxoRegistIcon	(HICON   hIcon, UI id, int x, int y, int cx, int cy);
AJCEXPORT	BOOL		WINAPI	AjcTxoUnregistImage	(UI id);

/****************************************************************************************************************/
#endif
