﻿#ifndef	AJCVMG_H_
#define	AJCVMG_H_
/****************************************************************************************************************/

//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define		AjcVmgCreate			AjcVmgCreateW
	#define		AjcVmgDelete			AjcVmgDeleteW
	#define		AjcVmgPurge				AjcVmgPurgeW
	#define		AjcVmgGenVar			AjcVmgGenVarW
	#define		AjcVmgSetAtt			AjcVmgSetAttW
	#define		AjcVmgGetAtt			AjcVmgGetAttW
	#define		AjcVmgDelVar			AjcVmgDelVarW
	#define		AjcVmgSetInteger		AjcVmgSetIntegerW
	#define		AjcVmgSetReal			AjcVmgSetRealW
	#define		AjcVmgSetString			AjcVmgSetStringW
	#define		AjcVmgGetInt32			AjcVmgGetInt32W
	#define		AjcVmgGetInt64			AjcVmgGetInt64W
	#define		AjcVmgGetReal			AjcVmgGetRealW
	#define		AjcVmgGetString			AjcVmgGetStringW
	#define		AjcVmgSwap				AjcVmgSwapW
	#define		AjcVmgGetArrNum			AjcVmgGetArrNumW
	#define		AjcVmgGetNode			AjcVmgGetNodeW
	#define		AjcVmgEnumVar			AjcVmgEnumVarW
	#define		AjcVmgCopy				AjcVmgCopyW

	#define		AJCVMGNODE				AJCVMGNODEW
	#define		PAJCVMGNODE				PAJCVMGNODEW
	#define		PCAJCVMGNODE			PCAJCVMGNODEW

	#define		AJCVMG					AJCVMGW
	#define		HAJCVMG					HAJCVMGW
#else
	#define		AjcVmgCreate			AjcVmgCreateA
	#define		AjcVmgDelete			AjcVmgDeleteA
	#define		AjcVmgPurge				AjcVmgPurgeA
	#define		AjcVmgGenVar			AjcVmgGenVarA
	#define		AjcVmgSetAtt			AjcVmgSetAttA
	#define		AjcVmgGetAtt			AjcVmgGetAttA
	#define		AjcVmgDelVar			AjcVmgDelVarA
	#define		AjcVmgSetInteger		AjcVmgSetIntegerA
	#define		AjcVmgSetReal			AjcVmgSetRealA
	#define		AjcVmgSetString			AjcVmgSetStringA
	#define		AjcVmgGetInt32			AjcVmgGetInt32A
	#define		AjcVmgGetInt64			AjcVmgGetInt64A
	#define		AjcVmgGetReal			AjcVmgGetRealA
	#define		AjcVmgGetString			AjcVmgGetStringA
	#define		AjcVmgSwap				AjcVmgSwapA
	#define		AjcVmgGetArrNum			AjcVmgGetArrNumA
	#define		AjcVmgGetNode			AjcVmgGetNodeA
	#define		AjcVmgEnumVar			AjcVmgEnumVarA
	#define		AjcVmgCopy				AjcVmgCopyA

	#define		AJCVMGNODE				AJCVMGNODEA
	#define		PAJCVMGNODE				PAJCVMGNODEA
	#define		PCAJCVMGNODE			PCAJCVMGNODEA

	#define		AJCVMG					AJCVMGA
	#define		HAJCVMG					HAJCVMGA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	変数の属性																									//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCVMGA_RDONLY	0x8000 		//	Bit15	: 読み出し専用
#define	AJCVMGA_USER	0x7FFF		//	Bit14-0 : ユーザ属性

#define	AJCVMGA_NORMAL	0			//	読み書き可

//--------------------------------------------------------------------------------------------------------------//
//	変数のタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCVMGT_UNDEF	= 0 ,	//　未定義／エラー
	AJCVMGT_INT		= 1	,	//　３２ビット整数(signed int)
	AJCVMGT_LONG		,	//　６４ビット整数(signed long long)
	AJCVMGT_REAL		,	//　倍精度浮動小数(double)
	AJCVMGT_STR			,	//　文字列
} AJCVMGTYPE, *PAJCVMGTYPE;

//--------------------------------------------------------------------------------------------------------------//
//	変数値（配列）へのポインタ																					//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef union {
		SIP		 pSI;		//	３２ビット整数
		SLLP	 pSLL;		//	６４ビット整数
		double	*pDBL;		//	実数
		BCP		*pStr;		//	文字列ポインタ
		VOP		vp;
} AJCVMGARRPA, *PAJCVMGARRPA;
typedef const AJCVMGARRPA *PCAJCVMGARRPA;
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef union {
		SIP		 pSI;		//	３２ビット整数
		SLLP	 pSLL;		//	６４ビット整数
		double	*pDBL;		//	実数
		WCP		*pStr;		//	文字列ポインタ
		VOP		vp;
} AJCVMGARRPW, *PAJCVMGARRPW;
typedef const AJCVMGARRPW *PCAJCVMGARRPW;
//--------------------------------------------------------------------------------------------------------------//
//	変数管理ノード																								//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	BCP			pName;		//	変数名（文字列）へのポインタ
	UI			att;		//	変数の属性（AJCVMGA_XXXXX)
	AJCVMGTYPE	type;		//	変数のタイプ
	UI			num;		//	変数（配列）要素数
	AJCVMGARRPA	arr;		//	変数値（ポインタ配列）
} AJCVMGNODEA, *PAJCVMGNODEA;
typedef const AJCVMGNODEA *PCAJCVMGNODEA;

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	WCP			pName;		//	変数名（文字列）へのポインタ
	UI			att;		//	変数の属性（AJCVMGA_XXXXX)
	AJCVMGTYPE	type;		//	変数のタイプ
	UI			num;		//	変数（配列）要素数
	AJCVMGARRPW	arr;		//	変数値（ポインタ配列）
} AJCVMGNODEW, *PAJCVMGNODEW;
typedef AJCVMGNODEW *PCAJCVMGNODEW;

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	UI			InstID;				//	インスタンスＩＤ
	HAJCAVL		hAvlVar;			//	変数管理用２分木
	UX			cbp;
	BOOL		(CALLBACK *cbNtcVar)(PCAJCVMGNODEA pVarInfo, UX cbp);
} AJCVMGA, *HAJCVMGA;

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	UI			InstID;				//	インスタンスＩＤ
	HAJCAVL		hAvlVar;			//	変数管理用２分木
	UX			cbp;
	BOOL		(CALLBACK *cbNtcVar)(PCAJCVMGNODEW pVarInfo, UX cbp);
} AJCVMGW, *HAJCVMGW;


//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT HAJCVMGA		WINAPI AjcVmgCreateA(VO);
AJCEXPORT HAJCVMGW		WINAPI AjcVmgCreateW(VO);

AJCEXPORT VO			WINAPI AjcVmgDeleteA(HAJCVMGA hVmg);
AJCEXPORT VO			WINAPI AjcVmgDeleteW(HAJCVMGW hVmg);

AJCEXPORT VO			WINAPI AjcVmgPurgeA(HAJCVMGA hVmg);
AJCEXPORT VO			WINAPI AjcVmgPurgeW(HAJCVMGW hVmg);

AJCEXPORT BOOL			WINAPI AjcVmgGenVarA(HAJCVMGA hVmg, C_BCP pVarName, AJCVMGTYPE type, UI num);
AJCEXPORT BOOL			WINAPI AjcVmgGenVarW(HAJCVMGW hVmg, C_WCP pVarName, AJCVMGTYPE type, UI num);

AJCEXPORT BOOL			WINAPI AjcVmgSetAttA(HAJCVMGA pW, C_BCP pVarName, UI att);
AJCEXPORT BOOL			WINAPI AjcVmgSetAttW(HAJCVMGA pW, C_WCP pVarName, UI att);

AJCEXPORT UI			WINAPI AjcVmgGetAttA(HAJCVMGA pW, C_BCP pVarName);
AJCEXPORT UI			WINAPI AjcVmgGetAttW(HAJCVMGA pW, C_WCP pVarName);

AJCEXPORT BOOL			WINAPI AjcVmgDelVarA(HAJCVMGA hVmg, C_BCP pVarName);
AJCEXPORT BOOL			WINAPI AjcVmgDelVarW(HAJCVMGW hVmg, C_WCP pVarName);

AJCEXPORT BOOL			WINAPI AjcVmgSetIntegerA(HAJCVMGA hVmg, C_BCP pVarName, UI ix, SLL value);
AJCEXPORT BOOL			WINAPI AjcVmgSetIntegerW(HAJCVMGW hVmg, C_WCP pVarName, UI ix, SLL value);

AJCEXPORT BOOL			WINAPI AjcVmgSetRealA	(HAJCVMGA hVmg, C_BCP pVarName, UI ix, double value);
AJCEXPORT BOOL			WINAPI AjcVmgSetRealW	(HAJCVMGW hVmg, C_WCP pVarName, UI ix, double value);

AJCEXPORT BOOL			WINAPI AjcVmgSetStringA	(HAJCVMGA hVmg, C_BCP pVarName, UI ix, C_BCP pStr);
AJCEXPORT BOOL			WINAPI AjcVmgSetStringW	(HAJCVMGW hVmg, C_WCP pVarName, UI ix, C_WCP pStr);

AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetInt32A	(HAJCVMGA hVmg, C_BCP pVarName, UI ix, SIP pValue);
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetInt32W	(HAJCVMGW hVmg, C_WCP pVarName, UI ix, SIP pValue);

AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetInt64A	(HAJCVMGA hVmg, C_BCP pVarName, UI ix, SLLP pValue);
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetInt64W	(HAJCVMGW hVmg, C_WCP pVarName, UI ix, SLLP pValue);

AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetRealA	(HAJCVMGA hVmg, C_BCP pVarName, UI ix, double *pValue);
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetRealW	(HAJCVMGW hVmg, C_WCP pVarName, UI ix, double *pValue);

AJCEXPORT C_BCP			WINAPI AjcVmgGetStringA	(HAJCVMGA hVmg, C_BCP pVarName, UI ix);
AJCEXPORT C_WCP			WINAPI AjcVmgGetStringW	(HAJCVMGW hVmg, C_WCP pVarName, UI ix);

AJCEXPORT BOOL			WINAPI AjcVmgSwapA(HAJCVMGA hVmg, C_BCP pVarName1, UI ix1, C_BCP pVarName2, UI ix2);
AJCEXPORT BOOL			WINAPI AjcVmgSwapW(HAJCVMGW hVmg, C_WCP pVarName1, UI ix1, C_WCP pVarName2, UI ix2);

AJCEXPORT UI			WINAPI AjcVmgGetArrNumA(HAJCVMGA hVmg, C_BCP pVarName);
AJCEXPORT UI			WINAPI AjcVmgGetArrNumW(HAJCVMGW hVmg, C_WCP pVarName);

AJCEXPORT PCAJCVMGNODEA	WINAPI AjcVmgGetNodeA(HAJCVMGA hVmg, C_BCP pVarName);
AJCEXPORT PCAJCVMGNODEW	WINAPI AjcVmgGetNodeW(HAJCVMGW hVmg, C_WCP pVarName);

AJCEXPORT UI 			WINAPI AjcVmgEnumVarA(HAJCVMGA hVmg, UX cbp, BOOL (CALLBACK *cbNtcVar)(PCAJCVMGNODEA pVarInfo, UX cbp));
AJCEXPORT UI 			WINAPI AjcVmgEnumVarW(HAJCVMGW hVmg, UX cbp, BOOL (CALLBACK *cbNtcVar)(PCAJCVMGNODEW pVarInfo, UX cbp));

AJCEXPORT BOOL			WINAPI AjcVmgCopyA(HAJCVMGA hVmgD, C_BCP pNameD, HAJCVMGA hVmgS, C_BCP pNameS);
AJCEXPORT BOOL			WINAPI AjcVmgCopyW(HAJCVMGW hVmgD, C_WCP pNameD, HAJCVMGW hVmgS, C_WCP pNameS);

/****************************************************************************************************************/
#endif
