﻿#ifndef	AJXAVS_H_
#define	AJXAVS_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	平衡２分木（文字列キー）																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義(ASCII)																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxAvs {
		BOOL	m_fUnicode;						//	UNICODE / ASCII 識別フラグ

	public:
		HAJCAVS	m_hAvs;							//	ＡＶＬインスタンスドハンドル
		BOOL	m_fDestruct;					//	デストラクト中を示すフラグ

		#ifdef UNICODE
			CAjxAvs(BOOL fUnicode = TRUE);		//	コンストラクタ(UNICODE)
		#else
			CAjxAvs(BOOL fUnicode = FALSE);		//	コンストラクタ(UNICODE)
		#endif
		~CAjxAvs();								//	デストラクタ

		BOOL	EnableMultiThread	(BOOL fEnable);								//	マルチスレッドの許可／禁止

		//----- ノードアクセス ---------------------------------------------------------------------------------//
		BOOL	InsNode				(C_BCP key, C_VOP pNodeData, UI len);		//	ノード挿入(ASCII)
		BOOL	InsNode				(C_WCP key, C_VOP pNodeData, UI len);		//	ノード挿入(UNICODE)

		int		GetNode				(C_BCP key, VOP   pBuf,	  UI lBuf);			//	ノード取得(ASCII)
		int		GetNode				(C_WCP key, VOP   pBuf,	  UI lBuf);			//	ノード取得(UNICODE)

		VOP		GetNodePtr			(C_BCP	key, UIP pLen = NULL);				//	ノードアドレス取得(ASCII)
		VOP		GetNodePtr			(C_WCP	key, UIP pLen = NULL);				//	ノードアドレス取得(UNICODE)

		BOOL	RepNode				(C_BCP key, C_VOP pNodeData, UI len);		//	ノード置換(ASCII)
		BOOL	RepNode				(C_WCP key, C_VOP pNodeData, UI len);		//	ノード置換(UNICODE)

		BOOL	InsOrRepNode		(C_BCP key, C_VOP pNodeData, UI len);		//	ノード挿入／置換(ASCII)
		BOOL	InsOrRepNode		(C_WCP key, C_VOP pNodeData, UI len);		//	ノード挿入／置換(UNICODE)

		BOOL	DelNode				(C_BCP key);								//	ノード削除(ASCII)
		BOOL	DelNode				(C_WCP key);								//	ノード削除(UNICODE)

		BOOL	DelAllNodes			();											//	全ノードを削除

		//----- その他 -----------------------------------------------------------------------------------------//
		UI		GetCount			();															//	ノード数取得
		UI		EnumNodes			(BOOL fDownSeq = FALSE);									//	全ノードのシーケンシャルな読み出し

		BOOL	CreatePtrArr	(PCAJCAVSPTRA *ppArr, UIP pNum = NULL, BOOL fDownSeq = FALSE);	//	全ノードへのポインタ配列生成(ASCII)
		BOOL	CreatePtrArr	(PCAJCAVSPTRW *ppArr, UIP pNum = NULL, BOOL fDownSeq = FALSE);	//	全ノードへのポインタ配列生成(UNICODE)

		BOOL		ReleasePtrArr	(PCAJCAVSPTRA pArr);										//	全ノードへのポインタ配列解放(ASCII)
		BOOL		ReleasePtrArr	(PCAJCAVSPTRW pArr);										//	全ノードへのポインタ配列解放(UNICODE)

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual VO	 OnNtcRemove	(C_BCP key, VOP pNodeData, UI len, UI nest);	//	ノード削除通知(ASCII)
		virtual VO	 OnNtcRemove	(C_WCP key, VOP pNodeData, UI len, UI nest);	//	ノード削除通知(UNICODE)

		virtual BOOL OnNtcNode		(C_BCP key, VOP pNodeData, UI len, UI nest);	//	ノード読み出し通知(ASCII)
		virtual BOOL OnNtcNode		(C_WCP key, VOP pNodeData, UI len, UI nest);	//	ノード読み出し通知(UNICODE)
	};
}

/****************************************************************************************************************/
#endif
