﻿#ifndef	AJXCTRL_H_
#define	AJXCTRL_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ダイアログボックス	（コントロールのアクセス）																//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT SAjxCtrl {
public:
		//----- コントロールアクセス ---------------------------------------------------------------------------//
		static UI		GetCtrlUInt					(HWND hCtrl);										//	コントロールの取得（符号なし整数）
		static SI		GetCtrlSInt					(HWND hCtrl);										//	コントロールの取得（符号付き整数）
		static UI		GetCtrlHex					(HWND hCtrl);										//	コントロールの取得（１６進整数）
		static double	GetCtrlReal					(HWND hCtrl);										//	コントロールの取得（実数）
		static ULL		GetCtrlUI64					(HWND hCtrl);										//	コントロールの取得（符号なし長整数）
		static SLL		GetCtrlSI64					(HWND hCtrl);										//	コントロールの取得（符号付き長整数）
		static ULL		GetCtrlH64					(HWND hCtrl);										//	コントロールの取得（１６進長整数）
		static UI		GetCtrlChk					(HWND hCtrl);										//	コントロールの取得（チェックボックス）
		static UI		GetCtrlStr					(HWND hCtrl, BCP   pBuf, UI lBuf);					//	コントロールの取得（文字列, ASCII）
		static UI		GetCtrlStr					(HWND hCtrl, WCP   pBuf, UI lBuf);					//	コントロールの取得（文字列,UNICODE）

	#ifdef UNICODE
		static UI		GetCtrlStrLen				(HWND hCtrl, BOOL fUnicode = TRUE);					//	コントロールの取得（文字列長, UNICODE）
	#else
		static UI		GetCtrlStrLen				(HWND hCtrl, BOOL fUnicode = FALSE);				//	コントロールの取得（文字列長, ASCII）
	#endif

		static int	 	GetCtrlSldPos				(HWND hCtrl);										//	コントロールの取得（スライダの位置）
		static UI		GetCtrlCboIx				(HWND hCtrl);										//	コントロールの取得（コンボボックス・インデクス）
		static UI		GetCtrlCboCount				(HWND hCtrl);										//	コントロールの取得（コンボボックス・項目数）

	#ifdef UNICODE
		static UI		GetCtrlCboLen				(HWND hCtrl, UI ix, BOOL fUnicode = TRUE);			//	コントロールの取得（コンボボックス・文字長, UNICODE）
	#else
		static UI		GetCtrlCboLen				(HWND hCtrl, UI ix, BOOL fUnicode = FALSE);			//	コントロールの取得（コンボボックス・文字長, ASCII）
	#endif

		static UI		GetCtrlCboItem				(HWND hCtrl, UI ix, BCP pBuf, UI lBuf);				//	コントロールの取得（コンボボックス・項目の文字列, ASCII）
		static UI		GetCtrlCboItem				(HWND hCtrl, UI ix, WCP pBuf, UI lBuf);				//	コントロールの取得（コンボボックス・項目の文字列, UNICODE）
		static SX		GetCtrlCboData				(HWND hCtrl, UI ix);								//	コントロールの取得（コンボボックス・データ値）
		static UI		GetCtrlCboFind				(HWND hCtrl, UI ix, C_BCP pStr, UI flag = AJCCBF_ALL);	//	コントロールの取得（コンボボックス・文字列検索, ASCII）
		static UI		GetCtrlCboFind				(HWND hCtrl, UI ix, C_WCP pStr, UI flag = AJCCBF_ALL);	//	コントロールの取得（コンボボックス・文字列検索, UNICODE）

	#ifdef UNICODE
		static UI		GetCtrlCboMaxLen			(HWND hCtrl, BOOL fUnicode = TRUE);					//	コントロールの取得（コンボボックス・項目群のの最大文字列長, UNICODE）
	#else
		static UI		GetCtrlCboMaxLen			(HWND hCtrl, BOOL fUnicode = FALSE);				//	コントロールの取得（コンボボックス・項目群のの最大文字列長, ASCII）
	#endif

		static BOOL		SetCtrlUInt					(HWND hCtrl, UI 	value);							//	コントロールの設定（符号なし整数）
		static BOOL 	SetCtrlSInt					(HWND hCtrl, SI 	value);							//	コントロールの設定（符号付き整数）
		static BOOL 	SetCtrlHex					(HWND hCtrl, UI 	value);							//	コントロールの設定（１６進整数）
		static BOOL 	SetCtrlReal					(HWND hCtrl, double value, int prec);				//	コントロールの設定（実数）
		static BOOL 	SetCtrlUI64					(HWND hCtrl, ULL	value);							//	コントロールの設定（符号なし長整数）
		static BOOL 	SetCtrlSI64					(HWND hCtrl, SLL	value);							//	コントロールの設定（符号付き長整数）
		static BOOL 	SetCtrlH64					(HWND hCtrl, ULL	value);							//	コントロールの設定（１６進長整数）
		static BOOL 	SepCtrlUInt					(HWND hCtrl, UI 	value);							//	コントロールの設定（符号なし整数，	３桁区切り）
		static BOOL 	SepCtrlSInt					(HWND hCtrl, SI 	value);							//	コントロールの設定（符号付き整数，	３桁区切り）
		static BOOL 	SepCtrlHex					(HWND hCtrl, UI 	value, int col );				//	コントロールの設定（１６進整数	，	桁数指定）
		static BOOL 	SepCtrlReal					(HWND hCtrl, double value, int prec);				//	コントロールの設定（実数，		  ３桁区切り）
		static BOOL 	SepCtrlUI64					(HWND hCtrl, ULL	value);							//	コントロールの設定（符号なし長整数，３桁区切り）
		static BOOL 	SepCtrlSI64					(HWND hCtrl, SLL	value);							//	コントロールの設定（符号付き長整数，３桁区切り）
		static BOOL 	SepCtrlH64					(HWND hCtrl, ULL	value, int col);				//	コントロールの設定（１６進長整数	，桁数指定）
		static BOOL	SetCtrlChk					(HWND hCtrl, UI state);									//	コントロールの設定（チェックボックス）
		static BOOL	SetCtrlRbt					(HWND hCtrl, int idFirst, int idLast);					//	コントロールの設定（ラジオボタン）
		static BOOL	SetCtrlStr					(HWND hCtrl, C_BCP pStr);								//	コントロールの設定（文字列, ASCII）
		static BOOL	SetCtrlStr					(HWND hCtrl, C_WCP pStr);								//	コントロールの設定（文字列, UNICODE）
		static BOOL	SetCtrlFStr					(HWND hCtrl, C_BCP pFmt, ...);							//	コントロールの設定（書式文字列, ASCII）
		static BOOL	SetCtrlFStr					(HWND hCtrl, C_WCP pFmt, ...);							//	コントロールの設定（書式文字列, ASCII）

	#ifdef UNICODE
		static BOOL	SetCtrlEdtLimit				(HWND hCtrl, UI limit, BOOL fUnicode = TRUE);			//	コントロールの設定（エディットコントロールの桁数, UNICODE）
	#else
		static BOOL	SetCtrlEdtLimit				(HWND hCtrl, UI limit, BOOL fUnicode = FALSE);			//	コントロールの設定（エディットコントロールの桁数, ASCII）
	#endif

		static BOOL	SetCtrlCboIx				(HWND hCtrl, UI ix);									//	コントロールの設定（コンボボックス・インデクス）
		static UI		SetCtrlCboAdd				(HWND hCtrl, UI ix, C_BCP pItem, UI flag);			//	コントロールの設定（コンボボックス・項目の文字列, ASCII）
		static UI		SetCtrlCboAdd				(HWND hCtrl, UI ix, C_WCP pItem, UI flag);			//	コントロールの設定（コンボボックス・項目の文字列, UNICODE）
		static UI		SetCtrlCboIns				(HWND hCtrl, UI ix, C_BCP pItem, UI flag);			//	コントロールの設定（コンボボックス・項目挿入, ASCII）
		static UI		SetCtrlCboIns				(HWND hCtrl, UI ix, C_WCP pItem, UI flag);			//	コントロールの設定（コンボボックス・項目挿入, UNICODE）
		static BOOL	SetCtrlCboDel				(HWND hCtrl, UI ix);									//	コントロールの設定（コンボボックス・項目削除）
		static BOOL	SetCtrlCboData				(HWND hCtrl, UI ix, SX data);							//	コントロールの設定（コンボボックス・データ値）
		static BOOL	SetCtrlCboList				(HWND hCtrl, C_BCP pList);								//	コントロールの設定（コンボボックス・項目リスト, ASCII）
		static BOOL	SetCtrlCboList				(HWND hCtrl, C_WCP pList);								//	コントロールの設定（コンボボックス・項目リスト, UNICODE）

	#ifdef UNICODE
		static BOOL	SetCtrlCboLimit				(HWND hCtrl, UI limit, BOOL fUnicode = TRUE);			//	コントロールの設定（コンボボックス・入力可能文字数, UNICODE）
	#else
		static BOOL	SetCtrlCboLimit				(HWND hCtrl, UI limit, BOOL fUnicode = FALSE);			//	コントロールの設定（コンボボックス・入力可能文字数, ASCII）
	#endif

		static BOOL	SetCtrlCboReset				(HWND hCtrl);											//	コントロールの設定（コンボボックス・リセット）
		static BOOL	SetCtrlPgsRange				(HWND hCtrl, int low, int high);						//	コントロールの設定（プログレスバーのレンジ）
		static BOOL	SetCtrlPgsPos				(HWND hCtrl, int pos);									//	コントロールの設定（プログレスバーの位置）
		static BOOL	SetCtrlSldRange				(HWND hCtrl, int low, int high, int page);				//	コントロールの設定（スライダのレンジ）
		static BOOL	SetCtrlSldPos				(HWND hCtrl, int pos);									//	コントロールの設定（スライダの位置）
		static BOOL	SetCtrlSpnInfo 				(HWND hCtrl, int low, int high, HWND hBuddy);			//	コントロールの設定（スピンボタンのレンジとバディウインド
		static BOOL	SetCtrlSpnRange				(HWND hCtrl, int low, int high);						//	コントロールの設定（スピンボタンのレンジ
		static BOOL	SetCtrlSpnBuddy				(HWND hCtrl, HWND hBuddy);								//	コントロールの設定（スピンボタンのバディウインド

		static HWND	SetCtrlTopMostInSiblings	(HWND hCtrl);											//	コントロールを兄弟ウインド中で再前面に設定する
		static HWND	SetCtrllBackMostInSiblings	(HWND hCtrl);											//	コントロールを兄弟ウインド中で再背面に設定する
		static BOOL	EnableCtrlToDrop			(HWND hCtrl, UI optDrop = AJCDROP_DIR_AND_FILE);		//	EDITコントロールにフォルダ／ファイルをドロップ可能にする（拡張）

		//----- コントロールのグレィ設定／表示／移動 -----------------------------------------------------------//
		static BOOL	EnableCtrl					(HWND hCtrl, BOOL fEnable);								//	コントロールの有効化／無効化
		static BOOL	EnableGroup					(HWND hCtrl, BOOL fEnaGrpBox, BOOL fEnaCtrls);			//	グループボックス内の全コントロール有効化／無効化
		static BOOL	ShowGroup					(HWND hCtrl, BOOL fShow);								//	グループボックスとグループボックス内の全コントロール表示／非表示
		static BOOL	ShowGroup					(HWND hCtrl, BOOL fShowGrpBox, BOOL fShowCtrls);		//	グループボックスやグループボックス内の全コントロール表示／非表示（拡張）
		static BOOL	MoveGroupToLoc				(HWND hCtrl, int x, int y);								//	グループボックスとグループボックス内の全コントロールを指定位置へ移動
		static BOOL	MoveGroupToCtl				(HWND hCtrl, HWND hctl);								//	グループボックスとグループボックス内の全コントロールを指定コントロールの位置へ移動
		static BOOL	MoveGroupToOrg				(HWND hCtrl);											//	グループボックスとグループボックス内の全コントロールを移動前の位置に戻す

		//----- コントロールの永続化 ---------------------------------------------------------------------------//
		static BOOL	DelAllCtrlPermAtt			(HWND hWnd);												//	全コントロールの永続化属性解除
		static BOOL	LoadAllControlSettings		(HWND hWnd, C_BCP pSect, UI act = AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCALL);	//	全コントロールの設定内容の読み出し(ASCII)
		static BOOL	LoadAllControlSettings		(HWND hWnd, C_WCP pSect, UI act = AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCALL);	//	全コントロールの設定内容の読み出し(UNICODE)
		static BOOL	SaveAllControlSettings		(HWND hWnd);												//	全コントロールの設定内容の書き込み

		static BOOL	CtrlSetPermAtt				(HWND hCtrl, UI att);										//	各コントロールの永続化属性の設定
		static BOOL	CtrlLoadTextBox				(HWND hCtrl, C_BCP pSect, BOOL fExcRdOnly = TRUE);			//	テキストボックスの読み出し(読出専用の動作を指定, ASCII)
		static BOOL	CtrlLoadTextBox				(HWND hCtrl, C_WCP pSect, BOOL fExcRdOnly = TRUE);			//	テキストボックスの読み出し(読出専用の動作を指定, UNICODE)
		static BOOL	CtrlSaveTextBox				(HWND hCtrl, C_BCP pSect, BOOL fExcRdOnly = TRUE);			//	テキストボックスの書き込み(読出専用の動作を指定, ASCII)
		static BOOL	CtrlSaveTextBox				(HWND hCtrl, C_WCP pSect, BOOL fExcRdOnly = TRUE);			//	テキストボックスの書き込み(読出専用の動作を指定, UNICODE)
		static BOOL	CtrlLoadChkBox				(HWND hCtrl, C_BCP pSect, BOOL fNtc = FALSE);				//	チェックボックス／ラジオボタンの読み出し(ASCII)
		static BOOL	CtrlLoadChkBox				(HWND hCtrl, C_WCP pSect, BOOL fNtc = FALSE);				//	チェックボックス／ラジオボタンの読み出し(UNICODE)
		static BOOL	CtrlSaveChkBox				(HWND hCtrl, C_BCP pSect);									//	チェックボックス／ラジオボタンの書き込み(ASCII)
		static BOOL	CtrlSaveChkBox				(HWND hCtrl, C_WCP pSect);									//	チェックボックス／ラジオボタンの書き込み(UNICODE)

		static BOOL	CtrlLoadComboBox			(HWND hCtrl, C_BCP pSect, UI sel = 0, BOOL fNtc = FALSE);	//	コンボボックスの読み出し(ASCII)
		static BOOL	CtrlLoadComboBox			(HWND hCtrl, C_WCP pSect, UI sel = 0, BOOL fNtc = FALSE);	//	コンボボックスの読み出し(UNICODE)
		static BOOL	CtrlSaveComboBox			(HWND hCtrl, C_BCP pSect, UI sel = 0);						//	コンボボックスの書き込み(ASCII)
		static BOOL	CtrlSaveComboBox			(HWND hCtrl, C_WCP pSect, UI sel = 0);						//	コンボボックスの書き込み(UNICODE)
		static BOOL	CtrlLoadListBox				(HWND hCtrl, C_BCP pSect, UI sel = 0);						//	リストボックスの読み出し(ASCII)
		static BOOL	CtrlLoadListBox				(HWND hCtrl, C_WCP pSect, UI sel = 0);						//	リストボックスの読み出し(UNICODE)
		static BOOL	CtrlSaveListBox				(HWND hCtrl, C_BCP pSect, UI sel = 0);						//	リストボックスの書き込み(ASCII)
		static BOOL	CtrlSaveListBox				(HWND hCtrl, C_WCP pSect, UI sel = 0);						//	リストボックスの書き込み(UNICODE)
	};
}
/****************************************************************************************************************/
#endif
