﻿#ifndef	AJXFILE_H_
#define	AJXFILE_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	テキストファイルアクセス コントロール																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxFile {
		HAJCFILE	m_hFile;			//	ファイルハンドル
		UI			m_BufLen;			//	書式文字列バッファ長
		BOOL		m_fUnicode;			//	UNICODE/ASCII識別
	public:

		#ifdef UNICODE
			CAjxFile(BOOL fUnicode = TRUE);		//	コンストラクタ(UNICODE)
		#else
			CAjxFile(BOOL fUnicode = FALSE);	//	コンストラクタ(ASCII)
		#endif
		~CAjxFile();					//	デストラクタ

		//	テキストファイル入力
		BOOL		FOpen	(C_BCP pPath, EAJCTEC tec = AJCTEC_AUTO);								//	入力テキストファイルオープン(ASCII)
		BOOL		FOpen	(C_WCP pPath, EAJCTEC tec = AJCTEC_AUTO);								//	入力テキストファイルオープン(UNICODE)

		BOOL		FOpenShare(C_BCP pPath, EAJCTEC tec = AJCTEC_AUTO, UI share = FILE_SHARE_READ | FILE_SHARE_WRITE);	//	入力テキストファイルオープン(ASCII	, 共有設定)
		BOOL		FOpenShare(C_WCP pPath, EAJCTEC tec = AJCTEC_AUTO, UI share = FILE_SHARE_READ | FILE_SHARE_WRITE);	//	入力テキストファイルオープン(UNICODE, 共有設定)

		BOOL		FAttachOpened(HANDLE hFile, EAJCTEC tec);										//	オープン済ファイルのハンドルを使用してインスタンス生成

		BCP			FGetS	(BCP pBuf, UI lBuf);													//	文字列入力(ASCII)
		WCP			FGetS	(WCP pBuf, UI lBuf);													//	文字列入力(UNICODE)

		UI			FGetC	();																		//	１文字入力(ASCII/UNICODE兼用)
		BC			FGetCA	();																		//	１文字入力(ASCII)
		WC			FGetCW	();																		//	１文字入力(UNICODE)

		ULL			FSavePoint();																	//	ファイル読み出しポイント退避
		BOOL		FRecvPoint();																	//	ファイル読み出しポイント回復

		BOOL		FEof	();																		//	入力ファイルのＥＯＦチェック


		//	テキストファイル出力
		BOOL		FCreate	(C_BCP pPath, EAJCTEC tec = AJCTEC_AUTO, BOOL fBOM = FALSE);			//	出力テキストファイル生成(ASCII)
		BOOL		FCreate	(C_WCP pPath, EAJCTEC tec = AJCTEC_AUTO, BOOL fBOM = FALSE);			//	出力テキストファイル生成(UNICODE)

		BOOL		FCreateShare(C_BCP pPath, EAJCTEC tec = AJCTEC_AUTO, BOOL fBOM = FALSE, UI share = FILE_SHARE_READ | FILE_SHARE_WRITE);	//	出力テキストファイル生成(ASCII)
		BOOL		FCreateShare(C_WCP pPath, EAJCTEC tec = AJCTEC_AUTO, BOOL fBOM = FALSE, UI share = FILE_SHARE_READ | FILE_SHARE_WRITE);	//	出力テキストファイル生成(UNICODE)

		BOOL		FAppend	(C_BCP pPath, EAJCTEC tec = AJCTEC_AUTO, BOOL fBOM = FALSE);			//	出力テキストファイル追記(ASCII)
		BOOL		FAppend	(C_WCP pPath, EAJCTEC tec = AJCTEC_AUTO, BOOL fBOM = FALSE);			//	出力テキストファイル追記(UNICODE)

		BOOL		FAppendShare(C_BCP pPath, EAJCTEC tec = AJCTEC_AUTO, BOOL fBOM = FALSE, UI share = FILE_SHARE_READ | FILE_SHARE_WRITE);	//	出力テキストファイル追記(ASCII)
		BOOL		FAppendShare(C_WCP pPath, EAJCTEC tec = AJCTEC_AUTO, BOOL fBOM = FALSE, UI share = FILE_SHARE_READ | FILE_SHARE_WRITE);	//	出力テキストファイル追記(UNICODE)

		BOOL		FAttachCreated(HANDLE hFile, EAJCTEC tec, BOOL fBOM);							//	生成済ファイルのハンドルを使用してインスタンス生成

		BOOL		FPutS	(C_BCP pText, UI lText = -1);											//	文字列出力(ASCII)
		BOOL		FPutS	(C_WCP pText, UI lText = -1);											//	文字列出力(UNICODE)

		BOOL		FPutC	(BC c);																	//	１文字出力(ASCII)
		BOOL		FPutC	(WC c);																	//	１文字出力(UNICODE)

		BOOL		FPrintF	(C_BCP pFmt, ...);														//	書式文字列出力(ASCII)
		BOOL		FPrintF	(C_WCP pFmt, ...);														//	書式文字列出力(UNICODE)

		BOOL		FVPrintF(C_BCP pFmt, va_list vls);												//	書式文字列出力(可変個パラメタのポインタ指定, ASCII)
		BOOL		FVPrintF(C_WCP pFmt, va_list vls);												//	書式文字列出力(可変個パラメタのポインタ指定, UNICODE)

		BOOL		FFlush	();																		//	テキスト出力ファイルのフラッシュ

		//	その他
		BOOL		FClose	();																		//	テキストファイルクローズ

		BOOL		FDetach	();																		//	テキストファイルをクローズしないでインスタンス解放

		EAJCTEC		FGetTec	();																		//	テキストエンコード種別取得

		BOOL		FGetBOM();																		//	入力ファイルのＢＯＭ有無の取得

		BOOL		FIsActive();																	//	ファイルオープン／生成状態かチェック

		BOOL		FIsModeInput();																	//	入出力モード取得

		BOOL		FSetFmtLen	(UI len);															//	書式文字列バッファ長設定

		HANDLE		FGetFileHandle();																//	ファイルハンドル取得
	};
}
/****************************************************************************************************************/
#endif
