﻿#ifndef	AJXG2D_H_
#define	AJXG2D_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	２Ｄグラフィック コントロール																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxG2d {
	public:
		HWND	m_hCtrl;				//	自コントロールのウインドハンドル

		CAjxG2d();						//	コンストラクタ
		~CAjxG2d();						//	デストラクタ

		//----- ２Ｄファンクション -----------------------------------------------------------------------------//
		BOOL	Init				(double x1, double y1, double x2, double y2, UI style = AJC3DGS_2DMODE);		//	２Ｄグラフモード初期化
		BOOL	Init				(PCAJC2DVEC pLo, PCAJC2DVEC pHi, UI style = AJC3DGS_2DMODE);					//	２Ｄグラフモード初期化（ベクトル指定）
		BOOL	SetPlane			(AJCG2DAXIS_DIR HoriAxis, AJCG2DAXIS_DIR VertAxis);								//	平面アングル設定
		BOOL	SetProp				(PCAJC2DGPROP pProp);															//	プロパティ設定
		BOOL	GetProp				(PAJC2DGPROP	pBuf);															//	プロパティ取得

		BOOL	AdjustRange			();																				//	レンジ自動調整
		BOOL	SetRange			(double x1, double y1, double x2, double y2);									//	各軸のレンジ設定
		BOOL	SetCenter			(double xc, double yc);															//	各軸の中心位置設定
		BOOL	SetWidth			(double xr, double yr);															//	各軸の幅（半径）設定
		BOOL	SetSameRangeWidth	();																				//	各軸のレンジ幅を同じにする
		BOOL	SetFixedAspect		(BOOL fFixed);																	//	レンジ設定された領域のアスペクトを１にする

		BOOL	SetColor			(UI id, COLORREF rgb);															//	表示色設定
		BOOL	SetPlotNumber		(UI id, UI PlotNumber);															//	プロットデータ数設定
		BOOL	SetPlotSize			(UI id, UI PixelSize, UI PixelSizeE);											//	プロットデータのピクセルサイズ設定

		BOOL	PutPlotData			(UI id, double x, double y);													//	プロットデータ投与
		BOOL	PutPlotData			(UI id, PCAJC2DVEC pPoint);														//	プロットデータ投与（ベクトル指定）

		HBITMAP	GetBitmap			();																				//	ビットマップデータ取得

		BOOL	LoadProp			(C_BCP pProfileSect =  "G2dProp", PCAJC2DGPROP pDefProp = NULL);				//	プロファイルからプロパティ値読出し(ASCII)
		BOOL	LoadProp			(C_WCP pProfileSect = L"G2dProp", PCAJC2DGPROP pDefProp = NULL);				//	プロファイルからプロパティ値読出し(UNICODE)
 
		BOOL	SaveProp	 		(C_BCP pProfileSect =  "G2dProp");												//	プロファイルへプロパティ値書き込み(ASCII)
		BOOL	SaveProp 			(C_WCP pProfileSect = L"G2dProp");												//	プロファイルへプロパティ値書き込み(UNICODE)

		BOOL	LoadPropEx			(C_BCP pProfileSect =  "G2dProp", PCAJC2DGPROP pDefProp = NULL);				//	プロファイルから詳細プロパティ値読出し(ASCII)
		BOOL	LoadPropEx			(C_WCP pProfileSect = L"G2dProp", PCAJC2DGPROP pDefProp = NULL);				//	プロファイルから詳細プロパティ値読出し(UNICODE)

		BOOL	SavePropEx			(C_BCP pProfileSect =  "G2dProp");												//	プロファイルへ詳細プロパティ値書き込み(ASCII)
		BOOL	SavePropEx			(C_WCP pProfileSect = L"G2dProp");												//	プロファイルへ詳細プロパティ値書き込み(UNICODE)

		BOOL	FillB  				(UI id, UI idBorder, double x, double y);										//	ボーダー色で囲まれた部分の塗りつぶし
		BOOL	FillB				(UI id, UI idBorder, PCAJC2DVEC pPoint);										//	ボーダー色で囲まれた部分の塗りつぶし（ベクトル指定）

		BOOL	FillS				(UI id, double x, double y);													//	連続する白色部分の塗りつぶし
		BOOL	FillS				(UI id, PCAJC2DVEC pPoint);														//	連続する白色部分の塗りつぶし（ベクトル指定）

		COLORREF GetPixel			(double x, double y);															//	ピクセルの表示色取得
		COLORREF GetPixel			(PCAJC2DVEC pPoint);															//	ピクセルの表示色取得（ベクトル指定）

		HFONT	SetTextFont			(HFONT hFont);																	//	テキスト描画フォント設定

		UI		TextOut				(int x, int y, C_BCP pTxt);														//	テキスト描画（ピクセル位置指定）(ASCII)
		UI		TextOut				(int x, int y, C_WCP pTxt);														//	テキスト描画（ピクセル位置指定）(UNICODE)

		UI		PrintF				(int x, int y, C_BCP pFmt, ...);												//	書式テキスト描画（ピクセル位置指定）(ASCII)	
		UI		PrintF				(int x, int y, C_WCP pFmt, ...);												//	書式テキスト描画（ピクセル位置指定）(UNICODE)

		UI		TextOutV			(AJCG2DTXOMD md, PCAJC2DVEC pV, C_BCP pTxt);									//	テキスト描画（３Ｄ座標指定）(ASCII)
		UI		TextOutV			(AJCG2DTXOMD md, PCAJC2DVEC pV, C_WCP pTxt);									//	テキスト描画（３Ｄ座標指定）(UNICODE)

		UI		PrintFV				(AJCG2DTXOMD md, PCAJC2DVEC pV, C_BCP pFmt, ...);								//	書式テキスト描画（３Ｄ座標指定）(ASCII)	
		UI		PrintFV				(AJCG2DTXOMD md, PCAJC2DVEC pV, C_WCP pFmt, ...);								//	書式テキスト描画（３Ｄ座標指定）(UNICODE)

		UI		GetText				(UI key, BCP pBuf, UI lBuf);													//	描画テキスト取得(ASCII)	
		UI		GetText				(UI key, WCP pBuf, UI lBuf);													//	描画テキスト取得(UNICODE)

		BOOL	ClearShape			(UI id);																		//	図形描画データクリアー
		BOOL	ClearShape			();																				//	全ての図形描画データクリアー
		BOOL	ClearPlot			(UI id);																		//	プロットデータクリアー
		BOOL	ClearPlot			();																				//	全てのプロットデータクリアー
		BOOL	ClearText			(UI key);																		//	描画テキストクリアー
		BOOL	ClearText			();																				//	全ての描画テキストクリアー

		//----- 平面描画ファンクション（２Ｄ／３Ｄ共通） -------------------------------------------------------//
		BOOL	Pixel 				(UI id, double x, double y, UI PixelSize);										//	平面にピクセル描画
		BOOL	Pixel 				(UI id, PCAJC2DVEC pPoint, UI PixelSize);										//	平面にピクセル描画（ベクトル指定）

		BOOL	Line				(UI id, double x1, double y1, double x2, double y2);							//	平面にライン描画
		BOOL	Line				(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);											//	平面にライン描画（ベクトル指定）

		BOOL	MoveTo				(UI id, double x, double y);													//	平面に描画するライン／矢印の始点設定
		BOOL	MoveTo				(UI id, PCAJC2DVEC ps);															//	平面に描画するライン／矢印の始点設定（ベクトル指定）

		BOOL	LineTo				(UI id, double x, double y);													//	終点を指定し平面にライン描画
		BOOL	LineTo				(UI id, PCAJC2DVEC pe);															//	終点を指定し平面にライン描画（ベクトル指定）

		BOOL	Arrow				(UI id, double x1, double y1, double x2, double y2);							//	平面に矢印描画
		BOOL	Arrow				(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);											//	平面に矢印描画（ベクトル指定）

		BOOL	ArrowTo				(UI id, double x, double y);													//	終点を指定し平面に矢印描画
		BOOL	ArrowTo				(UI id, PCAJC2DVEC pe);															//	終点を指定し平面に矢印描画（ベクトル指定）

		BOOL	Triangle			(UI id, double x1, double y1, double x2, double y2, double x3, double y3);		//	平面に三角形描画
		BOOL	Triangle			(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3);							//	平面に三角形描画（ベクトル指定）

		BOOL	Square				(UI id, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4);	//	平面に四角形描画
		BOOL	Square				(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3, PCAJC2DVEC p4);								//	平面に四角形描画（ベクトル指定）

		BOOL	Rectangle			(UI id, double x1, double y1, double x2, double y2);												//	平面に長方形描画
		BOOL	Rectangle			(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);																//	平面に長方形描画（ベクトル指定）

		BOOL	Ellipse				(UI id, double xc, double yc, double rx, double ry);												//	平面に円／楕円描画
		BOOL	Ellipse				(UI id, PCAJC2DVEC pCent, double rx, double ry);													//	平面に円／楕円描画（ベクトル指定）

		BOOL	Star				(UI id, double xc, double yc, double r1, double r2=0.0, UI nVtx=5, double rot= 0.0, BOOL fInLine= FALSE); // 平面に星形描画
		BOOL	Star				(UI id, PCAJC2DVEC pCent    , double r1, double r2=0.0, UI nVtx=5, double rot= 0.0, BOOL fInLine= FALSE); // 平面に星形描画（ベクトル指定）

		//----- ２Ｄ／３Ｄ共通ファンクション -------------------------------------------------------------------//
		BOOL	EnablePopupMenu		(BOOL fEnable);																	//	右クリックによるポップアップメニューの許可／禁止
		BOOL	SetNtcRClk			(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);										//	右クリック通知設定

		BOOL	SetTipText			(C_BCP pTxt);																	//	ツールチップの設定(ASCII)
		BOOL	SetTipText			(C_WCP pTxt);																	//	ツールチップの設定(UNICODE)

		UI		GetTipText			(BCP pBuf, UI lBuf);															//	ツールチップの取得(ASCII)
		UI		GetTipText			(WCP pBuf, UI lBuf);															//	ツールチップの取得(UNICODE)

		BOOL	SetChkBoxTipText	(UI n, C_BCP pTxt);																//	フィルタ・チェックボックス・ツールチップの設定(ASCII)
		BOOL	SetChkBoxTipText	(UI n, C_WCP pTxt);																//	フィルタ・チェックボックス・ツールチップの設定(UNICODE)

		UI		GetChkBoxTipText	(UI n, BCP pBuf, UI lBuf);														//	フィルタ・チェックボックス・ツールチップの取得(ASCII)
		UI		GetChkBoxTipText	(UI n, WCP pBuf, UI lBuf);														//	フィルタ・チェックボックス・ツールチップの取得(UNICODE)

		BOOL	SetTipShowAlways	(BOOL fShowAlways);																//	ツールチップ表示条件の設定
		BOOL	GetTipShowAlways	();																				//	ツールチップ表示条件の取得

		BOOL	SetChkBoxTipShowAlways(UI n, BOOL fShowAlways);														//	フィルタ・チェックボックス・ツールチップの設定
		BOOL	GetChkBoxTipShowAlways(UI n);																		//	フィルタ・チェックボックス・ツールチップの取得

		BOOL	SetTipShowAlwaysAll	(BOOL fShowAlways);																//	全ツールチップ表示条件の設定

		BOOL	SetFilter 			(UI n, BOOL state);																//	フィルタの設定
		BOOL	GetFilter 			(UI n);																			//	フィルタの取得

		BOOL	GetDroppedFile		(BC buf[MAX_PATH]);																//	ドロップされたファイル名取得(ASCII)
		BOOL	GetDroppedFile 		(WC buf[MAX_PATH]);																//	ドロップされたファイル名取得(UNICODE)

		BOOL	GetDroppedDir		(BC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);								//	ドロップされたディレクトリ名取得(ASCII)
		BOOL	GetDroppedDir		(WC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);								//	ドロップされたディレクトリ名取得(UNICODE)

		BOOL	SetTitleText		(C_BCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(ASCII)
		BOOL	SetTitleText		(C_WCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(UNICODE)

		BOOL	Pause				(BOOL fPause);																	//	画面表示の停止／再開

		BOOL	EnableMesDraw		(BOOL fEnable);																	//	描画時間計測情報の許可／禁止

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO		Attach					(HWND hWnd);				//	ハンドルを関連付け

		virtual	VO		OnNtcPlotList(PCAJC3DGPLOTLIST pList);				//	プロットリスト通知
		virtual	VO		OnNtcClear	 (int Factor);							//	データクリアー通知
		virtual	VO		OnNtcDblClk  ();									//	ダブルクリック通知
		virtual	VO		OnNtcDropFile(UI n);								//	ファイルドロップ通知
		virtual	VO		OnNtcDropDir (UI n);								//	フォルダドロップ通知
		virtual	VO		OnNtcRClick  (PCAJC3DGRCLK pRClk);					//	右クリック通知
	};
}
/****************************************************************************************************************/
#endif
