﻿#ifndef	AJXG3D_H_
#define	AJXG3D_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	３Ｄグラフィック コントロール																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxG3d {
	public:
		HWND	m_hCtrl;				//	自コントロールのウインドハンドル

		CAjxG3d();						//	コンストラクタ
		~CAjxG3d();						//	デストラクタ

		//----- ３Ｄファンクション -----------------------------------------------------------------------------//
		BOOL	Init				(double x1, double y1, double z1, double x2, double y2, double z2, UI style = AJC3DGS_3DMODE);	//	３Ｄグラフモード初期化
		BOOL	Init				(PCAJC3DVEC pLo, PAJC3DVEC pHi, PAJC3DVEC pRot, UI style = AJC3DGS_3DMODE);						//	３Ｄグラフモード初期化（ベクトル指定）
		BOOL	SetPlane			(AJCG3DAXIS_DIR HoriAxis, AJCG3DAXIS_DIR VertAxis);								//	平面表示
		BOOL	SetProp				(PCAJC3DGPROP pProp);															//	プロパティ設定
		BOOL	GetProp				(PAJC3DGPROP  pBuf);															//	プロパティ取得
		BOOL	AdjustRange			();																				//	レンジ自動調整
		BOOL	SetRange			(double x1, double y1, double z1, double x2, double y2, double z2);				//	各軸のレンジ設定
		BOOL	SetCenter			(double xc, double yc, double zc);												//	各軸の中心位置設定
		BOOL	SetWidth			(double xr, double yr, double zr);												//	各軸の幅（半径）設定
		BOOL	SetSameRangeWidth	();																				//	各軸のレンジ幅を同じにする
		BOOL	SetFixedAspect		(BOOL fFixed);																	//	レンジ設定された領域のアスペクトを設定する

		BOOL	SetColor			(UI id, COLORREF rgbP, COLORREF rgbN);											//	表示色設定
		BOOL	SetPlotNumber		(UI id, UI PlotNumber);															//	プロットデータ数設定
		BOOL	SetPlotSize			(UI id, UI PixelSize, UI PixelSizeE);											//	プロットデータのピクセルサイズ設定

		BOOL	PutPlotData			(UI id, double x, double y, double z);											//	プロットデータ投与
		BOOL	PutPlotData			(UI id, PCAJC3DVEC pPoint);														//	プロットデータ投与（ベクトル指定）

		BOOL	Pixel				(UI id, double x , double y , double z , UI PixelSize = 2);						//	ピクセル描画
		BOOL	Pixel				(UI id, PCAJC3DVEC pPoint, UI PixelSize = 2);									//	ピクセル描画（ベクトル指定）

		BOOL	Line				(UI id, double x1, double y1, double z1, double x2, double y2, double z2);		//	ライン描画
		BOOL	Line				(UI id, PCAJC3DVEC p1, PCAJC3DVEC p2);											//	ライン描画（ベクトル指定）

		BOOL	MoveTo				(UI id, double x, double y, double z);											//	ライン／矢印の始点設定
		BOOL	MoveTo				(UI id, PCAJC3DVEC ps);															//	ライン／矢印の始点設定（ベクトル指定）

		BOOL	LineTo				(UI id, double x, double y, double z);											//	ラインの終点を設定しライン描画
		BOOL	LineTo				(UI id, PCAJC3DVEC pe);															//	ラインの終点を設定しライン描画（ベクトル指定）

		BOOL	Arrow				(UI id, double x1, double y1, double z1, double x2, double y2, double z2);		//	矢印描画
		BOOL	Arrow				(UI id, PCAJC3DVEC p1, PCAJC3DVEC p2);											//	矢印描画（ベクトル指定）

		BOOL	ArrowTo				(UI id, double x, double y, double z);											//	ラインの終点を設定し矢印描画
		BOOL	ArrowTo				(UI id, PCAJC3DVEC pe);															//	ラインの終点を設定し矢印描画（ベクトル指定）

		BOOL	Triangle			(UI id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);	//	三角形描画
		BOOL	Triangle			(UI id, PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3);														//	三角形描画（ベクトル指定）

		BOOL	Square				(UI id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4);	//	四角形描画
		BOOL	Square				(UI id, PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PCAJC3DVEC p4);																			//	四角形描画（ベクトル指定）

		BOOL	Cube				(UI id, double xc, double yc, double zc, double xr, double yr, double zr, UI division = 8);					//	立方体／長方体描画
		BOOL	Cube				(UI id, PCAJC3DVEC pCent, double xr, double yr, double zr, UI division = 8);								//	立方体／長方体描画（ベクトル指定）

		BOOL	Sphere				(UI id, double xc, double yc, double zc, double xr, double yr, double zr, UI slice = 12, UI stack = 12);	//	球／楕球描画
		BOOL	Sphere				(UI id, PCAJC3DVEC pCent, double rx, double ry, double rz, UI slice = 12, UI stack = 12);					//	球／楕球描画（ベクトル指定）

		BOOL	DefPlane			(UI id, double xc, double yc, double zc, double xv, double yv, double zv, double xo, double yo, double zo);	//	３Ｄ空間上に任意の平面を定義
		BOOL	DefPlane			(UI id, PCAJC3DLVEC pLVec, PCAJC3DVEC pVOrg);																//	３Ｄ空間上に任意の平面を定義（ベクトル指定）

		BOOL	SetAngle			(double rtx, double rty, double rtz);											//	視点設定
		BOOL	SetAngleXY			();																				//	視点をＸ－Ｙ平面に設定
		BOOL	SetAngleXZ			();																				//	視点をＸ－Ｚ平面に設定
		BOOL	SetAngleYZ			();																				//	視点をＹ－Ｚ平面に設定
		BOOL	SetAngle3D			();																				//	視点を３Ｄイメージに設定

		HBITMAP	GetBitmap			();																				//	ビットマップ取得

		BOOL	LoadProp			(C_BCP pProfileSect =  "G3dProp", PCAJC3DGPROP pDefProp = NULL);				//	プロファイルからプロパティ値読出し(ASCII)
		BOOL	LoadProp 			(C_WCP pProfileSect = L"G3dProp", PCAJC3DGPROP pDefProp = NULL);				//	プロファイルからプロパティ値読出し(UNICODE)

		BOOL	SaveProp 			(C_BCP pProfileSect =  "G3dProp");												//	プロファイルへプロパティ値書き込み(ASCII)
		BOOL	SaveProp 			(C_WCP pProfileSect = L"G3dProp");												//	プロファイルへプロパティ値書き込み(UNICODE)

		BOOL	LoadPropEx			(C_BCP pProfileSect =  "G3dProp", PCAJC3DGPROP pDefProp = NULL);				//	プロファイルから詳細プロパティ値読出し(ASCII)
		BOOL	LoadPropEx			(C_WCP pProfileSect = L"G3dProp", PCAJC3DGPROP pDefProp = NULL);				//	プロファイルから詳細プロパティ値読出し(UNICODE)

		BOOL	SavePropEx			(C_BCP pProfileSect =  "G3dProp");												//	プロファイルへ詳細プロパティ値書き込み(ASCII)
		BOOL	SavePropEx			(C_WCP pProfileSect = L"G3dProp");												//	プロファイルへ詳細プロパティ値書き込み(UNICODE)

		HFONT	SetTextFont			(HFONT hFont);																	//	テキスト描画フォント設定

		UI		TextOut				(int x, int y, C_BCP pTxt);														//	テキスト描画（ピクセル位置指定）(ASCII)
		UI		TextOut				(int x, int y, C_WCP pTxt);														//	テキスト描画（ピクセル位置指定）(UNICODE)

		UI		PrintF				(int x, int y, C_BCP pFmt, ...);												//	書式テキスト描画（ピクセル位置指定）(ASCII)	
		UI		PrintF				(int x, int y, C_WCP pFmt, ...);												//	書式テキスト描画（ピクセル位置指定）(UNICODE)

		UI		TextOutV			(AJCG3DTXOMD md, PCAJC3DVEC pV, C_BCP pTxt);									//	テキスト描画（３Ｄ座標指定）(ASCII)
		UI		TextOutV			(AJCG3DTXOMD md, PCAJC3DVEC pV, C_WCP pTxt);									//	テキスト描画（３Ｄ座標指定）(UNICODE)

		UI		PrintFV				(AJCG3DTXOMD md, PCAJC3DVEC pV, C_BCP pFmt, ...);								//	書式テキスト描画（３Ｄ座標指定）(ASCII)	
		UI		PrintFV				(AJCG3DTXOMD md, PCAJC3DVEC pV, C_WCP pFmt, ...);								//	書式テキスト描画（３Ｄ座標指定）(UNICODE)

		UI		GetText				(UI key, BCP pBuf, UI lBuf);													//	描画テキスト取得(ASCII)	
		UI		GetText				(UI key, WCP pBuf, UI lBuf);													//	描画テキスト取得(UNICODE)

		BOOL	ClearShape			(UI id);																		//	図形描画データクリアー
		BOOL	ClearShape			();																				//	全図形描画データクリアー
		BOOL	ClearPlot			(UI id);																		//	プロットデータクリアー
		BOOL	ClearPlot			();																				//	全プロットデータクリアー
		BOOL	ClearText			(UI key);																		//	描画テキスト削除
		BOOL	ClearText			();																				//	全ての描画テキスト削除


		//----- 平面描画ファンクション（２Ｄ／３Ｄ共通） -------------------------------------------------------//
		BOOL	Pixel 				(UI id, double x, double y, UI PixelSize);										//	平面にピクセル描画
		BOOL	Pixel 				(UI id, PCAJC2DVEC pPoint, UI PixelSize);										//	平面にピクセル描画（ベクトル指定）

		BOOL	Line				(UI id, double x1, double y1, double x2, double y2);							//	平面にライン描画
		BOOL	Line				(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);											//	平面にライン描画（ベクトル指定）

		BOOL	MoveTo				(UI id, double x, double y);													//	平面に描画するライン／矢印の始点設定
		BOOL	MoveTo				(UI id, PCAJC2DVEC ps);															//	平面に描画するライン／矢印の始点設定（ベクトル指定）

		BOOL	LineTo				(UI id, double x, double y);													//	終点を指定し平面にライン描画
		BOOL	LineTo				(UI id, PCAJC2DVEC pe);															//	終点を指定し平面にライン描画（ベクトル指定）

		BOOL	Arrow				(UI id, double x1, double y1, double x2, double y2);							//	平面に矢印描画
		BOOL	Arrow				(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);											//	平面に矢印描画（ベクトル指定）

		BOOL	ArrowTo				(UI id, double x, double y);													//	終点を指定し平面に矢印描画
		BOOL	ArrowTo				(UI id, PCAJC2DVEC pe);															//	終点を指定し平面に矢印描画（ベクトル指定）

		BOOL	Triangle			(UI id, double x1, double y1, double x2, double y2, double x3, double y3);		//	平面に三角形描画
		BOOL	Triangle			(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3);							//	平面に三角形描画（ベクトル指定）

		BOOL	Square				(UI id, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4);	//	平面に四角形描画
		BOOL	Square				(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3, PCAJC2DVEC p4);								//	平面に四角形描画（ベクトル指定）

		BOOL	Rectangle			(UI id, double x1, double y1, double x2, double y2);												//	平面に長方形描画
		BOOL	Rectangle			(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);																//	平面に長方形描画（ベクトル指定）

		BOOL	Ellipse				(UI id, double xc, double yc, double rx, double ry);												//	平面に円／楕円描画
		BOOL	Ellipse				(UI id, PCAJC2DVEC pCent, double rx, double ry);													//	平面に円／楕円描画（ベクトル指定）

		BOOL	Star				(UI id, double xc, double yc, double r1, double r2=0.0, UI nVtx=5, double rot= 0.0, BOOL fInLine= FALSE); //	平面に星形描画
		BOOL	Star				(UI id, PCAJC2DVEC pCent    , double r1, double r2=0.0, UI nVtx=5, double rot= 0.0, BOOL fInLine= FALSE); //	平面に星形描画（ベクトル指定）

		//----- ２Ｄ／３Ｄ共通ファンクション -------------------------------------------------------------------//
		BOOL	EnablePopupMenu		(BOOL fEnable);																	//	右クリックによるポップアップメニューの許可／禁止
		BOOL	SetNtcRClk			(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);										//	右クリック通知設定

		BOOL	SetTipText			(C_BCP pTxt);																	//	ツールチップの設定(ASCII)
		BOOL	SetTipText			(C_WCP pTxt);																	//	ツールチップの設定(UNICODE)

		UI		GetTipText			(BCP pBuf, UI lBuf);															//	ツールチップの取得(ASCII)
		UI		GetTipText			(WCP pBuf, UI lBuf);															//	ツールチップの取得(UNICODE)

		BOOL	SetChkBoxTipText	(UI n, C_BCP pTxt);																//	フィルタ・チェックボックス・ツールチップの設定(ASCII)
		BOOL	SetChkBoxTipText	(UI n, C_WCP pTxt);																//	フィルタ・チェックボックス・ツールチップの設定(UNICODE)

		UI		GetChkBoxTipText	(UI n, BCP pBuf, UI lBuf);														//	フィルタ・チェックボックス・ツールチップの取得(ASCII)
		UI		GetChkBoxTipText	(UI n, WCP pBuf, UI lBuf);														//	フィルタ・チェックボックス・ツールチップの取得(UNICODE)

		BOOL	SetTipShowAlways	(BOOL fShowAlways);																//	ツールチップ表示条件の設定
		BOOL	GetTipShowAlways	();																				//	ツールチップ表示条件の取得

		BOOL	SetChkBoxTipShowAlways(UI n, BOOL fShowAlways);														//	フィルタ・チェックボックス・ツールチップの設定
		BOOL	GetChkBoxTipShowAlways(UI n);																		//	フィルタ・チェックボックス・ツールチップの取得

		BOOL	SetTipShowAlwaysAll	(BOOL fShowAlways);																//	全ツールチップ表示条件の設定

		BOOL	SetFilter 			(UI n, BOOL state);																//	フィルタの設定
		BOOL	GetFilter 			(UI n);																			//	フィルタの取得

		BOOL	GetDroppedFile		(BC buf[MAX_PATH]);																//	ドロップされたファイル名取得(ASCII)
		BOOL	GetDroppedFile 		(WC buf[MAX_PATH]);																//	ドロップされたファイル名取得(UNICODE)

		BOOL	GetDroppedDir		(BC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);								//	ドロップされたディレクトリ名取得(ASCII)
		BOOL	GetDroppedDir		(WC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);								//	ドロップされたディレクトリ名取得(UNICODE)

		BOOL	SetTitleText		(C_BCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(ASCII)
		BOOL	SetTitleText		(C_WCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(UNICODE)

		BOOL	Pause				(BOOL fPause);																	//	画面表示の停止／再開

		BOOL	EnableMesDraw		(BOOL fEnable);																	//	描画時間計測情報の許可／禁止

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO		Attach					(HWND hWnd);				//	ハンドルを関連付け

		virtual	VO		OnNtcRotTheta(PCAJC3DVEC pVec);						//	視点角度通知
		virtual	VO		OnNtcPlotList(PCAJC3DGPLOTLIST pList);				//	プロットリスト通知
		virtual	VO		OnNtcClear	 (int Factor);							//	データクリアー通知
		virtual	VO		OnNtcDblClk  ();									//	ダブルクリック通知
		virtual	VO		OnNtcDropFile(UI n);								//	ファイルドロップ通知
		virtual	VO		OnNtcDropDir (UI n);								//	フォルダドロップ通知
		virtual	VO		OnNtcRClick  (PCAJC3DGRCLK pRClk);					//	右クリック通知
	};
}
/****************************************************************************************************************/
#endif
