﻿#ifndef	AJXLZH_H_
#define	AJXLZH_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＬＺＨ書庫ファイルアクセス																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxLzh {
	public:
		CAjxLzh();						//	コンストラクタ
		~CAjxLzh();						//	デストラクタ

		HAJCLZH		FindFirst	(C_BCP pWild, UI flag = AJCLZHF_SUBDIR);		//	書庫内のファイル名検索（初回, ASCII）
		HAJCLZH		FindFirst	(C_WCP pWild, UI flag = AJCLZHF_SUBDIR);		//	書庫内のファイル名検索（初回, UNICODE）

		BOOL		FindNext	(HAJCLZH hLzh);									//	書庫内のファイル名検索（２回目以降）

		HAJCLZH		Open		(C_BCP pFilePath, UI flag = AJCLZHF_SUBDIR);	//	書庫内のファイルオープン(ASCII)
		HAJCLZH		Open		(C_WCP pFilePath, UI flag = AJCLZHF_SUBDIR);	//	書庫内のファイルオープン(UNICODE)

		UI			Read		(HAJCLZH hLzh, VOP pBuf, UI len);				//	書庫内のファイル読み出し

		VO			Close		(HAJCLZH hLzh);									//	書庫アクセスのクローズ

		BOOL		GetFileInfo	(HAJCLZH hLzh, PAJCLZHFILEINFOA pBuf);			//	検索したファイル情報取得(ASCII)
		BOOL		GetFileInfo	(HAJCLZH hLzh, PAJCLZHFILEINFOW pBuf);			//	検索したファイル情報取得(UNICODE)

		AJCLZHERR	GetLastError(VO);

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual UI		OnRead		(VOP pBuf, UI lBuf) = 0;					//	ファイル読み出し要求
		virtual VO		OnSeek		(UL  ofs)			= 0;					//	ファイル読み出し位置設定要求
	};
}
/****************************************************************************************************************/
#endif
