﻿#ifndef	AJXTCH_H_
#define	AJXTCH_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	タイムチャート コントロール																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxTch {
	public:
		HWND	m_hCtrl;				//	自コントロールのウインドハンドル

		CAjxTch();						//	コンストラクタ
		~CAjxTch();						//	デストラクタ

		BOOL	Stop					();														//	停止
		BOOL	Start					();														//	開始
		BOOL	Purge					();														//	クリアー

		BOOL	PutData					(double dat[]);											//	実数データ設定
		BOOL	PutData					(double d0						);
		BOOL	PutData					(double d0, double d1			);
		BOOL	PutData					(double d0, double d1, double d2);

		BOOL	PutData					(int	dat[]);											//	整数データ設定
		BOOL	PutData					(int d0 			   );
		BOOL	PutData					(int d0, int d1 	   );
		BOOL	PutData					(int d0, int d1, int d2);

		BOOL	ShowBorder				(BOOL fShow, COLORREF rgb);								//	外枠表示
		BOOL	ShowFilter				(BOOL fShow);											//	フィルタ表示
		BOOL	ShowScale 				(BOOL fLine, BOOL fValue);								//	スケール表示

		BOOL	GetProp					(PAJCTCPROP	pBuf);										//	プロパティ取得
		BOOL	SetProp					(PCAJCTCPROP pProp);									//	プロパティ設定

		BOOL	GetRange				(double *low, double *high);							//	実数レンジ取得
		BOOL	GetRange				(int	*low, int	*high);								//	整数レンジ取得
		BOOL	SetRange				(double	low, double  high);								//	実数レンジ設定
		BOOL	SetRange				(int 	low, int	 high);								//	整数レンジ設定
		BOOL	AdjustRange				();														//	レンジ自動調整
		BOOL	SetBufSize				(int n);												//	バッファサイズ設定
		BOOL	SetItemNumber			(int n);												//	データ項目数設定
		BOOL	SetAveNumber			(int n);												//	平均化個数設定
		BOOL	SetTimeScale			(int n);												//	タイムスケール幅設定

		HBITMAP	GetBitmap 				();														//	ビットマップ取得

		BOOL	LoadPermInfo			(C_BCP pProfileSect =  "TchPerm_*", C_BCP pKeyPrefix =	"Tch", UI PermItem = AJCTCH_PERM_FILTER);	//	プロファイルから永続情報読み出し（ASCII）
		BOOL	LoadPermInfo			(C_WCP pProfileSect = L"TchPerm_*", C_WCP pKeyPrefix = L"Tch", UI PermItem = AJCTCH_PERM_FILTER);	//	プロファイルから永続情報読み出し（UNICODE）

		BOOL	SavePermInfo			();														//	プロファイルへ永続情報書き込み

		BOOL	LoadProp 				(C_BCP pProfileSect = "TchPerm_*", PCAJCTCPROP pDefProp = NULL);	//	プロファイルからプロパティ読み出し(ASCII)
		BOOL	LoadProp 				(C_WCP pProfileSect = L"TchPerm_*", PCAJCTCPROP pDefProp = NULL);	//	プロファイルからプロパティ読み出し(UNICODE)

		BOOL	SaveProp 				(C_BCP pProfileSect =  "TchProp");									//	プロファイルへプロパティ書き込み(ASCII)
		BOOL	SaveProp 				(C_WCP pProfileSect = L"TchProp");									//	プロファイルへプロパティ書き込み(UNICODE)

		BOOL	LoadPropEx				(C_BCP pProfileSect =  "TchProp", PCAJCTCPROP pDefProp = NULL);		//	プロファイルからプロパティ，フィルタ設定，ウインドスタイル読み出し(ASCII)
		BOOL	LoadPropEx				(C_WCP pProfileSect = L"TchProp*", PCAJCTCPROP pDefProp = NULL);	//	プロファイルからプロパティ，フィルタ設定，ウインドスタイル読み出し(UNICODE)

		BOOL	SavePropEx				(C_BCP pProfileSect =  "TchProp");									//	プロファイルへプロパティ，フィルタ設定，ウインドスタイル書き込み(ASCII)
		BOOL	SavePropEx				(C_WCP pProfileSect = L"TchProp");									//	プロファイルへプロパティ，フィルタ設定，ウインドスタイル書き込み(UNICODE)

		BOOL	EnablePopupMenu			(BOOL fEnable);											//	右クリックによるポップアップメニューの許可／禁止

		BOOL	SetNtcRClk				(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);				//	右クリック通知設定

		BOOL	SetTipText				(C_BCP pTxt);											//	ツールチップ・テキスト設定(ASCII)
		BOOL	SetTipText				(C_WCP pTxt);											//	ツールチップ・テキスト設定(UNICODE)

		BOOL	GetTipText				(BCP pBuf, UI lBuf);									//	ツールチップ・テキスト取得(ASCII)
		BOOL	GetTipText				(WCP pBuf, UI lBuf);									//	ツールチップ・テキスト取得(UNICODE)

		BOOL	SetTipShowAlways		(BOOL fShowAlways);										//	ツールチップ・テキスト表示条件設定
		BOOL	GetTipShowAlways();																//	ツールチップ・テキスト表示条件取得	

		BOOL	SetChkBoxTipShowAlways	(UI n, BOOL fShowAlways);								//	フィィルタ（チェックボックス）のツールチップ・テキスト表示条件設定
		BOOL	GetChkBoxTipShowAlways	(UI n);													//	フィィルタ（チェックボックス）のツールチップ・テキスト表示条件取得

		BOOL	SetTipShowAlwaysAll		(BOOL fShowAlways);										//	全てのツールチップ・テキスト表示条件設定

		BOOL	SetChkBoxTipText		(UI n, C_BCP pTxt);										//	フィィルタ（チェックボックス）のツールチップ・テキスト設定(ASCII)
		BOOL	SetChkBoxTipText		(UI n, C_WCP pTxt);										//	フィィルタ（チェックボックス）のツールチップ・テキスト設定(UNICODE)

		BOOL	GetChkBoxTipText		(UI n, BCP pBuf, UI lBuf);								//	フィィルタ（チェックボックス）のツールチップ・テキスト取得(ASCII)
		BOOL	GetChkBoxTipText		(UI n, WCP pBuf, UI lBuf);								//	フィィルタ（チェックボックス）のツールチップ・テキスト取得(UNICODE)

		BOOL	SetMaxLineDist			(double MaxLineDist);									//	最大結線長設定
		double	GetMaxLineDist			();														//	最大結線長取得

		int		GetScrollPos			();														//	スクロール位置の取得
		BOOL	SetScrollPos			(int pos);												//	スクロール位置の設定

		BOOL	SetFilter 				(UI n, BOOL state);										//	フィルタの設定
		BOOL	GetFilter 				(UI n);													//	フィルタの取得

		BOOL	SetHLineAtt				(UI id, COLORREF color, int width = 1, int style = AJCTCH_DASH);	//	横線（属性の設定）
		BOOL	SetHLinePos				(UI id, double pos);												//	横線（描画位置の設定）
		BOOL	EnableHLine				(UI id, BOOL fEnable);												//	横線（描画の許可／禁止）

		BOOL	SetVLine				(COLORREF color, int width = 1, int style = AJCTCH_DASH);			//	縦線描画（最後に格納したデータの位置に縦線を描画する）	
		BOOL	EnableVLine				(BOOL fEnable);														//	縦線描画の許可／禁止

		BOOL	SetPoint				(int r);												//	プロット点描画（最後に格納したデータの位置にプロット点（円）を描画する）
		BOOL	EnablePoint				(BOOL fEnable);											//	プロット点描画の許可／禁止

		BOOL	GetDroppedFile			(BC buf[MAX_PATH]);										//	ドロップされたファイル名取得(ASCII)
		BOOL	GetDroppedFile			(WC buf[MAX_PATH]);										//	ドロップされたファイル名取得(UNICODE)

		BOOL	GetDroppedDir			(BC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);		//	ドロップされたディレクトリ名取得（末尾の「￥」付加指定付き）(ASCII)
		BOOL	GetDroppedDir			(WC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);		//	ドロップされたディレクトリ名取得（末尾の「￥」付加指定付き, UNICODE）

		BOOL	SetTitleText			(C_BCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(ASCII)
		BOOL	SetTitleText			(C_WCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(UNICODE)

		BOOL	SetIpInfo				(PCAJCTCIPINFO pInfo);									//	波形補間表示情報の設定
		BOOL	GetIpInfo				(PAJCTCIPINFO  pBuf );									//	波形補間表示情報の取得

		BOOL	Pause					(BOOL fPause);											//	表示の停止／再開

		BOOL	EnableMesDraw			(BOOL fEnable);											//	描画時間計測情報の許可／禁止

		BOOL	MesPeriShow				(BOOL fShow);											//	プロット周期計測情報表示／非表示の設定
		BOOL	MesPeriReset			();														//	プロット周期計測情報リセット

		HFONT	SetTextFont				(HFONT hFont);											//	テキスト描画フォント設定

		UI		TextOut					(int x, int y, C_BCP pTxt);								//	テキスト描画（ピクセル位置指定）(ASCII)
		UI		TextOut					(int x, int y, C_WCP pTxt);								//	テキスト描画（ピクセル位置指定）(UNICODE)

		UI		PrintF					(int x, int y, C_BCP pFmt, ...);						//	書式テキスト描画（ピクセル位置指定）(ASCII)	
		UI		PrintF					(int x, int y, C_WCP pFmt, ...);						//	書式テキスト描画（ピクセル位置指定）(UNICODE)

		UI		GetText					(UI key, BCP pBuf, UI lBuf);							//	描画テキスト取得(ASCII)	
		UI		GetText					(UI key, WCP pBuf, UI lBuf);							//	描画テキスト取得(UNICODE)

		BOOL	ClearText				(UI key);												//	描画テキスト削除
		BOOL	ClearText				();														//	全ての描画テキスト削除

		BOOL	Clear					();														//	全てのデータと描画テキスト削除

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO	Attach			(HWND hWnd);												//	ハンドルを関連付け

		virtual	VO	OnNtcRange		(PCAJCTC_NTC_RANGE pRange);									//	レンジ変化通知
		virtual	VO	OnNtcScrPos		(UI 			   ScrPos);									//	スクロール位置変化通知
		virtual	VO	OnNtcClear		();															//	グラフクリアー通知
		virtual	VO	OnNtcDblClk		();															//	ダブルクリック通知
		virtual	VO	OnNtcDropFile	(UI 			  nFiles);									//	ファイルドロップ通知
		virtual	VO	OnNtcDropDir	(UI 			  nDirs );									//	ディレクトリドロップ通知
		virtual	VO	OnNtcRClick		(PCAJCTCRCLK 	  pRClk );									//	右クリック通知

	};
}
/****************************************************************************************************************/
#endif
