﻿#ifndef	AJXTIP_H_
#define	AJXTIP_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ツールチップ スタティック コントロール																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT SAjxTip {
	public:

		//--- AjcTipCtl.h ---//

		static	BOOL			EnableMultiThread(BOOL fEnable);							//	マルチスレッドの許可／禁止

		static	AJCTIP_POSMODE	SetTipPosMode (AJCTIP_POSMODE PosMode);						//	ツールチップ表示位置モードの設定

		static	BOOL	 		Add(HWND hCtrl, C_BCP pTxt, int msDelay = 1000, int msShow = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);	//	ツールチップの関連付け(ASCII)
		static	BOOL	 		Add(HWND hCtrl, C_WCP pTxt, int msDelay = 1000, int msShow = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);	//	ツールチップの関連付け(UNICODE)

		static	BOOL	 		SetShowAlways(HWND hCtrl, BOOL fShowAlways);				//	ツールチップ表示条件の設定
		static	BOOL	 		GetShowAlways(HWND hCtrl);									//	ツールチップ表示条件の取得

		static	VO				SetShowForActive(BOOL fShowForActive);						//	全ツールチップ表示条件の設定
		static	BOOL	 		GetShowForActive(VO);										//	全ツールチップ表示条件の取得

		static	BOOL			Enable			(HWND hCtrl, BOOL fEnable);					//	チップテキストの表示許可／禁止設定
		static	BOOL			GetEnableState	(HWND hCtrl);								//	チップテキストの表示許可／禁止状態取得

		static	VO				EnableAll		 (BOOL fEnable);							//	全てのチップテキストの表示許可／禁止設定
		static	BOOL			GetEnableAllState(VO);										//	全てのチップテキストの表示許可／禁止状態取得

		static	BOOL	 		Remove(HWND hCtrl);											//	特定のツールチップの関連付け解除
		static	BOOL	 		Remove();													//	全てのツールチップの関連付け解除

		static	UI	 			GetInfo(HWND hCtrl, PAJCTIPINFO pInfoBuf, BCP pTxtBuf, UI lTxtBuf);	//	ツールチップの関連付け情報取得(ASCII)
		static	UI	 			GetInfo(HWND hCtrl, PAJCTIPINFO pInfoBuf, WCP pTxtBuf, UI lTxtBuf);	//	ツールチップの関連付け情報取得(UNICODE)

		static	BOOL			SetNtcSubclass(HWND hCtrl, HWND hNtc, UI msg, UX lParam);	//	サブクラス化の通知情報設定
		static	BOOL			ClrNtcSubclass(HWND hCtrl);									//	サブクラス化の通知情報消去

		static	VO	 			SetWindowTime(int msTime);									//	コントロール間移動猶予時間設定
		static	int	 			GetWindowTime();											//	コントロール間移動猶予時間取得

		static	VO	 			SetDefMsDelay(int msDelay);									//	デフォルトの表示遅延時間の設定
		static	int	 			GetDefMsDelay();											//	デフォルトの表示遅延時間の取得


		//--- AjcTipTxt.h ---//

		static	BOOL	 		Show(int x, int y,							 C_BCP pTxt, int msTime = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);	//	ツールチップの表示(ASCII)
		static	BOOL	 		Show(int x, int y, int minWidth, int height, C_BCP pTxt, int msTime = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);

		static	BOOL	 		Show(int x, int y,							 C_WCP pTxt, int msTime = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);	//	ツールチップの詳細表示(UNICODE)
		static	BOOL	 		Show(int x, int y, int minWidth, int height, C_WCP pTxt, int msTime = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);

		static	BOOL	 		ShowCenter(HWND hwnd,							C_BCP pTxt, int msTime = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);	//	ツールチップをウインド中央に表示(ASCII)
		static	BOOL	 		ShowCenter(HWND hwnd, int minWidth, int height, C_BCP pTxt, int msTime = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);
		static	BOOL	 		ShowCenter(HWND hwnd,							C_WCP pTxt, int msTime = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);	//	ツールチップをウインド中央に表示(UNICODE)
		static	BOOL	 		ShowCenter(HWND hwnd, int minWidth, int height, C_WCP pTxt, int msTime = 3000, HFONT hFont = NULL, COLORREF TextColor = (COLORREF)-1, COLORREF BackGround = (COLORREF)-1, COLORREF BorderColor = (COLORREF)-1);

		static	BOOL	 		GetSize(C_BCP pTxt, HFONT hFont, BOOL fBorder, LPSIZE pBuf);	//	ツールチップの表示サイズ取得(ASCII)
		static	BOOL	 		GetSize(C_WCP pTxt, HFONT hFont, BOOL fBorder, LPSIZE pBuf);	//	ツールチップの表示サイズ取得(UNICODE)

		static	VO	 			Move(int x, int y);											//	ツールチップウインドを移動

		static	VO	 			MoveCursor();												//	カーソルをツールチップ上の中央へ移動
		static	VO	 			MoveCursor(AJCTIP_CURMOVE cm);								//	カーソルをツールチップ上の指定位置へ移動

		static	VO	 			Hide();														//	ツールチップ非表示

		static	BOOL	 		GetRect(LPRECT pRect);										//	ツールチップウインドの矩形情報取得

		static	BOOL	 		SetPalette(int ix, COLORREF color);							//	パレット色の設定
		static	COLORREF		GetPalette(int ix);											//	パレット色の取得

		static	VO	 			SetDefTextColor  (COLORREF color);							//	デフォルトのテキスト表示色設定
		static	COLORREF		GetDefTextColor  ();										//	デフォルトのテキスト表示色取得

		static	VO	 			SetDefBorderColor(COLORREF color);							//	デフォルトの外枠表示色設定
		static	COLORREF		GetDefBorderColor();										//	デフォルトの外枠表示色取得

		static	VO	 			SetDefBkColor	  (COLORREF color);							//	デフォルトの背景表示色設定
		static	COLORREF		GetDefBkColor	  ();										//	デフォルトの背景表示色取得

		static	VO	 			SetDefFont		  (HFONT hFont);							//	デフォルトフォントの設定
		static	HFONT	 		GetDefFont		  ();										//	デフォルトフォントの取得

		static	VO	 			SetDefMsShow	  (int msShow);								//	デフォルトの表示時間の設定
		static	int	 			GetDefMsShow	  ();										//	デフォルトの表示時間の取得
	};
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	状況依存ツールチップ コントロール																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxTip {
		BOOL	m_fUnicode;						//	UNICODE / ASCII 識別フラグ
	public:
		HWND	m_hCtrl;

		#ifdef UNICODE
			CAjxTip(BOOL fUnicode = TRUE);								//	コンストラクタ(UNICODE)
		#else
			CAjxTip(BOOL fUnicode = FALSE);								//	コンストラクタ(ASCII)
		#endif
		~CAjxTip();														//	デストラクタ

		VO				Attach(HWND hCtrl);								//	アタッチ（コントロールハンドル充当）
		virtual BOOL	OnChkCursor(HWND hCtrl, LPPOINT ptClient);		//	カーソル位置チェック

		virtual VO		OnNeedText (HWND hCtrl, BCP pBuf, UI lBuf);		//	ツールチップテキスト取得要求(ASCII)
		virtual VO		OnNeedText (HWND hCtrl, WCP pBuf, UI lBuf);		//	ツールチップテキスト取得要求(UNICODE)
	};
}
/****************************************************************************************************************/
#endif
