﻿#ifndef	AJXXYM_H_
#define	AJXXYM_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	XMODEM/YMODEM 通信																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxXym {
		BOOL	m_fUnicode;
	public:
		HAJCXYM	m_hXym;

		#ifdef UNICODE
			CAjxXym(BOOL fUnicode = TRUE);		//	コンストラクタ(UNICODE)
		#else
			CAjxXym(BOOL fUnicode = FALSE);		//	コンストラクタ(ASCII)
		#endif
		~CAjxXym();								//	デストラクタ

		VO		GetTxTimeInfo(UIP t0, UIP r0, UIP t1, UIP r1);					//	送信時タイマ情報取得
		VO		SetTxTimeInfo(UI  t0, UI  r0, UI  t1, UI  r1);					//	送信時タイマ情報設定
		VO		GetRxTimeInfo(UIP t0, UIP r0, UIP t1, UIP r1);					//	受信時タイマ情報取得
		VO		SetRxTimeInfo(UI  t0, UI  r0, UI  t1, UI  r1);					//	受信時タイマ情報設定

		BOOL	TxStart 	 (AJCXYMPROTOCOL Protocol = AJCXYP_XMODEM_SUM);		//	ファイル送信開始
		BOOL	RxStart 	 (AJCXYMPROTOCOL Protocol = AJCXYP_XMODEM_SUM);		//	ファイル受信開始
		VO		Stop		 ();												//	ファイル転送中止
		VO		PutRxChar	 (UI rxd);											//	シリアル回線からの受信データ投与
		VO		TxEnd		 ();												//	シリアル回線への送信完了を通知（ＹＭＯＤＥＭ－Ｇ専用）

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual VO	OnNotice (UI knd, UX Param				);		//	イベント通知
		virtual VO	OnGetFile(PAJCXYMFILEINFOA pBuf			);		//	ファイル情報取得要求(ASCII)
		virtual VO	OnGetFile(PAJCXYMFILEINFOW pBuf			);		//	ファイル情報取得要求(UNIODE)
		virtual VO	OnGetData(VOP pBuf, UI lBuf, UIP pBytes	);		//	ファイルデータ取得要求
		virtual VO	OnSend	 (C_VOP pTxD, UI lTxD			);		//	データ送出要求
	};
}
/****************************************************************************************************************/
#endif
