OPTION ANGLE DEGREES
DECLARE NUMERIC theta0, tx, ty
LET theta0=0      ! Rotation angle about the z-axis
LET tx=0       ! Rotation angle about the x-axis
LET ty=0           ! Rotation angle about the y-axis
SET WINDOW -1,2,-1,2
SET POINT STYLE 1
LOCATE VALUE nowait (1),RANGE -90 TO 90,AT ty:ty
LOCATE VALUE nowait (2),RANGE -90 TO 90,AT tx:tx
DO
   SET DRAW mode hidden
   CLEAR  
   DIM rotx(4,4)      ! rotation about x-axis
   MAT rotx=IDN
   LET rotx(2,2)=COS(tx)
   LET rotx(2,3)=SIN(tx)
   LET rotx(3,2)=-SIN(tx)
   LET rotx(3,3)=COS(tx)
   DIM roty(4,4)      ! rotation about y-axis
   MAT roty=IDN
   LET roty(1,1)=COS(ty)
   LET roty(1,3)=-SIN(ty)
   LET roty(3,1)=SIN(ty)
   LET roty(3,3)=COS(ty)
   DIM m(4,4)
   MAT m=ROTATE(theta0)
   MAT m=m *  roty  *rotx 
   DRAW iterate WITH m
   SET DRAW mode explicit
   LOCATE VALUE nowait (1),RANGE -90 TO 90:ty
   LOCATE VALUE nowait (2),RANGE -90 TO 90:tx
    
LOOP
PICTURE iterate
   FOR a=0 TO 4 STEP 0.1
      LET x=1/2
      FOR k=1 TO 100
         CALL PlotPoint3D(a/4,x,k/100)
         LET x=a*x*(1-x)
      NEXT k
   NEXT a
end  PICTURE

END
EXTERNAL SUB PlotPoint3D(x,y,z)
DECLARE NUMERIC POINT(4) 
DECLARE NUMERIC m(4,4)
DECLARE NUMERIC xx,yy
MAT m=TRANSFORM
LET POINT(1)=x
LET POINT(2)=y
LET POINT(3)=z
LET POINT(4)=1
MAT POINT=POINT*m
LET xx=POINT(1)/POINT(4)
LET yy=POINT(2)/POINT(4)
GRAPH POINTS: xx,yy
END SUB


