# Komic Viewer

📖 軽量で使いやすいコミック・マンガビューアー

![Komic Viewer](https://img.shields.io/badge/Platform-Windows-blue) ![.NET](https://img.shields.io/badge/.NET-8.0-purple) ![License](https://img.shields.io/badge/License-MIT-green)

## 🎯 特徴

- **軽量・高速**: .NET 8.0ベースで軽快な動作
- **多彩な表示モード**: 単ページ・見開き表示に対応
- **豊富な対応形式**: ZIP, RAR, CBZ, CBR形式をサポート
- **ダークテーマ**: 目に優しいダークインターフェース
- **直感的操作**: マウス・キーボード・ホイールでの快適なナビゲーション
- **フルスクリーン対応**: 集中して読書を楽しめる
- **ドラッグ&ドロップ**: ファイルを簡単に開ける

## 📥 ダウンロード・インストール

### システム要件
- **OS**: Windows 10 version 1607 以降 / Windows 11
- **.NET**: .NET 8.0 Runtime（自動インストール案内あり）
- **メモリ**: 512MB以上推奨
- **ストレージ**: 50MB以上の空き容量

### インストール手順
1. KomicViewer-vXX.XX-win64.zipをダウンロード
2. ZIPファイルを展開
3. `KomicViewer.exe` を実行
4. 初回起動時に.NET 8.0 Runtimeのインストールが必要な場合があります

## 🚀 使い方

### ファイルを開く
- **ドラッグ&ドロップ**: ファイルをウィンドウにドロップ
- **メニューから**: 📁ファイル → 開く
- **ショートカット**: `Ctrl + O`

### ページナビゲーション
| 操作 | 説明 |
|------|------|
| `→` `↓` `Space` `PageDown` | 次のページ |
| `←` `↑` `PageUp` | 前のページ |
| `Home` | 最初のページ |
| `End` | 最後のページ |
| **マウスクリック** | 画面左端・右端（100px幅）で前/次のページ |
| **マウスホイール** | 上で前のページ、下で次のページ |

### 見開きモード専用機能
| 操作 | 右開き時の動作 | 左開き時の動作 |
|------|---------------|---------------|
| **◁ ボタン** | 1ページ送る | 1ページ戻す |
| **▷ ボタン** | 1ページ戻す | 1ページ送る |
| **右開き/左開き** | 読み方向切り替えボタン | 読み方向切り替えボタン |
| `Shift + →` | 1ページ戻す | 1ページ送る |
| `Shift + ←` | 1ページ送る | 1ページ戻す |

**注意**: 見開きモード専用機能は単ページモード時には非表示になります。

### 表示モード
| キー | 機能 |
|------|------|
| `1` | 単ページモード |
| `2` | 見開きモード |
| `F11` | フルスクリーン切り替え |
| `Esc` | フルスクリーン終了 |

### その他の機能
- **読み方向切り替え**: ツールバーで右開き/左開きを変更
  - **右開き（日本式）**: 見開き時、右側に小さいページ番号、左側に大きいページ番号
  - **左開き（欧米式）**: 見開き時、左側に小さいページ番号、右側に大きいページ番号
- **フルスクリーン時**: マウスを画面上部に移動でツールバー表示
- **ファイルを閉じる**: `Ctrl + W`

## 📁 対応ファイル形式

### アーカイブ形式
- **ZIP** (`.zip`, `.cbz`)
- **RAR** (`.rar`, `.cbr`)

### 画像形式（アーカイブ内）
- JPEG (`.jpg`, `.jpeg`)
- PNG (`.png`)
- GIF (`.gif`)
- BMP (`.bmp`)
- WebP (`.webp`)

## ⚙️ 高度な機能

### 自動レイアウト調整
- 横長画像は自動的に単ページ表示
- 見開きモードでも最適な表示を自動選択

### 高品質表示
- 高品質な画像拡大縮小アルゴリズム
- アンチエイリアシング対応

## 🔧 トラブルシューティング

### .NET Runtime エラー
```
このアプリケーションを実行するには .NET が必要です
```
**解決方法**: [.NET 8.0 Runtime](https://dotnet.microsoft.com/download/dotnet/8.0)をインストール

### ファイルが開けない
- **対応形式を確認**: ZIP, RAR, CBZ, CBR のみ対応
- **ファイル破損**: 別のアーカイブツールで確認
- **パスワード保護**: 現在未対応

### 画像が表示されない
- **画像形式を確認**: JPEG, PNG, GIF, BMP, WebP のみ対応
- **ファイル名**: 日本語ファイル名でも対応

## 📝 ライセンス

MIT License - 詳細は [LICENSE](LICENSE) ファイルを参照

## 🤝 免責事項

- 本ソフトウェアを使用して直接的、間接的に何らかの不具合、損害等が発生しても、作者はその責を負いません。各自の責任においてご利用下さい。

## 📞 サポート

- 基本的にサポートを行うことを保証していませんが、出来るだけバグ修正や要望などに対していきたいと思います。また、諸般に事情によりすべて返信できないと思いますがご容赦ください。
- EMail:tikomo@gmail.com


---

**Komic Viewer** - シンプルで快適なコミック読書体験を提供します 📚✨