/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define CSV_CPP
#include "common.h"

/*------------------------------------------------------------------------------
    ft@C
------------------------------------------------------------------------------*/
#define CMD_DEFINE  0
#define CMD_TEXT    1
#define CMD_LINE    2
#define CMD_RECT    3
#define CMD_PIXEL   4
#define CMD_MOVETO  5
#define CMD_LINETO  6
#define CMD_FLOOD   7
//--------------------------------
#define MAX_PARAMS  13
#define MAX_DEFINE  400
#define LEN_LINE    500
#define LEN_PARAM   100
#define LEN_SIG     50
#define LEN_VAL     100

/*------------------------------------------------------------------------------
    \
------------------------------------------------------------------------------*/
typedef struct Linear {
	WCHAR sig[LEN_SIG+1];
	WCHAR val[LEN_VAL+1];
	Linear *next;
} Linear;

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
INT32 resCsv;
INT32 resLineIdx;
INT32 cntDefine;
Linear root;
HPEN hPnMt;
HPEN hPnMtOld;

struct {
	INT32 cmd;
//--------------------------------------------
	INT32 x;
	INT32 y;
	WCHAR text[LEN_PARAM+1];
	INT32 rgb;
	INT32 back;
	BOOL flgAlpha;
	WCHAR fmy[LEN_PARAM+1];
	INT32 size;
	BOOL flgVert;
//--------------------------------------------
	INT32 x1;
	INT32 y1;
	INT32 x2;
	INT32 y2;
//	INT32 rgb;
	INT32 t;
//--------------------------------------------
//	INT32 x;
//	INT32 y;
	INT32 w;
	INT32 h;
//	INT32 rgb;
//	INT32 back;
//	INT32 t;
	INT32 c;
	BOOL flgFill;
	BOOL flgOnly;
	BOOL flgElip;
	BOOL flgL;
//--------------------------------------------
//	INT32 x;
//	INT32 y;
//	INT32 rgb;
//--------------------------------------------
//	INT32 x;
//	INT32 y;
//	INT32 rgb;
//	INT32 t;
//--------------------------------------------
//	INT32 x;
//	INT32 y;
//--------------------------------------------
//	INT32 x;
//	INT32 y;
//	INT32 rgb;
} prms;

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void CsvInit(void);
void CsvInitParams(void);
void CsvExit(st_Image *);
INT32 CsvReadFile(st_Image *, WCHAR *, BOOL *, INT32 *);
INT32 CsvReadLine(HANDLE, ACHAR *, INT32 *, INT32);
INT32 CsvReadParams(WCHAR *, INT32);
INT32 CsvReadParamsDefine(WCHAR [][LEN_PARAM+1], INT32, INT32);
INT32 CsvReadParamsText(WCHAR [][LEN_PARAM+1], INT32, INT32);
INT32 CsvReadParamsLine(WCHAR [][LEN_PARAM+1], INT32, INT32);
INT32 CsvReadParamsRect(WCHAR [][LEN_PARAM+1], INT32, INT32);
INT32 CsvReadParamsPixel(WCHAR [][LEN_PARAM+1], INT32, INT32);
INT32 CsvReadParamsMoveTo(WCHAR [][LEN_PARAM+1], INT32, INT32);
INT32 CsvReadParamsLineTo(WCHAR [][LEN_PARAM+1], INT32, INT32);
INT32 CsvReadParamsFlood(WCHAR [][LEN_PARAM+1], INT32, INT32);
INT32 CsvSplit(WCHAR *, WCHAR [][LEN_PARAM+1], INT32 *, INT32);
void CsvRemove(WCHAR *);
void CsvReplace(WCHAR *);
INT32 CsvCalc(INT32, const WCHAR *const, INT32 *);
BOOL CsvLinearIsExist(WCHAR *);
void CsvLinearInsert(WCHAR *, WCHAR *);
void CsvLinearAdd(Linear *, WCHAR *, WCHAR *);
void CsvLinearDelete(void);
void CsvLinearDump(void);
void CsvDraw(st_Image *);
void CsvDrawText(st_Image *);
void CsvDrawLine(st_Image *);
void CsvDrawRect(st_Image *);
void CsvDrawPixel(st_Image *);
void CsvDrawMoveto(st_Image *);
void CsvDrawLineto(st_Image *);
void CsvDrawFlood(st_Image *);

/*------------------------------------------------------------------------------
    Fvoid CsvInit(void)
    @\F
------------------------------------------------------------------------------*/
void CsvInit(void)
{
	wmemset(root.sig, 0x0000, LEN_SIG+1);
	wmemset(root.val, 0x0000, LEN_VAL+1);
	root.next = NULL;
	
	cntDefine = 0;
	
	hPnMt    = NULL;
	hPnMtOld = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid CsvInitParams(void)
    @\Fp[^
------------------------------------------------------------------------------*/
void CsvInitParams(void)
{
	prms.cmd = CMD_DEFINE;
	
	prms.x = 0;
	prms.y = 0;
	wmemset(prms.text, 0x0000, LEN_PARAM+1);
	prms.rgb      = 0x000000;
	prms.back     = 0x000000;
	prms.flgAlpha = FALSE;
	wmemset(prms.fmy, 0x0000, 25);
	prms.size    = 0;
	prms.flgVert = FALSE;
	
	prms.x1  = 0;
	prms.y1  = 0;
	prms.x2  = 0;
	prms.y2  = 0;
//	prms.rgb = 0x000000;
	prms.t   = 0;
	
//	prms.x       = 0;
//	prms.y       = 0;
	prms.w       = 0;
	prms.h       = 0;
//	prms.rgb     = 0x000000;
//	prms.back    = 0x000000;
//	prms.t       = 0;
	prms.c       = 0;
	prms.flgFill = FALSE;
	prms.flgOnly = FALSE;
	prms.flgElip = FALSE;
	prms.flgL    = FALSE;
	
//	prms.x   = 0;
//	prms.y   = 0;
//	prms.rgb = 0x000000;
}

/*------------------------------------------------------------------------------
    Fvoid CsvExit(st_Image *)
    Fst_Image *  -
    @\FЕt
------------------------------------------------------------------------------*/
void CsvExit(st_Image *pImg)
{
	CsvLinearDelete();
	
	if ((hPnMt != NULL) && (hPnMtOld != NULL)) {
		SelectObject(pImg->hdc, hPnMtOld);
		DeleteObject(hPnMt);
	}
}

/*------------------------------------------------------------------------------
    Fvoid CsvGetErrMsg(WCHAR *)
    FWCHAR *  -
    @\FG[bZ[W擾
------------------------------------------------------------------------------*/
void CsvGetErrMsg(WCHAR *pStr)
{
	swprintf(pStr, L"%dF", resLineIdx);
	
	switch (resCsv) {
	case CSV_ERR_FILE:           wcscat(pStr, L"csv file error");           break;
	case CSV_ERR_LINE_OVER:      wcscat(pStr, L"over 500 chara in line");   break;
	case CSV_ERR_SPL_OVCHAR:     wcscat(pStr, L"over 100 chara in param");  break;
	case CSV_ERR_SPL_OVPRMS:     wcscat(pStr, L"over params");              break;
	case CSV_ERR_DEF_WRONG:      wcscat(pStr, L"wrong params");             break;
	case CSV_ERR_DEF_COUNT:      wcscat(pStr, L"count over");               break;
	case CSV_ERR_DEF_LEN0:       wcscat(pStr, L"length 0");                 break;
	case CSV_ERR_DEF_LENOVER:    wcscat(pStr, L"length over");              break;
	case CSV_ERR_DEF_DUP:        wcscat(pStr, L"define duplication");       break;
	case CSV_ERR_WRONG:          wcscat(pStr, L"wrong params");             break;
	case CSV_ERR_VALI:           wcscat(pStr, L"validation params");        break;
	case PLSH_ERR_CHECKBLOCK:    wcscat(pStr, L"error check block");        break;
	case PLSH_ERR_FORMULA:       wcscat(pStr, L"error formula");            break;
	case PLSH_ERR_EXPRESSION:    wcscat(pStr, L"error expression");         break;
	case PLSH_ERR_LEN:           wcscat(pStr, L"error len");                break;
	case PLSH_ERR_TERMCNTL:      wcscat(pStr, L"error term cnt l");         break;
	case PLSH_ERR_TERMCNTR:      wcscat(pStr, L"error term cnt r");         break;
	case PLSH_ERR_PUSHDECODE:    wcscat(pStr, L"error push decode");        break;
	case PLSH_ERR_DIV0:          wcscat(pStr, L"error decode div 0");       break;
	case PLSH_ERR_DECODEREMAIN:  wcscat(pStr, L"error decode remain");      break;
	default:
		break;
	}
}

/*------------------------------------------------------------------------------
    FBOOL CsvReadFile(st_Image *, WCHAR *, BOOL *)
    Fst_Image *  -
          WCHAR *     -
          BOOL *      -
    ߒlFBOOL        -
    @\FCSVt@Cǂݍ݁A`悷
------------------------------------------------------------------------------*/
BOOL CsvReadFile(st_Image *pImg, WCHAR *path, BOOL *pUpdate)
{
	INT32 i;
	ACHAR buffA[LEN_LINE+1];
	WCHAR buffW[LEN_LINE+1];
	HANDLE hFile;
	INT32 cnt;
	INT32 resL;
	INT32 resP;
	
	resLineIdx = 0;
	
	if (pUpdate != NULL) {*pUpdate = FALSE;}
	CsvInit();
	
	if (!IsExistFile(path)) {resCsv = CSV_ERR_FILE;  return FALSE;}
	
	hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
					   FILE_ATTRIBUTE_NORMAL, NULL);
	
	if (hFile == INVALID_HANDLE_VALUE) {resCsv = CSV_ERR_FILE;  return FALSE;}
	
	while (1) {
		memset(buffA, 0x00, LEN_LINE+1);
		resL = CsvReadLine(hFile, buffA, &cnt, resLineIdx);
		resLineIdx++;
		
		wmemset(buffW, 0x0000, LEN_LINE+1);
		MultiByteToWideChar(CP_ACP, 0, buffA, -1, buffW, LEN_LINE+1);
		
		if (resL == CSV_ERR_LINE_OVER) {
			CloseHandle(hFile);
			CsvExit(pImg);
			resCsv = resL;
			return FALSE;
		}
		
		resP = CsvReadParams(buffW, resLineIdx);
		if (resP != CSV_OK) {
			CloseHandle(hFile);
			CsvExit(pImg);
			resCsv = resP;
			return FALSE;
		}
		
		CsvDraw(pImg);
		if (pUpdate != NULL) {*pUpdate = TRUE;}
		
		if (resL == CSV_EOF) {break;}
	}
	
	CloseHandle(hFile);
	CsvExit(pImg);
	return TRUE;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadLine(HANDLE, ACHAR *, INT32 *, INT32)
    FHANDLE   -
          ACHAR *  -
          INT32 *  -
          INT32    -
    ߒlFINT32    -
    @\FPsǂݍ
------------------------------------------------------------------------------*/
INT32 CsvReadLine(HANDLE hFile, ACHAR *buff, INT32 *pCnt, INT32 idx)
{
	INT32 i;
	ULOG32 cnt;
	ACHAR c;
	
	*pCnt = 0;
	
	i = 0;
	while (1) {
		if (*pCnt >= LEN_LINE) {return CSV_ERR_LINE_OVER;}
		
		ReadFile(hFile, &c, 1, &cnt, NULL);
		if (cnt != 1) {return CSV_EOF;}
		
		if (c == '\n') {
			if ((i != 0) && (*(buff + i - 1) == '\r')) {
				*(buff + i - 1) = '\0';
				(*pCnt)--;
			}
			break;
		}
		else {
			*(buff + i) = c;
			(*pCnt)++;
		}
		i++;
	}
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParams(WCHAR *, INT32)
    FWCHAR *  -
          INT32    -
    ߒlFINT32    -
    @\Fp[^𒊏o
------------------------------------------------------------------------------*/
INT32 CsvReadParams(WCHAR *buff, INT32 idx)
{
	INT32 i;
	WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1];
	INT32 res;
	INT32 cnt;
	
	for (i = 0; i < MAX_PARAMS; i++) {wmemset(buffPrms[i], 0x0000, LEN_PARAM+1);}
	CsvInitParams();
	
	res = CsvSplit(buff, buffPrms, &cnt, idx);
	if (res != CSV_OK) {return res;}
	
	CsvRemove(buffPrms[0]);
	if (wcscmp(buffPrms[0], L"DEFINE") == 0) {
		res = CsvReadParamsDefine(buffPrms, idx, cnt);
		if (res != CSV_OK) {return res;}
	}
	else if (wcscmp(buffPrms[0], L"TEXT") == 0) {
		res = CsvReadParamsText(buffPrms, idx, cnt);
		if (res != CSV_OK) {return res;}
	}
	else if (wcscmp(buffPrms[0], L"LINE") == 0) {
		res = CsvReadParamsLine(buffPrms, idx, cnt);
		if (res != CSV_OK) {return res;}
	}
	else if (wcscmp(buffPrms[0], L"RECT") == 0) {
		res = CsvReadParamsRect(buffPrms, idx, cnt);
		if (res != CSV_OK) {return res;}
	}
	else if (wcscmp(buffPrms[0], L"PIXEL") == 0) {
		res = CsvReadParamsPixel(buffPrms, idx, cnt);
		if (res != CSV_OK) {return res;}
	}
	else if (wcscmp(buffPrms[0], L"MOVETO") == 0) {
		res = CsvReadParamsMoveTo(buffPrms, idx, cnt);
		if (res != CSV_OK) {return res;}
	}
	else if (wcscmp(buffPrms[0], L"LINETO") == 0) {
		res = CsvReadParamsLineTo(buffPrms, idx, cnt);
		if (res != CSV_OK) {return res;}
	}
	else if (wcscmp(buffPrms[0], L"FLOOD") == 0) {
		res = CsvReadParamsFlood(buffPrms, idx, cnt);
		if (res != CSV_OK) {return res;}
	}
	else {
		return CSV_OK;
	}
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParamsDefine(WCHAR [][], INT32, INT32)
    FWCHAR [][]  -
          INT32       -
          INT32       -
    ߒlFINT32       -
    @\Fp[^𒊏o DEFINE
------------------------------------------------------------------------------*/
INT32 CsvReadParamsDefine(WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1], INT32 idx, INT32 cnt)
{
	if (cnt != 3) {return CSV_ERR_DEF_WRONG;}
	
	prms.cmd = CMD_DEFINE;
	
	if (cntDefine >= MAX_DEFINE) {return CSV_ERR_DEF_COUNT;}
	
	CsvRemove(buffPrms[1]);
	CsvRemove(buffPrms[2]);
	CsvReplace(buffPrms[2]);
	
	if ((wcslen(buffPrms[1]) == 0) || (wcslen(buffPrms[2]) == 0)) {return CSV_ERR_DEF_LEN0;}
	
	if ((wcslen(buffPrms[1]) >= LEN_SIG) || (wcslen(buffPrms[2]) >= LEN_VAL)) {return CSV_ERR_DEF_LENOVER;}
	
	if (CsvLinearIsExist(buffPrms[1])) {return CSV_ERR_DEF_DUP;}
	
	CsvLinearInsert(buffPrms[1], buffPrms[2]);
	cntDefine++;
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParamsText(WCHAR [][], INT32, INT32)
    FWCHAR [][]  -
          INT32       -
          INT32       -
    ߒlFINT32       -
    @\Fp[^𒊏o TEXT
------------------------------------------------------------------------------*/
INT32 CsvReadParamsText(WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1], INT32 idx, INT32 cnt)
{
	INT32 res;
	
	if (cnt != 10) {return CSV_ERR_WRONG;}
	
	prms.cmd = CMD_TEXT;
	
	CsvRemove(buffPrms[1]);
	CsvRemove(buffPrms[2]);
	CsvRemove(buffPrms[4]);
	CsvRemove(buffPrms[5]);
	CsvRemove(buffPrms[6]);
	CsvRemove(buffPrms[8]);
	CsvRemove(buffPrms[9]);
	
	CsvReplace(buffPrms[1]);
	CsvReplace(buffPrms[2]);
	CsvReplace(buffPrms[4]);
	CsvReplace(buffPrms[5]);
	CsvReplace(buffPrms[6]);
	CsvReplace(buffPrms[8]);
	CsvReplace(buffPrms[9]);
	
	if ((res = CsvCalc(idx, buffPrms[1], &prms.x)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[2], &prms.y)) != CSV_OK) {return res;}
	wcscpy(prms.text, buffPrms[3]);
	prms.rgb      = _wtor(buffPrms[4]);
	prms.back     = _wtor(buffPrms[5]);
	prms.flgAlpha = _wtob(buffPrms[6]);
	wcscpy(prms.fmy,  buffPrms[7]);
	if ((res = CsvCalc(idx, buffPrms[8], &prms.size)) != CSV_OK) {return res;}
	prms.flgVert = _wtob(buffPrms[9]);
	
	if ((prms.x < -999) || (9999 < prms.x) ||
		(prms.y < -999) || (9999 < prms.y) ||
		(prms.size < 0) || (999  < prms.size))
	{
		return CSV_ERR_VALI;
	}
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParamsLine(WCHAR [][], INT32, INT32)
    FWCHAR [][]  -
          INT32       -
          INT32       -
    ߒlFINT32       -
    @\Fp[^𒊏o LINE
------------------------------------------------------------------------------*/
INT32 CsvReadParamsLine(WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1], INT32 idx, INT32 cnt)
{
	INT32 res;
	
	if (cnt != 7) {return CSV_ERR_WRONG;}
	
	prms.cmd = CMD_LINE;
	
	CsvRemove(buffPrms[1]);
	CsvRemove(buffPrms[2]);
	CsvRemove(buffPrms[3]);
	CsvRemove(buffPrms[4]);
	CsvRemove(buffPrms[5]);
	CsvRemove(buffPrms[6]);
	
	CsvReplace(buffPrms[1]);
	CsvReplace(buffPrms[2]);
	CsvReplace(buffPrms[3]);
	CsvReplace(buffPrms[4]);
	CsvReplace(buffPrms[5]);
	CsvReplace(buffPrms[6]);
	
	if ((res = CsvCalc(idx, buffPrms[1], &prms.x1)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[2], &prms.y1)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[3], &prms.x2)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[4], &prms.y2)) != CSV_OK) {return res;}
	prms.rgb = _wtor(buffPrms[5]);
	if ((res = CsvCalc(idx, buffPrms[6], &prms.t)) != CSV_OK) {return res;}
	
	if ((prms.x1 < -9999) || (9999 < prms.x1) ||
		(prms.y1 < -9999) || (9999 < prms.y1) ||
		(prms.x2 < -9999) || (9999 < prms.x2) ||
		(prms.y2 < -9999) || (9999 < prms.y2) ||
		(prms.t  < 0)     || (99   < prms.t))
	{
		return CSV_ERR_VALI;
	}
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParamsRect(WCHAR [][], INT32, INT32)
    FWCHAR [][]  -
          INT32       -
          INT32       -
    ߒlFINT32       -
    @\Fp[^𒊏o RECT
------------------------------------------------------------------------------*/
INT32 CsvReadParamsRect(WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1], INT32 idx, INT32 cnt)
{
	INT32 res;
	
	if (cnt != 13) {return CSV_ERR_WRONG;}
	
	prms.cmd = CMD_RECT;
	
	CsvRemove(buffPrms[1]);
	CsvRemove(buffPrms[2]);
	CsvRemove(buffPrms[3]);
	CsvRemove(buffPrms[4]);
	CsvRemove(buffPrms[5]);
	CsvRemove(buffPrms[6]);
	CsvRemove(buffPrms[7]);
	CsvRemove(buffPrms[8]);
	CsvRemove(buffPrms[9]);
	CsvRemove(buffPrms[10]);
	CsvRemove(buffPrms[11]);
	CsvRemove(buffPrms[12]);
	
	CsvReplace(buffPrms[1]);
	CsvReplace(buffPrms[2]);
	CsvReplace(buffPrms[3]);
	CsvReplace(buffPrms[4]);
	CsvReplace(buffPrms[5]);
	CsvReplace(buffPrms[6]);
	CsvReplace(buffPrms[7]);
	CsvReplace(buffPrms[8]);
	CsvReplace(buffPrms[9]);
	CsvReplace(buffPrms[10]);
	CsvReplace(buffPrms[11]);
	CsvReplace(buffPrms[12]);
	
	if ((res = CsvCalc(idx, buffPrms[1], &prms.x)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[2], &prms.y)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[3], &prms.w)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[4], &prms.h)) != CSV_OK) {return res;}
	prms.rgb  = _wtor(buffPrms[5]);
	prms.back = _wtor(buffPrms[6]);
	if ((res = CsvCalc(idx, buffPrms[7], &prms.t)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[8], &prms.c)) != CSV_OK) {return res;}
	prms.flgFill = _wtob(buffPrms[9]);
	prms.flgOnly = _wtob(buffPrms[10]);
	prms.flgElip = _wtob(buffPrms[11]);
	prms.flgL    = _wtob(buffPrms[12]);
	
	if ((prms.x < -9999) || (9999 < prms.x) ||
		(prms.y < -9999) || (9999 < prms.y) ||
		(prms.w < -9999) || (9999 < prms.w) ||
		(prms.h < -9999) || (9999 < prms.h) ||
		(prms.t < 0)     || (99   < prms.t) ||
		(prms.c < 0)     || (999  < prms.c))
	{
		return CSV_ERR_VALI;
	}
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParamsPixel(WCHAR [][], INT32, INT32)
    FWCHAR [][]  -
          INT32       -
          INT32       -
    ߒlFINT32       -
    @\Fp[^𒊏o PIXEL
------------------------------------------------------------------------------*/
INT32 CsvReadParamsPixel(WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1], INT32 idx, INT32 cnt)
{
	INT32 res;
	
	if (cnt != 4) {return CSV_ERR_WRONG;}
	
	prms.cmd = CMD_PIXEL;
	
	CsvRemove(buffPrms[1]);
	CsvRemove(buffPrms[2]);
	CsvRemove(buffPrms[3]);
	
	CsvReplace(buffPrms[1]);
	CsvReplace(buffPrms[2]);
	CsvReplace(buffPrms[3]);
	
	if ((res = CsvCalc(idx, buffPrms[1], &prms.x)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[2], &prms.y)) != CSV_OK) {return res;}
	prms.rgb = _wtor(buffPrms[3]);
	
	if ((prms.x < -999) || (9999 < prms.x) ||
		(prms.y < -999) || (9999 < prms.y))
	{
		return CSV_ERR_VALI;
	}
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParamsMoveTo(WCHAR [][], INT32, INT32)
    FWCHAR [][]  -
          INT32       -
          INT32       -
    ߒlFINT32       -
    @\Fp[^𒊏o MOVETO
------------------------------------------------------------------------------*/
INT32 CsvReadParamsMoveTo(WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1], INT32 idx, INT32 cnt)
{
	INT32 res;
	
	if (cnt != 5) {return CSV_ERR_WRONG;}
	
	prms.cmd = CMD_MOVETO;
	
	CsvRemove(buffPrms[1]);
	CsvRemove(buffPrms[2]);
	CsvRemove(buffPrms[3]);
	CsvRemove(buffPrms[4]);
	
	CsvReplace(buffPrms[1]);
	CsvReplace(buffPrms[2]);
	CsvReplace(buffPrms[3]);
	CsvReplace(buffPrms[4]);
	
	if ((res = CsvCalc(idx, buffPrms[1], &prms.x)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[2], &prms.y)) != CSV_OK) {return res;}
	prms.rgb = _wtor(buffPrms[3]);
	if ((res = CsvCalc(idx, buffPrms[4], &prms.t)) != CSV_OK) {return res;}
	
	if ((prms.x < -999) || (9999 < prms.x) ||
		(prms.y < -999) || (9999 < prms.y) ||
		(prms.t < 0)    || (99   < prms.t))
	{
		return CSV_ERR_VALI;
	}
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParamsLineTo(WCHAR [][], INT32, INT32)
    FWCHAR [][]  -
          INT32       -
          INT32       -
    ߒlFINT32       -
    @\Fp[^𒊏o LINETO
------------------------------------------------------------------------------*/
INT32 CsvReadParamsLineTo(WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1], INT32 idx, INT32 cnt)
{
	INT32 res;
	
	if (cnt != 3) {return CSV_ERR_WRONG;}
	
	prms.cmd = CMD_LINETO;
	
	CsvRemove(buffPrms[1]);
	CsvRemove(buffPrms[2]);
	
	CsvReplace(buffPrms[1]);
	CsvReplace(buffPrms[2]);
	
	if ((res = CsvCalc(idx, buffPrms[1], &prms.x)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[2], &prms.y)) != CSV_OK) {return res;}
	
	if ((prms.x < -999) || (9999 < prms.x) ||
		(prms.y < -999) || (9999 < prms.y))
	{
		return CSV_ERR_VALI;
	}
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvReadParamsFlood(WCHAR [][], INT32, INT32)
    FWCHAR [][]  -
          INT32       -
          INT32       -
    ߒlFINT32       -
    @\Fp[^𒊏o FLOOD
------------------------------------------------------------------------------*/
INT32 CsvReadParamsFlood(WCHAR buffPrms[MAX_PARAMS][LEN_PARAM+1], INT32 idx, INT32 cnt)
{
	INT32 res;
	
	if (cnt != 4) {return CSV_ERR_WRONG;}
	
	prms.cmd = CMD_FLOOD;
	
	CsvRemove(buffPrms[1]);
	CsvRemove(buffPrms[2]);
	CsvRemove(buffPrms[3]);
	
	CsvReplace(buffPrms[1]);
	CsvReplace(buffPrms[2]);
	CsvReplace(buffPrms[3]);
	
	if ((res = CsvCalc(idx, buffPrms[1], &prms.x)) != CSV_OK) {return res;}
	if ((res = CsvCalc(idx, buffPrms[2], &prms.y)) != CSV_OK) {return res;}
	prms.rgb = _wtor(buffPrms[3]);
	
	if ((prms.x < -999) || (9999 < prms.x) ||
		(prms.y < -999) || (9999 < prms.y))
	{
		return CSV_ERR_VALI;
	}
	
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    FINT32 CsvSplit(WCHAR *, WCHAR [][], INT32 *, INT32)
    FWCHAR *     -
          WCHAR [][]  -
          INT32 *     -
          INT32       -
    ߒlFINT32       -
    @\FJ}ŋ؂
------------------------------------------------------------------------------*/
INT32 CsvSplit(WCHAR *buff, WCHAR buffPrms[][LEN_PARAM+1], INT32 *pCnt, INT32 idx)
{
	INT32 i;
	INT32 idxPrms;
	INT32 idxChar;
	WCHAR c;
	
	idxPrms = 0;
	idxChar = 0;
	
	i = 0;
	while (1) {
		if (idxChar >= LEN_PARAM)  {return CSV_ERR_SPL_OVCHAR;}
		if (idxPrms >= MAX_PARAMS) {return CSV_ERR_SPL_OVPRMS;}
		
		c = *(buff + i);
		
		if (c == L'\0') {
			break;
		}
		else if (c == L',') {
			idxPrms++;
			idxChar = 0;
		}
		else {
			buffPrms[idxPrms][idxChar] = c;
			idxChar++;
		}
		i++;
	}
	
	*pCnt = idxPrms + 1;
	return CSV_OK;
}

/*------------------------------------------------------------------------------
    Fvoid CsvRemove(WCHAR *)
    FWCHAR *    -
    @\F󔒂ƃ^u폜
------------------------------------------------------------------------------*/
void CsvRemove(WCHAR *buff)
{
	WCHAR *dst = buff;
	WCHAR *src = buff;
	
	while (*src) {
		if ((*src == L' ') ||
			(*src == L'\t'))
		{
			src++;
			continue;
		}
		*dst = *src;
		
		dst++;
		src++;
	}
	*dst = L'\0';
}

/*------------------------------------------------------------------------------
    Fvoid CsvReplace(WCHAR *)
    FWCHAR *   -
    @\F`ւ
------------------------------------------------------------------------------*/
void CsvReplace(WCHAR *buff)
{
	INT32 i;
	INT32 cnt;
	WCHAR *pStr;
	WCHAR *pRes;
	WCHAR tmp1[LEN_VAL+1];
	WCHAR tmp2[LEN_VAL+1];
	Linear *pCur;
	
	wmemset(tmp1, 0x0000, LEN_VAL+1);
	wmemset(tmp2, 0x0000, LEN_VAL+1);
	
	wcscpy(tmp1, buff);
	pStr = tmp1;
	
	pCur = root.next;
	
	for (i = 0; i < cntDefine; i++) {
		while (1) {
			pRes = wcsstr(pStr, pCur->sig);
			if (pRes != NULL) {
				cnt = pRes - pStr;
				
				wcsncat(tmp2, pStr, cnt);
				wcscat (tmp2, pCur->val);
				
				pStr = pRes + wcslen(pCur->sig);
			}
			else {
				wcscat(tmp2, pStr);
				break;
			}
		}
		wcscpy(tmp1, tmp2);
		pStr = tmp1;
		wmemset(tmp2, 0x0000, LEN_VAL+1);
		
		pCur = pCur->next;
	}
	wmemset(buff, 0x0000, LEN_VAL+1);
	wcscpy(buff, tmp1);
}

/*------------------------------------------------------------------------------
    FBOOL CsvCalc(INT32, const WCHAR *const, INT32 *)
    FINT32               -
          const WCHAR *const  -
          INT32 *             -
    ߒlFBOOL                -
    @\Fp[^̒̐vZ
------------------------------------------------------------------------------*/
BOOL CsvCalc(INT32 idx, const WCHAR *const str, INT32 *val)
{
	INT32 res;
	Polish *pol;
	
	pol = new Polish();
	res = pol->Calc(str, val);
	delete pol;
	
	if (res == PLSH_NOERROR) {return CSV_OK;}
	else                     {return res;}
}

/*------------------------------------------------------------------------------
    Fvoid CsvLinearIsExist(WCHAR *)
    FWCHAR *   -
    @\FjAɊɂ邩ǂ
------------------------------------------------------------------------------*/
BOOL CsvLinearIsExist(WCHAR *sig)
{
	Linear *pCur;
	
	pCur = root.next;
	
	while (pCur != NULL) {
		if (wcscmp(pCur->sig, sig) == 0) {return TRUE;}
		pCur = pCur->next;
	}
	return FALSE;
}

/*------------------------------------------------------------------------------
    Fvoid CsvLinearInsert(WCHAR *, WCHAR *)
    FWCHAR *   -
          WCHAR *   -
    @\FjAɍ
------------------------------------------------------------------------------*/
void CsvLinearInsert(WCHAR *sig, WCHAR *val)
{
	Linear *pCur;
	
	if (root.next == NULL) {
		CsvLinearAdd(&root, sig, val);
		return;
	}
	
	pCur = &root;
	
	while (1) {
		if (pCur->next == NULL) {
			CsvLinearAdd(pCur, sig, val);
			return;
		}
		
		if (wcslen(sig) >= wcslen(pCur->next->sig)) {
			CsvLinearAdd(pCur, sig, val);
			return;
		}
		pCur = pCur->next;
	}
}

/*------------------------------------------------------------------------------
    Fvoid CsvLinearAdd(Linear *, WCHAR *, WCHAR *)
    FLinear *  -
          WCHAR *   -
          WCHAR *   -
    @\FjAɒǉ
------------------------------------------------------------------------------*/
void CsvLinearAdd(Linear *pCur, WCHAR *sig, WCHAR *val)
{
	Linear *pTmp;
	
	pTmp = (Linear *)a_malloc(sizeof(Linear));
	wmemset(pTmp->sig, 0x0000, LEN_SIG+1);
	wmemset(pTmp->val, 0x0000, LEN_VAL+1);
	wcscpy(pTmp->sig, sig);
	wcscpy(pTmp->val, val);
	pTmp->next = pCur->next;
	pCur->next = pTmp;
}

/*------------------------------------------------------------------------------
    Fvoid CsvLinearDelete(void)
    @\FjA폜
------------------------------------------------------------------------------*/
void CsvLinearDelete(void)
{
	Linear *pCur;
	Linear *pDel;
	
	if (root.next == NULL) {return;}
	pCur = root.next;
	
	do {
		pDel = pCur;
		pCur = pCur->next;
		free(pDel);
	} while (pCur != NULL);
	
	root.next = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid CsvLinearDump(void)
    @\FjA̓eo
------------------------------------------------------------------------------*/
void CsvLinearDump(void)
{
	INT32 i;
	Linear *pCur;
	WCHAR str_print[3000];
	
	wmemset(str_print, 0x0000, 3000);
	
	i = 0;
	pCur = root.next;
	
	while (pCur != NULL) {
		if (30 < i) {
			MessageBox(NULL, str_print, L_TITLE, MB_OK);
			wmemset(str_print, 0x0000, 3000);
			i = 0;
		}
		
		wcscat(str_print, pCur->sig);
		wcscat(str_print, L",\t");
		wcscat(str_print, pCur->val);
		wcscat(str_print, L"\r\n");
		
		pCur = pCur->next;
		i++;
	}
	
	MessageBox(NULL, str_print, L_TITLE, MB_OK);
}

/*------------------------------------------------------------------------------
    Fvoid CsvDraw(st_Image *)
    Fst_Image *  -
    @\FꎞC[W`
------------------------------------------------------------------------------*/
void CsvDraw(st_Image *pImg)
{
	switch (prms.cmd) {
	case CMD_TEXT:    CsvDrawText(pImg);    break;
	case CMD_LINE:    CsvDrawLine(pImg);    break;
	case CMD_RECT:    CsvDrawRect(pImg);    break;
	case CMD_PIXEL:   CsvDrawPixel(pImg);   break;
	case CMD_MOVETO:  CsvDrawMoveto(pImg);  break;
	case CMD_LINETO:  CsvDrawLineto(pImg);  break;
	case CMD_FLOOD:   CsvDrawFlood(pImg);   break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid CsvDrawText(st_Image *)
    Fst_Image *  -
    @\F̕`
------------------------------------------------------------------------------*/
void CsvDrawText(st_Image *pImg)
{
	HDC hdc;
	HFONT hFt;
	HFONT hFtOld;
	WCHAR fmy[100+1];
	INT32 escapement;
	INT32 x;
	INT32 y;
	INT32 xMv;
	INT32 mode;
	
	hdc = pImg->hdc;
	x   = prms.x;
	y   = prms.y;
	
	if (prms.flgVert) {swprintf(fmy, L"@%s", prms.fmy); xMv = prms.size; escapement = 2700;}
	else              {swprintf(fmy, L"%s",  prms.fmy); xMv = 0;         escapement = 0;}
	
	hFt = CreateFont(prms.size, 0, escapement, 0, FW_DONTCARE,
					 FALSE, FALSE, FALSE,
					 ANSI_CHARSET,
					 OUT_DEFAULT_PRECIS,
					 CLIP_DEFAULT_PRECIS,
					 DEFAULT_QUALITY,
					 DEFAULT_PITCH|FF_DONTCARE, fmy);
	
	SetTextColor(hdc, prms.rgb);
	SetBkColor  (hdc, prms.back);
	
	if (prms.flgAlpha) {mode = TRANSPARENT;}
	else               {mode = OPAQUE;}
	SetBkMode(hdc, mode);
	
	hFtOld = (HFONT)SelectObject(hdc, hFt);
	
	a_TextOut(hdc, x + xMv, y, prms.text);
	
	SelectObject(hdc, hFtOld);
	DeleteObject(hFt);
}

/*------------------------------------------------------------------------------
    Fvoid CsvDrawLine(st_Image *)
    Fst_Image *  -
    @\F̕`
------------------------------------------------------------------------------*/
void CsvDrawLine(st_Image *pImg)
{
	HDC hdc;
	HPEN hPen;
	HPEN hPenOld;
	INT32 x1;
	INT32 y1;
	INT32 x2;
	INT32 y2;
	
	hdc = pImg->hdc;
	x1  = prms.x1;
	y1  = prms.y1;
	x2  = prms.x2;
	y2  = prms.y2;
	
	SetBkMode(hdc, TRANSPARENT);
	hPen = CreatePen(PS_SOLID, prms.t, prms.rgb);
	hPenOld = (HPEN)SelectObject(hdc, hPen);
	
	MoveToEx(hdc, x1, y1, NULL);
	LineTo  (hdc, x2, y2);
	
	SelectObject(hdc, hPenOld);
	DeleteObject(hPen);
}

/*------------------------------------------------------------------------------
    Fvoid CsvDrawRect(st_Image *)
    Fst_Image *  -
    @\F`̕`
------------------------------------------------------------------------------*/
void CsvDrawRect(st_Image *pImg)
{
	HDC hdc;
	HPEN   hPen;
	HBRUSH hBr;
	HPEN   old1;
	HBRUSH old2;
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	
	hdc = pImg->hdc;
	x   = prms.x;
	y   = prms.y;
	w   = prms.w;
	h   = prms.h;
	
	if ((prms.flgOnly == TRUE) && (prms.flgL == FALSE)) {
		hPen = CreatePen(PS_SOLID, prms.t, prms.back);
	}
	else {
		hPen = CreatePen(PS_SOLID, prms.t, prms.rgb);
	}
	old1 = (HPEN)SelectObject(hdc, hPen);
	
	hBr  = CreateSolidBrush(prms.back);
	old2 = (HBRUSH)SelectObject(hdc, hBr);
	
	if (prms.flgL == TRUE) {
		MoveToEx(hdc, x,     y, NULL);
		LineTo  (hdc, x,     y + h);
		LineTo  (hdc, x + w, y + h);
	}
	else if (prms.flgElip == TRUE) {
		if      (prms.flgOnly == TRUE)  {/*SelectObject(hdc, hPnNull);*/}
		else if (prms.flgFill == FALSE) {SelectObject(hdc, hBrNull);}
		Ellipse(hdc, x, y, x + w, y + h);
	}
	else {
		if      (prms.flgOnly == TRUE)  {/*SelectObject(hdc, hPnNull);*/}
		else if (prms.flgFill == FALSE) {SelectObject(hdc, hBrNull);}
		
		if (prms.c != 0) {
			RoundRect(hdc, x, y, x + w, y + h, prms.c, prms.c);
		}
		else {
			Rectangle(hdc, x, y, x + w, y + h);
		}
	}
	
	SelectObject(hdc, old1);
	SelectObject(hdc, old2);
	DeleteObject(hPen);
	DeleteObject(hBr);
}

/*------------------------------------------------------------------------------
    Fvoid CsvDrawPixel(st_Image *)
    Fst_Image *  -
    @\FsNZ̕`
------------------------------------------------------------------------------*/
void CsvDrawPixel(st_Image *pImg)
{
	HDC hdc;
	INT32 x;
	INT32 y;
	
	hdc = pImg->hdc;
	x   = prms.x;
	y   = prms.y;
	
	SetPixel(hdc, x, y, prms.rgb);
}

/*------------------------------------------------------------------------------
    Fvoid CsvDrawMoveto(st_Image *)
    Fst_Image *  -
    @\Fn_̕`
------------------------------------------------------------------------------*/
void CsvDrawMoveto(st_Image *pImg)
{
	HDC hdc;
	INT32 x;
	INT32 y;
	
	hdc = pImg->hdc;
	x   = prms.x;
	y   = prms.y;
	
	SelectObject(hdc, hPnMtOld);
	DeleteObject(hPnMt);
	
	hPnMt = CreatePen(PS_SOLID, prms.t, prms.rgb);
	hPnMtOld = (HPEN)SelectObject(hdc, hPnMt);
	
	MoveToEx(hdc, x, y, NULL);
	LineTo  (hdc, x, y);
}

/*------------------------------------------------------------------------------
    Fvoid CsvDrawLineto(st_Image *)
    Fst_Image *  -
    @\Fp̕`
------------------------------------------------------------------------------*/
void CsvDrawLineto(st_Image *pImg)
{
	HDC hdc;
	INT32 x;
	INT32 y;
	
	hdc = pImg->hdc;
	x   = prms.x;
	y   = prms.y;
	
	LineTo(hdc, x, y);
}

/*------------------------------------------------------------------------------
    Fvoid CsvDrawFlood(st_Image *)
    Fst_Image *  -
    @\FhԂ̕`
------------------------------------------------------------------------------*/
void CsvDrawFlood(st_Image *pImg)
{
	HDC hdc;
	INT32 x;
	INT32 y;
	HBRUSH hBr;
	HBRUSH old;
	INT32 target;
	
	hdc = pImg->hdc;
	x   = prms.x;
	y   = prms.y;
	
	hBr = CreateSolidBrush(prms.rgb);
	old = (HBRUSH)SelectObject(hdc, hBr);
	
	target = GetPixel(hdc, x, y);
	ExtFloodFill(hdc, x, y, target, FLOODFILLSURFACE);
	
	SelectObject(hdc, old);
	DeleteObject(hBr);
}
