/*------------------------------------------------------------------------------
    VXeCN[h
------------------------------------------------------------------------------*/
#include <windows.h>
#include <stdio.h>
#include <shlwapi.h>
#include <shlobj.h>

/*------------------------------------------------------------------------------
    ˑ
------------------------------------------------------------------------------*/
#pragma resource "icon_cui.res"

/*------------------------------------------------------------------------------
    ^  VXeCN[hɊɑ݂镨܂
------------------------------------------------------------------------------*/
typedef          int       BOOL;
typedef unsigned char      UINT8;
typedef signed   char      INT8;
typedef          char      ACHAR;
typedef unsigned short     UINT16;
typedef signed   short     INT16;
typedef unsigned int       UINT32;
typedef signed   int       INT32;
typedef unsigned long      ULOG32;
typedef signed   long      LOG32;
typedef unsigned long long UINT64;
typedef signed   long long INT64;
typedef const    WCHAR     LCHAR;

/*------------------------------------------------------------------------------
    ft@C
------------------------------------------------------------------------------*/
#define L_TITLE    (WCHAR *)L"SkyPhotoViewer"
#define L_ERROR    (WCHAR *)L"Error"
#define KEY_TAB    0x009
#define KEY_ENTER  0x00D
#define KEY_SHIFT  0x010
#define KEY_ESC    0x01B
#define TBSP_CNS   4
#define MAX_LEN    20000
#define MAX_LINE   1000

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void ProcessFromUI(void);
void ProcessFromPrompt(void);
void SetStartupPathName(void);
void SetFullPathName(void);
void Inst(void);
void MessageLoop(void);
LRESULT CALLBACK CnWndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CnWndProcPd(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CnWndProcEditP(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CnWndProcEditC(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CnWndProcBtnBrs(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CnWndProcBtnExe(HWND, UINT, WPARAM, LPARAM);
int CALLBACK FmWndProcBrs(HWND,UINT,LPARAM,LPARAM);
void CnSetFocus(WPARAM, LPARAM);
void CnSize(WPARAM, LPARAM);
void CnMinMaxInfo(WPARAM,LPARAM);
void CnClose(WPARAM,LPARAM);
void CnDestroy(WPARAM,LPARAM);
void CnKeyDown(WPARAM,LPARAM,HWND);
void CnKeyDownEnter(WPARAM,LPARAM,HWND);
void CnKeyDownEsc(WPARAM,LPARAM,HWND);
void CnKeyDownTab(WPARAM,LPARAM,HWND);
void CnPdCommand(WPARAM,LPARAM);
void CnEdSetFocus(WPARAM,LPARAM,HWND);
void CnEnterBrs(void);
void CnEnterExe(void);
void CnExecute(void);
BOOL IsExistFolder(WCHAR *);
BOOL IsFullPath(WCHAR *);
BOOL SetupLoad(void);
BOOL SetupStore(void);
BOOL SetupReadStr(HANDLE, WCHAR *, char *);
void SetupWriteStr(HANDLE, WCHAR *, char *);

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
WCHAR cmdStr[MAX_LINE];
WCHAR startup[MAX_PATH];
HINSTANCE gInst;
HICON hIcon;
HCURSOR hCurArrow;
HBRUSH hBrWhite;
HBRUSH hBrBrGray;
HFONT hFtArial14;
HFONT hFtMsGothic;
HWND hWnd;
HWND hPd[2];
HWND hEdit[2];
HWND hBtn[2];
LRESULT (CALLBACK *pCallEdit[2]) (HWND,UINT,WPARAM,LPARAM);
LRESULT (CALLBACK *pCallBtn[2]) (HWND,UINT,WPARAM,LPARAM);
INT32 tabStopIdx;
HWND tabStops[TBSP_CNS];

/*------------------------------------------------------------------------------
    Fint wWinMain(,,,)
    F,,,    -
    ߒlFint    -
    @\FX^[gAbv
------------------------------------------------------------------------------*/
int wWinMain(HINSTANCE v1, HINSTANCE v2, LPWSTR v3, int v4)
{
	INT32 len;
	
	gInst = v1;
	len   = wcslen(v3);
	
	if (len > MAX_LINE) {
		MessageBox(NULL, L"command too long error", L_ERROR, MB_OK);
	}
	else if (len == 0) {
		hIcon       = LoadIcon(gInst, L"MOONCUI");
		hCurArrow   = LoadCursor(NULL, IDC_ARROW);
		hBrWhite    = CreateSolidBrush(RGB(0xFF, 0xFF, 0xFF));
		hBrBrGray   = CreateSolidBrush(RGB(0xEE, 0xEE, 0xEE));
		hFtArial14  = CreateFont(14,0,0,0,FW_DONTCARE,FALSE,FALSE,FALSE,ANSI_CHARSET,
								 OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
								 DEFAULT_PITCH|FF_DONTCARE,L"Arial");
		hFtMsGothic = CreateFont(14,0,0,0,FW_DONTCARE,FALSE,FALSE,FALSE,ANSI_CHARSET,
								 OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
								 DEFAULT_PITCH|FF_DONTCARE,L"lr SVbN");
		Inst();
		MessageLoop();
		
		DeleteObject(hIcon);
		DeleteObject(hCurArrow);
		DeleteObject(hBrWhite);
		DeleteObject(hBrBrGray);
		DeleteObject(hFtArial14);
		DeleteObject(hFtMsGothic);
	}
	else {
		wcscpy(cmdStr, v3);
		ProcessFromPrompt();
	}
	return 0;
}

/*------------------------------------------------------------------------------
    Fvoid ProcessFromUI(void)
    @\FR}htspv.exes
------------------------------------------------------------------------------*/
void ProcessFromUI(void)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	WCHAR path[MAX_PATH];
	WCHAR str [MAX_PATH + MAX_LINE];
	BOOL res;
	
	SetStartupPathName();
	
	wmemset(path, 0x0000, MAX_PATH);
	GetModuleFileName(NULL, path, MAX_PATH);
	PathRemoveFileSpec(path);
	wcscat(path, L"\\spv.exe");
	
	wmemset(str, 0x0000, MAX_PATH + MAX_LINE);
	wcscat(str, path);
	wcscat(str, L" ");
	wcscat(str, cmdStr);
	
	memset(&si, 0, sizeof(STARTUPINFO));
	memset(&pi, 0, sizeof(PROCESS_INFORMATION));
	si.cb = sizeof(STARTUPINFO);
	
	res = CreateProcess(NULL,str,NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,NULL,NULL,&si,&pi);
	if (res) {
		WaitForInputIdle(pi.hProcess, INFINITE);
	}
	else {
		MessageBox(NULL, str, L"process start error", MB_OK);
	}
}

/*------------------------------------------------------------------------------
    Fvoid ProcessFromPrompt(void)
    @\FR}htspv.exes
------------------------------------------------------------------------------*/
void ProcessFromPrompt(void)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	WCHAR path[MAX_PATH];
	WCHAR str [MAX_PATH + MAX_LINE];
	BOOL res;
	
	SetFullPathName();
	
	wmemset(path, 0x0000, MAX_PATH);
	GetModuleFileName(NULL, path, MAX_PATH);
	PathRemoveFileSpec(path);
	wcscat(path, L"\\spv.exe");
	
	wmemset(str, 0x0000, MAX_PATH + MAX_LINE);
	wcscat(str, path);
	wcscat(str, L" ");
	wcscat(str, cmdStr);
	
	memset(&si, 0, sizeof(STARTUPINFO));
	memset(&pi, 0, sizeof(PROCESS_INFORMATION));
	si.cb = sizeof(STARTUPINFO);
	
	res = CreateProcess(NULL,str,NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,NULL,NULL,&si,&pi);
	if (res) {
		WaitForInputIdle(pi.hProcess, INFINITE);
	}
	else {
		MessageBox(NULL, str, L"process start error", MB_OK);
	}
}

/*------------------------------------------------------------------------------
    Fvoid SetStartupPathName(void)
    @\FR}h̃pXw肳ꂽtH_̃pXɕύX
------------------------------------------------------------------------------*/
void SetStartupPathName(void)
{
	WCHAR fullpath1[MAX_PATH];
	WCHAR fullpath2[MAX_PATH];
	WCHAR pathD[MAX_PATH];
	WCHAR **ppStr;
	INT32 cnt;
	
	ppStr = CommandLineToArgvW(cmdStr, &cnt);
	GetWindowText(hEdit[0], pathD, MAX_PATH);
	wcscpy(fullpath1, pathD);
	wcscat(fullpath1, L"\\");
	wcscpy(fullpath2, pathD);
	wcscat(fullpath2, L"\\");
	
	// HELLO
	if (wcscmp(ppStr[0], L"HELLO") == 0) {
		if (cnt != 1) {return;}
	}
	// PATH, [t@C]
	else if (wcscmp(ppStr[0], L"PATH") == 0) {
		if (cnt != 2) {return;}
		PathUnquoteSpaces(ppStr[1]);
		if (IsFullPath(ppStr[1])) {wcscpy(fullpath1, ppStr[1]);}
		else                      {wcscat(fullpath1, ppStr[1]);}
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);
	}
	// NEW, [VK摜t@C], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"NEW") == 0) {
		if (cnt != 4) {return;}
		PathUnquoteSpaces(ppStr[1]);
		if (IsFullPath(ppStr[1])) {wcscpy(fullpath1, ppStr[1]);}
		else                      {wcscat(fullpath1, ppStr[1]);}
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);
	}
	// ROTATE, [Ώۉ摜t@C]
	else if (wcscmp(ppStr[0], L"ROTATE") == 0) {
		if (cnt != 2) {return;}
		PathUnquoteSpaces(ppStr[1]);
		if (IsFullPath(ppStr[1])) {wcscpy(fullpath1, ppStr[1]);}
		else                      {wcscat(fullpath1, ppStr[1]);}
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);
	}
	// DEFORM, [Ώۉ摜t@C], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"DEFORM") == 0) {
		if (cnt != 4) {return;}
		PathUnquoteSpaces(ppStr[1]);
		if (IsFullPath(ppStr[1])) {wcscpy(fullpath1, ppStr[1]);}
		else                      {wcscat(fullpath1, ppStr[1]);}
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);
	}
	// RESIZE, [Ώۉ摜t@C]
	else if (wcscmp(ppStr[0], L"RESIZE") == 0) {
		if (cnt != 2) {return;}
		PathUnquoteSpaces(ppStr[1]);
		if (IsFullPath(ppStr[1])) {wcscpy(fullpath1, ppStr[1]);}
		else                      {wcscat(fullpath1, ppStr[1]);}
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);
	}
	// CSV, [Ώۉ摜t@C], [CSVt@C]
	else if (wcscmp(ppStr[0], L"CSV") == 0) {
		if (cnt != 3) {return;}
		PathUnquoteSpaces(ppStr[1]);
		PathUnquoteSpaces(ppStr[2]);
		if (IsFullPath(ppStr[1])) {wcscpy(fullpath1, ppStr[1]);}
		else                      {wcscat(fullpath1, ppStr[1]);}
		if (IsFullPath(ppStr[2])) {wcscpy(fullpath2, ppStr[2]);}
		else                      {wcscat(fullpath2, ppStr[2]);}
		PathQuoteSpaces(fullpath1);
		PathQuoteSpaces(fullpath2);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath2);
	}
	// APPEND, [Ώۉ摜t@C], [ǉ摜t@C], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"APPEND") == 0) {
		if (cnt != 5) {return;}
		PathUnquoteSpaces(ppStr[1]);
		PathUnquoteSpaces(ppStr[2]);
		if (IsFullPath(ppStr[1])) {wcscpy(fullpath1, ppStr[1]);}
		else                      {wcscat(fullpath1, ppStr[1]);}
		if (IsFullPath(ppStr[2])) {wcscpy(fullpath2, ppStr[2]);}
		else                      {wcscat(fullpath2, ppStr[2]);}
		PathQuoteSpaces(fullpath1);
		PathQuoteSpaces(fullpath2);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath2);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);
	}
	// SEPARATE, [ - ], [Ώۉ摜t@C], [ - ], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"SEPARATE") == 0) {
		if (cnt != 6) {return;}
		PathUnquoteSpaces(ppStr[2]);
		if (IsFullPath(ppStr[2])) {wcscpy(fullpath1, ppStr[2]);}
		else                      {wcscat(fullpath1, ppStr[2]);}
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[1]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[5]);
	}
	// TRIM, [Ώۉ摜t@C], [ - ], [ - ], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"TRIM") == 0) {
		if (cnt != 6) {return;}
		PathUnquoteSpaces(ppStr[1]);
		if (IsFullPath(ppStr[1])) {wcscpy(fullpath1, ppStr[1]);}
		else                      {wcscat(fullpath1, ppStr[1]);}
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[5]);
	}
}

/*------------------------------------------------------------------------------
    Fvoid SetFullPathName(void)
    @\FR}h̃pXtpXɕύX
------------------------------------------------------------------------------*/
void SetFullPathName(void)
{
	WCHAR fullpath1[MAX_PATH];
	WCHAR fullpath2[MAX_PATH];
	WCHAR pathD[MAX_PATH];
	WCHAR **ppStr;
	INT32 cnt;
	
	ppStr = CommandLineToArgvW(cmdStr, &cnt);
	GetWindowText(hEdit[0], pathD, MAX_PATH);
	
	// HELLO
	if (wcscmp(ppStr[0], L"HELLO") == 0) {
		if (cnt != 1) {return;}
	}
	// PATH, [t@C]
	else if (wcscmp(ppStr[0], L"PATH") == 0) {
		if (cnt != 2) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);
	}
	// NEW, [VK摜t@C], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"NEW") == 0) {
		if (cnt != 4) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);
	}
	// ROTATE, [Ώۉ摜t@C]
	else if (wcscmp(ppStr[0], L"ROTATE") == 0) {
		if (cnt != 2) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);
	}
	// DEFORM, [Ώۉ摜t@C], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"DEFORM") == 0) {
		if (cnt != 4) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);
	}
	// RESIZE, [Ώۉ摜t@C]
	else if (wcscmp(ppStr[0], L"RESIZE") == 0) {
		if (cnt != 2) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);
	}
	// CSV, [Ώۉ摜t@C], [CSVt@C]
	else if (wcscmp(ppStr[0], L"CSV") == 0) {
		if (cnt != 3) {return;}
		PathUnquoteSpaces(ppStr[1]);
		PathUnquoteSpaces(ppStr[2]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		GetFullPathName(ppStr[2], MAX_PATH, fullpath2, NULL);
		PathQuoteSpaces(fullpath1);
		PathQuoteSpaces(fullpath2);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath2);
	}
	// APPEND, [Ώۉ摜t@C], [ǉ摜t@C], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"APPEND") == 0) {
		if (cnt != 5) {return;}
		PathUnquoteSpaces(ppStr[1]);
		PathUnquoteSpaces(ppStr[2]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		GetFullPathName(ppStr[2], MAX_PATH, fullpath2, NULL);
		PathQuoteSpaces(fullpath1);
		PathQuoteSpaces(fullpath2);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath2);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);
	}
	// SEPARATE, [ - ], [Ώۉ摜t@C], [ - ], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"SEPARATE") == 0) {
		if (cnt != 6) {return;}
		PathUnquoteSpaces(ppStr[2]);
		GetFullPathName(ppStr[2], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[1]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[5]);
	}
	// TRIM, [Ώۉ摜t@C], [ - ], [ - ], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"TRIM") == 0) {
		if (cnt != 6) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[5]);
	}
}

/*------------------------------------------------------------------------------
    Fvoid Inst(void)
    @\F̂쐬
------------------------------------------------------------------------------*/
void Inst(void)
{
	WNDCLASS wc;
	DWORD style    = WS_CAPTION|WS_THICKFRAME|WS_SYSMENU/*|WS_MAXIMIZEBOX|WS_MINIMIZEBOX*/;
	DWORD stylePd  = WS_CHILD|WS_VISIBLE;
	DWORD styleEd1 = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_LEFT/*|ES_READONLY*/;
	DWORD styleEd2 = WS_CHILD|WS_VSCROLL|WS_VISIBLE|WS_BORDER|ES_LEFT|ES_MULTILINE|ES_AUTOHSCROLL;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	INT32 x, y;
	INT32 w, h;
	
	wc.style         = NULL;
	wc.lpfnWndProc   = DefWindowProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = gInst;
	wc.hIcon         = hIcon;
	wc.hCursor       = hCurArrow;
	wc.hbrBackground = hBrBrGray;
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = L"CONSOLE";
	RegisterClass(&wc);
	
	wc.hIcon         = NULL;
	wc.hbrBackground = hBrWhite;
	wc.lpszClassName = L"PADDING";
	RegisterClass(&wc);
	
	w = 700;
	h = 500;
	x = (GetSystemMetrics(SM_CXSCREEN)-w)/2;
	y = (GetSystemMetrics(SM_CYSCREEN)-h)/2;
	
	SetupLoad();
	if ((wcslen(startup) == 0) || (!IsExistFolder(startup))) {
		GetModuleFileName(NULL, startup, MAX_PATH);
		PathRemoveFileSpec(startup);
	}
	
	hWnd     = CreateWindow(L"CONSOLE",L"Console",style,   x,y,w,h,NULL,  NULL,gInst,NULL);
	hPd[0]   = CreateWindow(L"PADDING",NULL,      stylePd, 0,0,0,0,hWnd,  NULL,gInst,NULL);
	hPd[1]   = CreateWindow(L"PADDING",NULL,      stylePd, 0,0,0,0,hWnd,  NULL,gInst,NULL);
	hEdit[0] = CreateWindow(L"Edit",   startup,   styleEd1,0,0,0,0,hPd[0],NULL,gInst,NULL);
	hEdit[1] = CreateWindow(L"Edit",   NULL,      styleEd2,0,0,0,0,hWnd,  NULL,gInst,NULL);
	hBtn[0]  = CreateWindow(L"Button", L"browse", styleBt, 0,0,0,0,hPd[0],NULL,gInst,NULL);
	hBtn[1]  = CreateWindow(L"Button", L"execute",styleBt, 0,0,0,0,hPd[1],NULL,gInst,NULL);
	SetWindowLong(hPd[0],   GWL_USERDATA, 0);
	SetWindowLong(hPd[1],   GWL_USERDATA, 1);
	SetWindowLong(hEdit[0], GWL_USERDATA, 0);
	SetWindowLong(hEdit[1], GWL_USERDATA, 1);
	
	SetWindowLong(hWnd,   GWL_WNDPROC, (LONG)CnWndProc);
	SetWindowLong(hPd[0], GWL_WNDPROC, (LONG)CnWndProcPd);
	SetWindowLong(hPd[1], GWL_WNDPROC, (LONG)CnWndProcPd);
	
	SendMessage(hEdit[0], WM_SETFONT, (WPARAM)hFtArial14,  (LPARAM)NULL);
	SendMessage(hEdit[1], WM_SETFONT, (WPARAM)hFtMsGothic, (LPARAM)NULL);
	SendMessage(hBtn[0],  WM_SETFONT, (WPARAM)hFtArial14,  (LPARAM)NULL);
	SendMessage(hBtn[1],  WM_SETFONT, (WPARAM)hFtArial14,  (LPARAM)NULL);
	
	pCallEdit[0] = (LRESULT (CALLBACK *)(HWND,UINT,WPARAM,LPARAM))GetWindowLong(hEdit[0], GWL_WNDPROC);
	pCallEdit[1] = (LRESULT (CALLBACK *)(HWND,UINT,WPARAM,LPARAM))GetWindowLong(hEdit[1], GWL_WNDPROC);
	pCallBtn[0]  = (LRESULT (CALLBACK *)(HWND,UINT,WPARAM,LPARAM))GetWindowLong(hBtn[0],  GWL_WNDPROC);
	pCallBtn[1]  = (LRESULT (CALLBACK *)(HWND,UINT,WPARAM,LPARAM))GetWindowLong(hBtn[1],  GWL_WNDPROC);
	SetWindowLong(hEdit[0], GWL_WNDPROC, (LONG)CnWndProcEditP);
	SetWindowLong(hEdit[1], GWL_WNDPROC, (LONG)CnWndProcEditC);
	SetWindowLong(hBtn[0],  GWL_WNDPROC, (LONG)CnWndProcBtnBrs);
	SetWindowLong(hBtn[1],  GWL_WNDPROC, (LONG)CnWndProcBtnExe);
	
	tabStopIdx = 0;
	tabStops[0] = hEdit[0];
	tabStops[1] = hBtn[0];
	tabStops[2] = hEdit[1];
	tabStops[3] = hBtn[1];
	
	SetFocus(hEdit[1]);
	ShowWindow(hWnd, 0x1);
}

/*------------------------------------------------------------------------------
    Fvoid MessageLoop(void)
    @\FbZ[W[v
------------------------------------------------------------------------------*/
void MessageLoop(void)
{
	MSG msg;
	
	while (GetMessage(&msg, NULL, 0, 0) == TRUE) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CnWndProc(,,,)
    F...        -
    ߒlFLRESULT    -
    @\FCONSOLECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CnWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:       CnSetFocus(wp, lp);    break;
	case WM_SIZE:           CnSize(wp, lp);        break;
	case WM_GETMINMAXINFO:  CnMinMaxInfo(wp, lp);  break;
	case WM_CLOSE:          CnClose(wp, lp);       break;
	case WM_DESTROY:        CnDestroy(wp, lp);     break;
	default:
		break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CnWndProcPd(,,,)
    F...        -
    ߒlFLRESULT    -
    @\FPADDNGCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CnWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_COMMAND:  CnPdCommand(wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CnWndProcEditP(,,,)
    F-
    ߒlF-
    @\FEDIT PCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CnWndProcEditP(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:  CnEdSetFocus(wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CnKeyDown(wp, lp, hWnd);     break;
	case WM_CHAR:
		if (wp == KEY_TAB) {return 0;}
		break;
	default: break;
	}
	return pCallEdit[0](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CnWndProcEditC(,,,)
    F-
    ߒlF-
    @\FEDIT CCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CnWndProcEditC(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:  CnEdSetFocus(wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CnKeyDown(wp, lp, hWnd);     break;
	case WM_CHAR:
		if (wp == KEY_TAB) {return 0;}
		break;
	default:
		break;
	}
	return pCallEdit[1](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CnWndProcBtnBrs(,,,)
    F-
    ߒlF-
    @\FBTN BROWSECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CnWndProcBtnBrs(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:  CnEdSetFocus(wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CnKeyDown(wp, lp, hWnd);     break;
	default:
		break;
	}
	return pCallBtn[0](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CnWndProcBtnExe(,,,)
    F-
    ߒlF-
    @\FBTN EXECUTECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CnWndProcBtnExe(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:  CnEdSetFocus(wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CnKeyDown(wp, lp, hWnd);     break;
	default:
		break;
	}
	return pCallBtn[1](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fint CALLBACK CnWndProcBrs(,,,)
    F...    -
    ߒlFint    -
    @\FtH_IR[obN
------------------------------------------------------------------------------*/
int CALLBACK CnWndProcBrs(HWND hWnd, UINT msg, LPARAM lp1, LPARAM lp2)
{
	BROWSEINFO *pInfo;
	WCHAR *path;
	RECT rc;
	
	if (msg != BFFM_INITIALIZED) {return 0;}
	
	pInfo = (BROWSEINFO *)lp2;
	path = (WCHAR *)pInfo->lpszTitle;
	SendMessage(hWnd, BFFM_SETSELECTION, (WPARAM)TRUE, (LPARAM)path);
	
	GetWindowRect(pInfo->hwndOwner, &rc);
	SetWindowPos(hWnd, NULL, rc.left+20, rc.top-20, NULL, NULL, 0x071D);
	return 0;
}

/*------------------------------------------------------------------------------
    Fvoid CnSetFocus(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FCONSOLE WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void CnSetFocus(WPARAM wp, LPARAM lp)
{
	SetFocus(tabStops[tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid CnSize(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FCONSOLE WM_SIZECxg
------------------------------------------------------------------------------*/
void CnSize(WPARAM wp, LPARAM lp)
{
	RECT rc;
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	
	GetClientRect(hWnd, &rc);
	x = rc.left;
	y = rc.top;
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	SetWindowPos(hPd[0],   NULL, 8, 8, 494, 36, 0x071C);
	SetWindowPos(hEdit[0], NULL, 8, 8, 400, 20, 0x071C);
	SetWindowPos(hBtn[0],  NULL, 416, 5, 70, 25, 0x071C);
	SetWindowPos(hEdit[1], NULL, 8, 52, w-16, h-111, 0x071C);
	SetWindowPos(hPd[1],   NULL, w-100, h-51, 92, 43, 0x071C);
	SetWindowPos(hBtn[1],  NULL, 11, 8, 70, 25, 0x071C);
	
	InvalidateRect(hWnd, NULL, TRUE);
	UpdateWindow(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CnMinMaxInfo(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FCONSOLE WM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void CnMinMaxInfo(WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = 510+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	mmi->ptMinTrackSize.y = 200;
}

/*------------------------------------------------------------------------------
    Fvoid CnClose(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FCONSOLE WM_CLOSECxg
------------------------------------------------------------------------------*/
void CnClose(WPARAM wp, LPARAM lp)
{
	GetWindowText(hEdit[0], startup, MAX_LEN);
	SetupStore();
}

/*------------------------------------------------------------------------------
    Fvoid CnDestroy(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FCONSOLE WM_DESTROYCxg
------------------------------------------------------------------------------*/
void CnDestroy(WPARAM wp, LPARAM lp)
{
	PostMessage(NULL, WM_QUIT, (WPARAM)NULL, (LPARAM)NULL);
}

/*------------------------------------------------------------------------------
    Fvoid CnKeyDown(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FCONSOLE WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void CnKeyDown(WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  CnKeyDownEnter(wp, lp, hWnd);  break;
	case KEY_ESC:    CnKeyDownEsc  (wp, lp, hWnd);  break;
	case KEY_TAB:    CnKeyDownTab  (wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid CnKeyDownEnter(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FCONSOLE [enter]L[Cxg
------------------------------------------------------------------------------*/
void CnKeyDownEnter(WPARAM wp, LPARAM lp, HWND hWnd)
{
	if      (hWnd == hBtn[0]) {CnEnterBrs();}
	else if (hWnd == hBtn[1]) {CnEnterExe();}
	else {}
}

/*------------------------------------------------------------------------------
    Fvoid CnKeyDownEsc(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FCONSOLE [esc]L[Cxg
------------------------------------------------------------------------------*/
void CnKeyDownEsc(WPARAM wp, LPARAM lp, HWND hWnd)
{
	SendMessage(hWnd, WM_CLOSE, (WPARAM)NULL, (LPARAM)NULL);
}

/*------------------------------------------------------------------------------
    Fvoid CnKeyDownTab(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FCONSOLE [tab]L[Cxg
------------------------------------------------------------------------------*/
void CnKeyDownTab(WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (tabStopIdx == 0) {tabStopIdx = TBSP_CNS-1;}
		else                 {tabStopIdx--;}
	}
	else {
		tabStopIdx = (tabStopIdx + 1) % TBSP_CNS;
	}
	SetFocus(tabStops[tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid CnPdCommand(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FPD WM_COMMANDCxg
------------------------------------------------------------------------------*/
void CnPdCommand(WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == hBtn[0]) {CnEnterBrs();}
	else if ((HWND)lp == hBtn[1]) {CnEnterExe();}
	else {}
}

/*------------------------------------------------------------------------------
    Fvoid CnEdSetFocus(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FEDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void CnEdSetFocus(WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	INT32 len;
	
	for (i = 0; i < TBSP_CNS; i++) {
		if (hWnd == tabStops[i]) {
			tabStopIdx = i;
		}
	}
	
	if (hWnd == hEdit[0]) {
		len = SendMessage(hWnd, WM_GETTEXTLENGTH, (WPARAM)NULL, (LPARAM)NULL);
		SendMessage(hWnd, EM_SETSEL, (WPARAM)0, (LPARAM)len);
	}
}

/*------------------------------------------------------------------------------
    Fvoid CnEnterBrs(void)
    @\F[browse]{^s
------------------------------------------------------------------------------*/
void CnEnterBrs(void)
{
	BROWSEINFO info;
	LPITEMIDLIST list;
	WCHAR blank[MAX_PATH];
	WCHAR path[MAX_PATH];
	WCHAR text[MAX_PATH];
	
	GetWindowText(hEdit[0], text, MAX_LEN);
	
	info.hwndOwner      = hWnd;
	info.pidlRoot       = NULL;
	info.pszDisplayName = blank;
	info.lpszTitle      = text;
	info.ulFlags        = BIF_RETURNONLYFSDIRS  |
						  BIF_NEWDIALOGSTYLE    |
						  BIF_BROWSEFORCOMPUTER |
						  BIF_DONTGOBELOWDOMAIN |
						  BIF_RETURNFSANCESTORS |
						  BIF_RETURNONLYFSDIRS  |
						  BIF_NONEWFOLDERBUTTON;
	info.lpfn           = CnWndProcBrs;
	info.iImage         = NULL;
	info.lParam         = (LPARAM)&info;
	
	list = SHBrowseForFolder(&info);
	
	if (list != NULL) {
		SHGetPathFromIDList(list, path);
		
		if (IsExistFolder(path)) {
			if (!PathIsRoot(path)) {
				wcscpy(text, path);
			}
			else {
				if (!PathIsSystemFolder(path, NULL)) {
					wcscpy(text, path);
				}
				else {
					MessageBox(hWnd, L"impossible", L_ERROR, MB_OK);
				}
			}
		}
		else {
			MessageBox(hWnd, L"impossible", L_ERROR, MB_OK);
		}
	}
	
	CoTaskMemFree(list);
	SetWindowText(hEdit[0], text);
}

/*------------------------------------------------------------------------------
    Fvoid CnEnterExe(void)
    @\F[execute]{^s
------------------------------------------------------------------------------*/
void CnEnterExe(void)
{
	CnExecute();
}

/*------------------------------------------------------------------------------
    Fvoid CnExecute(void)
    @\Fs
------------------------------------------------------------------------------*/
void CnExecute(void)
{
	WCHAR buff[MAX_LEN];
	WCHAR *p;
	
	GetWindowText(hEdit[1], buff, MAX_LEN);
	
	p = wcstok(buff, L"\r\n");
	
	while (p != NULL) {
		wcscpy(cmdStr, p);
		
		ProcessFromUI();
		
		p = wcstok(NULL, L"\r\n");
	}
}

/*------------------------------------------------------------------------------
    FBOOL IsExistFolder(WCHAR *)
    FWCHAR *  -
    ߒlFBOOL     -
    @\FtH_̊mF
------------------------------------------------------------------------------*/
BOOL IsExistFolder(WCHAR *pathD)
{
	if (PathFileExists(pathD) == FALSE)                             {return FALSE;}
	if ((GetFileAttributes(pathD) & FILE_ATTRIBUTE_DIRECTORY) == 0) {return FALSE;}
	return TRUE;
}

/*------------------------------------------------------------------------------
    FBOOL IsFullPath(WCHAR *)
    FWCHAR *  -
    ߒlFBOOL     -
    @\FtpXǂ
------------------------------------------------------------------------------*/
BOOL IsFullPath(WCHAR *path)
{
	WCHAR fullpath[MAX_PATH];
	
	GetFullPathName(path, MAX_PATH, fullpath, NULL);
	
	if (wcscmp(path, fullpath) == 0) {return TRUE;}
	else                             {return FALSE;}
}

/*------------------------------------------------------------------------------
    FBOOL SetupLoad(void)
    ߒlFBOOL  -
    @\FZbgAbvt@C̓ǂݍ݂s
------------------------------------------------------------------------------*/
BOOL SetupLoad(void)
{
	HANDLE hFile;
	WCHAR path[MAX_PATH];
	WCHAR _startup[MAX_PATH];
	
	memset(startup, 0x00, MAX_PATH*2);
	
	SHGetSpecialFolderPath(NULL, path, CSIDL_PERSONAL, FALSE);
	wcscat(path, L"\\");
	wcscat(path, L_TITLE);
	if (!IsExistFolder(path)) {return FALSE;}
	wcscat(path, L"\\setup_cui.dat");
	
	hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
					   FILE_ATTRIBUTE_NORMAL, NULL);
	
	if (hFile == INVALID_HANDLE_VALUE) {return FALSE;}
	
	SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
	
	memset(_startup, 0x00, MAX_PATH*2);
	if (!SetupReadStr(hFile,_startup, (char *)"startup")) {CloseHandle(hFile); return FALSE;}
	
	CloseHandle(hFile);
	
	wcscpy(startup, _startup);
	return TRUE;
}

/*------------------------------------------------------------------------------
    FBOOL SetupStore(void)
    ߒlFBOOL  -
    @\FZbgAbvt@C݂̏s
------------------------------------------------------------------------------*/
BOOL SetupStore(void)
{
	HANDLE hFile;
	WCHAR path[MAX_PATH];
	
	SHGetSpecialFolderPath(NULL, path, CSIDL_PERSONAL, FALSE);
	wcscat(path, L"\\");
	wcscat(path, L_TITLE);
	if (!IsExistFolder(path)) {CreateDirectory(path, NULL);}
	wcscat(path, L"\\setup_cui.dat");
	
	hFile = CreateFile(path, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS,
					   FILE_ATTRIBUTE_NORMAL, NULL);
	
	if (hFile == INVALID_HANDLE_VALUE)
	{MessageBox(hWnd, L"setup_cui.dat error", L_ERROR, MB_OK);  return FALSE;}
	
	SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
	SetupWriteStr(hFile, startup,(char *)"startup");
	
	CloseHandle(hFile);
	return TRUE;
}

/*------------------------------------------------------------------------------
    FBOOL SetupReadStr(HANDLE, WCHAR *, char *)
    FHANDLE   -
          INT32 *  -
          char *   -
    ߒlFBOOL     -
    @\FZbgAbvt@C̕ǂݍ݂
------------------------------------------------------------------------------*/
BOOL SetupReadStr(HANDLE hFile, WCHAR *pStr, char *pName)
{
	ULOG32 cnt;
	char buff[20];
	INT32 lenName;
	UINT32 lenStr;
	
	lenName = strlen(pName);
	
	ReadFile(hFile, buff,    lenName, &cnt, NULL);
	ReadFile(hFile, &lenStr, 4,       &cnt, NULL);
	
	if ((MAX_PATH - 1) <= lenStr) {lenStr = MAX_PATH -1;}
	
	if (lenStr != 0) {ReadFile(hFile, pStr, lenStr*2, &cnt, NULL);}
	pStr[lenStr] = L'\0';
	
	if (strncmp(buff, pName, lenName) == 0) {return TRUE;}
	else                                    {return FALSE;}
}

/*------------------------------------------------------------------------------
    Fvoid SetupWriteStr(HANDLE, WCHAR *, char *)
    FHANDLE   -
          WCHAR *  -
          char *   -
    @\FZbgAbvt@C̕
------------------------------------------------------------------------------*/
void SetupWriteStr(HANDLE hFile, WCHAR *pStr, char *pName)
{
	ULOG32 cnt;
	INT32 lenName;
	INT32 lenStr;
	
	lenName = strlen(pName);
	lenStr  = wcslen(pStr);
	
	WriteFile(hFile, pName,   lenName,  &cnt, NULL);
	WriteFile(hFile, &lenStr, 4,        &cnt, NULL);
	WriteFile(hFile, pStr,    lenStr*2, &cnt, NULL);
}
