/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define IMAGE_CPP
#include "common.h"

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void ImageParamI(BYTE*,INT32,INT32*);
void ImageParamO(BYTE*,INT32,INT32*);

/*------------------------------------------------------------------------------
    Fvoid ImageInit(st_Image *)
    Fst_Image *  -
    @\FC[W
------------------------------------------------------------------------------*/
void ImageInit(st_Image *pImg)
{
	pImg->res        = FALSE;
	pImg->stat       = BIT_NONE;
	pImg->hBmp       = NULL;
	pImg->hdc        = NULL;
	pImg->w          = 0;
	pImg->h          = 0;
	pImg->bpp        = 24;
	pImg->pB         = NULL;
	pImg->Mflg       = FALSE;
	pImg->pxFmt      = NULL;
	pImg->fmt        = PNG;
	pImg->fmtIco     = 0;
	pImg->dateModify = {0};
	pImg->fileSize   = 0;
}

/*------------------------------------------------------------------------------
    Fvoid ImageCreate(st_Image *, INT32, INT32)
    Fst_Image *   -
          INT32        
          INT32        
    @\FC[W쐬܂B
------------------------------------------------------------------------------*/
void ImageCreate(st_Image *pImg, INT32 w, INT32 h)
{
	BITMAPINFO bInfo;
	RECT rc;
	
	InitBIH(w, h, &bInfo);
	
	// BITMAPINFOHEADER
	// BITMAPINFO -> BITMAPINFOHEADER
	//            -> RGBQUAD [1]     RGBQUAD𖳎Ėϊ
	// obNobt@ւ̎QƂ擾̂Ńobt@pӂ킯ł͂ȂB
	// ̏ꍇppł͂ȂpB
	pImg->hBmp = a_CreateDIBSection(NULL,&bInfo,0,(void **)&pImg->pB,NULL,0);
	pImg->hdc = CreateCompatibleDC(NULL);
	SelectObject(pImg->hdc, pImg->hBmp);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w;
	rc.bottom = h;
	SetClipRgn(pImg->hdc, &rc);
	
	pImg->w = w;
	pImg->h = h;
	
	pImg->fmt = PNG;
}

/*------------------------------------------------------------------------------
    Fvoid ImageWhite(st_Image *)
    Fst_Image *   -
    @\FC[W^ɂ܂B
------------------------------------------------------------------------------*/
void ImageWhite(st_Image *pImg)
{
	INT32 i;
	INT32 w;
	INT32 h;
	INT32 *pB32;
	
	w = pImg->w;
	h = pImg->h;
	
	pB32 = (INT32 *)pImg->pB;
	for (i = 0; i < w*h; i++) {
		*pB32 = 0x00FFFFFF;
		pB32++;
	}
}

/*------------------------------------------------------------------------------
    Fvoid ImageRotateR(st_Image *)
    Fst_Image *   -
    @\FC[WE90x]܂B
------------------------------------------------------------------------------*/
void ImageRotateR(st_Image *pImg)
{
	INT32 i, j;
	INT32 w, h;
	BYTE *pB1, *pB2;
	st_Image img;
	st_Image *pImg2 = &img;
	
	w = pImg->w;
	h = pImg->h;
	ImageCreate(pImg2, h, w);
	
	pB1 = pImg->pB;
	for (i = 0; i < h; i++) {
		
		pB2 = pImg2->pB + (w - 1) * h * 4 + i * 4;
		for (j = 0; j < w; j++) {
			*(pB2+3) = *(pB1+3);
			*(pB2+2) = *(pB1+2);
			*(pB2+1) = *(pB1+1);
			*(pB2+0) = *(pB1+0);
			pB1 += 4;
			pB2 -= h * 4;
		}
	}
	
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->hBmp = pImg2->hBmp;
	pImg->hdc  = pImg2->hdc;
	pImg->pB   = pImg2->pB;
	pImg->w    = pImg2->w;
	pImg->h    = pImg2->h;
}

/*------------------------------------------------------------------------------
    Fvoid ImageEffect(st_Image *, WPARAM)
    Fst_Image *  -
          WPARAM      -
    @\FC[WɌ
------------------------------------------------------------------------------*/
void ImageEffect(st_Image *pImg, WPARAM wp, INT32 *roundUp, INT32 *roundDw)
{
	INT32 i, j;
	INT32 w, h;
	BYTE *pB1, *pB2;
	double tmp;
	INT32 dc = 0;
	double r, g, b;
	INT32 ave;
	INT32 rSrc, gSrc, bSrc;
	INT32 rDst, gDst, bDst;
	st_Image img;
	
	w = pImg->w;
	h = pImg->h;
	ImageCreate(&img, w, h);
	
	pB1 = pImg->pB;
	pB2 = img.pB;
	
	switch (wp) {
	case M_BRIGHTUP:  dc = 16;   break;
	case M_BRIGHTDW:  dc = -16;  break;
	default:  break;
	}
	
	switch (wp) {
	case M_ROUNDUP:  if (*roundUp < 16) {(*roundUp)++;}  break;
	case M_ROUNDDW:  if (*roundDw < 16) {(*roundDw)++;}  break;
	default:  break;
	}
	
	if (wp == M_SWAP) {
		rSrc = (g_swSrc & 0x00FF0000) >> 16;
		gSrc = (g_swSrc & 0x0000FF00) >> 8;
		bSrc = (g_swSrc & 0x000000FF) >> 0;
		rDst = (g_swDst & 0x00FF0000) >> 16;
		gDst = (g_swDst & 0x0000FF00) >> 8;
		bDst = (g_swDst & 0x000000FF) >> 0;
	}
	
	for (i = 0; i < h; i++) {
		for (j = 0; j < w; j++) {
			switch (wp) {
			case M_MONO:
				tmp = 0;
				tmp += *(pB1+2);
				tmp += *(pB1+1);
				tmp += *(pB1+0);
				tmp /= 3;
				
				*(pB2+2) = *(pB2+1) = *(pB2+0) = tmp;
				break;
			case M_GRAD4:
				tmp = 0;
				tmp += *(pB1+2);
				tmp += *(pB1+1);
				tmp += *(pB1+0);
				tmp /= 3;
				
				if      (tmp > 0xC0) {tmp = 0xFF;}
				else if (tmp > 0x80) {tmp = 0xAA;}
				else if (tmp > 0x40) {tmp = 0x55;}
				else                 {tmp = 0x00;}
				
				*(pB2+2) = *(pB2+1) = *(pB2+0) = tmp;
				break;
			case M_INV:
				*(pB2+2) = 0xFF - *(pB1+2);
				*(pB2+1) = 0xFF - *(pB1+1);
				*(pB2+0) = 0xFF - *(pB1+0);
				break;
			case M_SEPIA:
				r = 0.299 * (*(pB1+2)) + 0.587 * (*(pB1+1)) + 0.114 * (*(pB1+0));
				g = r;
				b = r;
				
				*(pB2+2) = (r * 107) / 107;
				*(pB2+1) = (g *  74) / 107;
				*(pB2+0) = (b *  43) / 107;
				break;
			case M_BRIGHTUP:
			case M_BRIGHTDW:
				r = *(pB1+2) + dc;
				g = *(pB1+1) + dc;
				b = *(pB1+0) + dc;
				if (0xFF < r)      {*(pB2+2) = 0xFF;}
				else if (r < 0x00) {*(pB2+2) = 0x00;}
				else               {*(pB2+2) = r;}
				if (0xFF < g)      {*(pB2+1) = 0xFF;}
				else if (g < 0x00) {*(pB2+1) = 0x00;}
				else               {*(pB2+1) = g;}
				if (0xFF < b)      {*(pB2+0) = 0xFF;}
				else if (b < 0x00) {*(pB2+0) = 0x00;}
				else               {*(pB2+0) = b;}
				break;
			case M_SATURATION:
				r = *(pB1+2);
				g = *(pB1+1);
				b = *(pB1+0);
				
				ave = (r + g + r) / 3;
				r = (r - ave) * 1.3 + ave;
				g = (g - ave) * 1.3 + ave;
				b = (b - ave) * 1.3 + ave;
				
				if (0xFF < r)      {*(pB2+2) = 0xFF;}
				else if (r < 0x00) {*(pB2+2) = 0x00;}
				else               {*(pB2+2) = r;}
				if (0xFF < g)      {*(pB2+1) = 0xFF;}
				else if (g < 0x00) {*(pB2+1) = 0x00;}
				else               {*(pB2+1) = g;}
				if (0xFF < b)      {*(pB2+0) = 0xFF;}
				else if (b < 0x00) {*(pB2+0) = 0x00;}
				else               {*(pB2+0) = b;}
				break;
			case M_R_ONLY:
				if ((*(pB1+1) <= *(pB1+2)) && (*(pB1+0) <= *(pB1+2))) {
					*(pB2+2) = *(pB1+2);
					*(pB2+1) = *(pB1+1);
					*(pB2+0) = *(pB1+0);
				}
				else {
					tmp = 0;
					tmp += *(pB1+2);
					tmp += *(pB1+1);
					tmp += *(pB1+0);
					tmp /= 3;
					*(pB2+2) = *(pB2+1) = *(pB2+0) = tmp;
				}
				break;
			case M_G_ONLY:
				if ((*(pB1+2) <= *(pB1+1)) && (*(pB1+0) <= *(pB1+1))) {
					*(pB2+2) = *(pB1+2);
					*(pB2+1) = *(pB1+1);
					*(pB2+0) = *(pB1+0);
				}
				else {
					tmp = 0;
					tmp += *(pB1+2);
					tmp += *(pB1+1);
					tmp += *(pB1+0);
					tmp /= 3;
					*(pB2+2) = *(pB2+1) = *(pB2+0) = tmp;
				}
				break;
			case M_B_ONLY:
				if ((*(pB1+2) <= *(pB1+0)) && (*(pB1+1) <= *(pB1+0))) {
					*(pB2+2) = *(pB1+2);
					*(pB2+1) = *(pB1+1);
					*(pB2+0) = *(pB1+0);
				}
				else {
					tmp = 0;
					tmp += *(pB1+2);
					tmp += *(pB1+1);
					tmp += *(pB1+0);
					tmp /= 3;
					*(pB2+2) = *(pB2+1) = *(pB2+0) = tmp;
				}
				break;
			case M_ROUNDUP:
				tmp = 0;
				tmp += *(pB1+2);
				tmp += *(pB1+1);
				tmp += *(pB1+0);
				tmp /= 3;
				
				if ((16 * (16 - *roundUp)) <= tmp) {
					*(pB2+2) = 0xFF;
					*(pB2+1) = 0xFF;
					*(pB2+0) = 0xFF;
				}
				else {
					*(pB2+2) = *(pB1+2);
					*(pB2+1) = *(pB1+1);
					*(pB2+0) = *(pB1+0);
				}
				break;
			case M_ROUNDDW:
				tmp = 0;
				tmp += *(pB1+2);
				tmp += *(pB1+1);
				tmp += *(pB1+0);
				tmp /= 3;
				
				if (tmp <= (16 * *roundDw)) {
					*(pB2+2) = 0;
					*(pB2+1) = 0;
					*(pB2+0) = 0;
				}
				else {
					*(pB2+2) = *(pB1+2);
					*(pB2+1) = *(pB1+1);
					*(pB2+0) = *(pB1+0);
				}
				break;
			case M_SWAP:
				if ((rSrc == *(pB1+2)) && (gSrc == *(pB1+1)) && (bSrc == *(pB1+0))) {
					*(pB2+2) = rDst;
					*(pB2+1) = gDst;
					*(pB2+0) = bDst;
				}
				else {
					*(pB2+2) = *(pB1+2);
					*(pB2+1) = *(pB1+1);
					*(pB2+0) = *(pB1+0);
				}
				break;
			default:
				break;
			}
			
			pB1 += 4;
			pB2 += 4;
		}
	}
	
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
}

/*------------------------------------------------------------------------------
    Fvoid ImageTrim(st_Image *, INT32, INT32, INT32, INT32)
    Fst_Image *  -
          INT32       -
          INT32       -
          INT32       -
          INT32       -
    @\FC[W͈͐؂
------------------------------------------------------------------------------*/
void ImageTrim(st_Image *pImg, INT32 up, INT32 down, INT32 left, INT32 right)
{
	INT32 i, j;
	INT32 srcW, srcH;
	INT32 dstW, dstH;
	BYTE *pB1, *pB2;
	st_Image img;
	
	srcW = pImg->w;
	srcH = pImg->h;
	dstW = pImg->w - left - right;
	dstH = pImg->h - up - down;
	
	ImageCreate(&img, dstW, dstH);
	
	pB2 = img.pB;
	for (i = 0; i < dstH; i++) {
		pB1 = pImg->pB + left * 4 + srcW * 4 * (i + down);
		for (j = 0; j < dstW; j++) {
			*(pB2+3) = *(pB1+3);
			*(pB2+2) = *(pB1+2);
			*(pB2+1) = *(pB1+1);
			*(pB2+0) = *(pB1+0);
			pB1 += 4;
			pB2 += 4;
		}
	}
	
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
	pImg->w    = img.w;
	pImg->h    = img.h;
}

/*------------------------------------------------------------------------------
    Fvoid ImageDeform(st_Image *, INT32, INT32)
    Fst_Image *  -
          INT32       -
          INT32       -
    @\FC[Wό`
------------------------------------------------------------------------------*/
void ImageDeform(st_Image *pImg, INT32 w, INT32 h)
{
	INT32 srcW, srcH;
	INT32 dstW, dstH;
	st_Image img;
	
	srcW = pImg->w;
	srcH = pImg->h;
	dstW = w;
	dstH = h;
	
	ImageCreate(&img, dstW, dstH);
	
	SetStretchBltMode(img.hdc, HALFTONE);
	StretchBlt(img.hdc,   0, 0, dstW, dstH,
			   pImg->hdc, 0, 0, srcW, srcH, SRCCOPY);
	
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
	pImg->w    = img.w;
	pImg->h    = img.h;
}

/*------------------------------------------------------------------------------
    Fvoid ImageResize(st_Image *)
    Fst_Image *   -
    @\FC[W50%ɃTCY܂B
------------------------------------------------------------------------------*/
void ImageResize(st_Image *pImg)
{
	st_Image img;
	INT32 w, h;
	BOOL res;
	
	w = pImg->w / 2;
	h = pImg->h / 2;
	ImageCreate(&img, w, h);
	
	SetStretchBltMode(img.hdc, HALFTONE);
	res = StretchBlt(img.hdc, 0, 0, w, h,
					 pImg->hdc, 0, 0, pImg->w, pImg->h, SRCCOPY);
	if (res == FALSE){
		MessageBox(NULL, L"stretch error", L_TITLE, MB_OK);
		DeleteObject(img.hBmp);
		DeleteDC    (img.hdc);
		exit(1);
	}
	
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
	pImg->w    = img.w;
	pImg->h    = img.h;
}

/*------------------------------------------------------------------------------
    Fvoid ImageAppend(st_Image *, st_Image *, INT32, INT32)
    Fst_Image *  -
          st_Image *  -
          INT32       -
          INT32       -
    @\FC[WɃC[Wǉ
------------------------------------------------------------------------------*/
void ImageAppend(st_Image *pImg1, st_Image *pImg2, INT32 x, INT32 y)
{
	INT32 w, h;
	st_Image img;
	INT32 i;
	INT32 *pB32;
	
	if (pImg1->w < (pImg2->w + x)) {w = pImg2->w + x;} else {w = pImg1->w;}
	if (pImg1->h < (pImg2->h + y)) {h = pImg2->h + y;} else {h = pImg1->h;}
	
	ImageCreate(&img, w, h);
	
	pB32 = (INT32 *)img.pB;
	for (i = 0; i < w*h; i++) {
		*pB32 = 0x00000000;
		pB32++;
	}
	
	BitBlt(img.hdc, 0, 0, pImg1->w, pImg1->h, pImg1->hdc, 0, 0, SRCCOPY);
	BitBlt(img.hdc, x, y, pImg2->w, pImg2->h, pImg2->hdc, 0, 0, SRCCOPY);
	
	DeleteObject(pImg1->hBmp);
	DeleteDC    (pImg1->hdc);
	pImg1->hBmp = img.hBmp;
	pImg1->hdc  = img.hdc;
	pImg1->pB   = img.pB;
	pImg1->w    = img.w;
	pImg1->h    = img.h;
}

/*------------------------------------------------------------------------------
    Fvoid ImageSeparate(st_Image *, st_Image *, BOOL, INT32)
    Fst_Image *  -
          st_Image *  -
          BOOL        -
          INT32       -
    @\FC[W𕪊B
------------------------------------------------------------------------------*/
void ImageSeparate(st_Image *pImg1, st_Image *pImg2, BOOL v_h, INT32 pxl)
{
	INT32 w1, h1;
	INT32 w2, h2;
	INT32 x2, y2;
	st_Image img;
	
	if (v_h) {
		w1 = pImg1->w;
		h1 = pxl;
		w2 = pImg1->w;
		h2 = pImg1->h - pxl;
		x2 = 0;
		y2 = pxl;
	}
	else {
		w1 = pxl;
		h1 = pImg1->h;
		w2 = pImg1->w - pxl;
		h2 = pImg1->h;
		x2 = pxl;
		y2 = 0;
	}
	
	ImageCreate(&img,  w1, h1);
	ImageCreate(pImg2, w2, h2);
	
	BitBlt(img.hdc,    0, 0, w1, h1, pImg1->hdc, 0, 0,   SRCCOPY);
	BitBlt(pImg2->hdc, 0, 0, w2, h2, pImg1->hdc, x2, y2, SRCCOPY);
	
	DeleteObject(pImg1->hBmp);
	DeleteDC    (pImg1->hdc);
	pImg1->hBmp = img.hBmp;
	pImg1->hdc  = img.hdc;
	pImg1->pB   = img.pB;
	pImg1->w    = img.w;
	pImg1->h    = img.h;
}

/*------------------------------------------------------------------------------
    Fvoid ImageRead(LONG, st_Image *, WCHAR *,INT32)
    Fst_Image *  -
          WCHAR *     -
          INT32       -
    @\FC[Wǂݍ
------------------------------------------------------------------------------*/
void ImageRead(st_Image *pImg, WCHAR *path, INT32 mode)
{
	BOOL res;
	INT32 fmt;
	
//	pImg->pxFmt = PixelFormat24bppRGB;
	
	fmt = IsImageFile(path);
	GetImageDateModify(path, &pImg->dateModify);
	pImg->fileSize = GetImageFileSize(path);
	
	if (fmt == UNDEF) {
		res = FALSE;
	}
	else if ((fmt == BMP) && (g_idxBmp == 0)) {
		res = BmImageRead(pImg, path, mode);
		if (res == TRUE) {
			pImg->fmt   = BMP;
			pImg->pxFmt = PixelFormat24bppRGB;
			BmImageDivide(pImg, mode);
		}
	}
	else if (fmt == ICO) {
		res = IcImageRead(pImg, path);
		if (res == TRUE) {
			pImg->fmt = ICO;
			
			switch (icHeader.type) {
			case 0x01:  pImg->fmtIco = 0x01;  break;
			case 0x02:  pImg->fmtIco = 0x02;  break;
			default:  break;
			}
			
			switch (icBmpInfo.bpp) {
			case 24:  pImg->pxFmt = PixelFormat24bppRGB;   break;
			case 32:  pImg->pxFmt = PixelFormat32bppARGB;  break;
			default:  break;
			}
		}
	}
	else {
		res = ImageReadGdi(pImg, path, mode);
	}
	
	if (res == TRUE) {
		pImg->stat = BIT_SUCCESS;
		pImg->res  = TRUE;
	}
	else {
		if (PathFileExists(path) == FALSE) {pImg->stat = BIT_FAILURE|BIT_NOTEXIST;}
		else                               {pImg->stat = BIT_FAILURE|BIT_NOTIMAGE;}
		pImg->res = FALSE;
	}
}

/*------------------------------------------------------------------------------
    FBOOL ImageReadGdi(st_Image *, WCHAR *, INT32)
    Fst_Image *  -
          WCHAR *     -
          INT32       -
    ߒlFBOOL
    @\FGDI+ŃC[Wǂݍ
------------------------------------------------------------------------------*/
BOOL ImageReadGdi(st_Image *pImg, WCHAR *path, INT32 mode)
{
	BOOL res;
	GUID guid;
	INT32 i;
	BYTE *pB;
	Bitmap *pBmp;
	
	pBmp = Gdiplus::Bitmap::FromFile(path);
	
	if((pBmp != NULL) && (pBmp->GetLastStatus() == Gdiplus::Ok) &&
	   (pBmp->GetWidth()  != 0) &&
	   (pBmp->GetHeight() != 0))
	{
		pImg->w = pBmp->GetWidth();
		pImg->h = pBmp->GetHeight();
		if ((pImg->w > MAX_IMGW) || (pImg->h > MAX_IMGH)) {
			delete pBmp;
			return FALSE;
		}
		
		ImageDivide(pImg, pBmp, mode);  //  createdrawĂ
		
		pBmp->GetRawFormat(&guid);
		if     ((guid == ImageFormatBMP) ||
				(guid == ImageFormatMemoryBMP)) {pImg->fmt = BMP;}  // ImageFormatGIF
		else if (guid == ImageFormatPNG)        {pImg->fmt = PNG;}  // ImageFormatTIFF
		else if (guid == ImageFormatJPEG)       {pImg->fmt = JPG;}  // ImageFormatUndefined
		else                                    {pImg->fmt = UNDEF;}
		
		pImg->pxFmt = pBmp->GetPixelFormat();
		
		if (pImg->pxFmt == PixelFormat32bppARGB) {
			pB = pImg->pB;
			for (i = 0; i < (pImg->w * pImg->h); i++) {
				if (*(pB+3) != 0xFF) {
					pImg->Mflg = TRUE;
					break;  // Kw[vƖBāAĕςȂB
				}
				pB += 4;
			}
		}
		
//		ImageItemData iid;  // T|[gĂȂBÂH
//		pBmp->FindFirstItem(&iid);
//		pBmp->FindNextItem (&iid);
		res = TRUE;
	}
	else {
		res = FALSE;
	}
	
	delete pBmp;
	return res;
}

/*------------------------------------------------------------------------------
    Fvoid ImageDivide(st_Image *, Bitmap *, INT32)
    Fst_Image *  -
          Bitmap *    -
          INT32       -
    @\FkC[Wǂݍ
------------------------------------------------------------------------------*/
void ImageDivide(st_Image *pImg, Bitmap *pBmp, INT32 mode)
{
	INT32 w;
	INT32 h;
	
	w = pImg->w;
	h = pImg->h;
	
	ImageDivideWH(&w, &h, mode);
	ImageCreate(pImg, w, h);
	
	Graphics graphics(pImg->hdc);
	graphics.DrawImage(pBmp, 0, 0, w, h);
}

/*------------------------------------------------------------------------------
    Fvoid ImageDivideWH(INT32 *, INT32 *, INT32)
    FINT32 *  
          INT32 *  
          INT32    -
    @\FkC[W̕EvZ
------------------------------------------------------------------------------*/
void ImageDivideWH(INT32 *pW, INT32 *pH, INT32 mode)
{
	INT32 w;
	INT32 h;
	INT32 wBef;
	INT32 hBef;
	
	w = wBef = *pW;
	h = hBef = *pH;
	
	if (mode != NEUT) {
		if ((BASE_W*4*BASE_H*4) <= (w*h)) {
			w /= 4;
			h /= 4;
		}
		else if ((BASE_W*2*BASE_H*2) <= (w*h)) {
			w /= 2;
			h /= 2;
		}
		else {
		}
	}
	
	//  1280~ 800  ]  2560~1600
	switch (mode) {
	case DUAL:
		if (((BASE_W*BASE_H)) <= (w*h)) {w /= 1.41;  h /= 1.41;}
		break;
	case TRIP:
		if (((BASE_W*BASE_H)) <= (w*h)) {w /= 1.73;  h /= 1.73;}
		if (w < wBef) {w*=1.2;  h*=1.2;}
		break;
	case QUAD:
		if (( BASE_W      * BASE_H)       <= (w*h)) {w /= 2;     h /= 2;}
		if (((BASE_W/1.41)*(BASE_H/1.41)) <= (w*h)) {w /= 1.41;  h /= 1.41;}
		if (w < wBef) {w*=1.4;  h*=1.4;}
		break;
	case OCTA:
		if (( BASE_W      * BASE_H)       <= (w*h)) {w /= 2*1.41;  h /= 2*1.41;}
		if (((BASE_W/1.41)*(BASE_H/1.41)) <= (w*h)) {w /= 2;       h /= 2;}
		if (((BASE_W/2)   *(BASE_H/2))    <= (w*h)) {w /= 1.41;    h /= 1.41;}
		if (w < wBef) {w*=1.4;  h*=1.4;}
		break;
	case HEXA:
		if (( BASE_W          * BASE_H)           <= (w*h)) {w /= 4;       h /= 4;}
		if (((BASE_W/1.41)    *(BASE_H/1.41))     <= (w*h)) {w /= 2*1.41;  h /= 2*1.41;}
		if (((BASE_W/2)       *(BASE_H/2))        <= (w*h)) {w /= 2;       h /= 2;}
		if (((BASE_W/(2*1.41))*(BASE_H/(2*1.41))) <= (w*h)) {w /= 1.41;    h /= 1.41;}
		if (w < wBef) {w*=1.4;  h*=1.4;}
		break;
	case DOTR:
		if (( BASE_W          * BASE_H)           <= (w*h)) {w /= 4*1.41;  h /= 4*1.41;}
		if (((BASE_W/1.41)    *(BASE_H/1.41))     <= (w*h)) {w /= 4;       h /= 4;}
		if (((BASE_W/2)       *(BASE_H/2))        <= (w*h)) {w /= 2*1.41;  h /= 2*1.41;}
		if (((BASE_W/(2*1.41))*(BASE_H/(2*1.41))) <= (w*h)) {w /= 2;       h /= 2;}
		if (((BASE_W/4)       *(BASE_H/4))        <= (w*h)) {w /= 1.41;    h /= 1.41;}
		if (w < wBef) {w*=1.2;  h*=1.2;}
		break;
	default:
		break;
	}
	
	*pW = w;
	*pH = h;
}

/*------------------------------------------------------------------------------
    FBOOL ImageSave(st_Image *, WCHAR *)
    Fst_Image *    -
          WCHAR *       -
    ߒlFBOOL          -
    @\FC[Wۑ
------------------------------------------------------------------------------*/
BOOL ImageSave(st_Image *pImg, WCHAR *path)
{
	WCHAR pathD[MAX_PATH];
	
	wcscpy(pathD, path);
	PathRemoveFileSpec(pathD);
	if (!IsExistFolder(pathD)) {return FALSE;}
	
	pImg->bpp = 24;
	
	if ((pImg->fmt == BMP) && (g_idxBmp == 0)) {
		return BmImageSave(pImg, path);
	}
	else if (pImg->fmt == ICO) {
		return FALSE;
	}
	else {
		return ImageSaveGdi(pImg, path);
	}
}

/*------------------------------------------------------------------------------
    FBOOL ImageSave(st_Image *, WCHAR *, LONG, HWND, const WCHAR *)
    Fst_Image *    -
          WCHAR *       -
          LONG          -
          HWND          -
          const WCHAR * -
    ߒlFBOOL          -
    @\FC[Wۑ܂BsꍇgCB
------------------------------------------------------------------------------*/
BOOL ImageSaveRetry(st_Image *pImg, WCHAR *path, LONG id, HWND hWnd, const WCHAR *title)
{
	WCHAR pathD[MAX_PATH];
	WCHAR msg[MAX_PATH+100];
	BOOL res = TRUE;
	
	while (TRUE) {
		wcscpy(pathD, path);
		PathRemoveFileSpec(pathD);
		if (IsExistFolder(pathD)) {
			pImg->bpp = 24;
			
			if ((pImg->fmt == BMP) && (g_idxBmp == 0)) {
				res = BmImageSave(pImg, path);
			}
			else if (pImg->fmt == ICO) {
				res = FALSE;
			}
			else {
				res = ImageSaveGdi(pImg, path);
			}
		}
		else {
			res = FALSE;
		}
		
		if (res) {break;}
		
		swprintf(msg, TxFm(E_FMTRETRY), path);
		if (MbDialog(id, hWnd, msg, title, MB_RETRYCANCEL) != IDRETRY) {break;}
	}
	return res;
}

/*------------------------------------------------------------------------------
    FBOOL ImageSaveGdi(st_Image *, WCHAR *)
    Fst_Image *  -
          WCHAR *     -
    ߒlFBOOL        -
    @\FGDI+ŃC[Wۑ܂B
------------------------------------------------------------------------------*/
BOOL ImageSaveGdi(st_Image *pImg, WCHAR *pStr)
{
	INT32 i, j;
	INT32 wSize;
	INT32 mod;
	PixelFormat pxFmt;
	BYTE *pByte;
	BYTE *pB1, *pB2;
	CLSID clsid;
	UINT cnt;
	UINT size;
	Gdiplus::ImageCodecInfo *pIci;
	WCHAR *pEnc = NULL;
	WCHAR encBmp[50] = L"image/bmp";
	WCHAR encPng[50] = L"image/png";
	WCHAR encJpg[50] = L"image/jpeg";
	BOOL res;
	
	if (pImg->bpp != 24) {return FALSE;}
	pxFmt = PixelFormat24bppRGB;  // PixelFormat32bppARGB
	wSize = pImg->w * 3;
	mod   = (pImg->w * 3) % 4;
	if (mod != 0) {wSize += (4 - mod);}
	
	pByte = (BYTE *)a_malloc(wSize * pImg->h);
	
	pB1 = pImg->pB;
	for (i = 0; i < pImg->h; i++) {
		pB2 = pByte + wSize * (pImg->h - 1 - i);
		
		for (j = 0; j < pImg->w; j++) {
			*(pB2+2) = *(pB1+2);
			*(pB2+1) = *(pB1+1);
			*(pB2+0) = *(pB1+0);
			pB1 += 4;
			pB2 += 3;
		}
	}
	
	switch (pImg->fmt) {
	case BMP:  pEnc = encBmp;  break;
	case PNG:  pEnc = encPng;  break;
	case JPG:  pEnc = encJpg;  break;
	default:   pEnc = encPng;  break;
	}
	
	Gdiplus::GetImageEncodersSize(&cnt, &size);
	pIci = new Gdiplus::ImageCodecInfo[size];
	Gdiplus::GetImageEncoders(cnt, size, pIci);
	
	for (i = 0; i < cnt; i++) {
		if (wcscmp(pIci[i].MimeType, pEnc) == 0)
		{
			clsid = pIci[i].Clsid;
			break;
		}
	}
	delete pIci;
	
	Gdiplus::Bitmap bmp(pImg->w, pImg->h, wSize, pxFmt, pByte);
	if (bmp.Save(pStr, &clsid) == Ok) {res = TRUE;} else {res = FALSE;}
	
	free(pByte);
	return res;
}

/*------------------------------------------------------------------------------
    Fvoid ImageDelete(st_Image *)
    Fst_Image *    -
    @\FC[W폜܂B
------------------------------------------------------------------------------*/
void ImageDelete(st_Image *pImg)
{
	SelectClipRgn(pImg->hdc, NULL);
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->res        = FALSE;
	pImg->stat       = BIT_NONE;
	pImg->hBmp       = NULL;
	pImg->hdc        = NULL;
	pImg->w          = 0;
	pImg->h          = 0;
	pImg->pB         = NULL;
	pImg->Mflg       = FALSE;
	pImg->pxFmt      = NULL;
	pImg->fmt        = UNDEF;
	pImg->fmtIco     = 0;
	pImg->dateModify = {0};
	pImg->fileSize   = 0;
}

/*------------------------------------------------------------------------------
    Fvoid ImageReplace(st_Image *, st_Image *)
    Fst_Image *  
          st_Image *  
    @\FC[Wu
------------------------------------------------------------------------------*/
void ImageReplace(st_Image *dst, st_Image *src)
{
	ImageDelete(dst);
	*dst = *src;
	ImageInit(src);
}

/*------------------------------------------------------------------------------
    FBOOL BmImageRead(st_Image *, WCHAR *, INT32)
    Fst_Image *  -
          WCHAR *     -
          INT32       -
    ߒlFBOOL
    @\FŃrbg}bvt@Cǂݍ
------------------------------------------------------------------------------*/
BOOL BmImageRead(st_Image *pImg, WCHAR *path, INT32 mode)
{
	HANDLE hFile;
	ULOG32 cnt;
	BYTE *pByte;
	BYTE buffHeader[14];
	BYTE buffInfo  [40];
	BYTE *pBuffLine;
	INT32 i, j;
	INT32 w, h;
	INT32 wSize;
	INT32 mod;
	BYTE *pB1, *pB2;
	st_Image img;
	
	memset(&bmHeader, 0x00, sizeof(bmHeader));
	memset(&bmInfo,   0x00, sizeof(bmInfo));
	
	hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
					   FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) {
		MessageBox(NULL, L"file read failed", L_TITLE, MB_OK);
		return FALSE;
	}
	
	ReadFile(hFile, buffHeader, 14, &cnt, NULL);
	if (cnt != 14) {
//		MessageBox(NULL, L"bmp read 14byte", L_TITLE, MB_OK);
		CloseHandle(hFile);
		return FALSE;
	}
	
	pByte = buffHeader;
	ImageParamI(pByte, 2, (INT32*)&bmHeader.type);       pByte+=2;
	ImageParamI(pByte, 4, (INT32*)&bmHeader.size);       pByte+=4;
	ImageParamI(pByte, 2, (INT32*)&bmHeader.reserved1);  pByte+=2;
	ImageParamI(pByte, 2, (INT32*)&bmHeader.reserved2);  pByte+=2;
	ImageParamI(pByte, 4, (INT32*)&bmHeader.offset);     pByte+=4;
	
	if ((bmHeader.type      != 0x4D42)     ||
//		(bmHeader.size      != 0x00000000) ||
		(bmHeader.reserved1 != 0x0000)     ||
		(bmHeader.reserved2 != 0x0000))
//		(bmHeader.offset    != 54)
	{
//		MessageBox(NULL, L"bmp header invalid", L_TITLE, MB_OK);
//		BmImageDump();
		CloseHandle(hFile);
		return FALSE;
	}
	
	ReadFile(hFile, buffInfo, 40, &cnt, NULL);
	if (cnt != 40) {
//		MessageBox(NULL, L"bmp read 40byte", L_TITLE, MB_OK);
//		BmImageDump();
		CloseHandle(hFile);
		return FALSE;
	}
	
	pByte = buffInfo;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.size);          pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.width);         pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.height);        pByte+=4;
	ImageParamI(pByte, 2, (INT32*)&bmInfo.planes);        pByte+=2;
	ImageParamI(pByte, 2, (INT32*)&bmInfo.bpp);           pByte+=2;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.compression);   pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.sizeImage);     pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.xPixPerMeter);  pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.yPixPerMeter);  pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.clrUsed);       pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&bmInfo.clrImportant);  pByte+=4;
	
	if ((bmInfo.bpp == 1) ||
		(bmInfo.bpp == 2) ||
		(bmInfo.bpp == 4) ||
		(bmInfo.bpp == 8))
	{
//		MessageBox(NULL, L"index color not supported", L_TITLE, MB_OK);
		CloseHandle(hFile);
		return FALSE;
	}
	
	if ((bmInfo.size         != 40)         ||
		(bmInfo.width        > MAX_IMGW)    ||
		(bmInfo.height       > MAX_IMGH)    ||
		(bmInfo.planes       != 0x0001)     ||
		(bmInfo.bpp          != 24)         ||
		(bmInfo.compression  != 0)          ||
//		(bmInfo.sizeImage    != 0x00000000) ||
//		(bmInfo.xPixPerMeter != 0x00000000) ||
//		(bmInfo.yPixPerMeter != 0x00000000) ||
		(bmInfo.clrUsed      != 0)          ||
		(bmInfo.clrImportant != 0))
	{
//		MessageBox(NULL, L"bmp info invalid", L_TITLE, MB_OK);
		CloseHandle(hFile);
		return FALSE;
	}
	
//	BmImageDump();
	
	w     = bmInfo.width;
	h     = bmInfo.height;
	
	wSize = w*3;
	mod   = (w*3) % 4;
	if (mod != 0) {wSize += (4 - mod);}
	
	ImageCreate(&img, w, h);
	
	pBuffLine = (BYTE *)a_malloc(wSize);
	
	pB2 = img.pB;
	for (i = 0; i < h; i++) {
		ReadFile(hFile, pBuffLine, wSize, &cnt, NULL);
		if (cnt != wSize) {
//			MessageBox(NULL, L"bmp read image", L_TITLE, MB_OK);
			free(pBuffLine);
			CloseHandle(hFile);
			return FALSE;
		}
		
		pB1 = pBuffLine;
		for (j = 0; j < w; j++) {
			*(pB2+2) = *(pB1+2);
			*(pB2+1) = *(pB1+1);
			*(pB2+0) = *(pB1+0);
			pB2 += 4;
			pB1 += 3;
		}
	}
	
	pImg->w    = img.w;
	pImg->h    = img.h;
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
	pImg->res  = TRUE;
	
	free(pBuffLine);
	CloseHandle(hFile);
	return TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid BmImageDivide(st_Image *, INT32)
    Fst_Image *  -
          INT32       -
    @\FkC[Wɍւ
------------------------------------------------------------------------------*/
void BmImageDivide(st_Image *pImg, INT32 mode)
{
	INT32 w, h;
	INT32 tmp;
	st_Image img;
	
	w = pImg->w;
	h = pImg->h;
	
	tmp = w;
	ImageDivideWH(&w, &h, mode);
	if (w == tmp) {return;}
	
	ImageCreate(&img, w, h);
	
	SetStretchBltMode(img.hdc, HALFTONE);
	StretchBlt(img.hdc,   0, 0, w,       h,
			   pImg->hdc, 0, 0, pImg->w, pImg->h, SRCCOPY);
	
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->w    = img.w;
	pImg->h    = img.h;
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
}

/*------------------------------------------------------------------------------
    FBOOL BmImageSave(st_Image *, WCHAR *)
    Fst_Image *  -
          WCHAR *     -
    ߒlFBOOL        -
    @\FŃrbg}bvt@Cۑ
------------------------------------------------------------------------------*/
BOOL BmImageSave(st_Image *pImg, WCHAR *pStr)
{
	HANDLE hFile;
	ULOG32 cnt;
	BYTE *pByte;
	BYTE buffHeader[14];
	BYTE buffInfo  [40];
	INT32 wSize;
	INT32 mod;
	BYTE *pBuffLine;
	BYTE *pB1, *pB2;
	INT32 i, j;
	
	if (pImg->bpp != 24) {return FALSE;}
	
	wSize = pImg->w*3;
	mod   = (pImg->w*3) % 4;
	if (mod != 0) {wSize += (4 - mod);}
	
	memset(&bmHeader, 0x00, sizeof(bmHeader));
	memset(&bmInfo,   0x00, sizeof(bmInfo));
	
	bmHeader.type      = 0x4D42;
	bmHeader.size      = wSize * pImg->h + 54;
	bmHeader.reserved1 = 0x0000;
	bmHeader.reserved2 = 0x0000;
	bmHeader.offset    = 54;
	
	bmInfo.size         = 40;
	bmInfo.width        = pImg->w;
	bmInfo.height       = pImg->h;
	bmInfo.planes       = 0x0001;
	bmInfo.bpp          = 24;
	bmInfo.compression  = 0;
	bmInfo.sizeImage    = 0x00000000;
	bmInfo.xPixPerMeter = 0x00000000;
	bmInfo.yPixPerMeter = 0x00000000;
	bmInfo.clrUsed      = 0;
	bmInfo.clrImportant = 0;
	
	hFile = CreateFile(pStr, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS,
					   FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) {return FALSE;}
	
	pByte = buffHeader;
	ImageParamO(pByte, 2, (INT32*)&bmHeader.type);       pByte+=2;
	ImageParamO(pByte, 4, (INT32*)&bmHeader.size);       pByte+=4;
	ImageParamO(pByte, 2, (INT32*)&bmHeader.reserved1);  pByte+=2;
	ImageParamO(pByte, 2, (INT32*)&bmHeader.reserved2);  pByte+=2;
	ImageParamO(pByte, 4, (INT32*)&bmHeader.offset);     pByte+=4;
	WriteFile(hFile, buffHeader, 14, &cnt, NULL);
	
	pByte = buffInfo;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.size);          pByte+=4;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.width);         pByte+=4;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.height);        pByte+=4;
	ImageParamO(pByte, 2, (INT32*)&bmInfo.planes);        pByte+=2;
	ImageParamO(pByte, 2, (INT32*)&bmInfo.bpp);           pByte+=2;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.compression);   pByte+=4;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.sizeImage);     pByte+=4;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.xPixPerMeter);  pByte+=4;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.yPixPerMeter);  pByte+=4;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.clrUsed);       pByte+=4;
	ImageParamO(pByte, 4, (INT32*)&bmInfo.clrImportant);  pByte+=4;
	WriteFile(hFile, buffInfo, 40, &cnt, NULL);
	
	pBuffLine = (BYTE *)a_malloc(wSize);
	
	pB1 = pImg->pB;
	for (i = 0; i < pImg->h; i++) {
		memset(pBuffLine, 0x00, wSize);
		
		pB2 = pBuffLine;
		for (j = 0; j < pImg->w; j++) {
			*(pB2+2) = *(pB1+2);
			*(pB2+1) = *(pB1+1);
			*(pB2+0) = *(pB1+0);
			pB1 += 4;
			pB2 += 3;
		}
		
		WriteFile(hFile, pBuffLine, wSize, &cnt, NULL);
		if (cnt != wSize) {CloseHandle(hFile);  return FALSE;}
	}
	
	free(pBuffLine);
	CloseHandle(hFile);
	
	return TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid BmImageDump(void)
    @\FBMPfR[h\
------------------------------------------------------------------------------*/
void BmImageDump(void)
{
	INT32 idx;
	WCHAR str[400];
	
	idx = 0;
	idx += swprintf(str+idx, L"type     =0x%04X\r\n", bmHeader.type);
	idx += swprintf(str+idx, L"size     =0x%08X\r\n", bmHeader.size);
	idx += swprintf(str+idx, L"reserved1=0x%04X\r\n", bmHeader.reserved1);
	idx += swprintf(str+idx, L"reserved2=0x%04X\r\n", bmHeader.reserved2);
	idx += swprintf(str+idx, L"offset   =0x%08X\r\n", bmHeader.offset);
	
	idx += swprintf(str+idx, L"size        =0x%08X\r\n", bmInfo.size);
	idx += swprintf(str+idx, L"width       =0x%08X\r\n", bmInfo.width);
	idx += swprintf(str+idx, L"height      =0x%08X\r\n", bmInfo.height);
	idx += swprintf(str+idx, L"planes      =0x%04X\r\n", bmInfo.planes);
	idx += swprintf(str+idx, L"bpp         =0x%04X\r\n", bmInfo.bpp);
	idx += swprintf(str+idx, L"compression =0x%08X\r\n", bmInfo.compression);
	idx += swprintf(str+idx, L"sizeImage   =0x%08X\r\n", bmInfo.sizeImage);
	idx += swprintf(str+idx, L"xPixPerMeter=0x%08X\r\n", bmInfo.xPixPerMeter);
	idx += swprintf(str+idx, L"yPixPerMeter=0x%08X\r\n", bmInfo.yPixPerMeter);
	idx += swprintf(str+idx, L"clrUsed     =0x%08X\r\n", bmInfo.clrUsed);
	idx += swprintf(str+idx, L"clrImportant=0x%08X\r\n", bmInfo.clrImportant);
//	idx += swprintf(str+idx, L"=%d", idx);
	
	MessageBox(NULL, str, L_TITLE, MB_OK);
}

/*------------------------------------------------------------------------------
    FBOOL IcImageRead(st_Image *, WCHAR *)
    Fst_Image *   -
          WCHAR *      -
    ߒlFBOOL
    @\FICO/CURt@Cǂݍ
------------------------------------------------------------------------------*/
BOOL IcImageRead(st_Image *pImg, WCHAR *path)
{
	HANDLE hFile;
	ULOG32 cnt;
	BYTE *pByte;
	BYTE buffHeader [6];
	BYTE buffInfo   [16];
	BYTE buffBmpInfo[40];
	BYTE *buffMask;
	INT32 bytePerPixel;
	BYTE *pBuffLine;
	INT32 i, j;
	INT32 w, h;
	INT32 wSize;
	INT32 mod;
	BYTE *pB1, *pB2;
	st_Image img;
	
	memset(&icHeader, 0x00, sizeof(icHeader));
	memset(&icInfo,   0x00, sizeof(icInfo));
	memset(&icBmpInfo,0x00, sizeof(icBmpInfo));
	
	hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
					   FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) {
		MessageBox(NULL, L"file read failed", L_TITLE, MB_OK);
		return FALSE;
	}
	
	ReadFile(hFile, buffHeader, 6, &cnt, NULL);
	if (cnt != 6) {
//		MessageBox(NULL, L"ico/cur read 6byte", L_TITLE, MB_OK);
		CloseHandle(hFile);
		return FALSE;
	}
	pByte = buffHeader;
	ImageParamI(pByte, 2, (INT32*)&icHeader.reserved);  pByte+=2;
	ImageParamI(pByte, 2, (INT32*)&icHeader.type);      pByte+=2;
	ImageParamI(pByte, 2, (INT32*)&icHeader.count);     pByte+=2;
	
	if ((icHeader.reserved != 0x00)  ||
		((icHeader.type    != 0x01)  &&
		 (icHeader.type    != 0x02)) ||
		(icHeader.count    != 1))
	{
//		MessageBox(NULL, L"ico/cur header invalid", L_TITLE, MB_OK);
//		IcImageDump();
		CloseHandle(hFile);
		return FALSE;
	}
	
	ReadFile(hFile, buffInfo, 16, &cnt, NULL);
	if (cnt != 16) {
//		MessageBox(NULL, L"ico/cur read 16byte", L_TITLE, MB_OK);
		CloseHandle(hFile);
		return FALSE;
	}
	pByte = buffInfo;
	ImageParamI(pByte, 1, (INT32*)&icInfo.width);       pByte+=1;
	ImageParamI(pByte, 1, (INT32*)&icInfo.height);      pByte+=1;
	ImageParamI(pByte, 1, (INT32*)&icInfo.colorCount);  pByte+=1;
	ImageParamI(pByte, 1, (INT32*)&icInfo.reserved);    pByte+=1;
	ImageParamI(pByte, 2, (INT32*)&icInfo.hotSpotX);    pByte+=2;
	ImageParamI(pByte, 2, (INT32*)&icInfo.hotSpotY);    pByte+=2;
	ImageParamI(pByte, 4, (INT32*)&icInfo.size);        pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&icInfo.offset);      pByte+=4;
	
	if (
//		(icInfo.width      > MAX_ICOW)    ||
//		(icInfo.height     > MAX_ICOH)    ||
		(icInfo.colorCount != 0x00)       || // 256FȏȂ0
		(icInfo.reserved   != 0x00)       ||
//		(icInfo.hotSpotX   != 0x0000)     ||
//		(icInfo.hotSpotY   != 0x0000)     ||
//		(icInfo.size       != 0x00000000) ||
		(icInfo.offset     != 22))
	{
//		MessageBox(NULL, L"ico/cur info invalid", L_TITLE, MB_OK);
//		IcImageDump();
		CloseHandle(hFile);
		return FALSE;
	}
	
	ReadFile(hFile, buffBmpInfo, 40, &cnt, NULL);
	if (cnt != 40) {
//		MessageBox(NULL, L"ico/cur read 40byte", L_TITLE, MB_OK);
		CloseHandle(hFile);
		return FALSE;
	}
	pByte = buffBmpInfo;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.size);          pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.reserved1);     pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.reserved2);     pByte+=4;
	ImageParamI(pByte, 2, (INT32*)&icBmpInfo.planes);        pByte+=2;
	ImageParamI(pByte, 2, (INT32*)&icBmpInfo.bpp);           pByte+=2;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.compression);   pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.sizeImage);     pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.xPixPerMeter);  pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.yPixPerMeter);  pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.clrUsed);       pByte+=4;
	ImageParamI(pByte, 4, (INT32*)&icBmpInfo.clrImportant);  pByte+=4;
	
	if ((icBmpInfo.bpp == 1) ||
		(icBmpInfo.bpp == 2) ||
		(icBmpInfo.bpp == 4) ||
		(icBmpInfo.bpp == 8))
	{
//		MessageBox(NULL, L"index color not supported", L_TITLE, MB_OK);
		CloseHandle(hFile);
		return FALSE;
	}
	
	if ((icBmpInfo.size         != 40)         ||
//		(icBmpInfo.reserved1    != 0x00000000) ||
//		(icBmpInfo.reserved2    != 0x00000000) ||  ȂQ{
		(icBmpInfo.planes       != 0x0001)     ||
		((icBmpInfo.bpp         != 24) &&
		 (icBmpInfo.bpp         != 32))        ||
		(icBmpInfo.compression  != 0)          ||
//		(icBmpInfo.sizeImage    != 0x00000000) ||
//		(icBmpInfo.xPixPerMeter != 0x00000000) ||
//		(icBmpInfo.yPixPerMeter != 0x00000000) ||
//		(icBmpInfo.clrUsed      != 0)          ||
		(icBmpInfo.clrImportant != 0))
	{
//		MessageBox(NULL, L"ico/cur bmp info invalid", L_TITLE, MB_OK);
//		IcImageDump();
		CloseHandle(hFile);
		return FALSE;
	}
	
//	IcImageDump();
	
	w = (UINT8)icInfo.width;
	h = (UINT8)icInfo.height;
	
	if (icBmpInfo.bpp == 24) {bytePerPixel = 3;}
	else                     {bytePerPixel = 4;}
	
	wSize = w * bytePerPixel;
	mod   = (w * bytePerPixel) % 4;
	if (mod != 0) {wSize += (4 - mod);}
	
	ImageCreate(&img, w, h);
	
	pBuffLine = (BYTE *)a_malloc(wSize);
	
	pB2 = img.pB;
	for (i = 0; i < h; i++) {
		ReadFile(hFile, pBuffLine, wSize, &cnt, NULL);
		if (cnt != wSize) {
//			MessageBox(NULL, L"ico/cur read image", L_TITLE, MB_OK);
			free(pBuffLine);
			CloseHandle(hFile);
			return FALSE;
		}
		
		pB1 = pBuffLine;
		for (j = 0; j < w; j++) {
			*(pB2+2) = *(pB1+2);
			*(pB2+1) = *(pB1+1);
			*(pB2+0) = *(pB1+0);
			pB2 += 4;
			pB1 += bytePerPixel;
		}
	}
	
	pImg->w    = img.w;
	pImg->h    = img.h;
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
	pImg->res  = TRUE;
	free(pBuffLine);
	
	wSize = w / 8;
	mod   = (w / 8) % 4;
	if (mod != 0) {wSize += (4 - mod);}
	
	buffMask = (BYTE *)a_malloc(wSize*h);
	
	ReadFile(hFile, buffMask, wSize*h, &cnt, NULL);
	if (cnt != wSize*h) {
		free(buffMask);
		MessageBox(NULL, L"ico/cur read mask", L_TITLE, MB_OK);
		CloseHandle(hFile);
		return FALSE;
	}
	IcImageMask(pImg, buffMask, w, h, wSize);
	
	free(buffMask);
	CloseHandle(hFile);
	return TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid IcImageMask(st_Image *, BYTE *)
    Fst_Image *   -
          BYTE *       -
    @\FICO/CURt@C̓߃}XN쐬
------------------------------------------------------------------------------*/
void IcImageMask(st_Image *pImg, BYTE *pMask, INT32 w, INT32 h, INT32 wSize)
{
	INT32 i, j;
	BYTE *pB1, *pB2;
	
	pB2 = pImg->pB;
	for (i = 0; i < h; i++) {
		for (j = 0; j < w; j++) {
			pB1 = pMask + wSize*i + j/8;
			
			if ((*pB1 & (0x80 >> (j % 8))) != 0) {
				*(pB2+3) = 0x00;
			}
			else {
				*(pB2+3) = 0xFF;
			}
			pB2 += 4;
		}
	}
	pImg->Mflg  = TRUE;
}

/*------------------------------------------------------------------------------
    FBOOL IcImageSave(WCHAR *)
    FWCHAR *  -
    ߒlFBOOL     -
    @\FICO/CURt@Cۑ
------------------------------------------------------------------------------*/
BOOL IcImageSave(WCHAR *pStr)
{
	return TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid IcImageDump(void)
    @\FICO/CURfR[h\
------------------------------------------------------------------------------*/
void IcImageDump(void)
{
	INT32 idx;
	WCHAR str[500];
	
	idx = 0;
	idx += swprintf(str+idx, L"reserved =0x%04X\r\n", icHeader.reserved);
	idx += swprintf(str+idx, L"type     =0x%04X\r\n", icHeader.type);
	idx += swprintf(str+idx, L"count    =0x%04X\r\n", icHeader.count);
	idx += swprintf(str+idx, L"\r\n");
	idx += swprintf(str+idx, L"width      =%d\r\n",     icInfo.width);
	idx += swprintf(str+idx, L"height     =%d\r\n",     icInfo.height);
	idx += swprintf(str+idx, L"colorCount =%d\r\n",     icInfo.colorCount);
	idx += swprintf(str+idx, L"reserved   =0x%02X\r\n", icInfo.reserved);
	idx += swprintf(str+idx, L"hotSpotX   =%d\r\n",     icInfo.hotSpotX);
	idx += swprintf(str+idx, L"hotSpotY   =%d\r\n",     icInfo.hotSpotY);
	idx += swprintf(str+idx, L"size       =%d\r\n",     icInfo.size);
	idx += swprintf(str+idx, L"offset     =%d\r\n",     icInfo.offset);
	idx += swprintf(str+idx, L"\r\n");
	idx += swprintf(str+idx, L"size        =%d\r\n",     icBmpInfo.size);
	idx += swprintf(str+idx, L"reserved1   =%d\r\n",     icBmpInfo.reserved1);
	idx += swprintf(str+idx, L"reserved2   =%d\r\n",     icBmpInfo.reserved2);
	idx += swprintf(str+idx, L"planes      =0x%04X\r\n", icBmpInfo.planes);
	idx += swprintf(str+idx, L"bpp         =%d\r\n",     icBmpInfo.bpp);
	idx += swprintf(str+idx, L"compression =0x%08X\r\n", icBmpInfo.compression);
	idx += swprintf(str+idx, L"sizeImage   =%d\r\n",     icBmpInfo.sizeImage);
	idx += swprintf(str+idx, L"xPixPerMeter=0x%08X\r\n", icBmpInfo.xPixPerMeter);
	idx += swprintf(str+idx, L"yPixPerMeter=0x%08X\r\n", icBmpInfo.yPixPerMeter);
	idx += swprintf(str+idx, L"clrUsed     =0x%08X\r\n", icBmpInfo.clrUsed);
	idx += swprintf(str+idx, L"clrImportant=0x%08X\r\n", icBmpInfo.clrImportant);
//	idx += swprintf(str+idx, L"=%d", idx);
	
	MessageBox(NULL, str, L_TITLE, MB_OK);
}

/*------------------------------------------------------------------------------
    Fvoid ImageParamI(BYTE *, INT32, INT32 *)
    FBYTE *   obt@
          INT32    oCg
          INT32 *  i[
    @\Fobt@p擾
------------------------------------------------------------------------------*/
void ImageParamI(BYTE *pBuff, INT32 cnt, INT32 *pData)
{
	INT32 i;
	
	*pData = 0x00000000;
	for (i = 0; i < cnt; i++) {
		*pData += pBuff[i] << (8*i);
	}
}

/*------------------------------------------------------------------------------
    Fvoid ImageParamO(BYTE *, INT32, INT32 *)
    FBYTE *   obt@
          INT32    oCg
          INT32 *  i[
    @\Fobt@Ƀpō
------------------------------------------------------------------------------*/
void ImageParamO(BYTE *pBuff, INT32 cnt, INT32 *pData)
{
	INT32 i;
	
	for (i = 0; i < cnt; i++) {
		pBuff[i] = (INT8)(*pData >> (8*i));
	}
}
