/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define CP_CPP
#include "../common.h"
//  Copy PartFꕔRs[

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 x1;
	INT32 y1;
	INT32 x2;
	INT32 y2;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_COPPAT];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			UINT32 percent;
			BOOL flgClick;
			INT32 flgsBorder;
			st_Image tmp;
			st_Image shw;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit[4];
	HWND hBtn[2];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[4]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn [2]) (HWND,UINT,WPARAM,LPARAM);
} cp[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void CpInitClass(void);
void CpInit(LONG);
void CpInst(LONG);
void CpDialog(LONG);
LRESULT CALLBACK CpWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CpWndProcEditX1(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CpWndProcEditY1(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CpWndProcEditX2(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CpWndProcEditY2(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CpWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CpWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CpWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CpWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void CpSize         (LONG, WPARAM, LPARAM);
void CpGetMinMaxInfo(LONG, WPARAM, LPARAM);
void CpSetFocus     (LONG, WPARAM, LPARAM);
void CpKeyDown      (LONG, WPARAM, LPARAM, HWND);
void CpKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void CpKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void CpKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void CpKeyDownUpDw  (LONG, WPARAM, LPARAM, HWND);
void CpClose        (LONG, WPARAM, LPARAM);
void CpDestroy      (LONG, WPARAM, LPARAM);
void CpPdCommand    (LONG, WPARAM, LPARAM);
void CpPdPaint      (LONG, WPARAM, LPARAM);
void CpEdSetFocus   (LONG, LONG, WPARAM, LPARAM, HWND);
void CpEdKillFocus  (LONG, LONG, WPARAM, LPARAM, HWND);
BOOL CpEdChar       (LONG, LONG, WPARAM, LPARAM);
void CpPcPaint      (LONG, WPARAM, LPARAM);
void CpPcMouseMove  (LONG, WPARAM, LPARAM);
void CpPcLButtonDown(LONG, WPARAM, LPARAM);
void CpPcLButtonUp  (LONG, WPARAM, LPARAM);
void CpEnterOk(LONG);
void CpEnterCan(LONG);
void CpTmpCreate(LONG, INT32, INT32, INT32);
void CpTmpDelete(LONG);
void CpShadowCreate(LONG, INT32, INT32);
void CpShadowDelete(LONG);
void CpShadow(LONG, HDC, HDC, INT32, INT32, INT32, INT32);
void CpBorder(LONG, HDC);
void CpSetCursor(LONG, INT32, INT32);
void CpMouse(LONG, INT32, INT32);
void CpLimitXy(LONG, INT32 *, INT32 *, INT32 *, INT32 *);
void CpView(LONG);
void CpSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid CpInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void CpInitClass(void)
{
	WNDCLASS wc;
	WNDCLASS wcPd;
	WNDCLASS wcCn;
	WNDCLASS wcPc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_COPPAT,  &wc);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_COPPATPD,&wcPd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_COPPATCN,&wcCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_COPPATPC,&wcPc);
	
	RegisterClass(&wc);
	RegisterClass(&wcPd);
	RegisterClass(&wcCn);
	RegisterClass(&wcPc);
}

/*------------------------------------------------------------------------------
    Fvoid CpInit(LONG)
    FLONG    FORM ID
    @\FꕔRs[
------------------------------------------------------------------------------*/
void CpInit(LONG id)
{
	INT32 i;
	
	cp[id].x1         = 0;
	cp[id].y1         = 0;
	cp[id].x2         = 0;
	cp[id].y2         = 0;
	cp[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_COPPAT; i++) {cp[id].tabStops[i] = NULL;}
	
	cp[id].cn.x = 0;
	cp[id].cn.y = 0;
	cp[id].cn.w = 0;
	cp[id].cn.h = 0;
	
	cp[id].pc.x         = 0;
	cp[id].pc.y         = 0;
	cp[id].pc.w         = 0;
	cp[id].pc.h         = 0;
	cp[id].pc.percent   = 0;
	cp[id].pc.flgClick  = FALSE;
	cp[id].pc.flgsBorder= 0;
	ImageInit(&cp[id].pc.tmp);
	
	cp[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {cp[id].hPd  [i] = NULL;}
	for (i = 0; i < 4; i++) {cp[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {cp[id].hBtn [i] = NULL;}
	cp[id].hCn  = NULL;
	cp[id].hPc  = NULL;
	
	for (i = 0; i < 4; i++) {cp[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {cp[id].pCallBtn [i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid CpInst(LONG)
    FLONG      FORM ID
    @\FCOPPAT̉
------------------------------------------------------------------------------*/
void CpInst(LONG id)
{
	DWORD styleCp = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD stylePd1= WS_CHILD|WS_VISIBLE;
	DWORD stylePd2= WS_CHILD;
	DWORD styleCn = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc = WS_CHILD;
	INT32 x[4] = {61,61,61, 61,};
	INT32 y[4] = {12,42,72,102,};
	INT32 w;
	WCHAR buff[4][10+1];
	
	cp[id].x1 = 0;
	cp[id].y1 = 0;
	cp[id].x2 = fm[id].pc[0].img.w-1;
	cp[id].y2 = fm[id].pc[0].img.h-1;
	_itow(cp[id].x1, buff[0], 10);
	_itow(cp[id].y1, buff[1], 10);
	_itow(cp[id].x2, buff[2], 10);
	_itow(cp[id].y2, buff[3], 10);
	
	w = SZ_WEDIT2-PADD8*2;
	cp[id].hWnd     = a_CreateWindow(NM_COPPAT,  TxTl(E_TTLCPT),styleCp, 0,   0,   0, 0,  fm[id].hWnd);
	cp[id].hPd  [0] = a_CreateWindow(NM_COPPATPD,NULL,          stylePd1,8,   8,   w, 166,cp[id].hWnd);
	cp[id].hPd  [1] = a_CreateWindow(NM_COPPATPD,NULL,          stylePd2,0,   0,   0, 0,  cp[id].hWnd);
	cp[id].hEdit[0] = a_CreateWindow(L"Edit",    buff[0],       styleEd, x[0],y[0],65,17, cp[id].hPd[0]);
	cp[id].hEdit[1] = a_CreateWindow(L"Edit",    buff[1],       styleEd, x[1],y[1],65,17, cp[id].hPd[0]);
	cp[id].hEdit[2] = a_CreateWindow(L"Edit",    buff[2],       styleEd, x[2],y[2],65,17, cp[id].hPd[0]);
	cp[id].hEdit[3] = a_CreateWindow(L"Edit",    buff[3],       styleEd, x[3],y[3],65,17, cp[id].hPd[0]);
	cp[id].hBtn [0] = a_CreateWindow(L"Button",  TxEd(E_OK),    styleBt, 10,  133, 70,25, cp[id].hPd[0]);
	cp[id].hBtn [1] = a_CreateWindow(L"Button",  TxEd(E_CANCEL),styleBt, 90,  133, 70,25, cp[id].hPd[0]);
	cp[id].hCn      = a_CreateWindow(NM_COPPATCN,NULL,          styleCn, 0,   0,   0, 0,  cp[id].hPd[1]);
	cp[id].hPc      = a_CreateWindow(NM_COPPATPC,NULL,          stylePc, 0,   0,   0, 0,  cp[id].hCn);
	
	SetWindowLong(cp[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(cp[id].hPd  [0], GWL_USERDATA, 0*100+id);
	SetWindowLong(cp[id].hPd  [1], GWL_USERDATA, 1*100+id);
	SetWindowLong(cp[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(cp[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(cp[id].hEdit[2], GWL_USERDATA, 2*100+id);
	SetWindowLong(cp[id].hEdit[3], GWL_USERDATA, 3*100+id);
	SetWindowLong(cp[id].hBtn [0], GWL_USERDATA, 0*100+id);
	SetWindowLong(cp[id].hBtn [1], GWL_USERDATA, 1*100+id);
	SetWindowLong(cp[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(cp[id].hWnd,   GWL_WNDPROC, (LONG)CpWndProc);
	SetWindowLong(cp[id].hPd[0], GWL_WNDPROC, (LONG)CpWndProcPd);
	SetWindowLong(cp[id].hPd[1], GWL_WNDPROC, (LONG)CpWndProcPd);
	SetWindowLong(cp[id].hPc,    GWL_WNDPROC, (LONG)CpWndProcPc);
	
	E_SETLIMITTEXT(cp[id].hEdit[0], 4);
	E_SETLIMITTEXT(cp[id].hEdit[1], 4);
	E_SETLIMITTEXT(cp[id].hEdit[2], 4);
	E_SETLIMITTEXT(cp[id].hEdit[3], 4);
	
	E_SETFONT(cp[id].hEdit[0], hFtCourier);
	E_SETFONT(cp[id].hEdit[1], hFtCourier);
	E_SETFONT(cp[id].hEdit[2], hFtCourier);
	E_SETFONT(cp[id].hEdit[3], hFtCourier);
	B_SETFONT(cp[id].hBtn [0], hFtArial14);
	B_SETFONT(cp[id].hBtn [1], hFtArial14);
	
	cp[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(cp[id].hEdit[0], GWL_WNDPROC);
	cp[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(cp[id].hEdit[1], GWL_WNDPROC);
	cp[id].pCallEdit[2] = (CALLFUNC)GetWindowLong(cp[id].hEdit[2], GWL_WNDPROC);
	cp[id].pCallEdit[3] = (CALLFUNC)GetWindowLong(cp[id].hEdit[3], GWL_WNDPROC);
	cp[id].pCallBtn [0] = (CALLFUNC)GetWindowLong(cp[id].hBtn [0], GWL_WNDPROC);
	cp[id].pCallBtn [1] = (CALLFUNC)GetWindowLong(cp[id].hBtn [1], GWL_WNDPROC);
	SetWindowLong(cp[id].hEdit[0], GWL_WNDPROC, (LONG)CpWndProcEditX1);
	SetWindowLong(cp[id].hEdit[1], GWL_WNDPROC, (LONG)CpWndProcEditY1);
	SetWindowLong(cp[id].hEdit[2], GWL_WNDPROC, (LONG)CpWndProcEditX2);
	SetWindowLong(cp[id].hEdit[3], GWL_WNDPROC, (LONG)CpWndProcEditY2);
	SetWindowLong(cp[id].hBtn [0], GWL_WNDPROC, (LONG)CpWndProcBtnOk);
	SetWindowLong(cp[id].hBtn [1], GWL_WNDPROC, (LONG)CpWndProcBtnCan);
	
	cp[id].tabStopIdx = 0;
	cp[id].tabStops[0] = cp[id].hEdit[0];
	cp[id].tabStops[1] = cp[id].hEdit[1];
	cp[id].tabStops[2] = cp[id].hEdit[2];
	cp[id].tabStops[3] = cp[id].hEdit[3];
	cp[id].tabStops[4] = cp[id].hBtn [0];
	cp[id].tabStops[5] = cp[id].hBtn [1];
	
	SetFocus  (cp[id].hEdit[0]);
	EditSelAll(cp[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid CpDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void CpDialog(LONG id)
{
	CpInit(id);
	CpInst(id);
	PpPlacement(id, cp[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = cp[id].hWnd;
	
	ShowWindow(cp[id].hPd[1], 0x1);
	ShowWindow(cp[id].hCn,    0x1);
	ShowWindow(cp[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProc(,,,)
    F-
    ߒlF-
    @\FCPCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SIZE:           CpSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  CpGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       CpSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          CpClose        (id, wp, lp);  break;
	case WM_DESTROY:        CpDestroy      (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProcEditX1(,,,)
    F-
    ߒlF-
    @\FEDIT X1Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProcEditX1(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   CpEdSetFocus (id, idE, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  CpEdKillFocus(id, idE, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		CpKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (CpEdChar(id, idE, wp, lp) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return cp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProcEditY1(,,,)
    F-
    ߒlF-
    @\FEDIT Y1Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProcEditY1(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   CpEdSetFocus (id, idE, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  CpEdKillFocus(id, idE, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		CpKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (CpEdChar(id, idE, wp, lp) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return cp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProcEditX2(,,,)
    F-
    ߒlF-
    @\FEDIT X2Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProcEditX2(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   CpEdSetFocus (id, idE, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  CpEdKillFocus(id, idE, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		CpKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (CpEdChar(id, idE, wp, lp) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return cp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProcEditY2(,,,)
    F-
    ߒlF-
    @\FEDIT Y2Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProcEditY2(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   CpEdSetFocus (id, idE, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  CpEdKillFocus(id, idE, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		CpKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (CpEdChar(id, idE, wp, lp) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return cp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FBTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  CpEdSetFocus(id, idB, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CpKeyDown   (id,      wp, lp, hWnd);  break;
	default: break;
	}
	return cp[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FBTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  CpEdSetFocus(id, idB, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CpKeyDown   (id,      wp, lp, hWnd);  break;
	default: break;
	}
	return cp[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProcPd(,,,)
    F-
    ߒlF-
    @\FPDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			CpPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			CpPdPaint(id, wp, lp);
		}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CpWndProcPc(,,,)
    F-
    ߒlF-
    @\FPCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CpWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        CpPcPaint      (id, wp, lp);  break;
	case WM_MOUSEMOVE:    CpPcMouseMove  (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  CpPcLButtonDown(id, wp, lp);  break;
	case WM_LBUTTONUP:    CpPcLButtonUp  (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid CpSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SIZECxg
------------------------------------------------------------------------------*/
void CpSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(cp[id].hWnd, &rc);
	a_SetWindowPos(cp[id].hPd[1], SZ_WEDIT2, PADD8, rc.right-SZ_WEDIT2-PADD8, rc.bottom-PADD8*2);
	
	CpSetPane(id);
	CpView(id);
	
	x2 = 0;
	y2 = 0;
	w2 = cp[id].pc.w;
	h2 = cp[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (cp[id].pc.percent < 10000) {mode = HALFTONE;}
	else                           {mode = COLORONCOLOR;}
	
	CpTmpDelete(id);
	CpShadowDelete(id);
	CpTmpCreate(id, w2, h2, mode);
	CpShadowCreate(id, w2, h2);
	StretchBlt(cp[id].pc.tmp.hdc,    x2, y2, w2, h2,
			   fm[id].pc[0].img.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(cp[id].pc.tmp.hdc, &rc, hBrGray);
	
	a_SetWindowPos(cp[id].hPc, cp[id].pc.x, cp[id].pc.y,
							   cp[id].pc.w, cp[id].pc.h);
	
	InvalidateRect(cp[id].hWnd,   NULL, TRUE);
	InvalidateRect(cp[id].hPd[1], NULL, TRUE);
	InvalidateRect(cp[id].hCn,    NULL, TRUE);
	InvalidateRect(cp[id].hPc,    NULL, FALSE);
	UpdateWindow(cp[id].hWnd);
	UpdateWindow(cp[id].hPd[1]);
	UpdateWindow(cp[id].hCn);
	UpdateWindow(cp[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid CpGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void CpGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT2+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 166      +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid CpSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void CpSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(cp[id].tabStops[cp[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid CpKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void CpKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  CpKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    CpKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    CpKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     CpKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid CpKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[enter]L[Cxg
------------------------------------------------------------------------------*/
void CpKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == cp[id].hBtn[1]) {CpEnterCan(id);}
	else                        {CpEnterOk (id);}
}

/*------------------------------------------------------------------------------
    Fvoid CpKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[esc]L[Cxg
------------------------------------------------------------------------------*/
void CpKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(cp[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CpKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[tab]L[Cxg
------------------------------------------------------------------------------*/
void CpKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (cp[id].tabStopIdx == 0) {cp[id].tabStopIdx = TBSP_COPPAT-1;}
		else                        {cp[id].tabStopIdx--;}
	}
	else {
		cp[id].tabStopIdx = (cp[id].tabStopIdx + 1) % TBSP_COPPAT;
	}
	SetFocus(cp[id].tabStops[cp[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid CpKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[][]L[Cxg
------------------------------------------------------------------------------*/
void CpKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	LONG idE;
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	WCHAR text[4+1];
	INT32 val;
	INT32 valTmp;
	INT32 limL;
	INT32 limH;
	INT32 step;
	POINT pt;
	RECT rc;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	if      (hWnd == cp[id].hBtn [0]) {return;}
	else if (hWnd == cp[id].hBtn [1]) {return;}
	else if (hWnd == cp[id].hEdit[0]) {idE = 0;}
	else if (hWnd == cp[id].hEdit[1]) {idE = 1;}
	else if (hWnd == cp[id].hEdit[2]) {idE = 2;}
	else if (hWnd == cp[id].hEdit[3]) {idE = 3;}
	
	GetWindowText(hWnd, text, 4+1);
	val = _wtoi(text);
	valTmp = val;
	
	limL = 0;
	if ((idE == 0) || (idE == 2)) {limH = fm[id].pc[0].img.w-1;}
	else                          {limH = fm[id].pc[0].img.h-1;}
	
	if      (idE == 0) {limH = cp[id].x2;}
	else if (idE == 1) {limH = cp[id].y2;}
	
	if      (idE == 2) {limL = cp[id].x1;}
	else if (idE == 3) {limL = cp[id].y1;}
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	switch (idE) {
	case 0:  cp[id].x1 = val;  break;
	case 1:  cp[id].y1 = val;  break;
	case 2:  cp[id].x2 = val;  break;
	case 3:  cp[id].y2 = val;  break;
	default: break;
	}
	
	if (valTmp == val) {return;}
	
	InvalidateRect(cp[id].hPc, NULL, FALSE);
	UpdateWindow(cp[id].hPc);
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	
	GetCursorPos(&pt);
	GetWindowRect(cp[id].hPc, &rc);
	CpSetCursor(id, pt.x - rc.left, pt.y - rc.top);
}

/*------------------------------------------------------------------------------
    Fvoid CpClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_CLOSECxg
------------------------------------------------------------------------------*/
void CpClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CpDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_DESTROYCxg
------------------------------------------------------------------------------*/
void CpDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	CpTmpDelete(id);
	CpShadowDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid CpPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_COMMANDCxg
------------------------------------------------------------------------------*/
void CpPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if ((HWND)lp == cp[id].hBtn[0]) {CpEnterOk (id);}
	else                            {CpEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid CpPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_PAINTCxg
------------------------------------------------------------------------------*/
void CpPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(cp[id].hPd[0], &ps);
	GetClientRect(cp[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	a_TextOut(hdc, 33, 12, L"X1");
	a_TextOut(hdc, 33, 42, L"Y1");
	a_TextOut(hdc, 33, 72, L"X2");
	a_TextOut(hdc, 33,102, L"Y2");
	
	SelectClipRgn(hdc, NULL);
	EndPaint(cp[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid CpEdSetFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    EDIT ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FEDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void CpEdSetFocus(LONG id, LONG idE, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_COPPAT; i++) {
		if (hWnd == cp[id].tabStops[i]) {
			cp[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CpEdKillFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    EDIT ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FEDIT WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void CpEdKillFocus(LONG id, LONG idE, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR text[6];
	INT32 val;
	
	GetWindowText(hWnd, text, 6);
	val = _wtoi(text);
	
	switch (idE) {
	case 0:
		if (val < 0)                        {cp[id].x1 = 0;}
		else if (cp[id].x2 < val)           {cp[id].x1 = cp[id].x2;}
		else if (fm[id].pc[0].img.w <= val) {cp[id].x1 = fm[id].pc[0].img.w-1;}
		else                                {cp[id].x1 = val;}
		_itow(cp[id].x1, text, 10);
		break;
	case 1:
		if (val < 0)                        {cp[id].y1 = 0;}
		else if (cp[id].y2 < val)           {cp[id].y1 = cp[id].y2;}
		else if (fm[id].pc[0].img.h <= val) {cp[id].y1 = fm[id].pc[0].img.h-1;}
		else                                {cp[id].y1 = val;}
		_itow(cp[id].y1, text, 10);
		break;
	case 2:
		if (val < 0)                        {cp[id].x2 = 0;}
		else if (fm[id].pc[0].img.w <= val) {cp[id].x2 = fm[id].pc[0].img.w-1;}
		else if (val < cp[id].x1)           {cp[id].x2 = cp[id].x1;}
		else                                {cp[id].x2 = val;}
		_itow(cp[id].x2, text, 10);
		break;
	case 3:
		if (val < 0)                        {cp[id].y2 = 0;}
		else if (fm[id].pc[0].img.h <= val) {cp[id].y2 = fm[id].pc[0].img.h-1;}
		else if (val < cp[id].y1)           {cp[id].y2 = cp[id].y1;}
		else                                {cp[id].y2 = val;}
		_itow(cp[id].y2, text, 10);
		break;
	default:
		break;
	}
	SetWindowText(hWnd, text);
	InvalidateRect(cp[id].hPc, NULL, FALSE);
}

/*------------------------------------------------------------------------------
    FBOOL CpEdChar(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    EDIT ID
          WPARAM  -
          LPARAM  -
    ߒlFBOOL    -
    @\FEDIT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL CpEdChar(LONG id, LONG idE, WPARAM wp, LPARAM lp)
{
	if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	
	switch (wp) {
	case 0x03:		// ctrl+C
	case 0x08:		// back space
	case 0x16:		// ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid CpPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_PAINTCxg
------------------------------------------------------------------------------*/
void CpPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	INT32 x1, y1, x2, y2;
	RECT rc;
	st_Image img;
	
	hdc = BeginPaint(cp[id].hPc, &ps);
	GetClientRect(cp[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	ImageCreate(&img, cp[id].pc.w, cp[id].pc.h);
	
	BitBlt(img.hdc,           0, 0, cp[id].pc.w, cp[id].pc.h,
		   cp[id].pc.tmp.hdc, 0, 0, SRCCOPY);
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(cp[id].x1     * cp[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(cp[id].y1     * cp[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((cp[id].x2+1) * cp[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((cp[id].y2+1) * cp[id].pc.h) / fm[id].pc[0].img.h;
	CpLimitXy(id, &x1, &y1, &x2, &y2);
	
	CpShadow(id, img.hdc, cp[id].pc.shw.hdc, x1, y1, x2-x1, y2-y1);
	
	BitBlt(hdc,     0, 0, cp[id].pc.w, cp[id].pc.h,
		   img.hdc, 0, 0, SRCCOPY);
	
	CpBorder(id, hdc);
	
	ImageDelete(&img);
	SelectClipRgn(hdc, NULL);
	EndPaint(cp[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid CpPcMouseMove(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_MOUSEMOVECxg
------------------------------------------------------------------------------*/
void CpPcMouseMove(LONG id, WPARAM wp, LPARAM lp)
{
	INT16 x, y;
	RECT rc;
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	GetClientRect(cp[id].hPc, &rc);
	if (x < rc.left)   {x = rc.left;}
	if (rc.right < x)  {x = rc.right;}
	if (y < rc.top)    {y = rc.top;}
	if (rc.bottom < y) {y = rc.bottom;}
	
	if ((wp & MK_LBUTTON) != 0) {CpMouse(id, x, y);}
	else                        {CpSetCursor(id, x, y);}
}

/*------------------------------------------------------------------------------
    Fvoid CpPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void CpPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 x, y;
	INT32 x1, y1, x2, y2;
	INT32 x1L, x1H;
	INT32 y1L, y1H;
	INT32 x2L, x2H;
	INT32 y2L, y2H;
	
	cp[id].pc.flgClick = TRUE;
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	SetCapture(cp[id].hPc);
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(cp[id].x1     * cp[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(cp[id].y1     * cp[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((cp[id].x2+1) * cp[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((cp[id].y2+1) * cp[id].pc.h) / fm[id].pc[0].img.h;
	x1L = x1 - 5;
	x1H = x1 + 5;
	y1L = y1 - 5;
	y1H = y1 + 5;
	x2L = x2 - 5;
	x2H = x2 + 5;
	y2L = y2 - 5;
	y2H = y2 + 5;
	
	cp[id].pc.flgsBorder = 0;
	if ((x1L<x) && (x<x1H)) {
		if      ((y1L<y) && (y<y1H)) {cp[id].pc.flgsBorder = BIT_WEST|BIT_NORTH;}
		else if ((y2L<y) && (y<y2H)) {cp[id].pc.flgsBorder = BIT_WEST|BIT_SOUTH;}
		else if ((y1 <y) && (y<y2))  {cp[id].pc.flgsBorder = BIT_WEST;}
	}
	else if ((x2L<x) && (x<x2H)) {
		if      ((y1L<y) && (y<y1H)) {cp[id].pc.flgsBorder = BIT_EAST|BIT_NORTH;}
		else if ((y2L<y) && (y<y2H)) {cp[id].pc.flgsBorder = BIT_EAST|BIT_SOUTH;}
		else if ((y1 <y) && (y<y2))  {cp[id].pc.flgsBorder = BIT_EAST;}
	}
	else if ((x1<x) && (x<x2)) {
		if      ((y1L<y) && (y<y1H)) {cp[id].pc.flgsBorder = BIT_NORTH;}
		else if ((y2L<y) && (y<y2H)) {cp[id].pc.flgsBorder = BIT_SOUTH;}
	}
	
	CpSetCursor(id, x, y);
}

/*------------------------------------------------------------------------------
    Fvoid CpPcLButtonUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void CpPcLButtonUp(LONG id, WPARAM wp, LPARAM lp)
{
	ReleaseCapture();
	cp[id].pc.flgClick = FALSE;
}

/*------------------------------------------------------------------------------
    Fvoid CpEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void CpEnterOk(LONG id)
{
	WCHAR text[4][4+1];
	INT32 val[4];
	INT32 i, j;
	INT32 len;
	HBITMAP hBmp;
	BYTE *pByte;
	INT32 srcX1, srcY1, srcX2, srcY2;
	INT32 dstX1, dstY1, dstX2, dstY2;
	INT32 srcW, srcH;
	INT32 dstW, dstH;
	BYTE *pB1, *pB2;
	BITMAP bmp;
	INT32 ret;
	
	for (i = 0; i < 4; i++) {
		GetWindowText(cp[id].hEdit[i], text[i], 4+1);
		val[i] = _wtoi(text[i]);
	}
	
	for (i = 0; i < 4; i++) {
		len = wcslen(text[i]);
		for (j = 0; j < len; j++) {
			if ((text[i][j] < L'0') || (L'9' < text[i][j])) {
//				MbDialog(id, cp[id].hWnd, L"coppat validation 0-9", L_TITLE, MB_OK);
				CLOSE(cp[id].hWnd);
				return;
			}
		}
	}
	
	srcX1 = 0;
	srcY1 = 0;
	srcX2 = fm[id].pc[0].img.w - 1;
	srcY2 = fm[id].pc[0].img.h - 1;
	
	if ((val[0] < srcX1) ||
		(val[1] < srcY1) ||
		(srcX2 < val[2]) ||
		(srcY2 < val[3]) ||
		(val[0] > val[2]) || (val[1] > val[3]))
	{
//		MbDialog(id, cp[id].hWnd, L"coppat validation value", L_TITLE, MB_OK);
		CLOSE(cp[id].hWnd);
		return;
	}
	
	dstX1 = val[0];
	dstY1 = val[1];
	dstX2 = val[2];
	dstY2 = val[3];
	
	srcW = fm[id].pc[0].img.w;
	srcH = fm[id].pc[0].img.h;
	dstW = dstX2 - dstX1 + 1;
	dstH = dstY2 - dstY1 + 1;
	
	pByte = (BYTE *)a_malloc(dstW*dstH*4);
	
	for (i = 0; i < dstH; i++) {
		pB1 = fm[id].pc[0].img.pB + dstX1*4 + (i+srcY2-dstY2)*srcW*4;
		pB2 = pByte               + (dstH - 1 - i) * dstW*4;
		for (j = 0; j < dstW; j++) {
			*(pB2+3) = *(pB1+3);
			*(pB2+2) = *(pB1+2);
			*(pB2+1) = *(pB1+1);
			*(pB2+0) = *(pB1+0);
			pB1 += 4;
			pB2 += 4;
		}
	}
	
	hBmp = CreateBitmap(dstW, dstH, 0x0001, 32, pByte);
	
	OpenClipboard(NULL);
	EmptyClipboard();
	
	ret = GetObject(hBmp, sizeof(BITMAP), &bmp);
	if (ret == 0) {
		MbDialog(id, cp[id].hWnd, L"get object miss", L_TITLE, MB_OK);
	}
	
	SetClipboardData(CF_BITMAP, hBmp);
	
	CloseClipboard();
	DeleteObject(hBmp);
	free(pByte);
	
	MnFlushEdit(id);
	CLOSE(cp[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CpEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void CpEnterCan(LONG id)
{
	CLOSE(cp[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CpTmpCreate(LONG, INT32, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
          INT32    ][h
    @\FꕔRs[ ꎞC[W쐬
------------------------------------------------------------------------------*/
void CpTmpCreate(LONG id, INT32 w, INT32 h, INT32 mode)
{
	ImageCreate(&cp[id].pc.tmp, w, h);
	
	SetStretchBltMode(cp[id].pc.tmp.hdc, mode);
}

/*------------------------------------------------------------------------------
    Fvoid CpTmpDelete(LONG)
    FLONG     FORM ID
    @\FꕔRs[ ꎞC[W폜
------------------------------------------------------------------------------*/
void CpTmpDelete(LONG id)
{
	DeleteDC    (cp[id].pc.tmp.hdc);
	DeleteObject(cp[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid CpShadowCreate(LONG, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
    @\FꕔRs[ eC[W 쐬
------------------------------------------------------------------------------*/
void CpShadowCreate(LONG id, INT32 w, INT32 h)
{
	INT64 r, g, b;
	INT64 bright;
	BYTE color;
	
	ImageCreate(&cp[id].pc.shw, w, h);
	
	r = (UINT8)fm[id].cn[0].avgRed;
	g = (UINT8)fm[id].cn[0].avgGreen;
	b = (UINT8)fm[id].cn[0].avgBlue;
	bright = (r + g + b) / 3;
	if (bright < 0x80) {color = 0xFF;}
	else               {color = 0x00;}
	
	memset(cp[id].pc.shw.pB, color, w * h * 4);
}

/*------------------------------------------------------------------------------
    Fvoid CpShadowDelete(LONG)
    FLONG     FORM ID
    @\FꕔRs[ eC[W  폜
------------------------------------------------------------------------------*/
void CpShadowDelete(LONG id)
{
	DeleteDC    (cp[id].pc.shw.hdc);
	DeleteObject(cp[id].pc.shw.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid CpShadow(LONG, HDC, HDC, INT32, INT32, INT32, INT32)
    FLONG    FORM ID
          HDC     -
          HDC     -
          INT32   -
          INT32   -
          INT32   -
          INT32   -
    @\FꕔRs[ e`
------------------------------------------------------------------------------*/
void CpShadow(LONG id, HDC hdcDst, HDC hdcSrc, INT32 x, INT32 y, INT32 w, INT32 h)
{
	BLENDFUNCTION blFunc;
	
	if (w <= 0) {return;}
	if (h <= 0) {return;}
	
	blFunc.BlendOp             = AC_SRC_OVER;
	blFunc.BlendFlags          = 0;
	blFunc.SourceConstantAlpha = 128;
	blFunc.AlphaFormat         = 0;
	
	AlphaBlend(hdcDst, x, y, w, h, hdcSrc, x, y, w, h, blFunc);
}

/*------------------------------------------------------------------------------
    Fvoid CpBorder(LONG id, HDC)
    FLONG    FORM ID
          HDC     -
    @\FꕔRs[ E`
------------------------------------------------------------------------------*/
void CpBorder(LONG id, HDC hdc)
{
	INT32 x1, y1, x2, y2;
	RECT rc;
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = cp[id].pc.tmp.w;
	rc.bottom = cp[id].pc.tmp.h;
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hPnBlack);
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(cp[id].x1     * cp[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(cp[id].y1     * cp[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((cp[id].x2+1) * cp[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((cp[id].y2+1) * cp[id].pc.h) / fm[id].pc[0].img.h;
	CpLimitXy(id, &x1, &y1, &x2, &y2);
	
	// 炸1dot̂ň悤Ɏw
	MoveToEx(hdc, x1, y1, NULL);
	LineTo  (hdc, x1, y2);
	
	if (cp[id].pc.h <= y2) {y2 = cp[id].pc.h-1;}
	MoveToEx(hdc, x1, y2, NULL);
	LineTo  (hdc, x2, y2);
	
	if (cp[id].pc.w <= x2) {x2 = cp[id].pc.w-1;}
	MoveToEx(hdc, x2, y2, NULL);
	LineTo  (hdc, x2, y1);
	
	MoveToEx(hdc, x2, y1, NULL);
	LineTo  (hdc, x1, y1);
	
	SelectClipRgn(hdc, NULL);
}

/*------------------------------------------------------------------------------
    Fvoid CpSetCursor(LONG id, INT32, INT32)
    FLONG    FORM ID
          INT32   XW
          INT32   YW
    @\FꕔRs[ J[\ύX
------------------------------------------------------------------------------*/
void CpSetCursor(LONG id, INT32 x, INT32 y)
{
	INT32 x1, y1, x2, y2;
	INT32 x1L, x1H;
	INT32 y1L, y1H;
	INT32 x2L, x2H;
	INT32 y2L, y2H;
	HCURSOR hCur;
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(cp[id].x1     * cp[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(cp[id].y1     * cp[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((cp[id].x2+1) * cp[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((cp[id].y2+1) * cp[id].pc.h) / fm[id].pc[0].img.h;
	x1L = x1-5;    x1H = x1+5;
	y1L = y1-5;    y1H = y1+5;
	x2L = x2-5;    x2H = x2+5;
	y2L = y2-5;    y2H = y2+5;
	
	hCur = hCurArrow;
	if ((x1L<x) && (x<x1H)) {
		if      ((y1L<y) && (y<y1H)) {hCur = hCurSzNwse;}
		else if ((y2L<y) && (y<y2H)) {hCur = hCurSzNesw;}
		else if ((y1 <y) && (y<y2))  {hCur = hCurSzWe;}
	}
	else if ((x2L<x) && (x<x2H)) {
		if      ((y1L<y) && (y<y1H)) {hCur = hCurSzNesw;}
		else if ((y2L<y) && (y<y2H)) {hCur = hCurSzNwse;}
		else if ((y1 <y) && (y<y2))  {hCur = hCurSzWe;}
	}
	else if ((x1<x) && (x<x2)) {
		if      ((y1L<y) && (y<y1H)) {hCur = hCurSzNs;}
		else if ((y2L<y) && (y<y2H)) {hCur = hCurSzNs;}
	}
	SetCursor(hCur);
	SetClassLong(cp[id].hPc, GCL_HCURSOR, (LONG)hCur);
}

/*------------------------------------------------------------------------------
    Fvoid CpMouse(LONG id, INT32, INT32)
    FLONG    FORM ID
          INT32   XW
          INT32   YW
    @\FꕔRs[ }EX
------------------------------------------------------------------------------*/
void CpMouse(LONG id, INT32 x, INT32 y)
{
	WCHAR text[4+1];
	INT32 val;
	HWND hWnd;
	
	if (cp[id].pc.flgClick == FALSE) {return;}
	if (cp[id].pc.flgsBorder == 0)   {return;}
	
	if (IsBit(cp[id].pc.flgsBorder, BIT_SOUTH)) {
		TryZeroDivision(cp[id].pc.h);
		y = (double)(y * fm[id].pc[0].img.h+1) / cp[id].pc.h;
		if (y < cp[id].y1) {cp[id].y2 = cp[id].y1;}
		else                  {cp[id].y2 = y;}
		val = cp[id].y2;
		if (fm[id].pc[0].img.h <= val) {val = fm[id].pc[0].img.h-1;}
		hWnd = cp[id].hEdit[3];
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
	}
	if (IsBit(cp[id].pc.flgsBorder, BIT_EAST)) {
		TryZeroDivision(cp[id].pc.w);
		x = (double)(x * fm[id].pc[0].img.w+1) / cp[id].pc.w;
		if (x < cp[id].x1) {cp[id].x2 = cp[id].x1;}
		else                  {cp[id].x2 = x;}
		val = cp[id].x2;
		if (fm[id].pc[0].img.w <= val) {val = fm[id].pc[0].img.w-1;}
		hWnd = cp[id].hEdit[2];
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
	}
	if (IsBit(cp[id].pc.flgsBorder, BIT_NORTH)) {
		TryZeroDivision(cp[id].pc.h);
		y = (double)(y * fm[id].pc[0].img.h) / cp[id].pc.h;
		if (cp[id].y2 < y) {cp[id].y1 = cp[id].y2;}
		else                  {cp[id].y1 = y;}
		val = cp[id].y1;
		hWnd = cp[id].hEdit[1];
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
	}
	if (IsBit(cp[id].pc.flgsBorder, BIT_WEST)) {
		TryZeroDivision(cp[id].pc.w);
		x = (double)(x * fm[id].pc[0].img.w) / cp[id].pc.w;
		if (cp[id].x2 < x) {cp[id].x1 = cp[id].x2;}
		else                  {cp[id].x1 = x;}
		val = cp[id].x1;
		hWnd = cp[id].hEdit[0];
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
	}
	InvalidateRect(cp[id].hPc, NULL, FALSE);
}

/*------------------------------------------------------------------------------
    Fvoid CpLimitXy(-)
    F-
    @\FꕔRs[ W𐧌
------------------------------------------------------------------------------*/
void CpLimitXy(LONG id, INT32 *pX1, INT32 *pY1, INT32 *pX2, INT32 *pY2)
{
	if (*pX1 < 0) {*pX1 = 0;}
	if (*pY1 < 0) {*pY1 = 0;}
	if (*pX2 < 0) {*pX2 = 0;}
	if (*pY2 < 0) {*pY2 = 0;}
	if (cp[id].pc.w <= *pX1) {*pX1 = cp[id].pc.w-1;}
	if (cp[id].pc.h <= *pY1) {*pY1 = cp[id].pc.h-1;}
	if (cp[id].pc.w <= *pX2) {*pX2 = cp[id].pc.w-1;}
	if (cp[id].pc.h <= *pY2) {*pY2 = cp[id].pc.h-1;}
}

/*------------------------------------------------------------------------------
    Fvoid CpView(LONG)
    FLONG    FORM ID
    @\FꕔRs[\p
------------------------------------------------------------------------------*/
void CpView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	gainW = (double)cp[id].cn.w / fm[id].pc[0].img.w;
	gainH = (double)cp[id].cn.h / fm[id].pc[0].img.h;
	
	if (CmpGain(gainW, gainH) == TRUE) {
		limW = TRUE;
		limH = TRUE;
	}
	else {
		if (gainW < gainH) {
			gainH = gainW;
			limW = TRUE;
		}
		else {
			gainW = gainH;
			limH = TRUE;
		}
	}
	
	x = (double)cp[id].cn.w / 2 - (double)fm[id].pc[0].img.w * gainW / 2;
	y = (double)cp[id].cn.h / 2 - (double)fm[id].pc[0].img.h * gainH / 2;
	w = (double)fm[id].pc[0].img.w * gainW;
	h = (double)fm[id].pc[0].img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = cp[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = cp[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(fm[id].pc[0].img.w);  cp[id].pc.percent = ((double)w / fm[id].pc[0].img.w) * 10000;}
	else              {TryZeroDivision(fm[id].pc[0].img.h);  cp[id].pc.percent = ((double)h / fm[id].pc[0].img.h) * 10000;}
	
	cp[id].pc.x = x;
	cp[id].pc.y = y;
	if (w <= 0) {cp[id].pc.w = 1;}
	else        {cp[id].pc.w = w;}
	if (h <= 0) {cp[id].pc.h = 1;}
	else        {cp[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid CpSetPane(LONG)
    FLONG    FORM ID
    @\FꕔRs[̕\̘g\
------------------------------------------------------------------------------*/
void CpSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(cp[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(cp[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(cp[id].hCn, &rc);
	cp[id].cn.x = rc.left;
	cp[id].cn.y = rc.top;
	cp[id].cn.w = rc.right - rc.left;
	cp[id].cn.h = rc.bottom - rc.top;
}
